/* envgetserv.c -- get service entry for multiple environments

   Copyright 2009 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "defaults.h"
#include "files.h"
#include "incl_unix.h"
#include "incl_net.h"

struct servent *env_getserv(const char *serv, const char *proto)
{
	char	buff[50];

	/* Both "serv" and "envselect_name" are generated by me, so buff "has" to be big enough */

	strcpy(buff, serv);

	if  (envselect_name)
		strcat(buff, envselect_name);

	return  getservbyname(buff, proto);
}
