/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.prng.BasePRNG;
import gnu.crypto.prng.LimitReachedException;
import java.util.Map;

public class ARCFour
extends BasePRNG {
    public static final String ARCFOUR_KEY_MATERIAL = "gnu.crypto.prng.arcfour.key-material";
    public static final int ARCFOUR_SBOX_SIZE = 256;
    private byte[] s;
    private byte m;
    private byte n;

    public ARCFour() {
        super("arcfour");
    }

    public Object clone() {
        ARCFour copy = new ARCFour();
        copy.s = this.s != null ? (byte[])this.s.clone() : null;
        copy.m = this.m;
        copy.n = this.n;
        copy.buffer = this.buffer != null ? (byte[])this.buffer.clone() : null;
        copy.ndx = this.ndx;
        copy.initialised = this.initialised;
        return copy;
    }

    public void setup(Map attributes) {
        int i;
        int j;
        byte[] kb = (byte[])attributes.get(ARCFOUR_KEY_MATERIAL);
        if (kb == null) {
            throw new IllegalArgumentException("ARCFOUR needs a key");
        }
        this.s = new byte[256];
        this.n = 0;
        this.m = 0;
        byte[] k = new byte[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.s[i2] = (byte)i2;
        }
        if (kb.length > 0) {
            j = 0;
            for (i = 0; i < 256; ++i) {
                k[i] = kb[j++];
                if (j < kb.length) continue;
                j = 0;
            }
        }
        j = 0;
        for (i = 0; i < 256; ++i) {
            j = j + this.s[i] + k[i];
            byte temp = this.s[i];
            this.s[i] = this.s[j & 0xFF];
            this.s[j & 0xFF] = temp;
        }
        this.buffer = new byte[256];
        try {
            this.fillBlock();
        }
        catch (LimitReachedException wontHappen) {
            // empty catch block
        }
    }

    public void fillBlock() throws LimitReachedException {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.m = (byte)(this.m + 1);
            this.n = (byte)(this.n + this.s[this.m & 0xFF]);
            int temp = this.s[this.m & 0xFF];
            this.s[this.m & 0xFF] = this.s[this.n & 0xFF];
            this.s[this.n & 0xFF] = temp;
            temp = this.s[this.m & 0xFF] + this.s[this.n & 0xFF];
            this.buffer[i] = this.s[temp & 0xFF];
        }
    }

    static {
        ARCFOUR_KEY_MATERIAL = ARCFOUR_KEY_MATERIAL;
    }
}

