/* udstr.c: 
 *
 ****************************************************************
 * Copyright (C) 2004 Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/mem/mem.h"
#include "hackerlab/strings/udstr.h"



struct udstr_handle
{
  enum uni_encoding_scheme enc;
  size_t length;
  uni_string data;

  alloc_limits limits;
  int refs;
};




t_udstr
udstr_save (alloc_limits limits,
            uni_string str,
            enum uni_encoding_scheme enc)
{
  return udstr_save_n (limits, str, enc, ustr_length_in_encoding (enc, str, enc));
}


t_udstr
udstr_make_n (alloc_limits limits,
              enum uni_encoding_scheme enc,
              size_t len)
{
  t_udstr answer = 0;
  size_t byte_len;

  answer = (t_udstr)lim_malloc (limits, sizeof (*answer));
  if (!answer)
    return 0;

  byte_len = (len + 1) * uni_code_unit_size (enc);

  answer->limits = 0;
  answer->length = len;
  answer->refs = 1;
  answer->data = (uni_string)lim_malloc (limits, byte_len);

  if (answer->data)
    {
      mem_set0 ((t_uchar *)answer->data, byte_len);
    }
  else
    {
      lim_free (0, (t_uchar *)answer);
      answer = 0;
    }

  return answer;
}



t_udstr
udstr_save_n (alloc_limits limits,
              uni_string str,
              enum uni_encoding_scheme enc,
              size_t len)
{
  t_udstr answer;

  answer = (t_udstr)lim_malloc (limits, sizeof (*answer));
  if (!answer)
    return 0;

  answer->limits = 0;
  answer->length = len;
  answer->refs = 1;
  answer->data = ustr_save_n (limits, enc, str, enc, len);

  if (!answer->data)
    {
      lim_free (limits, (t_uchar *)answer);
      answer = 0;
    }

  return answer;
}



t_udstr
udstr_copy (alloc_limits limits, t_udstr orig)
{
  return udstr_save_n (limits, orig->data, orig->enc, orig->length);
}



void
udstr_ref (t_udstr s)
{
  if (s)
    ++s->refs;
}


void
udstr_unref (t_udstr s)
{
  if (s && !--s->refs)
    {
      lim_free (s->limits, (t_uchar *)s->data);
      lim_free (s->limits, (t_uchar *)s);
    }
}





uni_string
udstr_data (enum uni_encoding_scheme * enc, size_t * length, t_udstr x)
{
  if (!x)
    {
      if (length)
        *length = 0;
      if (enc)
        *enc = uni_utf8;
      return 0;
    }
  else
    {
      if (length)
        *length = x->length;
      if (enc)
        *enc = x->enc;
      return x->data;
    }
}




/* tag: Tom Lord Fri Jan  2 08:47:21 2004 (udstr.c)
 */
