/* inv.h: file inventories
 *
 ****************************************************************
 * Copyright (C) 2002 Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__FILE_UTILS__INV_H
#define INCLUDE__FILE_UTILS__INV_H

#include "hackerlab/os/sys/stat.h"
#include "hackerlab/machine/types.h"
#include "hackerlab/mem/alloc-limits.h"
#include "hackerlab/rx-posix/regex.h"
#include "liblarch/ftag.h"


enum inv_category
{
  inv_source = 1,
  inv_precious = 2,
  inv_backup = 4,
  inv_junk = 8,
  inv_tree = 16,
  inv_unrecognized = 32
};

struct inv_options
{
  t_uint categories;		/* set of enum inv_category */

  int want_tags;		/* go to the expense of computing file tags? */
  int include_untagged;		/* report source-named files that are missing tags? */
  enum ftag_method method;	/* tagging method */

  int nested;			/* search in nested trees? */
  int control;			/* include arch control files? */
  int include_excluded;		/* ignore the `excludes_pattern'? */

  char * tree_control_system_name;
  char * control_dir_name;
  char * conventions_file_name;
  regex_t excludes_pattern;
  regex_t junk_pattern;
  regex_t backup_pattern;
  regex_t precious_pattern;
  regex_t unrecognized_pattern;
  regex_t source_pattern;
};

typedef int (*inv_callback) (int * errn,
			     struct alloc_limits * limits,
			     t_uchar * path,
			     struct stat * stat_buf,
			     enum inv_category category,
			     t_uchar * tag,
			     void * closure);



/* automatically generated __STDC__ prototypes */
extern int inv_traversal (int * errn,
                          char ** bad_file,
                          struct alloc_limits * limits,
                          struct inv_options * options,
                          t_uchar * path,
                          inv_callback callback,
                          void * closure);
extern int inv_guess_conventions_files (int * errn,
                                        struct alloc_limits * limits,
                                        struct inv_options * options,
                                        char * path);
extern int inv_get_naming_conventions (int * errn,
                                       int * re_error,
                                       struct alloc_limits * limits,
                                       struct inv_options * options,
                                       char * path);
extern void inv_free_naming_conventions (struct inv_options * options);
#endif  /* INCLUDE__FILE_UTILS__INV_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (inv.h)
 */
