#include<stdio.h>
#define NOTHING 0
#define ORBIT 1
#define DFIELD 2

typedef struct dfobj{
  struct dfobj *next;
  int type,active,mode,n;
  float *data;
} dfobj;

extern dfobj *dfobjs;
extern float oxmin, oxmax, oymin, oymax;
extern int xgrid, ygrid;
extern int width, height;
extern int xinitialized;
extern int owidth, oheight;

float xscale_factor, yscale_factor, ixsf, iysf;
int xoffset, yoffset;

/***************************************************************/
show_graphics()
{
  if( dfobjs == (dfobj *)0)  int_error("Nothing to replot", -1);
  if(!xinitialized) init_x();
}
reset_ode()
{
  dfobj *tmp = dfobjs;
  
  while(tmp)
    {
      tmp->active = 0;
      tmp = tmp->next;
    }
}
plot_ode()
{
  int i, j;
  dfobj *tmp = dfobjs;
  float *data;

  while(tmp)
    {
      if(tmp->active == 0)
	{
	  if(tmp->mode == ORBIT)
	    {
	      data = tmp->data;
	      for(i = 0; i < tmp->n -2; i += 2) /* more than 2 pts */
		make_a_line_segment(data[i], data[i+1], data[i+2],data[i+3]);
	    }
	  else if(tmp->mode == DFIELD)
	    {
	      float xdif, ydif,x,y,u,v,xx,yy,uu,vv; int k;
	      xdif = (oxmax - oxmin)/xgrid;
	      ydif = (oymax - oymin)/ygrid;
	      data = tmp->data;
	      x = xdif;
	      for(i = 0; i< xgrid -1; i++)
		{
		  y = ydif;
		  for(j = 0; j < ygrid -1; j++)
		    {
		      k = 2*(i*(ygrid -1) + j);
		      u = data[k]; v = data[k+1];
		      uu = 0.775 *u; vv = 0.775*v;
		      xx = -0.1 *v; yy = 0.1*u;
		      u=x+u; v= y+v;
		      make_a_line_segment(x,y,u,v);
		      make_a_line_segment(u,v,uu + x + xx, vv + y + yy);
		      make_a_line_segment(u,v,uu + x - xx, vv + y - yy);
		      y += ydif;
		    }
		  x += xdif;
		}
	    }
	  tmp->active = 1;
	}
      tmp = tmp->next;
    }
}
/***************************************************************/

set_scale_factor(w,h) /* w  and  h  are the screen dimension */
     int w,h;
{
  /* world to screen */
  xscale_factor = (float) (w/* - 2* xoffset*/)/(oxmax -oxmin);
  yscale_factor = (float) (h /*- 2* yoffset*/)/(oymax -oymin);
  /* screen to world */
  ixsf = 1.0/xscale_factor;
  iysf = 1.0/yscale_factor;
}

world_2_screen(wx,wy,sx,sy)
     float wx, wy; int *sx, *sy;
{
  *sx = (int) ( xscale_factor * wx) /*+ xoffset*/;
  *sy = oheight - (int) ( yscale_factor * wy) /*+ yoffset*/;  
}
screen_2_world(sx,sy,wx,wy)
     int sx,sy; float *wx, *wy;
{
  *wx = ixsf * (float)(sx /*- xoffset*/) + oxmin;
  *wy = iysf * (float) (oheight - sy /*- yoffset*/) + oymin;
}
/*******************************************************************/
static char *help_message[] = {
  "\nDfplot is a simple program designed to plot the direction fields",
  "and trajectories of an ODE or a system of two ODEs.  Its command",
  "syntax is roughly the same as Gnuplot.  The only new command  is",
  "to input an ode:",
  "        example1 = ode{ D[x,t]= x*x -t}",
  "        example2 = ode{ D[x,t]= y, D[y,t]= -sin(x) + 0.1* y}",
  "The meaning is clear.\n",
  "To plot the direction field of example1, just enter",
  "       plot example1",
  "Inside the plot window,  press and move the  LEFT mouse button",
  "alows you to see the coordinate of the mouse, press the MIDDLE",
  "button will cause dfplot to  compute the trajectory of the ode",
  "through the point under the mouse.(so be very careful with it)",
  "Press any key will destroy the plot window.",
  "\nAfter the plot window is destroyed, a 'replot' command will",
  "bring the last window back, a 'lpr' command will send the last",
  "graph to the laser printer.",
  "\nThe commands 'set xrange' etc  allows you to control the plot",
  "range.",
  ""
};

do_help()
{
  int i = 0;
  char **t = help_message;
  while(i<19) {
    fprintf(stderr, "%s\n", *t);
    t++; i++;
  }
}
/*******************************************************************/
