/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VerilogTab
extends PreferencePanel {
    private Setting verilogUseAssignSetting = SimulationTool.getVerilogUseAssignSetting();
    private Setting verilogUseTriregSetting = SimulationTool.getVerilogUseTriregSetting();
    private JPanel inputPanel;
    private JSeparator jSeparator1;
    private JCheckBox netlistNonstandardCells;
    private JPanel outputPanel;
    private JCheckBox parameterizeModuleNames;
    private JPanel preferences;
    private JCheckBox preserveVerilogFormatting;
    private JPanel projectSettings;
    private JCheckBox runPlacement;
    private JCheckBox stopAtStandardCells;
    private JCheckBox verDefWireTrireg;
    private JCheckBox verUseAssign;
    private JCheckBox writeModuleForEachIcon;

    public VerilogTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getUserPreferencesPanel() {
        return this.preferences;
    }

    public JPanel getProjectPreferencesPanel() {
        return this.projectSettings;
    }

    public String getName() {
        return "Verilog";
    }

    public void init() {
        this.stopAtStandardCells.setSelected(SimulationTool.getVerilogStopAtStandardCells());
        this.netlistNonstandardCells.setSelected(SimulationTool.getVerilogNetlistNonstandardCells());
        this.preserveVerilogFormatting.setSelected(SimulationTool.getPreserveVerilogFormating());
        this.parameterizeModuleNames.setSelected(SimulationTool.getVerilogParameterizeModuleNames());
        this.runPlacement.setSelected(SimulationTool.getVerilogRunPlacementTool());
        this.writeModuleForEachIcon.setSelected(SimulationTool.isVerilogWriteModuleForEachIcon());
        this.verUseAssign.setSelected(this.getBoolean(this.verilogUseAssignSetting));
        this.verDefWireTrireg.setSelected(this.getBoolean(this.verilogUseTriregSetting));
    }

    public void term() {
        SimulationTool.setVerilogStopAtStandardCells(this.stopAtStandardCells.isSelected());
        SimulationTool.setVerilogNetlistNonstandardCells(this.netlistNonstandardCells.isSelected());
        SimulationTool.setPreserveVerilogFormating(this.preserveVerilogFormatting.isSelected());
        SimulationTool.setVerilogParameterizeModuleNames(this.parameterizeModuleNames.isSelected());
        SimulationTool.setVerilogRunPlacementTool(this.runPlacement.isSelected());
        SimulationTool.setVerilogWriteModuleForEachIcon(this.writeModuleForEachIcon.isSelected());
        this.setBoolean(this.verilogUseAssignSetting, this.verUseAssign.isSelected());
        this.setBoolean(this.verilogUseTriregSetting, this.verDefWireTrireg.isSelected());
    }

    public void reset() {
        if (SimulationTool.getFactoryVerilogStopAtStandardCells() != SimulationTool.getVerilogStopAtStandardCells()) {
            SimulationTool.setVerilogStopAtStandardCells(SimulationTool.getFactoryVerilogStopAtStandardCells());
        }
        if (SimulationTool.getFactoryVerilogNetlistNonstandardCells() != SimulationTool.getVerilogNetlistNonstandardCells()) {
            SimulationTool.setVerilogNetlistNonstandardCells(SimulationTool.getFactoryVerilogNetlistNonstandardCells());
        }
        if (SimulationTool.getFactoryPreserveVerilogFormating() != SimulationTool.getPreserveVerilogFormating()) {
            SimulationTool.setPreserveVerilogFormating(SimulationTool.getFactoryPreserveVerilogFormating());
        }
        if (SimulationTool.getFactoryVerilogParameterizeModuleNames() != SimulationTool.getVerilogParameterizeModuleNames()) {
            SimulationTool.setVerilogParameterizeModuleNames(SimulationTool.getFactoryVerilogParameterizeModuleNames());
        }
        if (SimulationTool.getFactoryVerilogRunPlacementTool() != SimulationTool.getVerilogRunPlacementTool()) {
            SimulationTool.setVerilogRunPlacementTool(SimulationTool.getFactoryVerilogRunPlacementTool());
        }
        if (SimulationTool.isFactoryVerilogWriteModuleForEachIcon() != SimulationTool.isVerilogWriteModuleForEachIcon()) {
            SimulationTool.setVerilogWriteModuleForEachIcon(SimulationTool.isFactoryVerilogWriteModuleForEachIcon());
        }
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.preferences = new JPanel();
        this.inputPanel = new JPanel();
        this.runPlacement = new JCheckBox();
        this.outputPanel = new JPanel();
        this.stopAtStandardCells = new JCheckBox();
        this.preserveVerilogFormatting = new JCheckBox();
        this.parameterizeModuleNames = new JCheckBox();
        this.writeModuleForEachIcon = new JCheckBox();
        this.netlistNonstandardCells = new JCheckBox();
        this.projectSettings = new JPanel();
        this.verDefWireTrireg = new JCheckBox();
        this.verUseAssign = new JCheckBox();
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                VerilogTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.preferences.setLayout(new GridBagLayout());
        this.inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        this.inputPanel.setLayout(new GridBagLayout());
        this.runPlacement.setText("Run Placement after import");
        this.runPlacement.setBorder(null);
        this.runPlacement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VerilogTab.this.runPlacementActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.inputPanel.add((Component)this.runPlacement, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.preferences.add((Component)this.inputPanel, gridBagConstraints);
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        this.outputPanel.setLayout(new GridBagLayout());
        this.stopAtStandardCells.setText("Do not netlist Standard Cells");
        this.stopAtStandardCells.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.stopAtStandardCells, gridBagConstraints);
        this.preserveVerilogFormatting.setText("Preserve Verilog formatting");
        this.preserveVerilogFormatting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.preserveVerilogFormatting, gridBagConstraints);
        this.parameterizeModuleNames.setText("Parameterize Verilog module names");
        this.parameterizeModuleNames.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.parameterizeModuleNames, gridBagConstraints);
        this.writeModuleForEachIcon.setText("Write Separate Module for each Icon");
        this.writeModuleForEachIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.writeModuleForEachIcon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VerilogTab.this.writeModuleForEachIconActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.writeModuleForEachIcon, gridBagConstraints);
        this.netlistNonstandardCells.setText("Netlist Non-standard Cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.netlistNonstandardCells, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.preferences.add((Component)this.outputPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.getContentPane().add((Component)this.preferences, gridBagConstraints);
        this.projectSettings.setLayout(new GridBagLayout());
        this.verDefWireTrireg.setText("Default wire is Trireg");
        this.verDefWireTrireg.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.projectSettings.add((Component)this.verDefWireTrireg, gridBagConstraints);
        this.verUseAssign.setText("Use ASSIGN Construct");
        this.verUseAssign.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.projectSettings.add((Component)this.verUseAssign, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.projectSettings, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void runPlacementActionPerformed(ActionEvent evt) {
    }

    private void writeModuleForEachIconActionPerformed(ActionEvent evt) {
    }
}

