/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.Variable;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableCell
extends ImmutableElectricObject {
    public final CellId cellId;
    public final CellName groupName;
    public final long creationDate;
    public final long revisionDate;
    public final TechId techId;
    final Variable[] params;

    private ImmutableCell(CellId cellId, CellName groupName, long creationDate, long revisionDate, TechId techId, int flags, Variable[] vars, Variable[] params) {
        super(vars, flags);
        this.cellId = cellId;
        this.groupName = groupName;
        this.creationDate = creationDate;
        this.revisionDate = revisionDate;
        this.techId = techId;
        this.params = params;
        this.check();
    }

    public static ImmutableCell newInstance(CellId cellId, long creationDate) {
        if (cellId == null) {
            throw new NullPointerException("cellId");
        }
        CellName cellName = CellName.newName(cellId.cellName.getName(), View.SCHEMATIC, 0);
        return new ImmutableCell(cellId, cellName, creationDate, creationDate, null, 0, Variable.NULL_ARRAY, Variable.NULL_ARRAY);
    }

    public ImmutableCell withGroupName(CellName groupName) {
        if (this.groupName.equals(groupName)) {
            return this;
        }
        if (groupName.getVersion() != 0 || groupName.getView() != View.SCHEMATIC) {
            throw new IllegalArgumentException(groupName.toString());
        }
        return new ImmutableCell(this.cellId, groupName, this.creationDate, this.revisionDate, this.techId, this.flags, this.getVars(), this.params);
    }

    public ImmutableCell withCreationDate(long creationDate) {
        if (this.creationDate == creationDate) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, creationDate, this.revisionDate, this.techId, this.flags, this.getVars(), this.params);
    }

    public ImmutableCell withRevisionDate(long revisionDate) {
        if (this.revisionDate == revisionDate) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, revisionDate, this.techId, this.flags, this.getVars(), this.params);
    }

    public ImmutableCell withTechId(TechId techId) {
        if (this.techId == techId) {
            return this;
        }
        if (techId != null && techId.idManager != this.cellId.idManager) {
            throw new IllegalArgumentException("techId");
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.revisionDate, techId, this.flags, this.getVars(), this.params);
    }

    public ImmutableCell withFlags(int flags) {
        if (this.flags == flags) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.revisionDate, this.techId, flags, this.getVars(), this.params);
    }

    public Variable getParameter(Variable.AttrKey key) {
        int paramIndex = ImmutableCell.searchVar(this.params, key);
        return paramIndex >= 0 ? this.params[paramIndex] : null;
    }

    public Iterator<Variable> getParameters() {
        return ArrayIterator.iterator(this.params);
    }

    public int getNumParameters() {
        return this.params.length;
    }

    public Variable getParameter(int paramIndex) {
        return this.params[paramIndex];
    }

    public ImmutableCell withParam(Variable var) {
        if (!var.getTextDescriptor().isParam() || !var.isInherit()) {
            throw new IllegalArgumentException("Variable " + var + " is not param");
        }
        if (!this.paramsAllowed()) {
            throw new IllegalArgumentException("Parameters are not allowed for " + this);
        }
        if (this.searchVar(var.getKey()) >= 0) {
            throw new IllegalArgumentException(this + " has variable with the same name as parameter " + var);
        }
        Variable[] params = ImmutableCell.arrayWithVariable(this.params, var);
        if (this.params == params) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.revisionDate, this.techId, this.flags, this.getVars(), params);
    }

    public ImmutableCell withoutParam(Variable.AttrKey key) {
        Variable[] params = ImmutableCell.arrayWithoutVariable(this.params, key);
        if (this.params == params) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.revisionDate, this.techId, this.flags, this.getVars(), params);
    }

    public ImmutableCell withVariable(Variable var) {
        if (var.getTextDescriptor().isParam()) {
            throw new IllegalArgumentException("Variable " + var + " is param");
        }
        if (var.isAttribute() && ImmutableCell.searchVar(this.params, var.getKey()) >= 0) {
            throw new IllegalArgumentException(this + " has parameter with the same name as variable " + var);
        }
        if (!this.paramsAllowed()) {
            var = var.withParam(false);
        }
        Variable[] vars = this.arrayWithVariable(var);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.revisionDate, this.techId, this.flags, vars, this.params);
    }

    public ImmutableCell withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.revisionDate, this.techId, this.flags, vars, this.params);
    }

    ImmutableCell withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        Variable[] params = ImmutableCell.arrayWithRenamedIds(this.params, idMapper);
        CellId cellId = idMapper.get(this.cellId);
        if (this.getVars() == vars && this.params == params && this.cellId == cellId) {
            return this;
        }
        return new ImmutableCell(cellId, this.groupName, this.creationDate, this.revisionDate, this.techId, this.flags, vars, params);
    }

    public ImmutableCell withoutVariables() {
        if (this.getNumVariables() == 0 && this.params.length == 0) {
            return this;
        }
        return new ImmutableCell(this.cellId, this.groupName, this.creationDate, this.revisionDate, this.techId, this.flags, Variable.NULL_ARRAY, Variable.NULL_ARRAY);
    }

    void checkSimilarParams(ImmutableCell that) {
        if (this.params.length != that.params.length) {
            throw new IllegalArgumentException("Different params in " + this + " and " + that);
        }
        for (int i = 0; i < this.params.length; ++i) {
            Variable thisParam = this.params[i];
            Variable thatParam = that.params[i];
            if (thisParam.getKey() != thatParam.getKey()) {
                throw new IllegalArgumentException("Different params in " + this + " and " + that);
            }
            if (thisParam.getUnit() != thatParam.getUnit()) {
                throw new IllegalArgumentException("Different units of param " + thisParam.getKey() + " in " + this + " and " + that);
            }
            if (thisParam.withObject(thatParam.getObject()) == thisParam) continue;
            throw new IllegalArgumentException("Different values of param " + thisParam.getKey() + " in " + this + " and " + that);
        }
    }

    public LibId getLibId() {
        return this.cellId.libId;
    }

    @Override
    void write(IdWriter writer) throws IOException {
        writer.writeNodeProtoId(this.cellId);
        writer.writeString(this.groupName.toString());
        writer.writeLong(this.creationDate);
        writer.writeLong(this.revisionDate);
        writer.writeBoolean(this.techId != null);
        if (this.techId != null) {
            writer.writeTechId(this.techId);
        }
        writer.writeInt(this.flags);
        super.write(writer);
        ImmutableCell.writeVars(this.params, writer);
    }

    static ImmutableCell read(IdReader reader) throws IOException {
        CellId cellId = (CellId)reader.readNodeProtoId();
        String groupNameString = reader.readString();
        CellName groupName = CellName.parseName(groupNameString);
        long creationDate = reader.readLong();
        long revisionDate = reader.readLong();
        boolean hasTechId = reader.readBoolean();
        TechId techId = hasTechId ? reader.readTechId() : null;
        int flags = reader.readInt();
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableCell.readVars(reader) : Variable.NULL_ARRAY;
        Variable[] params = ImmutableCell.readVars(reader);
        return new ImmutableCell(cellId, groupName, creationDate, revisionDate, techId, flags, vars, params);
    }

    @Override
    public int hashCodeExceptVariables() {
        return this.cellId.hashCode();
    }

    @Override
    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableCell)) {
            return false;
        }
        ImmutableCell that = (ImmutableCell)o;
        return this.cellId == that.cellId && this.groupName == that.groupName && this.creationDate == that.creationDate && this.revisionDate == that.revisionDate && this.techId == that.techId && this.flags == that.flags && this.params == that.params;
    }

    public void check() {
        super.check(true);
        assert (this.cellId != null);
        assert (this.groupName.getVersion() == 0);
        assert (this.groupName.getView() == View.SCHEMATIC);
        assert (this.techId == null || this.techId.idManager == this.cellId.idManager);
        for (int i = 0; i < this.params.length; ++i) {
            Variable param = this.params[i];
            param.check(true, true);
            assert (param.getTextDescriptor().isParam() && param.getTextDescriptor().isInherit());
            if (i > 0) assert (this.params[i - 1].getKey().compareTo(param.getKey()) < 0);
            assert (this.searchVar(param.getKey()) < 0);
        }
        if (this.params.length > 0) {
            assert (this.paramsAllowed());
            for (Variable var : this.getVars()) {
                if (var.isAttribute()) assert (ImmutableCell.searchVar(this.params, var.getKey()) < 0);
            }
        } else assert (this.params == Variable.NULL_ARRAY);
    }

    public boolean paramsAllowed() {
        return this.cellId.isIcon() || this.cellId.isSchematic();
    }

    public boolean busNamesAllowed() {
        return this.cellId.isIcon() || this.cellId.isSchematic() || this.cellId.libId.libName.equals("Clipboard!!");
    }

    public String toString() {
        return this.cellId.toString();
    }
}

