/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.technology.xml.XmlParam;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoCMOS
extends Technology {
    public static final int SCMOSRULES = 0;
    public static final int SUBMRULES = 1;
    public static final int DEEPRULES = 2;
    public static final Variable.Key TECH_LAST_STATE = Variable.newKey("TECH_last_state");
    public static final Version changeOfMetal6 = Version.parseVersion("8.02o");
    private Layer[] viaLayers = new Layer[5];
    private Layer poly1Layer;
    private Layer poly2_lay;
    private Layer transistorPolyLayer;
    private Layer silicideBlockLayer;
    private Layer[] selectLayers;
    private Layer[] metalLayers = new Layer[6];
    private Layer polyCutLayer;
    private Layer pActiveWellLayer;
    private Layer[] activeLayers = new Layer[2];
    private Layer[] pseudoActiveLayers = new Layer[2];
    private Layer[] pseudoSelectLayers = new Layer[2];
    private Layer[] pseudoWellLayers = new Layer[2];
    private Layer[] wellLayers = new Layer[2];
    private Layer activeCutLayer;
    private Layer thickActiveLayer;
    private Layer passivationLayer;
    private Layer polyCapLayer;
    private Layer padFrameLayer;
    private Layer pBaseLayer;
    private ArcProto[] metalArcs = new ArcProto[6];
    private ArcProto[] polyArcs = new ArcProto[2];
    private ArcProto[] activeArcs = new ArcProto[2];
    private ArcProto[] wellArcs = new ArcProto[2];
    private ArcProto active_arc;
    private PrimitiveNode[] metalPinNodes = new PrimitiveNode[6];
    private PrimitiveNode[] activePinNodes = new PrimitiveNode[2];
    private PrimitiveNode[] wellPinNodes = new PrimitiveNode[2];
    private PrimitiveNode[] polyPinNodes = new PrimitiveNode[2];
    private PrimitiveNode[] metalActiveContactNodes = new PrimitiveNode[2];
    private PrimitiveNode[] metal1PolyContactNodes = new PrimitiveNode[3];
    private PrimitiveNode[] transistorNodes = new PrimitiveNode[2];
    private PrimitiveNode[] thickTransistorNodes = new PrimitiveNode[2];
    private PrimitiveNode[] scalableTransistorNodes;
    private PrimitiveNode npnTransistorNode;
    private PrimitiveNode[] metalContactNodes = new PrimitiveNode[5];
    private PrimitiveNode[] metalWellContactNodes = new PrimitiveNode[2];
    private Technology.NodeLayer[] transistorPolyLayers = new Technology.NodeLayer[2];
    private Technology.NodeLayer[] transistorActiveLayers = new Technology.NodeLayer[2];
    private Technology.NodeLayer[] transistorActiveTLayers = new Technology.NodeLayer[2];
    private Technology.NodeLayer[] transistorActiveBLayers = new Technology.NodeLayer[2];
    private Technology.NodeLayer[] transistorPolyLLayers = new Technology.NodeLayer[2];
    private Technology.NodeLayer[] transistorPolyRLayers = new Technology.NodeLayer[2];
    private Technology.NodeLayer[] transistorPolyCLayers = new Technology.NodeLayer[2];
    private Technology.NodeLayer[] transistorWellLayers = new Technology.NodeLayer[2];
    private Technology.NodeLayer[] transistorSelectLayers = new Technology.NodeLayer[2];
    private static final int SCALABLE_ACTIVE_TOP = 0;
    private static final int SCALABLE_METAL_TOP = 1;
    private static final int SCALABLE_ACTIVE_BOT = 2;
    private static final int SCALABLE_METAL_BOT = 3;
    private static final int SCALABLE_ACTIVE_CTR = 4;
    private static final int SCALABLE_POLY = 5;
    private static final int SCALABLE_WELL = 6;
    private static final int SCALABLE_SUBSTRATE = 7;
    private static final int SCALABLE_TOTAL = 8;
    private final Setting cacheRuleSet = this.makeIntSetting("MoCMOSRuleSet", "Technology tab", "MOSIS CMOS rule set", "MOCMOS Rule Set", 1);
    private final Setting cacheSecondPolysilicon;
    private final Setting cacheDisallowStackedVias;
    private final Setting cacheAlternateActivePolyRules;
    private final Setting cacheAnalog;
    private static final int MOCMOSNOSTACKEDVIAS = 1;
    private static final int MOCMOSMETALS = 28;
    private static final int MOCMOS2METAL = 0;
    private static final int MOCMOS3METAL = 4;
    private static final int MOCMOS4METAL = 8;
    private static final int MOCMOS5METAL = 12;
    private static final int MOCMOS6METAL = 16;
    private static final int MOCMOSRULESET = 96;
    private static final int MOCMOSSUBMRULES = 0;
    private static final int MOCMOSDEEPRULES = 32;
    private static final int MOCMOSSCMOSRULES = 64;
    private static final int MOCMOSALTAPRULES = 128;
    private static final int MOCMOSTWOPOLY = 256;

    public MoCMOS(Generic generic, Xml.Technology t) {
        super(generic, t);
        int i;
        this.cacheRuleSet.setTrueMeaning(new String[]{"SCMOS", "Submicron", "Deep"});
        this.cacheSecondPolysilicon = this.makeBooleanSetting(this.getTechName() + "SecondPolysilicon", "Technology tab", this.getTechName().toUpperCase() + " CMOS: Second Polysilicon Layer", "UseSecondPolysilicon", true);
        this.cacheDisallowStackedVias = this.makeBooleanSetting("MoCMOSDisallowStackedVias", "Technology tab", "MOSIS CMOS: Disallow Stacked Vias", "DisallowStackedVias", false);
        this.cacheAlternateActivePolyRules = this.makeBooleanSetting("MoCMOSAlternateActivePolyRules", "Technology tab", "MOSIS CMOS: Alternate Active and Poly Contact Rules", "UseAlternativeActivePolyRules", false);
        this.cacheAnalog = this.makeBooleanSetting(this.getTechName() + "Analog", "Technology tab", "MOSIS CMOS: Vertical NPN transistor pbase", "Analog", false);
        this.setNoNegatedArcs();
        this.setStaticTechnology();
        this.setFactoryResolution(0.01);
        this.setFactoryLESettings(0.167, 0.16, 0.7);
        this.metalLayers[0] = this.findLayer("Metal-1");
        this.metalLayers[1] = this.findLayer("Metal-2");
        this.metalLayers[2] = this.findLayer("Metal-3");
        this.metalLayers[3] = this.findLayer("Metal-4");
        this.metalLayers[4] = this.findLayer("Metal-5");
        this.metalLayers[5] = this.findLayer("Metal-6");
        this.poly1Layer = this.findLayer("Polysilicon-1");
        this.poly2_lay = this.findLayer("Polysilicon-2");
        this.activeLayers[0] = this.findLayer("P-Active");
        this.activeLayers[1] = this.findLayer("N-Active");
        this.selectLayers = new Layer[2];
        this.selectLayers[0] = this.findLayer("P-Select");
        this.selectLayers[1] = this.findLayer("N-Select");
        this.wellLayers[0] = this.findLayer("P-Well");
        this.wellLayers[1] = this.findLayer("N-Well");
        this.polyCutLayer = this.findLayer("Poly-Cut");
        this.activeCutLayer = this.findLayer("Active-Cut");
        for (int i2 = 0; i2 < this.viaLayers.length; ++i2) {
            this.viaLayers[i2] = this.findLayer("Via");
        }
        this.passivationLayer = this.findLayer("Passivation");
        this.transistorPolyLayer = this.findLayer("Transistor-Poly");
        this.polyCapLayer = this.findLayer("Poly-Cap");
        this.pActiveWellLayer = this.findLayer("P-Active-Well");
        this.silicideBlockLayer = this.findLayer("Silicide-Block");
        this.thickActiveLayer = this.findLayer("Thick-Active");
        this.padFrameLayer = this.findLayer("Pad-Frame");
        this.pBaseLayer = this.findLayer("P-Base");
        Layer pseudoMetal1_lay = this.metalLayers[0].getPseudoLayer();
        Layer pseudoMetal2_lay = this.metalLayers[1].getPseudoLayer();
        Layer pseudoMetal3_lay = this.metalLayers[2].getPseudoLayer();
        Layer pseudoMetal4_lay = this.metalLayers[3].getPseudoLayer();
        Layer pseudoMetal5_lay = this.metalLayers[4].getPseudoLayer();
        Layer pseudoMetal6_lay = this.metalLayers[5].getPseudoLayer();
        Layer pseudoPoly1_lay = this.poly1Layer.getPseudoLayer();
        Layer pseudoPoly2_lay = this.poly2_lay.getPseudoLayer();
        this.pseudoActiveLayers[0] = this.activeLayers[0].getPseudoLayer();
        this.pseudoActiveLayers[1] = this.activeLayers[1].getPseudoLayer();
        this.pseudoSelectLayers[0] = this.selectLayers[0].getPseudoLayer();
        this.pseudoSelectLayers[1] = this.selectLayers[1].getPseudoLayer();
        this.pseudoWellLayers[0] = this.wellLayers[0].getPseudoLayer();
        this.pseudoWellLayers[1] = this.wellLayers[1].getPseudoLayer();
        this.metalArcs[0] = this.findArcProto("Metal-1");
        this.metalArcs[1] = this.findArcProto("Metal-2");
        this.metalArcs[2] = this.findArcProto("Metal-3");
        this.metalArcs[3] = this.findArcProto("Metal-4");
        this.metalArcs[4] = this.findArcProto("Metal-5");
        this.metalArcs[5] = this.findArcProto("Metal-6");
        this.polyArcs[0] = this.findArcProto("Polysilicon-1");
        this.polyArcs[1] = this.findArcProto("Polysilicon-2");
        this.activeArcs[0] = this.findArcProto("P-Active");
        this.activeArcs[1] = this.findArcProto("N-Active");
        this.wellArcs[0] = this.findArcProto("P-Well");
        this.wellArcs[1] = this.findArcProto("N-Well");
        this.active_arc = this.findArcProto("Active");
        this.metalPinNodes[0] = this.findNodeProto("Metal-1-Pin");
        this.metalPinNodes[1] = this.findNodeProto("Metal-2-Pin");
        this.metalPinNodes[2] = this.findNodeProto("Metal-3-Pin");
        this.metalPinNodes[3] = this.findNodeProto("Metal-4-Pin");
        this.metalPinNodes[4] = this.findNodeProto("Metal-5-Pin");
        this.metalPinNodes[5] = this.findNodeProto("Metal-6-Pin");
        this.polyPinNodes[0] = this.findNodeProto("Polysilicon-1-Pin");
        this.polyPinNodes[1] = this.findNodeProto("Polysilicon-2-Pin");
        this.activePinNodes[0] = this.findNodeProto("P-Active-Pin");
        this.activePinNodes[1] = this.findNodeProto("N-Active-Pin");
        PrimitiveNode activeGenPinNode = this.findNodeProto("Active-Pin");
        this.wellPinNodes[0] = this.findNodeProto("P-Well-Pin");
        this.wellPinNodes[1] = this.findNodeProto("N-Well-Pin");
        this.metalActiveContactNodes[0] = this.findNodeProto("Metal-1-P-Active-Con");
        this.metalActiveContactNodes[1] = this.findNodeProto("Metal-1-N-Active-Con");
        this.metal1PolyContactNodes[0] = this.findNodeProto("Metal-1-Polysilicon-1-Con");
        this.metal1PolyContactNodes[1] = this.findNodeProto("Metal-1-Polysilicon-2-Con");
        this.metal1PolyContactNodes[2] = this.findNodeProto("Metal-1-Polysilicon-1-2-Con");
        String[] stdNames = new String[]{"p", "n"};
        for (int i3 = 0; i3 < 2; ++i3) {
            this.transistorNodes[i3] = this.findNodeProto(stdNames[i3].toUpperCase() + "-Transistor");
        }
        String[] thickNames = new String[]{"Thick-P", "Thick-N"};
        for (i = 0; i < this.thickTransistorNodes.length; ++i) {
            this.thickTransistorNodes[i] = this.findNodeProto(thickNames[i] + "-Transistor");
        }
        this.scalableTransistorNodes = new PrimitiveNode[2];
        this.scalableTransistorNodes[0] = this.findNodeProto("P-Transistor-Scalable");
        this.scalableTransistorNodes[1] = this.findNodeProto("N-Transistor-Scalable");
        this.npnTransistorNode = this.findNodeProto("NPN-Transistor");
        this.metalContactNodes[0] = this.findNodeProto("Metal-1-Metal-2-Con");
        this.metalContactNodes[1] = this.findNodeProto("Metal-2-Metal-3-Con");
        this.metalContactNodes[2] = this.findNodeProto("Metal-3-Metal-4-Con");
        this.metalContactNodes[3] = this.findNodeProto("Metal-4-Metal-5-Con");
        this.metalContactNodes[4] = this.findNodeProto("Metal-5-Metal-6-Con");
        for (i = 0; i < this.metalWellContactNodes.length; ++i) {
            this.metalWellContactNodes[i] = this.findNodeProto(this.metalLayers[0].getName() + "-" + this.wellLayers[i].getName() + "-Con");
        }
    }

    public MoCMOS(Generic generic) {
        this(generic, "mocmos", "MOSIS CMOS", "MOSIS CMOS", Foundry.Type.MOSIS, 200.0, true);
        this.initFoundryMOSIS();
    }

    private MoCMOS(Generic generic, String techName, String techShortName, String techDesc, Foundry.Type defaultFoundryType, double factoryScale, boolean haveMocmosExtensions) {
        super(generic, techName, defaultFoundryType, 6);
        int i;
        this.cacheRuleSet.setTrueMeaning(new String[]{"SCMOS", "Submicron", "Deep"});
        this.cacheSecondPolysilicon = this.makeBooleanSetting(this.getTechName() + "SecondPolysilicon", "Technology tab", this.getTechName().toUpperCase() + " CMOS: Second Polysilicon Layer", "UseSecondPolysilicon", true);
        this.cacheDisallowStackedVias = this.makeBooleanSetting("MoCMOSDisallowStackedVias", "Technology tab", "MOSIS CMOS: Disallow Stacked Vias", "DisallowStackedVias", false);
        this.cacheAlternateActivePolyRules = this.makeBooleanSetting("MoCMOSAlternateActivePolyRules", "Technology tab", "MOSIS CMOS: Alternate Active and Poly Contact Rules", "UseAlternativeActivePolyRules", false);
        this.cacheAnalog = this.makeBooleanSetting(this.getTechName() + "Analog", "Technology tab", "MOSIS CMOS: Vertical NPN transistor pbase", "Analog", false);
        this.setFactoryScale(factoryScale, true);
        this.setTechShortName(techShortName);
        this.setTechDesc(techDesc);
        this.setNoNegatedArcs();
        this.setStaticTechnology();
        this.setFactoryTransparentLayers(new Color[]{new Color(96, 209, 255), new Color(255, 155, 192), new Color(107, 226, 96), new Color(224, 95, 255), new Color(247, 251, 20)});
        this.setFactoryResolution(0.01);
        this.metalLayers[0] = Layer.newInstance(this, "Metal-1", new EGraphics(false, true, null, 1, 96, 209, 255, 0.8, true, new int[]{8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0}));
        this.metalLayers[1] = Layer.newInstance(this, "Metal-2", new EGraphics(false, true, null, 4, 224, 95, 255, 0.7, true, new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056}));
        this.metalLayers[2] = Layer.newInstance(this, "Metal-3", new EGraphics(false, true, null, 5, 247, 251, 20, 0.6, true, new int[]{8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0}));
        this.metalLayers[3] = Layer.newInstance(this, "Metal-4", new EGraphics(true, true, null, 0, 150, 150, 255, 0.5, true, new int[]{65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0}));
        this.metalLayers[4] = Layer.newInstance(this, "Metal-5", new EGraphics(true, true, EGraphics.Outline.PAT_S, 0, 255, 190, 6, 0.4, true, new int[]{34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476}));
        this.metalLayers[5] = Layer.newInstance(this, "Metal-6", new EGraphics(true, true, null, 0, 0, 255, 255, 0.3, true, new int[]{34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369}));
        this.poly1Layer = Layer.newInstance(this, "Polysilicon-1", new EGraphics(false, true, null, 2, 255, 155, 192, 1.0, true, new int[]{4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845}));
        this.poly2_lay = Layer.newInstance(this, "Polysilicon-2", new EGraphics(true, true, null, 0, 255, 190, 6, 1.0, true, new int[]{44975, 34952, 64250, 34952, 44975, 34952, 64250, 34952, 44975, 34952, 64250, 34952, 44975, 34952, 64250, 34952}));
        this.activeLayers[0] = Layer.newInstance(this, "P-Active", new EGraphics(false, true, null, 3, 107, 226, 96, 1.0, true, new int[]{0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336}));
        this.activeLayers[1] = Layer.newInstance(this, "N-Active", new EGraphics(false, true, null, 3, 107, 226, 96, 1.0, true, new int[]{0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336}));
        this.selectLayers = new Layer[2];
        this.selectLayers[0] = Layer.newInstance(this, "P-Select", new EGraphics(true, true, null, 0, 255, 255, 0, 1.0, false, new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056}));
        this.selectLayers[1] = Layer.newInstance(this, "N-Select", new EGraphics(true, true, null, 0, 255, 255, 0, 1.0, false, new int[]{257, 0, 4112, 0, 257, 0, 4112, 0, 257, 0, 4112, 0, 257, 0, 4112, 0}));
        this.wellLayers[0] = Layer.newInstance(this, "P-Well", new EGraphics(true, true, null, 0, 139, 99, 46, 1.0, false, new int[]{514, 257, 32896, 16448, 8224, 4112, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 2056, 1028}));
        this.wellLayers[1] = Layer.newInstance(this, "N-Well", new EGraphics(true, true, null, 0, 139, 99, 46, 1.0, false, new int[]{514, 0, 8224, 0, 514, 0, 8224, 0, 514, 0, 8224, 0, 514, 0, 8224, 0}));
        this.polyCutLayer = Layer.newInstance(this, "Poly-Cut", new EGraphics(false, false, null, 0, 100, 100, 100, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.activeCutLayer = Layer.newInstance(this, "Active-Cut", new EGraphics(false, false, null, 0, 100, 100, 100, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        for (int i2 = 0; i2 < this.viaLayers.length; ++i2) {
            this.viaLayers[i2] = Layer.newInstance(this, "Via" + (i2 + 1), new EGraphics(false, false, null, 0, 180, 180, 180, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        }
        this.passivationLayer = Layer.newInstance(this, "Passivation", new EGraphics(true, true, null, 0, 100, 100, 100, 1.0, true, new int[]{7196, 15934, 13878, 15934, 7196, 0, 0, 0, 7196, 15934, 13878, 15934, 7196, 0, 0, 0}));
        this.transistorPolyLayer = Layer.newInstance(this, "Transistor-Poly", new EGraphics(false, true, null, 2, 255, 155, 192, 1.0, true, new int[]{4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845}));
        this.polyCapLayer = Layer.newInstance(this, "Poly-Cap", new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.pActiveWellLayer = Layer.newInstance(this, "P-Active-Well", new EGraphics(false, true, null, 3, 107, 226, 96, 1.0, false, new int[]{0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336}));
        this.silicideBlockLayer = Layer.newInstance(this, "Silicide-Block", new EGraphics(true, true, null, 2, 255, 155, 192, 1.0, true, new int[]{4112, 10280, 17476, 33410, 257, 0, 0, 0, 4112, 10280, 17476, 33410, 257, 0, 0, 0}));
        this.thickActiveLayer = Layer.newInstance(this, "Thick-Active", new EGraphics(true, true, null, 0, 0, 0, 0, 1.0, false, new int[]{16448, 32896, 257, 514, 257, 32896, 16448, 8224, 16448, 32896, 257, 514, 257, 32896, 16448, 8224}));
        this.padFrameLayer = Layer.newInstance(this, "Pad-Frame", new EGraphics(false, false, null, 0, 255, 0, 0, 1.0, false, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.createExtraLayers();
        this.metalLayers[0].setFunction(Layer.Function.METAL1);
        this.metalLayers[1].setFunction(Layer.Function.METAL2);
        this.metalLayers[2].setFunction(Layer.Function.METAL3);
        this.metalLayers[3].setFunction(Layer.Function.METAL4);
        this.metalLayers[4].setFunction(Layer.Function.METAL5);
        this.metalLayers[5].setFunction(Layer.Function.METAL6);
        this.poly1Layer.setFunction(Layer.Function.POLY1);
        this.poly2_lay.setFunction(Layer.Function.POLY2);
        this.activeLayers[0].setFunction(Layer.Function.DIFFP);
        this.activeLayers[1].setFunction(Layer.Function.DIFFN);
        this.selectLayers[0].setFunction(Layer.Function.IMPLANTP);
        this.selectLayers[1].setFunction(Layer.Function.IMPLANTN);
        this.wellLayers[0].setFunction(Layer.Function.WELLP);
        this.wellLayers[1].setFunction(Layer.Function.WELLN);
        this.polyCutLayer.setFunction(Layer.Function.CONTACT1, 32768);
        this.activeCutLayer.setFunction(Layer.Function.CONTACT1, 65536);
        this.viaLayers[0].setFunction(Layer.Function.CONTACT2, 16384);
        this.viaLayers[1].setFunction(Layer.Function.CONTACT3, 16384);
        this.viaLayers[2].setFunction(Layer.Function.CONTACT4, 16384);
        this.viaLayers[3].setFunction(Layer.Function.CONTACT5, 16384);
        this.viaLayers[4].setFunction(Layer.Function.CONTACT6, 16384);
        this.passivationLayer.setFunction(Layer.Function.OVERGLASS);
        this.transistorPolyLayer.setFunction(Layer.Function.GATE);
        this.polyCapLayer.setFunction(Layer.Function.CAP);
        this.pActiveWellLayer.setFunction(Layer.Function.DIFFP);
        this.silicideBlockLayer.setFunction(Layer.Function.ART);
        this.thickActiveLayer.setFunction(Layer.Function.DIFF, 0x800000);
        this.padFrameLayer.setFunction(Layer.Function.ART);
        if (this.pBaseLayer != null) {
            this.pBaseLayer.setFunction(Layer.Function.BASE);
        }
        Layer pseudoMetal1_lay = this.metalLayers[0].makePseudo();
        Layer pseudoMetal2_lay = this.metalLayers[1].makePseudo();
        Layer pseudoMetal3_lay = this.metalLayers[2].makePseudo();
        Layer pseudoMetal4_lay = this.metalLayers[3].makePseudo();
        Layer pseudoMetal5_lay = this.metalLayers[4].makePseudo();
        Layer pseudoMetal6_lay = this.metalLayers[5].makePseudo();
        Layer pseudoPoly1_lay = this.poly1Layer.makePseudo();
        Layer pseudoPoly2_lay = this.poly2_lay.makePseudo();
        this.pseudoActiveLayers[0] = this.activeLayers[0].makePseudo();
        this.pseudoActiveLayers[1] = this.activeLayers[1].makePseudo();
        this.pseudoSelectLayers[0] = this.selectLayers[0].makePseudo();
        this.pseudoSelectLayers[1] = this.selectLayers[1].makePseudo();
        this.pseudoWellLayers[0] = this.wellLayers[0].makePseudo();
        this.pseudoWellLayers[1] = this.wellLayers[1].makePseudo();
        this.metalLayers[0].setFactoryCIFLayer("CMF");
        this.metalLayers[1].setFactoryCIFLayer("CMS");
        this.metalLayers[2].setFactoryCIFLayer("CMT");
        this.metalLayers[3].setFactoryCIFLayer("CMQ");
        this.metalLayers[4].setFactoryCIFLayer("CMP");
        this.metalLayers[5].setFactoryCIFLayer("CM6");
        this.poly1Layer.setFactoryCIFLayer("CPG");
        this.poly2_lay.setFactoryCIFLayer("CEL");
        this.activeLayers[0].setFactoryCIFLayer("CAA");
        this.activeLayers[1].setFactoryCIFLayer("CAA");
        this.selectLayers[0].setFactoryCIFLayer("CSP");
        this.selectLayers[1].setFactoryCIFLayer("CSN");
        this.wellLayers[0].setFactoryCIFLayer("CWP");
        this.wellLayers[1].setFactoryCIFLayer("CWN");
        this.polyCutLayer.setFactoryCIFLayer("CCC");
        this.activeCutLayer.setFactoryCIFLayer("CCC");
        this.viaLayers[0].setFactoryCIFLayer("CVA");
        this.viaLayers[1].setFactoryCIFLayer("CVS");
        this.viaLayers[2].setFactoryCIFLayer("CVT");
        this.viaLayers[3].setFactoryCIFLayer("CVQ");
        this.viaLayers[4].setFactoryCIFLayer("CV5");
        this.passivationLayer.setFactoryCIFLayer("COG");
        this.transistorPolyLayer.setFactoryCIFLayer("CPG");
        this.polyCapLayer.setFactoryCIFLayer("CPC");
        this.pActiveWellLayer.setFactoryCIFLayer("CAA");
        this.silicideBlockLayer.setFactoryCIFLayer("CSB");
        this.thickActiveLayer.setFactoryCIFLayer("CTA");
        this.padFrameLayer.setFactoryCIFLayer("XP");
        this.pBaseLayer.setFactoryCIFLayer("CBA");
        this.metalLayers[0].setFactorySkillLayer("metal1");
        this.metalLayers[1].setFactorySkillLayer("metal2");
        this.metalLayers[2].setFactorySkillLayer("metal3");
        this.metalLayers[3].setFactorySkillLayer("metal4");
        this.metalLayers[4].setFactorySkillLayer("metal5");
        this.metalLayers[5].setFactorySkillLayer("metal6");
        this.poly1Layer.setFactorySkillLayer("poly");
        this.poly2_lay.setFactorySkillLayer("");
        this.activeLayers[0].setFactorySkillLayer("aa");
        this.activeLayers[1].setFactorySkillLayer("aa");
        this.selectLayers[0].setFactorySkillLayer("pplus");
        this.selectLayers[1].setFactorySkillLayer("nplus");
        this.wellLayers[0].setFactorySkillLayer("pwell");
        this.wellLayers[1].setFactorySkillLayer("nwell");
        this.polyCutLayer.setFactorySkillLayer("pcont");
        this.activeCutLayer.setFactorySkillLayer("acont");
        this.viaLayers[0].setFactorySkillLayer("via");
        this.viaLayers[1].setFactorySkillLayer("via2");
        this.viaLayers[2].setFactorySkillLayer("via3");
        this.viaLayers[3].setFactorySkillLayer("via4");
        this.viaLayers[4].setFactorySkillLayer("via5");
        this.passivationLayer.setFactorySkillLayer("glasscut");
        this.transistorPolyLayer.setFactorySkillLayer("poly");
        this.polyCapLayer.setFactorySkillLayer("");
        this.pActiveWellLayer.setFactorySkillLayer("aa");
        this.silicideBlockLayer.setFactorySkillLayer("");
        this.thickActiveLayer.setFactorySkillLayer("");
        this.padFrameLayer.setFactorySkillLayer("");
        this.setFactoryLESettings(0.167, 0.16, 0.7);
        double BULK_LAYER = 0.0;
        double WELL_THICKNESS = 13.0;
        double SELECT_THICKNESS = 5.0;
        double SELECT_DISTANCE = 8.0;
        double ACTIVE_THICKNESS = 4.0;
        double ACTIVE_DISTANCE = 9.0;
        double THICKACT_THICKNESS = 7.0;
        double THICKACT_DISTANCE = 6.0;
        double ILD_LAYER = 3.5;
        double IMD_LAYER = 5.65;
        double METAL_LAYER = 2.65;
        this.wellLayers[0].setFactory3DInfo(WELL_THICKNESS, BULK_LAYER, "NICEST", 0.8);
        this.wellLayers[1].setFactory3DInfo(WELL_THICKNESS, BULK_LAYER, "NICEST", 0.8);
        this.selectLayers[0].setFactory3DInfo(SELECT_THICKNESS, SELECT_DISTANCE, "SCREEN_DOOR", 0.4);
        this.selectLayers[1].setFactory3DInfo(SELECT_THICKNESS, SELECT_DISTANCE, "SCREEN_DOOR", 0.4);
        this.activeLayers[0].setFactory3DInfo(ACTIVE_THICKNESS, ACTIVE_DISTANCE, "NONE", 0.0);
        this.activeLayers[1].setFactory3DInfo(ACTIVE_THICKNESS, ACTIVE_DISTANCE, "NONE", 0.0);
        this.pActiveWellLayer.setFactory3DInfo(ACTIVE_THICKNESS, ACTIVE_DISTANCE, "NONE", 0.0);
        this.thickActiveLayer.setFactory3DInfo(THICKACT_THICKNESS, THICKACT_DISTANCE, "NICEST", 0.6);
        this.metalLayers[0].setFactory3DInfo(METAL_LAYER, ILD_LAYER + this.activeLayers[0].getDepth(), "NONE", 0.2);
        this.metalLayers[1].setFactory3DInfo(METAL_LAYER, IMD_LAYER + this.metalLayers[0].getDistance(), "NONE", 0.2);
        this.viaLayers[0].setFactory3DInfo(this.metalLayers[1].getDistance() - this.metalLayers[0].getDepth(), this.metalLayers[0].getDepth(), "NONE", 0.2);
        this.metalLayers[2].setFactory3DInfo(METAL_LAYER, IMD_LAYER + this.metalLayers[1].getDistance(), "NONE", 0.2);
        this.viaLayers[1].setFactory3DInfo(this.metalLayers[2].getDistance() - this.metalLayers[1].getDepth(), this.metalLayers[1].getDepth(), "NONE", 0.2);
        this.metalLayers[3].setFactory3DInfo(METAL_LAYER, IMD_LAYER + this.metalLayers[2].getDistance(), "NONE", 0.2);
        this.viaLayers[2].setFactory3DInfo(this.metalLayers[3].getDistance() - this.metalLayers[2].getDepth(), this.metalLayers[2].getDepth(), "NONE", 0.2);
        this.metalLayers[4].setFactory3DInfo(METAL_LAYER, IMD_LAYER + this.metalLayers[3].getDistance(), "NONE", 0.2);
        this.viaLayers[3].setFactory3DInfo(this.metalLayers[4].getDistance() - this.metalLayers[3].getDepth(), this.metalLayers[3].getDepth(), "NONE", 0.2);
        this.metalLayers[5].setFactory3DInfo(4.95, IMD_LAYER + this.metalLayers[4].getDistance(), "NONE", 0.2);
        this.viaLayers[4].setFactory3DInfo(this.metalLayers[5].getDistance() - this.metalLayers[4].getDepth(), this.metalLayers[4].getDepth(), "NONE", 0.2);
        double PASS_LAYER = 5.0;
        double PO_LAYER = 1.0;
        double FOX_LAYER = 0.0;
        double FOX_LAYER_POLY2 = 2.85;
        double TOX_LAYER = 0.0;
        double activeDepth = this.activeLayers[0].getDepth();
        this.poly1Layer.setFactory3DInfo(PO_LAYER, FOX_LAYER + activeDepth, "NONE", 0.2);
        this.transistorPolyLayer.setFactory3DInfo(PO_LAYER, TOX_LAYER + activeDepth, "NONE", 0.2);
        this.poly2_lay.setFactory3DInfo(PO_LAYER, FOX_LAYER_POLY2 + activeDepth, "NONE", 0.2);
        this.polyCapLayer.setFactory3DInfo(PO_LAYER, FOX_LAYER + activeDepth, "NONE", 0.2);
        this.polyCutLayer.setFactory3DInfo(this.metalLayers[0].getDistance() - this.poly1Layer.getDepth(), this.poly1Layer.getDepth(), "NONE", 0.2);
        this.activeCutLayer.setFactory3DInfo(this.metalLayers[0].getDistance() - this.activeLayers[1].getDepth(), this.activeLayers[1].getDepth(), "NONE", 0.2);
        this.passivationLayer.setFactory3DInfo(PASS_LAYER, this.metalLayers[5].getDepth(), "NONE", 0.2);
        this.silicideBlockLayer.setFactory3DInfo(0.0, BULK_LAYER, "NONE", 0.2);
        this.padFrameLayer.setFactory3DInfo(0.0, this.passivationLayer.getDepth(), "NONE", 0.2);
        this.metalLayers[0].setFactoryParasitics(0.078, 0.1209, 0.1104);
        this.metalLayers[1].setFactoryParasitics(0.078, 0.0843, 0.0974);
        this.metalLayers[2].setFactoryParasitics(0.078, 0.0843, 0.0974);
        this.metalLayers[3].setFactoryParasitics(0.078, 0.0843, 0.0974);
        this.metalLayers[4].setFactoryParasitics(0.078, 0.0843, 0.0974);
        this.metalLayers[5].setFactoryParasitics(0.036, 0.0423, 0.1273);
        this.poly1Layer.setFactoryParasitics(6.2, 0.1467, 0.0608);
        this.poly2_lay.setFactoryParasitics(50.0, 1.0, 0.0);
        this.activeLayers[0].setFactoryParasitics(2.5, 0.9, 0.0);
        this.activeLayers[1].setFactoryParasitics(3.0, 0.9, 0.0);
        this.selectLayers[0].setFactoryParasitics(0.0, 0.0, 0.0);
        this.selectLayers[1].setFactoryParasitics(0.0, 0.0, 0.0);
        this.wellLayers[0].setFactoryParasitics(0.0, 0.0, 0.0);
        this.wellLayers[1].setFactoryParasitics(0.0, 0.0, 0.0);
        this.polyCutLayer.setFactoryParasitics(2.2, 0.0, 0.0);
        this.activeCutLayer.setFactoryParasitics(2.5, 0.0, 0.0);
        this.viaLayers[0].setFactoryParasitics(1.0, 0.0, 0.0);
        this.viaLayers[1].setFactoryParasitics(0.9, 0.0, 0.0);
        this.viaLayers[2].setFactoryParasitics(0.8, 0.0, 0.0);
        this.viaLayers[3].setFactoryParasitics(0.8, 0.0, 0.0);
        this.viaLayers[4].setFactoryParasitics(0.8, 0.0, 0.0);
        this.passivationLayer.setFactoryParasitics(0.0, 0.0, 0.0);
        this.transistorPolyLayer.setFactoryParasitics(2.5, 0.09, 0.0);
        this.polyCapLayer.setFactoryParasitics(0.0, 0.0, 0.0);
        this.pActiveWellLayer.setFactoryParasitics(0.0, 0.0, 0.0);
        this.silicideBlockLayer.setFactoryParasitics(0.0, 0.0, 0.0);
        this.thickActiveLayer.setFactoryParasitics(0.0, 0.0, 0.0);
        this.padFrameLayer.setFactoryParasitics(0.0, 0.0, 0.0);
        this.setFactoryParasitics(4.0, 0.1);
        String[] headerLevel1 = new String[]{"*CMOS/BULK-NWELL (PRELIMINARY PARAMETERS)", ".OPTIONS NOMOD DEFL=3UM DEFW=3UM DEFAD=70P DEFAS=70P LIMPTS=1000", "+ITL5=0 RELTOL=0.01 ABSTOL=500PA VNTOL=500UV LVLTIM=2", "+LVLCOD=1", ".MODEL N NMOS LEVEL=1", "+KP=60E-6 VTO=0.7 GAMMA=0.3 LAMBDA=0.05 PHI=0.6", "+LD=0.4E-6 TOX=40E-9 CGSO=2.0E-10 CGDO=2.0E-10 CJ=.2MF/M^2", ".MODEL P PMOS LEVEL=1", "+KP=20E-6 VTO=0.7 GAMMA=0.4 LAMBDA=0.05 PHI=0.6", "+LD=0.6E-6 TOX=40E-9 CGSO=3.0E-10 CGDO=3.0E-10 CJ=.2MF/M^2", ".MODEL DIFFCAP D CJO=.2MF/M^2"};
        this.setSpiceHeaderLevel1(headerLevel1);
        String[] headerLevel2 = new String[]{"* MOSIS 3u CMOS PARAMS", ".OPTIONS NOMOD DEFL=2UM DEFW=6UM DEFAD=100P DEFAS=100P", "+LIMPTS=1000 ITL5=0 ABSTOL=500PA VNTOL=500UV", "* Note that ITL5=0 sets ITL5 to infinity", ".MODEL N NMOS LEVEL=2 LD=0.3943U TOX=502E-10", "+NSUB=1.22416E+16 VTO=0.756 KP=4.224E-05 GAMMA=0.9241", "+PHI=0.6 UO=623.661 UEXP=8.328627E-02 UCRIT=54015.0", "+DELTA=5.218409E-03 VMAX=50072.2 XJ=0.4U LAMBDA=2.975321E-02", "+NFS=4.909947E+12 NEFF=1.001E-02 NSS=0.0 TPG=1.0", "+RSH=20.37 CGDO=3.1E-10 CGSO=3.1E-10", "+CJ=3.205E-04 MJ=0.4579 CJSW=4.62E-10 MJSW=0.2955 PB=0.7", ".MODEL P PMOS LEVEL=2 LD=0.2875U TOX=502E-10", "+NSUB=1.715148E+15 VTO=-0.7045 KP=1.686E-05 GAMMA=0.3459", "+PHI=0.6 UO=248.933 UEXP=1.02652 UCRIT=182055.0", "+DELTA=1.0E-06 VMAX=100000.0 XJ=0.4U LAMBDA=1.25919E-02", "+NFS=1.0E+12 NEFF=1.001E-02 NSS=0.0 TPG=-1.0", "+RSH=79.10 CGDO=2.89E-10 CGSO=2.89E-10", "+CJ=1.319E-04 MJ=0.4125 CJSW=3.421E-10 MJSW=0.198 PB=0.66", ".TEMP 25.0"};
        this.setSpiceHeaderLevel2(headerLevel2);
        this.metalArcs[0] = this.newArcProto("Metal-1", 0.0, 3.0, ArcProto.Function.METAL1, new Technology.ArcLayer(this.metalLayers[0], Poly.Type.FILLED, "7.1"));
        this.metalArcs[0].setFactoryFixedAngle(true);
        this.metalArcs[0].setWipable();
        this.metalArcs[0].setFactoryAngleIncrement(90);
        this.metalArcs[1] = this.newArcProto("Metal-2", 0.0, 3.0, ArcProto.Function.METAL2, new Technology.ArcLayer(this.metalLayers[1], Poly.Type.FILLED, "9.1"));
        this.metalArcs[1].setFactoryFixedAngle(true);
        this.metalArcs[1].setWipable();
        this.metalArcs[1].setFactoryAngleIncrement(90);
        this.metalArcs[2] = this.newArcProto("Metal-3", 0.0, 3.0, ArcProto.Function.METAL3, new Technology.ArcLayer(this.metalLayers[2], Poly.Type.FILLED, "15.1"));
        this.metalArcs[2].setFactoryFixedAngle(true);
        this.metalArcs[2].setWipable();
        this.metalArcs[2].setFactoryAngleIncrement(90);
        this.metalArcs[3] = this.newArcProto("Metal-4", 0.0, 3.0, ArcProto.Function.METAL4, new Technology.ArcLayer(this.metalLayers[3], Poly.Type.FILLED, "22.1"));
        this.metalArcs[3].setFactoryFixedAngle(true);
        this.metalArcs[3].setWipable();
        this.metalArcs[3].setFactoryAngleIncrement(90);
        this.metalArcs[4] = this.newArcProto("Metal-5", 0.0, 3.0, ArcProto.Function.METAL5, new Technology.ArcLayer(this.metalLayers[4], Poly.Type.FILLED, "26.1"));
        this.metalArcs[4].setFactoryFixedAngle(true);
        this.metalArcs[4].setWipable();
        this.metalArcs[4].setFactoryAngleIncrement(90);
        this.metalArcs[5] = this.newArcProto("Metal-6", 0.0, 5.0, ArcProto.Function.METAL6, new Technology.ArcLayer(this.metalLayers[5], Poly.Type.FILLED, "30.1"));
        this.metalArcs[5].setFactoryFixedAngle(true);
        this.metalArcs[5].setWipable();
        this.metalArcs[5].setFactoryAngleIncrement(90);
        this.polyArcs[0] = this.newArcProto("Polysilicon-1", 0.0, 2.0, ArcProto.Function.POLY1, new Technology.ArcLayer(this.poly1Layer, Poly.Type.FILLED, "3.1"));
        this.polyArcs[0].setFactoryFixedAngle(true);
        this.polyArcs[0].setWipable();
        this.polyArcs[0].setFactoryAngleIncrement(90);
        this.polyArcs[1] = this.newArcProto("Polysilicon-2", 0.0, 7.0, ArcProto.Function.POLY2, new Technology.ArcLayer(this.poly2_lay, Poly.Type.FILLED, "11.1"));
        this.polyArcs[1].setFactoryFixedAngle(true);
        this.polyArcs[1].setWipable();
        this.polyArcs[1].setFactoryAngleIncrement(90);
        this.activeArcs[0] = this.newArcProto("P-Active", 12.0, 15.0, ArcProto.Function.DIFFP, new Technology.ArcLayer(this.activeLayers[0], Poly.Type.FILLED, "2.1"), new Technology.ArcLayer(this.wellLayers[1], Poly.Type.FILLED, "2.1", "2.3"), new Technology.ArcLayer(this.selectLayers[0], Poly.Type.FILLED, "2.1", "4.2"));
        this.activeArcs[0].setFactoryFixedAngle(true);
        this.activeArcs[0].setWipable();
        this.activeArcs[0].setFactoryAngleIncrement(90);
        this.activeArcs[1] = this.newArcProto("N-Active", 12.0, 15.0, ArcProto.Function.DIFFN, new Technology.ArcLayer(this.activeLayers[1], Poly.Type.FILLED, "2.1"), new Technology.ArcLayer(this.wellLayers[0], Poly.Type.FILLED, "2.1", "2.3"), new Technology.ArcLayer(this.selectLayers[1], Poly.Type.FILLED, "2.1", "4.2"));
        this.activeArcs[1].setFactoryFixedAngle(true);
        this.activeArcs[1].setWipable();
        this.activeArcs[1].setFactoryAngleIncrement(90);
        this.active_arc = this.newArcProto("Active", 0.0, 3.0, ArcProto.Function.DIFF, new Technology.ArcLayer(this.activeLayers[0], Poly.Type.FILLED, "2.1"), new Technology.ArcLayer(this.activeLayers[1], Poly.Type.FILLED, "2.1"));
        this.active_arc.setFactoryFixedAngle(true);
        this.active_arc.setWipable();
        this.active_arc.setFactoryAngleIncrement(90);
        this.wellArcs[0] = this.newArcProto("P-Well", 0.0, 2.0, ArcProto.Function.WELL, new Technology.ArcLayer(this.wellLayers[0], 2.0, Poly.Type.FILLED));
        this.wellArcs[0].setFactoryFixedAngle(true);
        this.wellArcs[0].setWipable();
        this.wellArcs[0].setFactoryAngleIncrement(90);
        this.wellArcs[0].setArcInvisible(false);
        this.wellArcs[1] = this.newArcProto("N-Well", 0.0, 2.0, ArcProto.Function.WELL, new Technology.ArcLayer(this.wellLayers[1], 2.0, Poly.Type.FILLED));
        this.wellArcs[1].setFactoryFixedAngle(true);
        this.wellArcs[1].setWipable();
        this.wellArcs[1].setFactoryAngleIncrement(90);
        for (int i3 = 0; i3 < this.metalArcs.length; ++i3) {
            ArcProto ap = this.metalArcs[i3];
            this.metalPinNodes[i3] = ap.makeWipablePin("Metal-" + (i3 + 1) + "-Pin", "metal-" + (i3 + 1), 3.0, new ArcProto[0]);
        }
        this.polyPinNodes[0] = this.polyArcs[0].makeWipablePin("Polysilicon-1-Pin", "polysilicon-1", 2.0, new ArcProto[0]);
        this.polyPinNodes[1] = this.polyArcs[1].makeWipablePin("Polysilicon-2-Pin", "polysilicon-2", 3.0, new ArcProto[0]);
        this.activePinNodes[0] = this.activeArcs[0].makeWipablePin("P-Active-Pin", "p-active", 15.0, new ArcProto[0]);
        this.activePinNodes[1] = this.activeArcs[1].makeWipablePin("N-Active-Pin", "n-active", 15.0, new ArcProto[0]);
        this.wellPinNodes[0] = this.wellArcs[0].makeWipablePin("P-Well-Pin", "p-active", 3.0, new ArcProto[0]);
        this.wellPinNodes[1] = this.wellArcs[1].makeWipablePin("N-Well-Pin", "n-active", 3.0, new ArcProto[0]);
        PrimitiveNode activeGenPinNode = this.active_arc.makeWipablePin("Active-Pin", "active", 3.0, this.activeArcs[0], this.activeArcs[1]);
        this.metalActiveContactNodes[0] = PrimitiveNode.newInstance("Metal-1-P-Active-Con", this, 17.0, 17.0, "6.2, 7.3", new SizeOffset(6.0, 6.0, 6.0, 6.0), new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(6.5)), new Technology.NodeLayer(this.activeLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(6.0)), new Technology.NodeLayer(this.wellLayers[1], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox()), new Technology.NodeLayer(this.selectLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(4.0)), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(8.5), "6.1", "6.3", "6.3")});
        this.metalActiveContactNodes[0].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metalActiveContactNodes[0], new ArcProto[]{this.activeArcs[0], this.metalArcs[0]}, "metal-1-p-act", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(8.0), EdgeV.fromBottom(8.0), EdgeH.fromRight(8.0), EdgeV.fromTop(8.0))});
        this.metalActiveContactNodes[0].setFunction(PrimitiveNode.Function.CONTACT);
        this.metalActiveContactNodes[1] = PrimitiveNode.newInstance("Metal-1-N-Active-Con", this, 17.0, 17.0, "6.2, 7.3", new SizeOffset(6.0, 6.0, 6.0, 6.0), new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(6.5)), new Technology.NodeLayer(this.activeLayers[1], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(6.0)), new Technology.NodeLayer(this.wellLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox()), new Technology.NodeLayer(this.selectLayers[1], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(4.0)), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(8.5), "6.1", "6.3", "6.3")});
        this.metalActiveContactNodes[1].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metalActiveContactNodes[1], new ArcProto[]{this.activeArcs[1], this.metalArcs[0]}, "metal-1-n-act", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(8.0), EdgeV.fromBottom(8.0), EdgeH.fromRight(8.0), EdgeV.fromTop(8.0))});
        this.metalActiveContactNodes[1].setFunction(PrimitiveNode.Function.CONTACT);
        this.metal1PolyContactNodes[0] = PrimitiveNode.newInstance("Metal-1-Polysilicon-1-Con", this, 5.0, 5.0, "5.2, 7.3", null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(0.5)), new Technology.NodeLayer(this.poly1Layer, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox()), Technology.NodeLayer.makeMulticut(this.polyCutLayer, 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(2.5), "5.1", "5.3", "5.3")});
        this.metal1PolyContactNodes[0].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metal1PolyContactNodes[0], new ArcProto[]{this.polyArcs[0], this.metalArcs[0]}, "metal-1-polysilicon-1", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.0), EdgeV.fromBottom(2.0), EdgeH.fromRight(2.0), EdgeV.fromTop(2.0))});
        this.metal1PolyContactNodes[0].setFunction(PrimitiveNode.Function.CONTACT);
        this.metal1PolyContactNodes[1] = PrimitiveNode.newInstance("Metal-1-Polysilicon-2-Con", this, 10.0, 10.0, "?", null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(3.0)), new Technology.NodeLayer(this.poly2_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox()), Technology.NodeLayer.makeMulticut(this.polyCutLayer, 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(5.0), "5.1", "5.3", "5.3")});
        this.metal1PolyContactNodes[1].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metal1PolyContactNodes[1], new ArcProto[]{this.polyArcs[1], this.metalArcs[0]}, "metal-1-polysilicon-2", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(4.5), EdgeV.fromBottom(4.5), EdgeH.fromRight(4.5), EdgeV.fromTop(4.5))});
        this.metal1PolyContactNodes[1].setFunction(PrimitiveNode.Function.CONTACT);
        this.metal1PolyContactNodes[2] = PrimitiveNode.newInstance("Metal-1-Polysilicon-1-2-Con", this, 15.0, 15.0, "?", null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(5.5)), new Technology.NodeLayer(this.poly1Layer, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(5.0)), new Technology.NodeLayer(this.poly2_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox()), Technology.NodeLayer.makeMulticut(this.polyCutLayer, 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(7.5), "5.1", "5.3", "5.3")});
        this.metal1PolyContactNodes[2].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metal1PolyContactNodes[2], new ArcProto[]{this.polyArcs[0], this.polyArcs[1], this.metalArcs[0]}, "metal-1-polysilicon-1-2", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(7.0), EdgeV.fromBottom(7.0), EdgeH.fromRight(7.0), EdgeV.fromTop(7.0))});
        this.metal1PolyContactNodes[2].setFunction(PrimitiveNode.Function.CONTACT);
        String[] stdNames = new String[]{"p", "n"};
        for (int i4 = 0; i4 < 2; ++i4) {
            this.transistorPolyLayers[i4] = new Technology.NodeLayer(this.transistorPolyLayer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(4.0), EdgeV.fromBottom(10.0)), new Technology.TechPoint(EdgeH.fromRight(4.0), EdgeV.fromTop(10.0))}, 1.0, 1.0, 2.0, 2.0);
            this.transistorPolyLLayers[i4] = new Technology.NodeLayer(this.poly1Layer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(4.0), EdgeV.fromBottom(10.0)), new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromTop(10.0))}, 1.0, 1.0, 0.0, 2.0);
            this.transistorPolyRLayers[i4] = new Technology.NodeLayer(this.poly1Layer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromBottom(10.0)), new Technology.TechPoint(EdgeH.fromRight(4.0), EdgeV.fromTop(10.0))}, 1.0, 1.0, 2.0, 0.0);
            this.transistorPolyCLayers[i4] = new Technology.NodeLayer(this.transistorPolyLayer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromBottom(10.0)), new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromTop(10.0))}, 1.0, 1.0, 2.0, 2.0);
            this.transistorActiveLayers[i4] = new Technology.NodeLayer(this.activeLayers[i4], 1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromBottom(7.0)), new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromTop(7.0))}, 4.0, 4.0, 0.0, 0.0);
            this.transistorActiveTLayers[i4] = new Technology.NodeLayer(this.activeLayers[i4], 1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromTop(10.0)), new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromTop(7.0))}, 4.0, 0.0, 0.0, 0.0);
            this.transistorActiveBLayers[i4] = new Technology.NodeLayer(this.activeLayers[i4], 3, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromBottom(7.0)), new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromBottom(10.0))}, 0.0, 4.0, 0.0, 0.0);
            this.transistorWellLayers[i4] = new Technology.NodeLayer(this.wellLayers[(i4 + 1) % this.transistorNodes.length], -1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.fromBottom(1.0)), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.fromTop(1.0))}, 10.0, 10.0, 6.0, 6.0);
            this.transistorSelectLayers[i4] = new Technology.NodeLayer(this.selectLayers[i4], -1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(4.0), EdgeV.fromBottom(5.0)), new Technology.TechPoint(EdgeH.fromRight(4.0), EdgeV.fromTop(5.0))}, 6.0, 6.0, 2.0, 2.0);
            this.transistorNodes[i4] = PrimitiveNode.newInstance(stdNames[i4].toUpperCase() + "-Transistor", this, 15.0, 22.0, "2.1, 3.1", new SizeOffset(6.0, 6.0, 10.0, 10.0), new Technology.NodeLayer[]{this.transistorActiveLayers[i4], this.transistorPolyLayers[i4], this.transistorWellLayers[i4], this.transistorSelectLayers[i4]});
            this.transistorNodes[i4].setElectricalLayers(new Technology.NodeLayer[]{this.transistorActiveTLayers[i4], this.transistorActiveBLayers[i4], this.transistorPolyCLayers[i4], this.transistorPolyLLayers[i4], this.transistorPolyRLayers[i4], this.transistorWellLayers[i4], this.transistorSelectLayers[i4]});
            this.transistorNodes[i4].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.transistorNodes[i4], new ArcProto[]{this.polyArcs[0]}, stdNames[i4] + "-trans-poly-left", 180, 90, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(4.0), EdgeV.fromBottom(11.0), EdgeH.fromLeft(4.0), EdgeV.fromTop(11.0)), PrimitivePort.newInstance(this, this.transistorNodes[i4], new ArcProto[]{this.activeArcs[i4]}, stdNames[i4] + "-trans-diff-top", 90, 90, 1, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(7.5), EdgeV.fromTop(7.5), EdgeH.fromRight(7.5), EdgeV.fromTop(7.0)), PrimitivePort.newInstance(this, this.transistorNodes[i4], new ArcProto[]{this.polyArcs[0]}, stdNames[i4] + "-trans-poly-right", 0, 90, 0, PortCharacteristic.UNKNOWN, EdgeH.fromRight(4.0), EdgeV.fromBottom(11.0), EdgeH.fromRight(4.0), EdgeV.fromTop(11.0)), PrimitivePort.newInstance(this, this.transistorNodes[i4], new ArcProto[]{this.activeArcs[i4]}, stdNames[i4] + "-trans-diff-bottom", 270, 90, 2, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(7.5), EdgeV.fromBottom(7.0), EdgeH.fromRight(7.5), EdgeV.fromBottom(7.5)), PrimitivePort.newInstance(this, this.transistorNodes[i4], new ArcProto[]{this.wellArcs[(i4 + 1) % this.transistorNodes.length]}, stdNames[i4] + "-trans-well", 0, 360, 3, PortCharacteristic.UNKNOWN, EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0), EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0))});
            this.transistorNodes[i4].setFunction(i4 == 0 ? PrimitiveNode.Function.TRAPMOS : PrimitiveNode.Function.TRANMOS);
            this.transistorNodes[i4].setHoldsOutline();
            this.transistorNodes[i4].setCanShrink();
            this.transistorNodes[i4].setSpecialType(1);
            this.transistorNodes[i4].setSpecialValues(new double[]{7.0, 1.5, 2.5, 2.0, 1.0, 2.0});
        }
        String[] thickNames = new String[]{"Thick-P", "Thick-N"};
        Technology.NodeLayer[] thickActiveLayers = new Technology.NodeLayer[]{this.transistorActiveLayers[0], this.transistorActiveLayers[1]};
        Technology.NodeLayer[] thickPolyLayers = new Technology.NodeLayer[]{this.transistorPolyLayers[0], this.transistorPolyLayers[1]};
        Technology.NodeLayer[] thickWellLayers = new Technology.NodeLayer[]{this.transistorWellLayers[0], this.transistorWellLayers[1]};
        Technology.NodeLayer[] thickSelectLayers = new Technology.NodeLayer[]{this.transistorSelectLayers[0], this.transistorSelectLayers[1]};
        Technology.NodeLayer[] thickActiveTLayers = new Technology.NodeLayer[]{this.transistorActiveTLayers[0], this.transistorActiveTLayers[1]};
        Technology.NodeLayer[] thickActiveBLayers = new Technology.NodeLayer[]{this.transistorActiveBLayers[0], this.transistorActiveBLayers[1]};
        Technology.NodeLayer[] thickPolyCLayers = new Technology.NodeLayer[]{this.transistorPolyCLayers[0], this.transistorPolyCLayers[1]};
        Technology.NodeLayer[] thickPolyLLayers = new Technology.NodeLayer[]{this.transistorPolyLLayers[0], this.transistorPolyLLayers[1]};
        Technology.NodeLayer[] thickPolyRLayers = new Technology.NodeLayer[]{this.transistorPolyRLayers[0], this.transistorPolyRLayers[1]};
        Technology.NodeLayer[] thickLayers = new Technology.NodeLayer[2];
        for (i = 0; i < thickLayers.length; ++i) {
            thickLayers[i] = new Technology.NodeLayer(this.thickActiveLayer, -1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.fromBottom(1.0)), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.fromTop(1.0))}, 10.0, 10.0, 6.0, 6.0);
        }
        for (i = 0; i < this.thickTransistorNodes.length; ++i) {
            this.thickTransistorNodes[i] = PrimitiveNode.newInstance(thickNames[i] + "-Transistor", this, 15.0, 22.0, "2.1, 3.1", new SizeOffset(6.0, 6.0, 10.0, 10.0), new Technology.NodeLayer[]{thickActiveLayers[i], thickPolyLayers[i], thickWellLayers[i], thickSelectLayers[i], thickLayers[i]});
            this.thickTransistorNodes[i].setElectricalLayers(new Technology.NodeLayer[]{thickActiveTLayers[i], thickActiveBLayers[i], thickPolyCLayers[i], thickPolyLLayers[i], thickPolyRLayers[i], thickWellLayers[i], thickSelectLayers[i], thickLayers[i]});
            this.thickTransistorNodes[i].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.thickTransistorNodes[i], new ArcProto[]{this.polyArcs[0]}, "poly-left", 180, 90, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(4.0), EdgeV.fromBottom(11.0), EdgeH.fromLeft(4.0), EdgeV.fromTop(11.0)), PrimitivePort.newInstance(this, this.thickTransistorNodes[i], new ArcProto[]{this.activeArcs[i]}, "diff-top", 90, 90, 1, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(7.5), EdgeV.fromTop(7.5), EdgeH.fromRight(7.5), EdgeV.fromTop(7.0)), PrimitivePort.newInstance(this, this.thickTransistorNodes[i], new ArcProto[]{this.polyArcs[0]}, "poly-right", 0, 90, 0, PortCharacteristic.UNKNOWN, EdgeH.fromRight(4.0), EdgeV.fromBottom(11.0), EdgeH.fromRight(4.0), EdgeV.fromTop(11.0)), PrimitivePort.newInstance(this, this.thickTransistorNodes[i], new ArcProto[]{this.activeArcs[i]}, "diff-bottom", 270, 90, 2, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(7.5), EdgeV.fromBottom(7.0), EdgeH.fromRight(7.5), EdgeV.fromBottom(7.5)), PrimitivePort.newInstance(this, this.thickTransistorNodes[i], new ArcProto[]{this.wellArcs[(i + 1) % this.thickTransistorNodes.length]}, stdNames[i] + "-trans-well", 0, 360, 3, PortCharacteristic.UNKNOWN, EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0), EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0))});
            this.thickTransistorNodes[i].setFunction(i == 0 ? PrimitiveNode.Function.TRAPMOS : PrimitiveNode.Function.TRANMOS);
            this.thickTransistorNodes[i].setHoldsOutline();
            this.thickTransistorNodes[i].setCanShrink();
            this.thickTransistorNodes[i].setSpecialType(1);
            this.thickTransistorNodes[i].setSpecialValues(new double[]{7.0, 1.5, 2.5, 2.0, 1.0, 2.0});
            this.thickTransistorNodes[i].setSkipSizeInPalette();
            this.thickTransistorNodes[i].setNodeBit(64);
        }
        if (haveMocmosExtensions) {
            this.scalableTransistorNodes = new PrimitiveNode[2];
            for (i = 0; i < this.scalableTransistorNodes.length; ++i) {
                int otherType = (i + 1) % this.scalableTransistorNodes.length;
                this.scalableTransistorNodes[i] = PrimitiveNode.newInstance(stdNames[i].toUpperCase() + "-Transistor-Scalable", this, 17.0, 26.0, "2.1, 3.1", new SizeOffset(7.0, 7.0, 12.0, 12.0), new Technology.NodeLayer[]{new Technology.NodeLayer(this.activeLayers[i], 1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromTop(11.0)), new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromTop(6.0))}), new Technology.NodeLayer(this.metalLayers[0], 1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.5), EdgeV.fromTop(10.5)), new Technology.TechPoint(EdgeH.fromRight(6.5), EdgeV.fromTop(6.5))}), new Technology.NodeLayer(this.activeLayers[i], 3, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromBottom(6.0)), new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromBottom(11.0))}), new Technology.NodeLayer(this.metalLayers[0], 3, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.5), EdgeV.fromBottom(6.5)), new Technology.TechPoint(EdgeH.fromRight(6.5), EdgeV.fromBottom(10.5))}), new Technology.NodeLayer(this.activeLayers[i], -1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(7.0), EdgeV.fromBottom(9.0)), new Technology.TechPoint(EdgeH.fromRight(7.0), EdgeV.fromTop(9.0))}), new Technology.NodeLayer(this.transistorPolyLayer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(5.0), EdgeV.fromBottom(12.0)), new Technology.TechPoint(EdgeH.fromRight(5.0), EdgeV.fromTop(12.0))}), new Technology.NodeLayer(this.wellLayers[otherType], -1, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox()), new Technology.NodeLayer(this.selectLayers[i], -1, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(4.0)), new Technology.NodeLayer(this.activeCutLayer, -1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(7.5), EdgeV.fromBottom(7.5)), new Technology.TechPoint(EdgeH.fromLeft(9.5), EdgeV.fromBottom(9.5))}), new Technology.NodeLayer(this.activeCutLayer, -1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(7.5), EdgeV.fromTop(9.5)), new Technology.TechPoint(EdgeH.fromLeft(9.5), EdgeV.fromTop(7.5))})});
                this.scalableTransistorNodes[i].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.scalableTransistorNodes[i], new ArcProto[]{this.polyArcs[0]}, stdNames[i] + "-trans-sca-poly-left", 180, 90, 0, PortCharacteristic.UNKNOWN, EdgeH.fromCenter(-3.5), EdgeV.makeCenter(), EdgeH.fromCenter(-3.5), EdgeV.makeCenter()), PrimitivePort.newInstance(this, this.scalableTransistorNodes[i], new ArcProto[]{this.activeArcs[i], this.metalArcs[0]}, stdNames[i] + "-trans-sca-diff-top", 90, 90, 1, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.fromCenter(4.5), EdgeH.makeCenter(), EdgeV.fromCenter(4.5)), PrimitivePort.newInstance(this, this.scalableTransistorNodes[i], new ArcProto[]{this.polyArcs[0]}, stdNames[i] + "-trans-sca-poly-right", 0, 90, 0, PortCharacteristic.UNKNOWN, EdgeH.fromCenter(3.5), EdgeV.makeCenter(), EdgeH.fromCenter(3.5), EdgeV.makeCenter()), PrimitivePort.newInstance(this, this.scalableTransistorNodes[i], new ArcProto[]{this.activeArcs[i], this.metalArcs[0]}, stdNames[i] + "-trans-sca-diff-bottom", 270, 90, 2, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.fromCenter(-4.5), EdgeH.makeCenter(), EdgeV.fromCenter(-4.5)), PrimitivePort.newInstance(this, this.scalableTransistorNodes[i], new ArcProto[]{this.wellArcs[otherType]}, stdNames[i] + "-trans-well", 0, 360, 3, PortCharacteristic.UNKNOWN, EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0), EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0))});
                this.scalableTransistorNodes[i].setFunction(i == 0 ? PrimitiveNode.Function.TRAPMOS : PrimitiveNode.Function.TRANMOS);
                this.scalableTransistorNodes[i].setCanShrink();
            }
            this.npnTransistorNode = PrimitiveNode.newInstance("NPN-Transistor", this, 56.0, 48.0, "16.*", new SizeOffset(13.0, 13.0, 13.0, 13.0), new Technology.NodeLayer[]{Technology.NodeLayer.makeMulticut(this.activeCutLayer, 2, Poly.Type.FILLED, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromBottom(8.0)), new Technology.TechPoint(EdgeH.fromRight(6.0), EdgeV.fromTop(8.0))}, "6.1", "6.3", "6.3"), new Technology.NodeLayer(this.metalLayers[0], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromRight(9.0), EdgeV.fromBottom(3.0)), new Technology.TechPoint(EdgeH.fromRight(3.0), EdgeV.fromTop(3.0))}), new Technology.NodeLayer(this.activeLayers[1], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromRight(9.0), EdgeV.fromBottom(3.0)), new Technology.TechPoint(EdgeH.fromRight(3.0), EdgeV.fromTop(3.0))}), new Technology.NodeLayer(this.selectLayers[1], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromRight(11.0), EdgeV.fromBottom(11.0)), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.fromTop(11.0))}), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 2, Poly.Type.FILLED, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromBottom(8.0)), new Technology.TechPoint(EdgeH.fromLeft(6.0), EdgeV.fromTop(8.0))}, "6.1", "6.3", "6.3"), new Technology.NodeLayer(this.metalLayers[0], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(3.0), EdgeV.fromBottom(3.0)), new Technology.TechPoint(EdgeH.fromLeft(9.0), EdgeV.fromTop(3.0))}), new Technology.NodeLayer(this.activeLayers[1], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(3.0), EdgeV.fromBottom(3.0)), new Technology.TechPoint(EdgeH.fromLeft(9.0), EdgeV.fromTop(3.0))}), new Technology.NodeLayer(this.selectLayers[1], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.fromBottom(11.0)), new Technology.TechPoint(EdgeH.fromLeft(11.0), EdgeV.fromTop(11.0))}), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 2, Poly.Type.FILLED, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(11.0), EdgeV.fromBottom(6.0)), new Technology.TechPoint(EdgeH.fromCenter(-13.0), EdgeV.fromBottom(6.0))}, "6.1", "6.3", "6.3"), new Technology.NodeLayer(this.metalLayers[0], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(9.0), EdgeV.fromBottom(3.0)), new Technology.TechPoint(EdgeH.fromCenter(-10.0), EdgeV.fromBottom(9.0))}), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 2, Poly.Type.FILLED, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromCenter(13.0), EdgeV.fromBottom(6.0)), new Technology.TechPoint(EdgeH.fromRight(11.0), EdgeV.fromBottom(6.0))}, "6.1", "6.3", "6.3"), new Technology.NodeLayer(this.metalLayers[0], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromCenter(10.0), EdgeV.fromBottom(3.0)), new Technology.TechPoint(EdgeH.fromRight(9.0), EdgeV.fromBottom(9.0))}), new Technology.NodeLayer(this.activeLayers[1], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(9.0), EdgeV.fromBottom(3.0)), new Technology.TechPoint(EdgeH.fromRight(9.0), EdgeV.fromBottom(9.0))}), new Technology.NodeLayer(this.selectLayers[1], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.fromBottom(11.0))}), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 2, Poly.Type.FILLED, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(11.0), EdgeV.fromTop(6.0)), new Technology.TechPoint(EdgeH.fromRight(11.0), EdgeV.fromTop(6.0))}, "6.1", "6.3", "6.3"), new Technology.NodeLayer(this.metalLayers[0], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(9.0), EdgeV.fromTop(9.0)), new Technology.TechPoint(EdgeH.fromRight(9.0), EdgeV.fromTop(3.0))}), new Technology.NodeLayer(this.activeLayers[1], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(9.0), EdgeV.fromTop(9.0)), new Technology.TechPoint(EdgeH.fromRight(9.0), EdgeV.fromTop(3.0))}), new Technology.NodeLayer(this.selectLayers[1], 2, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.fromTop(11.0)), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeTopEdge())}), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 1, Poly.Type.FILLED, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(22.0), EdgeV.fromBottom(24.0)), new Technology.TechPoint(EdgeH.fromCenter(-6.0), EdgeV.fromTop(24.0))}, "6.1", "6.3", "6.3"), new Technology.NodeLayer(this.metalLayers[0], 1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(19.0), EdgeV.fromBottom(21.0)), new Technology.TechPoint(EdgeH.fromCenter(-3.0), EdgeV.fromTop(21.0))}), new Technology.NodeLayer(this.selectLayers[1], 1, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(19.0), EdgeV.fromBottom(21.0)), new Technology.TechPoint(EdgeH.fromCenter(-3.0), EdgeV.fromTop(21.0))}), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 0, Poly.Type.FILLED, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromCenter(6.0), EdgeV.fromBottom(24.0)), new Technology.TechPoint(EdgeH.fromRight(22.0), EdgeV.fromTop(24.0))}, "6.1", "6.3", "6.3"), new Technology.NodeLayer(this.metalLayers[0], 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromCenter(3.0), EdgeV.fromBottom(21.0)), new Technology.TechPoint(EdgeH.fromRight(19.0), EdgeV.fromTop(21.0))}), new Technology.NodeLayer(this.selectLayers[0], 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromCenter(3.0), EdgeV.fromBottom(21.0)), new Technology.TechPoint(EdgeH.fromRight(19.0), EdgeV.fromTop(21.0))}), new Technology.NodeLayer(this.pBaseLayer, -1, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(13.0)), new Technology.NodeLayer(this.wellLayers[1], -1, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
            this.npnTransistorNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.npnTransistorNode, new ArcProto[]{this.metalArcs[0]}, "base", 180, 90, 0, PortCharacteristic.UNKNOWN, EdgeH.fromCenter(5.5), EdgeV.fromBottom(23.5), EdgeH.fromRight(21.5), EdgeV.fromTop(23.5)), PrimitivePort.newInstance(this, this.npnTransistorNode, new ArcProto[]{this.metalArcs[0]}, "emitter", 90, 90, 1, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(21.5), EdgeV.fromBottom(23.5), EdgeH.fromCenter(-5.5), EdgeV.fromTop(23.5)), PrimitivePort.newInstance(this, this.npnTransistorNode, new ArcProto[]{this.metalArcs[0]}, "collector", 90, 90, 2, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(5.5), EdgeV.fromTop(6.5), EdgeH.fromRight(5.5), EdgeV.fromTop(5.5))});
            this.npnTransistorNode.setFunction(PrimitiveNode.Function.TRANPN);
            this.npnTransistorNode.setCanShrink();
            this.npnTransistorNode.setSkipSizeInPalette();
        }
        this.metalContactNodes[0] = PrimitiveNode.newInstance("Metal-1-Metal-2-Con", this, 5.0, 5.0, "8.3, 9.3", new SizeOffset(0.5, 0.5, 0.5, 0.5), new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(0.5)), new Technology.NodeLayer(this.metalLayers[1], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(0.5)), Technology.NodeLayer.makeMulticut(this.viaLayers[0], 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(2.5), "8.1", "8.2", "8.2")});
        this.metalContactNodes[0].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metalContactNodes[0], new ArcProto[]{this.metalArcs[0], this.metalArcs[1]}, "metal-1-metal-2", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(1.5), EdgeV.fromBottom(1.5), EdgeH.fromRight(1.5), EdgeV.fromTop(1.5))});
        this.metalContactNodes[0].setFunction(PrimitiveNode.Function.CONTACT);
        this.metalContactNodes[1] = PrimitiveNode.newInstance("Metal-2-Metal-3-Con", this, 6.0, 6.0, "14.3, 15.3", new SizeOffset(1.0, 1.0, 1.0, 1.0), new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[1], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(1.0)), new Technology.NodeLayer(this.metalLayers[2], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(1.0)), Technology.NodeLayer.makeMulticut(this.viaLayers[1], 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(3.0), "14.1", "14.2", "14.2")});
        this.metalContactNodes[1].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metalContactNodes[1], new ArcProto[]{this.metalArcs[1], this.metalArcs[2]}, "metal-2-metal-3", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.5), EdgeV.fromBottom(2.5), EdgeH.fromRight(2.5), EdgeV.fromTop(2.5))});
        this.metalContactNodes[1].setFunction(PrimitiveNode.Function.CONTACT);
        this.metalContactNodes[2] = PrimitiveNode.newInstance("Metal-3-Metal-4-Con", this, 6.0, 6.0, "21.3, 22.3", null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[2], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(1.0)), new Technology.NodeLayer(this.metalLayers[3], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox()), Technology.NodeLayer.makeMulticut(this.viaLayers[2], 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(3.0), "21.1", "21.2", "21.2")});
        this.metalContactNodes[2].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metalContactNodes[2], new ArcProto[]{this.metalArcs[2], this.metalArcs[3]}, "metal-3-metal-4", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.5), EdgeV.fromBottom(2.5), EdgeH.fromRight(2.5), EdgeV.fromTop(2.5))});
        this.metalContactNodes[2].setFunction(PrimitiveNode.Function.CONTACT);
        this.metalContactNodes[3] = PrimitiveNode.newInstance("Metal-4-Metal-5-Con", this, 7.0, 7.0, "25.3, 26.3", new SizeOffset(1.5, 1.5, 1.5, 1.5), new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[3], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(1.5)), new Technology.NodeLayer(this.metalLayers[4], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(1.5)), Technology.NodeLayer.makeMulticut(this.viaLayers[3], 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(3.5), "25.1", "25.2", "25.2")});
        this.metalContactNodes[3].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metalContactNodes[3], new ArcProto[]{this.metalArcs[3], this.metalArcs[4]}, "metal-4-metal-5", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.5), EdgeV.fromBottom(2.5), EdgeH.fromRight(2.5), EdgeV.fromTop(2.5))});
        this.metalContactNodes[3].setFunction(PrimitiveNode.Function.CONTACT);
        this.metalContactNodes[4] = PrimitiveNode.newInstance("Metal-5-Metal-6-Con", this, 8.0, 8.0, "29.3, 30.3", new SizeOffset(1.5, 1.5, 1.5, 1.5), new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[4], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(1.5)), new Technology.NodeLayer(this.metalLayers[5], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(1.5)), Technology.NodeLayer.makeMulticut(this.viaLayers[4], 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(4.0), "29.1", "29.2", "29.2")});
        this.metalContactNodes[4].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metalContactNodes[4], new ArcProto[]{this.metalArcs[4], this.metalArcs[5]}, "metal-5-metal-6", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.5), EdgeV.fromBottom(2.5), EdgeH.fromRight(2.5), EdgeV.fromTop(2.5))});
        this.metalContactNodes[4].setFunction(PrimitiveNode.Function.CONTACT);
        for (i = 0; i < this.metalWellContactNodes.length; ++i) {
            PrimitiveNode.Function func = i == 0 ? PrimitiveNode.Function.WELL : PrimitiveNode.Function.SUBSTRATE;
            Layer active = i == 0 ? this.pActiveWellLayer : this.activeLayers[1];
            this.metalWellContactNodes[i] = PrimitiveNode.newInstance(this.metalLayers[0].getName() + "-" + this.wellLayers[i].getName() + "-Con", this, 17.0, 17.0, "4.2, 6.2, 7.3", new SizeOffset(6.0, 6.0, 6.0, 6.0), new Technology.NodeLayer[]{new Technology.NodeLayer(this.metalLayers[0], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(6.5)), new Technology.NodeLayer(active, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(6.0)), new Technology.NodeLayer(this.wellLayers[i], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox()), new Technology.NodeLayer(this.selectLayers[i], 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeIndented(4.0)), Technology.NodeLayer.makeMulticut(this.activeCutLayer, 0, Poly.Type.FILLED, Technology.TechPoint.makeIndented(8.5), "6.1", "6.3", "6.3")});
            this.metalWellContactNodes[i].addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.metalWellContactNodes[i], new ArcProto[]{this.metalArcs[0]}, i == 0 ? "metal-1-well" : "metal-1-substrate", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(8.0), EdgeV.fromBottom(8.0), EdgeH.fromRight(8.0), EdgeV.fromTop(8.0))});
            this.metalWellContactNodes[i].setFunction(func);
        }
        this.createPureLayerNodes();
        this.oldNodeNames.put("Metal-1-Substrate-Con", this.metalWellContactNodes[1]);
        this.oldNodeNames.put("Metal-1-Well-Con", this.metalWellContactNodes[0]);
    }

    private void createPureLayerNodes() {
        int i;
        for (i = 0; i < this.metalLayers.length; ++i) {
            this.metalLayers[i].makePureLayerNode(this.metalLayers[i].getName() + "-Node", 3.0, Poly.Type.FILLED, "metal-" + (i + 1), this.metalArcs[i]);
        }
        this.poly1Layer.makePureLayerNode("Polysilicon-1-Node", 2.0, Poly.Type.FILLED, "polysilicon-1", this.polyArcs[0]);
        this.poly2_lay.makePureLayerNode("Polysilicon-2-Node", 3.0, Poly.Type.FILLED, "polysilicon-2", this.polyArcs[1]);
        for (i = 0; i < this.activeLayers.length; ++i) {
            this.activeLayers[i].makePureLayerNode(this.activeLayers[i].getName() + "-Node", 3.0, Poly.Type.FILLED, "active", this.active_arc, this.activeArcs[0], this.activeArcs[1]);
        }
        for (i = 0; i < this.selectLayers.length; ++i) {
            this.selectLayers[i].makePureLayerNode(this.selectLayers[i].getName() + "-Node", 4.0, Poly.Type.FILLED, "select", new ArcProto[0]);
        }
        for (i = 0; i < this.wellLayers.length; ++i) {
            this.wellLayers[i].makePureLayerNode(this.wellLayers[i].getName() + "-Node", 12.0, Poly.Type.FILLED, "well", this.wellArcs[i]);
        }
        this.polyCutLayer.makePureLayerNode("Poly-Cut-Node", 2.0, Poly.Type.FILLED, "polycut", new ArcProto[0]);
        this.activeCutLayer.makePureLayerNode("Active-Cut-Node", 2.0, Poly.Type.FILLED, "activecut", new ArcProto[0]);
        for (i = 0; i < this.viaLayers.length; ++i) {
            this.viaLayers[i].makePureLayerNode("Via-" + (i + 1) + "-Node", 2.0, Poly.Type.FILLED, "via-" + (i + 1), new ArcProto[0]);
        }
        this.passivationLayer.makePureLayerNode("Passivation-Node", 8.0, Poly.Type.FILLED, "passivation", new ArcProto[0]);
        this.transistorPolyLayer.makePureLayerNode("Transistor-Poly-Node", 2.0, Poly.Type.FILLED, "trans-poly-1", this.polyArcs[0]);
        this.polyCapLayer.makePureLayerNode("Poly-Cap-Node", 8.0, Poly.Type.FILLED, "poly-cap", new ArcProto[0]);
        this.pActiveWellLayer.makePureLayerNode("P-Active-Well-Node", 8.0, Poly.Type.FILLED, "p-active-well", new ArcProto[0]);
        this.silicideBlockLayer.makePureLayerNode("Silicide-Block-Node", 2.0, Poly.Type.FILLED, "silicide-block", this.polyArcs[0]);
        this.thickActiveLayer.makePureLayerNode("Thick-Active-Node", 4.0, Poly.Type.FILLED, "thick-active", new ArcProto[0]);
        this.padFrameLayer.makePureLayerNode("Pad-Frame-Node", 8.0, Poly.Type.FILLED, "pad-frame", new ArcProto[0]);
        if (this.pBaseLayer != null) {
            this.pBaseLayer.makePureLayerNode("P-Base-Node", 22.0, Poly.Type.FILLED, "p-base", new ArcProto[0]);
        }
    }

    private void createExtraLayers() {
        this.pBaseLayer = Layer.newInstance(this, "P-Base", new EGraphics(true, true, EGraphics.Outline.PAT_S, 0, 107, 226, 96, 0.8, true, new int[]{17476, 8738, 4369, 34952, 17476, 8738, 4369, 2184, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 2184}));
    }

    private void initFoundryMOSIS() {
        this.newFoundry(Foundry.Type.MOSIS, MoCMOS.class.getResource("utils/Mosis180DRCDeck.xml"), "Metal-1 49, 80p, 80t", "Metal-2 51, 82p, 82t", "Metal-3 62, 93p, 93t", "Metal-4 31, 63p, 63t", "Metal-5 33, 64p, 64t", "Metal-6 37, 68p, 68t", "Polysilicon-1 46, 77p, 77t", "Transistor-Poly 46", "Polysilicon-2 56", "P-Active 43", "N-Active 43", "P-Active-Well 43", "P-Select 44", "N-Select 45", "P-Well 41", "N-Well 42", "Poly-Cut 25", "Active-Cut 25", "Via1 50", "Via2 61", "Via3 30", "Via4 32", "Via5 36", "Passivation 52", "Poly-Cap 28", "Silicide-Block 29", "Thick-Active 60", "Pad-Frame 26", "P-Base 58");
    }

    private void buildTechPalette() {
        this.getPrefComponentMenu();
        if (this.nodeGroups == null) {
            this.nodeGroups = this.getDefaultNodesGrouped();
        }
    }

    @Override
    public Object[][] getDefaultNodesGrouped() {
        String tmpVar;
        ArrayList<Comparable<NodeInst>> tmp;
        int i;
        int maxY = this.metalArcs.length + this.activeArcs.length + 2 + 1 + 1 + 1;
        this.factoryNodeGroups = new Object[maxY][3];
        int count = 0;
        String[] stdNames = new String[]{"p", "n"};
        this.factoryNodeGroups[count][0] = this.npnTransistorNode;
        for (i = 0; i < this.transistorNodes.length; ++i) {
            tmp = new ArrayList<Comparable<NodeInst>>(2);
            tmpVar = stdNames[i] + "Mos";
            tmp.add(MoCMOS.makeNodeInst(this.transistorNodes[i], this.transistorNodes[i].getFunction(), 0, true, tmpVar, 9.0));
            tmp.add(MoCMOS.makeNodeInst(this.thickTransistorNodes[i], this.thickTransistorNodes[i].getFunction(), 0, true, tmpVar, 9.0));
            if (this.scalableTransistorNodes != null) {
                tmp.add(MoCMOS.makeNodeInst(this.scalableTransistorNodes[i], this.scalableTransistorNodes[i].getFunction(), 0, true, tmpVar, 9.0));
            }
            this.factoryNodeGroups[count][i + 1] = tmp;
        }
        ++count;
        for (i = 0; i < this.metalWellContactNodes.length; ++i) {
            tmpVar = stdNames[i] + "Well";
            this.factoryNodeGroups[count][i + 1] = MoCMOS.makeNodeInst(this.metalWellContactNodes[i], this.metalWellContactNodes[i].getFunction(), 0, true, tmpVar, 5.5);
        }
        for (i = 0; i < this.activeArcs.length; ++i) {
            tmp = new ArrayList(2);
            tmp.add(this.activeArcs[i]);
            tmp.add(this.wellArcs[i]);
            this.factoryNodeGroups[++count][0] = tmp;
            tmp = new ArrayList(2);
            tmp.add(MoCMOS.makeNodeInst(this.activePinNodes[i]));
            tmp.add(MoCMOS.makeNodeInst(this.wellPinNodes[i]));
            this.factoryNodeGroups[count][1] = tmp;
            tmpVar = stdNames[i] + "Act";
            this.factoryNodeGroups[count][2] = MoCMOS.makeNodeInst(this.metalActiveContactNodes[i], this.metalActiveContactNodes[i].getFunction(), 0, true, tmpVar, 5.55);
        }
        this.factoryNodeGroups[++count][0] = this.polyArcs[0];
        this.factoryNodeGroups[count][1] = MoCMOS.makeNodeInst(this.polyPinNodes[0]);
        this.factoryNodeGroups[count][2] = this.metal1PolyContactNodes[0];
        this.factoryNodeGroups[++count][0] = this.polyArcs[1];
        this.factoryNodeGroups[count][1] = MoCMOS.makeNodeInst(this.polyPinNodes[1]);
        tmp = new ArrayList();
        tmp.add(MoCMOS.makeNodeInst(this.metal1PolyContactNodes[1], this.metal1PolyContactNodes[1].getFunction(), 0, true, null, 5.5));
        tmp.add(MoCMOS.makeNodeInst(this.metal1PolyContactNodes[2], this.metal1PolyContactNodes[2].getFunction(), 0, true, null, 5.5));
        this.factoryNodeGroups[count][2] = tmp;
        for (i = 0; i < this.metalArcs.length; ++i) {
            this.factoryNodeGroups[++count][0] = this.metalArcs[i];
            this.factoryNodeGroups[count][1] = MoCMOS.makeNodeInst(this.metalPinNodes[i]);
            this.factoryNodeGroups[count][2] = i < this.metalArcs.length - 1 ? this.metalContactNodes[i] : null;
        }
        this.factoryNodeGroups[++count][0] = "Pure";
        this.factoryNodeGroups[count][1] = "Misc.";
        this.factoryNodeGroups[count][2] = "Cell";
        return this.factoryNodeGroups;
    }

    @Override
    protected void setStateNow() {
        EDatabase.theDatabase.checkChanging();
        this.setNotUsed(this.isSecondPolysilicon() ? 2 : 1);
        this.findArcProto("Active").setNotUsed(true);
        if (this.npnTransistorNode != null) {
            this.npnTransistorNode.setNotUsed(!this.isAnalog());
        }
        this.cachedRules = this.factoryRules = this.makeFactoryDesignRules();
        this.setTechDesc(this.describeState());
    }

    private String describeState() {
        int numMetals = this.getNumMetals();
        String rules = "";
        switch (this.getRuleSet()) {
            case 0: {
                rules = "now standard";
                break;
            }
            case 2: {
                rules = "now deep";
                break;
            }
            case 1: {
                rules = "now submicron";
            }
        }
        int numPolys = 1;
        if (this.isSecondPolysilicon()) {
            numPolys = 2;
        }
        String description = "MOSIS CMOS (2-6 metals [now " + numMetals + "], 1-2 polys [now " + numPolys + "], flex rules [" + rules + "]";
        if (this.isDisallowStackedVias()) {
            description = description + ", stacked vias disallowed";
        }
        if (this.isAlternateActivePolyRules()) {
            description = description + ", alternate contact rules";
        }
        return description + ")";
    }

    @Override
    protected void dumpExtraProjectSettings(PrintWriter out) {
        MoCMOS.printlnSetting(out, this.getRuleSetSetting());
        MoCMOS.printlnSetting(out, this.getSecondPolysiliconSetting());
        MoCMOS.printlnSetting(out, this.getDisallowStackedViasSetting());
        MoCMOS.printlnSetting(out, this.getAlternateActivePolyRulesSetting());
        MoCMOS.printlnSetting(out, this.getAnalogSetting());
    }

    @Override
    protected void makeRuleSets(XmlParam.Technology t) {
        XmlParam.RuleSet common = t.newRuleSet("common");
        Map<XmlParam.Layer, XmlParam.Distance> layerWidth = common.newLayerRule("width");
        this.addRule(t, layerWidth, this.wellLayers[0], "1.1");
        this.addRule(t, layerWidth, this.wellLayers[1], "1.1");
        this.addRule(t, layerWidth, this.activeLayers[0], "2.1");
        this.addRule(t, layerWidth, this.activeLayers[1], "2.1");
        this.addRule(t, layerWidth, this.pActiveWellLayer, "defaultWidth");
        this.addRule(t, layerWidth, this.poly1Layer, "3.1");
        this.addRule(t, layerWidth, this.transistorPolyLayer, "3.1");
        this.addRule(t, layerWidth, this.selectLayers[0], "4.4");
        this.addRule(t, layerWidth, this.selectLayers[1], "4.4");
        this.addRule(t, layerWidth, this.polyCutLayer, "5.1");
        this.addRule(t, layerWidth, this.activeCutLayer, "6.1");
        this.addRule(t, layerWidth, this.metalLayers[0], "7.1");
        this.addRule(t, layerWidth, this.viaLayers[0], "8.1");
        this.addRule(t, layerWidth, this.metalLayers[1], "9.1");
        this.addRule(t, layerWidth, this.passivationLayer, "defaultWidth");
        this.addRule(t, layerWidth, this.poly2_lay, "11.1");
        this.addRule(t, layerWidth, this.viaLayers[1], "14.1");
        this.addRule(t, layerWidth, this.metalLayers[2], "15.1");
        this.addRule(t, layerWidth, this.pBaseLayer, "16.1", "16.6", "16.5");
        this.addRule(t, layerWidth, this.silicideBlockLayer, "20.1");
        this.addRule(t, layerWidth, this.viaLayers[2], "21.1");
        this.addRule(t, layerWidth, this.metalLayers[3], "22.1");
        this.addRule(t, layerWidth, this.polyCapLayer, "23.1");
        this.addRule(t, layerWidth, this.thickActiveLayer, "24.1");
        this.addRule(t, layerWidth, this.viaLayers[3], "25.1");
        this.addRule(t, layerWidth, this.metalLayers[4], "26.1");
        this.addRule(t, layerWidth, this.viaLayers[4], "29.1");
        this.addRule(t, layerWidth, this.metalLayers[5], "30.1");
        this.addRule(t, layerWidth, this.padFrameLayer, "defaultWidth");
        this.make3d(t, common);
    }

    private void addRule(XmlParam.Technology t, Map<XmlParam.Layer, XmlParam.Distance> layerRule, Layer layer, String ... mocmosRules) {
        XmlParam.Layer l = t.findLayer(layer.getName());
        XmlParam.Distance dist = new XmlParam.Distance();
        dist.addRule(mocmosRules[0], 1.0);
        for (int i = 1; i < mocmosRules.length; ++i) {
            dist.addRule(mocmosRules[i], 2.0);
        }
        layerRule.put(l, dist);
    }

    @Override
    protected Poly[] getShapeOfNode(NodeInst ni, boolean electrical, boolean reasonable, Technology.NodeLayer[] primLayers, Layer layerOverride) {
        NodeProto prototype = ni.getProto();
        if (this.scalableTransistorNodes != null && (prototype == this.scalableTransistorNodes[0] || prototype == this.scalableTransistorNodes[1])) {
            return this.getShapeOfNodeScalable(ni, null, reasonable);
        }
        return super.getShapeOfNode(ni, electrical, reasonable, primLayers, layerOverride);
    }

    private Poly[] getShapeOfNodeScalable(NodeInst ni, VarContext context, boolean reasonable) {
        int box;
        int numContacts = 2;
        boolean insetContacts = false;
        String pt = ni.getVarValue(TRANS_CONTACT, String.class);
        if (pt != null) {
            for (int i = 0; i < pt.length(); ++i) {
                char chr = pt.charAt(i);
                if (chr == '0' || chr == '1' || chr == '2') {
                    numContacts = chr - 48;
                    continue;
                }
                if (chr != 'i' && chr != 'I') continue;
                insetContacts = true;
            }
        }
        int boxOffset = 4 - numContacts * 2;
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        double nodeWid = ni.getXSize();
        double activeWid = nodeWid - 14.0;
        int extraInset = 0;
        Variable var = ni.getVar(Schematics.ATTR_WIDTH);
        if (var != null) {
            double requestedWid;
            VarContext evalContext = context;
            if (evalContext == null) {
                evalContext = VarContext.globalContext;
            }
            String extra = var.describe(evalContext, ni);
            Object o = evalContext.evalVar(var, ni);
            if (o != null) {
                extra = o.toString();
            }
            if ((requestedWid = TextUtils.atof(extra)) > activeWid) {
                System.out.println("Warning: " + ni.getParent() + ", " + ni + " requests width of " + requestedWid + " but is only " + activeWid + " wide");
            }
            if (requestedWid < activeWid && requestedWid > 0.0) {
                extraInset = (int)((activeWid - requestedWid) / 2.0);
                activeWid = requestedWid;
            }
        }
        double actInset = (nodeWid - activeWid) / 2.0;
        double gateOverhang = this.getTransistorExtension(np, true, this.cachedRules);
        double polyInset = actInset - gateOverhang;
        double actContInset = 7 + extraInset;
        if (activeWid < 5.0) {
            actContInset -= (5.0 - activeWid) / 2.0;
        }
        double metContInset = actContInset + 0.5;
        Technology.NodeLayer activeMulticut = this.metalActiveContactNodes[0].findMulticut();
        Technology.NodeLayer activeSurround = this.metalActiveContactNodes[0].getLayers()[1];
        assert (activeSurround.getLayer().getFunction().isDiff());
        double cutSize = activeMulticut.getMulticutSizeX();
        assert (cutSize == activeMulticut.getMulticutSizeY());
        double cutIndent = activeMulticut.getLeftEdge().getAdder() - activeSurround.getLeftEdge().getAdder();
        double cutSep = activeMulticut.getMulticutSep1D();
        assert (cutSep == activeMulticut.getMulticutSep2D());
        int numCuts = (int)((activeWid - cutIndent * 2.0 + cutSep) / (cutSize + cutSep));
        if (numCuts <= 0) {
            numCuts = 1;
        }
        double cutBase = 0.0;
        if (numCuts != 1) {
            cutBase = (activeWid - cutIndent * 2.0 - cutSize * (double)numCuts - cutSep * (double)(numCuts - 1)) / 2.0 + (nodeWid - activeWid) / 2.0 + cutIndent;
        }
        int extraCuts = numCuts * 2 - (2 - numContacts) * numCuts;
        Technology.NodeLayer[] layers = np.getLayers();
        int count = 8 + extraCuts - boxOffset;
        Technology.NodeLayer[] newNodeLayers = new Technology.NodeLayer[count];
        int fillIndex = 0;
        for (box = boxOffset; box < 8; ++box) {
            Technology.TechPoint[] oldPoints = layers[box].getPoints();
            Technology.TechPoint[] points = new Technology.TechPoint[oldPoints.length];
            for (int i = 0; i < oldPoints.length; ++i) {
                points[i] = oldPoints[i].duplicate();
            }
            switch (box) {
                case 4: {
                    points[0].getX().setAdder(actInset);
                    points[0].getX().setAdder(actInset);
                    points[1].getX().setAdder(-actInset);
                    break;
                }
                case 0: 
                case 2: {
                    points[0].getX().setAdder(actContInset);
                    points[1].getX().setAdder(-actContInset);
                    if (!insetContacts) break;
                    double shift = 0.5;
                    if (points[0].getY().getAdder() < 0.0) {
                        shift = -0.5;
                    }
                    points[0].getY().setAdder(points[0].getY().getAdder() + shift);
                    points[1].getY().setAdder(points[1].getY().getAdder() + shift);
                    break;
                }
                case 5: {
                    points[0].getX().setAdder(polyInset);
                    points[1].getX().setAdder(-polyInset);
                    break;
                }
                case 1: 
                case 3: {
                    points[0].getX().setAdder(metContInset);
                    points[1].getX().setAdder(-metContInset);
                    if (!insetContacts) break;
                    double shift = 0.5;
                    if (points[0].getY().getAdder() < 0.0) {
                        shift = -0.5;
                    }
                    points[0].getY().setAdder(points[0].getY().getAdder() + shift);
                    points[1].getY().setAdder(points[1].getY().getAdder() + shift);
                    break;
                }
                case 6: 
                case 7: {
                    if (!insetContacts) break;
                    points[0].getY().setAdder(points[0].getY().getAdder() + 0.5);
                    points[1].getY().setAdder(points[1].getY().getAdder() - 0.5);
                }
            }
            newNodeLayers[fillIndex] = new Technology.NodeLayer(layers[box].getLayer(), layers[box].getPortNum(), layers[box].getStyle(), layers[box].getRepresentation(), points);
            ++fillIndex;
        }
        for (box = 0; box < extraCuts; ++box) {
            int oldIndex = 8;
            if (box >= numCuts) {
                ++oldIndex;
            }
            Technology.TechPoint[] oldPoints = layers[oldIndex].getPoints();
            Technology.TechPoint[] points = new Technology.TechPoint[oldPoints.length];
            for (int i = 0; i < oldPoints.length; ++i) {
                points[i] = oldPoints[i].duplicate();
            }
            if (numCuts == 1) {
                points[0].getX().setAdder(ni.getXSize() / 2.0 - cutSize / 2.0);
                points[1].getX().setAdder(ni.getXSize() / 2.0 + cutSize / 2.0);
            } else {
                int cut = box % numCuts;
                double base = cutBase + (double)cut * (cutSize + cutSep);
                points[0].getX().setAdder(base);
                points[1].getX().setAdder(base + cutSize);
            }
            if (insetContacts) {
                double shift = 0.5;
                if (points[0].getY().getAdder() < 0.0) {
                    shift = -0.5;
                }
                points[0].getY().setAdder(points[0].getY().getAdder() + shift);
                points[1].getY().setAdder(points[1].getY().getAdder() + shift);
            }
            newNodeLayers[fillIndex] = new Technology.NodeLayer(layers[oldIndex].getLayer(), layers[oldIndex].getPortNum(), layers[oldIndex].getStyle(), layers[oldIndex].getRepresentation(), points);
            ++fillIndex;
        }
        return super.getShapeOfNode(ni, false, reasonable, newNodeLayers, null);
    }

    @Override
    protected XMLRules makeFactoryDesignRules() {
        Foundry foundry = this.getSelectedFoundry();
        List<DRCTemplate> theRules = foundry.getRules();
        XMLRules rules = new XMLRules(this);
        boolean pWellProcess = User.isPWellProcessLayoutTechnology();
        assert (foundry != null);
        int numMetals = this.getNumMetals();
        int rulesMode = this.getRuleSet();
        for (int pass = 0; pass < 2; ++pass) {
            for (DRCTemplate rule : theRules) {
                if (pass == 0 ? rule.ruleType == DRCTemplate.DRCRuleType.NODSIZ : rule.ruleType != DRCTemplate.DRCRuleType.NODSIZ) continue;
                int when = rule.when;
                boolean goodrule = true;
                if ((when & (DRCTemplate.DRCMode.DE.mode() | DRCTemplate.DRCMode.SU.mode() | DRCTemplate.DRCMode.SC.mode())) != 0) {
                    switch (rulesMode) {
                        case 2: {
                            if ((when & DRCTemplate.DRCMode.DE.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 1: {
                            if ((when & DRCTemplate.DRCMode.SU.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 0: {
                            if ((when & DRCTemplate.DRCMode.SC.mode()) != 0) break;
                            goodrule = false;
                        }
                    }
                    if (!goodrule) continue;
                }
                if ((when & (DRCTemplate.DRCMode.M2.mode() | DRCTemplate.DRCMode.M3.mode() | DRCTemplate.DRCMode.M4.mode() | DRCTemplate.DRCMode.M5.mode() | DRCTemplate.DRCMode.M6.mode())) != 0) {
                    switch (numMetals) {
                        case 2: {
                            if ((when & DRCTemplate.DRCMode.M2.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 3: {
                            if ((when & DRCTemplate.DRCMode.M3.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 4: {
                            if ((when & DRCTemplate.DRCMode.M4.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 5: {
                            if ((when & DRCTemplate.DRCMode.M5.mode()) != 0) break;
                            goodrule = false;
                            break;
                        }
                        case 6: {
                            if ((when & DRCTemplate.DRCMode.M6.mode()) != 0) break;
                            goodrule = false;
                        }
                    }
                    if (!goodrule) continue;
                }
                if ((when & DRCTemplate.DRCMode.AC.mode()) != 0 && !this.isAlternateActivePolyRules() || (when & DRCTemplate.DRCMode.NAC.mode()) != 0 && this.isAlternateActivePolyRules() || (when & DRCTemplate.DRCMode.SV.mode()) != 0 && this.isDisallowStackedVias() || (when & DRCTemplate.DRCMode.NSV.mode()) != 0 && !this.isDisallowStackedVias() || (when & DRCTemplate.DRCMode.AN.mode()) != 0 && !this.isAnalog()) continue;
                String proc = "";
                if ((when & (DRCTemplate.DRCMode.DE.mode() | DRCTemplate.DRCMode.SU.mode() | DRCTemplate.DRCMode.SC.mode())) != 0) {
                    switch (rulesMode) {
                        case 2: {
                            proc = "DEEP";
                            break;
                        }
                        case 1: {
                            proc = "SUBM";
                            break;
                        }
                        case 0: {
                            proc = "SCMOS";
                        }
                    }
                }
                String metal = "";
                if ((when & (DRCTemplate.DRCMode.M2.mode() | DRCTemplate.DRCMode.M3.mode() | DRCTemplate.DRCMode.M4.mode() | DRCTemplate.DRCMode.M5.mode() | DRCTemplate.DRCMode.M6.mode())) != 0) {
                    switch (this.getNumMetals()) {
                        case 2: {
                            metal = "2m";
                            break;
                        }
                        case 3: {
                            metal = "3m";
                            break;
                        }
                        case 4: {
                            metal = "4m";
                            break;
                        }
                        case 5: {
                            metal = "5m";
                            break;
                        }
                        case 6: {
                            metal = "6m";
                        }
                    }
                    if (!goodrule) continue;
                }
                String ruleName = rule.ruleName;
                String extraString = metal + proc;
                if (extraString.length() > 0 && ruleName.indexOf(extraString) == -1) {
                    rule = new DRCTemplate(rule);
                    rule.ruleName = rule.ruleName + ", " + extraString;
                }
                rules.loadDRCRules(this, foundry, rule, pWellProcess);
            }
        }
        this.resizeArcs(rules);
        rules.resizeMetalContacts(this.metalContactNodes, numMetals);
        rules.resizeContactsWithActive(this.metalActiveContactNodes, null, false, false, false);
        rules.resizeContactsWithActive(this.metalWellContactNodes, null, false, false, false);
        rules.resizePolyContact(this.metal1PolyContactNodes[0]);
        XMLRules.XMLRule polyWid = null;
        for (PrimitiveNode primNode : this.transistorNodes) {
            Technology.NodeLayer activeNode = primNode.getLayers()[0];
            Technology.NodeLayer activeTNode = primNode.getElectricalLayers()[0];
            Technology.NodeLayer activeBNode = primNode.getElectricalLayers()[1];
            Technology.NodeLayer polyNode = primNode.getLayers()[1];
            Technology.NodeLayer polyCNode = primNode.getElectricalLayers()[2];
            Technology.NodeLayer polyLNode = primNode.getElectricalLayers()[3];
            Technology.NodeLayer polyRNode = primNode.getElectricalLayers()[4];
            Technology.NodeLayer wellNode = primNode.getLayers()[2];
            Technology.NodeLayer selNode = primNode.getLayers()[3];
            int index = rules.getRuleIndex(activeNode.getLayer().getIndex(), wellNode.getLayer().getIndex());
            XMLRules.XMLRule actSurround = rules.getRule(index, DRCTemplate.DRCRuleType.SURROUND, primNode.getName());
            double length = primNode.getDefHeight();
            if (polyWid == null) {
                polyWid = rules.getRule(polyNode.getLayer().getIndex(), DRCTemplate.DRCRuleType.MINWID);
            }
            double actOverhang = this.getTransistorExtension(primNode, false, rules);
            double lenValMax = DBMath.round(length / 2.0 - polyWid.getValue(0) / 2.0);
            double lenValMin = DBMath.round(lenValMax - actOverhang);
            double gateOverhang = this.getTransistorExtension(primNode, true, rules);
            double polyExten = actSurround.getValue(0) - gateOverhang;
            double gateEdge = polyExten + gateOverhang;
            activeNode.getBottomEdge().setAdder(lenValMin);
            activeNode.getTopEdge().setAdder(-lenValMin);
            activeBNode.getBottomEdge().setAdder(lenValMin);
            activeBNode.getTopEdge().setAdder(lenValMax);
            activeTNode.getTopEdge().setAdder(-lenValMin);
            activeTNode.getBottomEdge().setAdder(-lenValMax);
            activeNode.getLeftEdge().setAdder(gateEdge);
            activeNode.getRightEdge().setAdder(-gateEdge);
            activeBNode.getLeftEdge().setAdder(gateEdge);
            activeBNode.getRightEdge().setAdder(-gateEdge);
            activeTNode.getLeftEdge().setAdder(gateEdge);
            activeTNode.getRightEdge().setAdder(-gateEdge);
            polyNode.getBottomEdge().setAdder(lenValMax);
            polyNode.getTopEdge().setAdder(-lenValMax);
            polyNode.getLeftEdge().setAdder(polyExten);
            polyNode.getRightEdge().setAdder(-polyExten);
            polyLNode.getBottomEdge().setAdder(lenValMax);
            polyLNode.getTopEdge().setAdder(-lenValMax);
            polyLNode.getLeftEdge().setAdder(polyExten);
            polyLNode.getRightEdge().setAdder(gateEdge);
            polyRNode.getBottomEdge().setAdder(lenValMax);
            polyRNode.getTopEdge().setAdder(-lenValMax);
            polyRNode.getLeftEdge().setAdder(-gateEdge);
            polyRNode.getRightEdge().setAdder(-polyExten);
            polyCNode.getBottomEdge().setAdder(lenValMax);
            polyCNode.getTopEdge().setAdder(-lenValMax);
            polyCNode.getLeftEdge().setAdder(gateEdge);
            polyCNode.getRightEdge().setAdder(-gateEdge);
            index = rules.getRuleIndex(activeNode.getLayer().getIndex(), selNode.getLayer().getIndex());
            XMLRules.XMLRule selSurround = rules.getRule(index, DRCTemplate.DRCRuleType.SURROUND, primNode.getName());
            index = rules.getRuleIndex(polyNode.getLayer().getIndex(), selNode.getLayer().getIndex());
            XMLRules.XMLRule selPolySurround = rules.getRule(index, DRCTemplate.DRCRuleType.SURROUND, primNode.getName());
            double selExtenOppLen = actSurround.getValue(0) - selPolySurround.getValue(0);
            double selExtenAlongLen = lenValMin - selSurround.getValue(0);
            selNode.getLeftEdge().setAdder(selExtenOppLen);
            selNode.getRightEdge().setAdder(-selExtenOppLen);
            selNode.getBottomEdge().setAdder(selExtenAlongLen);
            selNode.getTopEdge().setAdder(-selExtenAlongLen);
            double serpPolyWid = polyWid.getValue(0) / 2.0;
            double serpActiveWid = serpPolyWid + actOverhang;
            double serpSelectWid = serpActiveWid + selSurround.getValue(0);
            double serpWellWid = serpActiveWid + actSurround.getValue(0);
            double serpSelectExt = selPolySurround.getValue(0);
            double serpWellExt = actSurround.getValue(0);
            polyNode.setSerpentineLWidth(serpPolyWid);
            polyNode.setSerpentineRWidth(serpPolyWid);
            polyNode.setSerpentineExtentT(gateOverhang);
            polyNode.setSerpentineExtentB(gateOverhang);
            polyCNode.setSerpentineLWidth(serpPolyWid);
            polyCNode.setSerpentineRWidth(serpPolyWid);
            polyLNode.setSerpentineLWidth(serpPolyWid);
            polyLNode.setSerpentineRWidth(serpPolyWid);
            polyLNode.setSerpentineExtentB(gateOverhang);
            polyRNode.setSerpentineLWidth(serpPolyWid);
            polyRNode.setSerpentineRWidth(serpPolyWid);
            polyRNode.setSerpentineExtentT(gateOverhang);
            activeNode.setSerpentineLWidth(serpActiveWid);
            activeNode.setSerpentineRWidth(serpActiveWid);
            activeTNode.setSerpentineLWidth(serpActiveWid);
            activeBNode.setSerpentineRWidth(serpActiveWid);
            selNode.setSerpentineLWidth(serpSelectWid);
            selNode.setSerpentineRWidth(serpSelectWid);
            selNode.setSerpentineExtentT(serpSelectExt);
            selNode.setSerpentineExtentB(serpSelectExt);
            wellNode.setSerpentineLWidth(serpWellWid);
            wellNode.setSerpentineRWidth(serpWellWid);
            wellNode.setSerpentineExtentT(serpWellExt);
            wellNode.setSerpentineExtentB(serpWellExt);
            primNode.setSizeOffset(new SizeOffset(actSurround.getValue(0), actSurround.getValue(0), lenValMax, lenValMax));
        }
        this.buildTechPalette();
        return rules;
    }

    @Override
    public Technology.SizeCorrector getSizeCorrector(Version version, Map<Setting, Object> projectSettings, boolean isJelib, boolean keepExtendOverMin) {
        Object secondPolysiliconValue;
        Technology.SizeCorrector sc = super.getSizeCorrector(version, projectSettings, isJelib, keepExtendOverMin);
        if (!keepExtendOverMin) {
            return sc;
        }
        boolean newDefaults = version.compareTo(Version.parseVersion("8.04u")) >= 0;
        int numMetals = newDefaults ? 6 : 4;
        boolean isSecondPolysilicon = newDefaults;
        int ruleSet = 1;
        Object numMetalsValue = projectSettings.get(this.getNumMetalsSetting());
        if (numMetalsValue instanceof Integer) {
            numMetals = (Integer)numMetalsValue;
        }
        if ((secondPolysiliconValue = projectSettings.get(this.getSecondPolysiliconSetting())) instanceof Boolean) {
            isSecondPolysilicon = (Boolean)secondPolysiliconValue;
        } else if (secondPolysiliconValue instanceof Integer) {
            isSecondPolysilicon = (Integer)secondPolysiliconValue != 0;
        }
        Object ruleSetValue = projectSettings.get(this.getRuleSetSetting());
        if (ruleSetValue instanceof Integer) {
            ruleSet = (Integer)ruleSetValue;
        }
        if (numMetals == this.getNumMetals() && isSecondPolysilicon == this.isSecondPolysilicon() && ruleSet == this.getRuleSet() && version.compareTo(changeOfMetal6) >= 0) {
            return sc;
        }
        this.setArcCorrection(sc, "Polysilicon-2", ruleSet == 0 ? 3.0 : 7.0);
        this.setArcCorrection(sc, "Metal-3", numMetals <= 3 ? (double)(ruleSet == 0 ? 6 : 5) : 3.0);
        this.setArcCorrection(sc, "Metal-4", numMetals <= 4 ? 6.0 : 3.0);
        this.setArcCorrection(sc, "Metal-5", numMetals <= 5 ? 4.0 : 3.0);
        if (version.compareTo(changeOfMetal6) < 0) {
            this.setArcCorrection(sc, "Metal-6", 4.0);
        }
        return sc;
    }

    @Override
    public void setRuleVariables(DRCRules newDRCRules) {
        throw new UnsupportedOperationException();
    }

    public int getRuleSet() {
        return this.cacheRuleSet.getInt();
    }

    public Setting getRuleSetSetting() {
        return this.cacheRuleSet;
    }

    public boolean isSecondPolysilicon() {
        return this.cacheSecondPolysilicon.getBoolean();
    }

    public Setting getSecondPolysiliconSetting() {
        return this.cacheSecondPolysilicon;
    }

    public boolean isDisallowStackedVias() {
        return this.cacheDisallowStackedVias.getBoolean();
    }

    public Setting getDisallowStackedViasSetting() {
        return this.cacheDisallowStackedVias;
    }

    public boolean isAlternateActivePolyRules() {
        return this.cacheAlternateActivePolyRules.getBoolean();
    }

    public Setting getAlternateActivePolyRulesSetting() {
        return this.cacheAlternateActivePolyRules;
    }

    public boolean isAnalog() {
        return this.cacheAnalog.getBoolean();
    }

    public Setting getAnalogSetting() {
        return this.cacheAnalog;
    }

    @Override
    public Map<Setting, Object> convertOldVariable(String varName, Object value) {
        if (varName.equals("MoCMOSNumberOfMetalLayers") || varName.equals("MOCMOSNumberOfMetalLayers")) {
            return Collections.singletonMap(this.getNumMetalsSetting(), value);
        }
        if (varName.equals("MoCMOSSecondPolysilicon")) {
            return Collections.singletonMap(this.getSecondPolysiliconSetting(), value);
        }
        if (!varName.equalsIgnoreCase(TECH_LAST_STATE.getName())) {
            return null;
        }
        if (!(value instanceof Integer)) {
            return null;
        }
        int oldBits = (Integer)value;
        HashMap<Setting, Object> settings = new HashMap<Setting, Object>();
        boolean oldNoStackedVias = (oldBits & 1) != 0;
        settings.put(this.getDisallowStackedViasSetting(), new Integer(oldNoStackedVias ? 1 : 0));
        int numMetals = 0;
        switch (oldBits & 0x1C) {
            case 0: {
                numMetals = 2;
                break;
            }
            case 4: {
                numMetals = 3;
                break;
            }
            case 8: {
                numMetals = 4;
                break;
            }
            case 12: {
                numMetals = 5;
                break;
            }
            case 16: {
                numMetals = 6;
            }
        }
        settings.put(this.getNumMetalsSetting(), new Integer(numMetals));
        int ruleSet = 0;
        switch (oldBits & 0x60) {
            case 0: {
                ruleSet = 1;
                break;
            }
            case 32: {
                ruleSet = 2;
                break;
            }
            case 64: {
                ruleSet = 0;
            }
        }
        settings.put(this.getRuleSetSetting(), new Integer(ruleSet));
        boolean alternateContactRules = (oldBits & 0x80) != 0;
        settings.put(this.getAlternateActivePolyRulesSetting(), new Integer(alternateContactRules ? 1 : 0));
        boolean secondPoly = (oldBits & 0x100) != 0;
        settings.put(this.getSecondPolysiliconSetting(), new Integer(secondPoly ? 1 : 0));
        return settings;
    }

    @Override
    public void setPrimitiveNodeSize(NodeInst ni, double width, double length) {
        if (ni.getFunction().isResistor()) {
            super.setPrimitiveNodeSize(ni, length, width);
        } else {
            super.setPrimitiveNodeSize(ni, width, length);
        }
    }

    private double getTransistorExtension(PrimitiveNode primNode, boolean poly, DRCRules rules) {
        if (!primNode.getFunction().isTransistor()) {
            return 0.0;
        }
        Technology.NodeLayer activeNode = primNode.getLayers()[0];
        Technology.NodeLayer polyCNode = this.scalableTransistorNodes != null && (primNode == this.scalableTransistorNodes[0] || primNode == this.scalableTransistorNodes[1]) ? primNode.getLayers()[5] : primNode.getElectricalLayers()[2];
        DRCTemplate overhang = poly ? rules.getExtensionRule(polyCNode.getLayer(), activeNode.getLayer(), false) : rules.getExtensionRule(activeNode.getLayer(), polyCNode.getLayer(), false);
        return overhang != null ? overhang.getValue(0) : 0.0;
    }
}

