/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class Regression {
    private static final int port = 35742;

    public static void main(String[] args) {
        Regression.runScript(args[0]);
    }

    public static void runScript(String script) {
        SnapshotReader reader = null;
        EDatabase database = EDatabase.clientDatabase();
        Snapshot currentSnapshot = database.getInitialSnapshot();
        System.out.println("Running " + script);
        try {
            System.out.println("Attempting to connect to port 35742 ...");
            Socket socket = null;
            for (int i = 0; i < 100; ++i) {
                try {
                    Thread.sleep(20L);
                    socket = new Socket((String)null, 35742);
                }
                catch (IOException e) {
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (socket != null) break;
            }
            if (socket == null) {
                System.out.println("Can't connect");
                return;
            }
            reader = new SnapshotReader(new DataInputStream(new BufferedInputStream(socket.getInputStream())), database.getIdManager());
            DataOutputStream clientOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            int protocolVersion = reader.readInt();
            if (protocolVersion != 16) {
                System.out.println("Client's protocol version 16 is incompatible with Server's protocol version " + protocolVersion);
                System.exit(1);
            }
            System.out.println("Connected");
            EJob ejob = EvalJavaBsh.runScriptJob((String)script).ejob;
            ejob.serialize(EDatabase.clientDatabase());
            clientOutputStream.writeInt(ejob.jobId);
            clientOutputStream.writeUTF(ejob.jobType.toString());
            clientOutputStream.writeUTF(ejob.jobName);
            clientOutputStream.writeInt(ejob.serializedJob.length);
            clientOutputStream.write(ejob.serializedJob);
            clientOutputStream.flush();
            Technology.initAllTechnologies();
            block11: while (true) {
                byte tag = reader.readByte();
                switch (tag) {
                    case 1: {
                        currentSnapshot = Snapshot.readSnapshot(reader, currentSnapshot);
                        continue block11;
                    }
                    case 2: {
                        boolean hasSerializedJob;
                        Integer.valueOf(reader.readInt());
                        reader.readString();
                        Job.Type.valueOf(reader.readString());
                        EJob.State newState = EJob.State.valueOf(reader.readString());
                        reader.readLong();
                        if (newState == EJob.State.WAITING && (hasSerializedJob = reader.readBoolean())) {
                            reader.readBytes();
                        }
                        if (newState != EJob.State.SERVER_DONE) continue block11;
                        reader.readBytes();
                        continue block11;
                    }
                    case 3: {
                        String str = reader.readString();
                        System.out.print("#" + str);
                        continue block11;
                    }
                }
                System.out.println("Bad tag " + tag);
            }
        }
        catch (IOException e) {
            reader = null;
            System.out.println("END OF FILE reading from server");
            return;
        }
    }
}

