/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import java.awt.geom.Point2D;

public abstract class AbstractShapeBuilder {
    protected Layer.Function.Set onlyTheseLayers;
    protected boolean reasonable;
    protected boolean electrical;
    protected double[] doubleCoords = new double[8];
    protected int pointCount;
    public int[] intCoords = new int[4];
    private Shrinkage shrinkage;
    private static final int MAXARCPIECES = 16;

    public Layer.Function.Set getOnlyTheseLayers() {
        return this.onlyTheseLayers;
    }

    public void setOnlyTheseLayers(Layer.Function.Set onlyTheseLayers) {
        this.onlyTheseLayers = onlyTheseLayers;
    }

    public void setReasonable(boolean b) {
        this.reasonable = b;
    }

    public void setElectrical(boolean b) {
        this.electrical = b;
    }

    public Shrinkage getShrinkage() {
        return this.shrinkage;
    }

    public void setShrinkage(Shrinkage shrinkage) {
        this.shrinkage = shrinkage;
    }

    public void genShapeOfArc(ImmutableArcInst a) {
        if (this.genShapeEasy(a)) {
            return;
        }
        this.pointCount = 0;
        a.protoType.tech.getShapeOfArc(this, a);
    }

    public void makeGridPoly(ImmutableArcInst a, long gridWidth, Poly.Type style, Layer layer) {
        Double radiusDouble;
        if (a.protoType.isCurvable() && (radiusDouble = a.getRadius()) != null && this.curvedArcGridOutline(a, gridWidth, DBMath.lambdaToGrid(radiusDouble))) {
            this.pushPoly(style, layer);
            return;
        }
        if (gridWidth <= 0L) {
            this.pushPoint(a.tailLocation);
            this.pushPoint(a.headLocation);
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            this.pushPoly(style, layer);
            return;
        }
        int w2 = (int)gridWidth >>> 1;
        short shrinkT = a.isTailExtended() ? this.shrinkage.get(a.tailNodeId) : (short)1;
        short shrinkH = a.isHeadExtended() ? this.shrinkage.get(a.headNodeId) : (short)1;
        int angle = a.getAngle();
        double w2x = DBMath.roundShapeCoord((double)w2 * GenMath.cos(angle));
        double w2y = DBMath.roundShapeCoord((double)w2 * GenMath.sin(angle));
        double tx = 0.0;
        double ty = 0.0;
        if (shrinkT == 0) {
            tx = -w2x;
            ty = -w2y;
        } else if (shrinkT != 1) {
            Point2D e = AbstractShapeBuilder.computeExtension(w2, -w2x, -w2y, a.getOppositeAngle(), shrinkT);
            tx = e.getX();
            ty = e.getY();
        }
        double hx = 0.0;
        double hy = 0.0;
        if (shrinkH == 0) {
            hx = w2x;
            hy = w2y;
        } else if (shrinkH != 1) {
            Point2D e = AbstractShapeBuilder.computeExtension(w2, w2x, w2y, angle, shrinkH);
            hx = e.getX();
            hy = e.getY();
        }
        this.pushPoint(a.tailLocation, tx - w2y, ty + w2x);
        this.pushPoint(a.tailLocation, tx + w2y, ty - w2x);
        this.pushPoint(a.headLocation, hx + w2y, hy - w2x);
        this.pushPoint(a.headLocation, hx - w2y, hy + w2x);
        if (gridWidth != 0L && style.isOpened()) {
            this.pushPoint(a.tailLocation, tx - w2y, ty + w2x);
        }
        this.pushPoly(style, layer);
    }

    public static Point2D computeExtension(int w2, double ix1, double iy1, int angle, short shrink) {
        double s2;
        double s1;
        if (shrink == 0) {
            return new Point2D.Double(ix1, iy1);
        }
        if (shrink == 1) {
            return new Point2D.Double(0.0, 0.0);
        }
        assert (shrink >= 2);
        int angle2 = shrink - 2 - angle;
        if (angle2 < 0) {
            angle2 += 3600;
        }
        double x1 = ix1;
        double y1 = iy1;
        if (y1 == 0.0) {
            s1 = x1;
            if (x1 == 0.0) {
                return new Point2D.Double(0.0, 0.0);
            }
            x1 = x1 > 0.0 ? 1.0 : -1.0;
        } else if (x1 == 0.0) {
            s1 = y1;
            y1 = y1 > 0.0 ? 1.0 : -1.0;
        } else {
            s1 = x1 * x1 + y1 * y1;
        }
        double x2 = DBMath.roundShapeCoord((double)w2 * GenMath.cos(angle2));
        double y2 = DBMath.roundShapeCoord((double)w2 * GenMath.sin(angle2));
        if (y2 == 0.0) {
            s2 = x2;
            if (x2 == 0.0) {
                return new Point2D.Double(0.0, 0.0);
            }
            x2 = x2 > 0.0 ? 1.0 : -1.0;
        } else if (x2 == 0.0) {
            s2 = y2;
            y2 = y2 > 0.0 ? 1.0 : -1.0;
        } else {
            s2 = x2 * x2 + y2 * y2;
        }
        double det = x1 * y2 - y1 * x2;
        if (det == 0.0) {
            return new Point2D.Double(0.0, 0.0);
        }
        double x = (x2 * s1 + x1 * s2) / det;
        double y = (y2 * s1 + y1 * s2) / det;
        x = DBMath.roundShapeCoord(x);
        y = DBMath.roundShapeCoord(y);
        x += iy1;
        y -= ix1;
        if (det < 0.0) {
            x = -x;
            y = -y;
        }
        return new Point2D.Double(x, y);
    }

    public boolean curvedArcGridOutline(ImmutableArcInst a, long gridWidth, long gridRadius) {
        int angle;
        int i;
        int pieces;
        double gridLength;
        long pureGridRadius = Math.abs(gridRadius);
        if ((double)(pureGridRadius * 2L) < (gridLength = a.getGridLength())) {
            return false;
        }
        Point2D[] centers = DBMath.findCenters(pureGridRadius, a.headLocation.gridMutable(), a.tailLocation.gridMutable());
        if (centers == null) {
            return false;
        }
        Point2D centerPt = centers[1];
        if (gridRadius < 0L) {
            centerPt = centers[0];
        }
        double centerX = centerPt.getX();
        double centerY = centerPt.getY();
        int angleBase = DBMath.figureAngle((double)a.headLocation.getGridX() - centerX, (double)a.headLocation.getGridY() - centerY);
        int angleRange = DBMath.figureAngle((double)a.tailLocation.getGridX() - centerX, (double)a.tailLocation.getGridY() - centerY);
        if ((angleRange -= angleBase) < 0) {
            angleRange += 3600;
        }
        if (angleRange > 1800) {
            if ((angleBase += angleRange) < 0) {
                angleBase += 3600;
            }
            angleRange = 3600 - angleRange;
        }
        for (pieces = angleRange; pieces > 16; pieces /= 2) {
        }
        if (pieces == 0) {
            return false;
        }
        double outerRadius = pureGridRadius + gridWidth / 2L;
        double innerRadius = outerRadius - (double)gridWidth;
        for (i = 0; i <= pieces; ++i) {
            angle = (angleBase + i * angleRange / pieces) % 3600;
            this.pushPoint(DBMath.cos(angle) * innerRadius + centerX, DBMath.sin(angle) * innerRadius + centerY);
        }
        for (i = pieces; i >= 0; --i) {
            angle = (angleBase + i * angleRange / pieces) % 3600;
            this.pushPoint(DBMath.cos(angle) * outerRadius + centerX, DBMath.sin(angle) * outerRadius + centerY);
        }
        return true;
    }

    public boolean genShapeEasy(ImmutableArcInst a) {
        if (!a.isEasyShape()) {
            return false;
        }
        ArcProto protoType = a.protoType;
        int gridExtendOverMin = (int)a.getGridExtendOverMin();
        int minLayerExtend = gridExtendOverMin + protoType.getMinLayerGridExtend();
        if (minLayerExtend == 0) {
            assert (protoType.getNumArcLayers() == 1);
            Technology.ArcLayer primLayer = protoType.getArcLayer(0);
            Layer layer = primLayer.getLayer();
            if (this.onlyTheseLayers != null && !this.onlyTheseLayers.contains(layer.getFunction(), layer.getFunctionExtras())) {
                return true;
            }
            Poly.Type style = primLayer.getStyle();
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            this.intCoords[0] = (int)a.tailLocation.getGridX();
            this.intCoords[1] = (int)a.tailLocation.getGridY();
            this.intCoords[2] = (int)a.headLocation.getGridX();
            this.intCoords[3] = (int)a.headLocation.getGridY();
            this.addIntLine(this.intCoords, style, primLayer.getLayer());
            return true;
        }
        boolean tailExtended = false;
        if (a.isTailExtended()) {
            short shrinkT = this.shrinkage.get(a.tailNodeId);
            if (shrinkT == 0) {
                tailExtended = true;
            } else if (shrinkT != 1) {
                return false;
            }
        }
        boolean headExtended = false;
        if (a.isHeadExtended()) {
            short shrinkH = this.shrinkage.get(a.headNodeId);
            if (shrinkH == 0) {
                headExtended = true;
            } else if (shrinkH != 1) {
                return false;
            }
        }
        int n = protoType.getNumArcLayers();
        for (int i = 0; i < n; ++i) {
            Technology.ArcLayer primLayer = protoType.getArcLayer(i);
            Layer layer = primLayer.getLayer();
            assert (primLayer.getStyle() == Poly.Type.FILLED);
            if (this.onlyTheseLayers != null && !this.onlyTheseLayers.contains(layer.getFunction(), layer.getFunctionExtras())) continue;
            a.makeGridBoxInt(this.intCoords, tailExtended, headExtended, gridExtendOverMin + protoType.getLayerGridExtend(i));
            this.addIntBox(this.intCoords, layer);
        }
        return true;
    }

    public void pushPoint(EPoint p, double gridX, double gridY) {
        this.pushPointLow((double)p.getGridX() + DBMath.roundShapeCoord(gridX), (double)p.getGridY() + DBMath.roundShapeCoord(gridY));
    }

    public void pushPoint(double gridX, double gridY) {
        this.pushPointLow(DBMath.roundShapeCoord(gridX), DBMath.roundShapeCoord(gridY));
    }

    public void pushPoint(EPoint p) {
        this.pushPointLow(p.getGridX(), p.getGridY());
    }

    private void pushPointLow(double gridX, double gridY) {
        if (this.pointCount * 2 >= this.doubleCoords.length) {
            this.resize();
        }
        this.doubleCoords[this.pointCount * 2] = gridX;
        this.doubleCoords[this.pointCount * 2 + 1] = gridY;
        ++this.pointCount;
    }

    private void resize() {
        double[] newDoubleCoords = new double[this.doubleCoords.length * 2];
        System.arraycopy(this.doubleCoords, 0, newDoubleCoords, 0, this.doubleCoords.length);
        this.doubleCoords = newDoubleCoords;
    }

    public void pushPoly(Poly.Type style, Layer layer) {
        this.addDoublePoly(this.pointCount, style, layer);
        this.pointCount = 0;
    }

    public void pushBox(int minX, int minY, int maxX, int maxY, Layer layer) {
        this.intCoords[0] = minX;
        this.intCoords[1] = minY;
        this.intCoords[2] = maxX;
        this.intCoords[3] = maxY;
        this.addIntBox(this.intCoords, layer);
    }

    public abstract void addDoublePoly(int var1, Poly.Type var2, Layer var3);

    public abstract void addIntLine(int[] var1, Poly.Type var2, Layer var3);

    public abstract void addIntBox(int[] var1, Layer var2);

    public static class Shrinkage {
        public static final short EXTEND_90 = 0;
        public static final short EXTEND_0 = 1;
        private static final short EXTEND_ANY = 2;
        private static final int ANGLE_SHIFT = 12;
        private static final int ANGLE_MASK = 4095;
        private static final int ANGLE_DIAGONAL_MASK = 0x1000000;
        private static final int ANGLE_COUNT_SHIFT = 25;
        private final short[] shrink;

        public Shrinkage() {
            this.shrink = new short[0];
        }

        public Shrinkage(CellBackup cellBackup) {
            CellRevision cellRevision = cellBackup.cellRevision;
            int maxNodeId = -1;
            for (int nodeIndex = 0; nodeIndex < cellRevision.nodes.size(); ++nodeIndex) {
                maxNodeId = Math.max(maxNodeId, ((ImmutableNodeInst)cellRevision.nodes.get((int)nodeIndex)).nodeId);
            }
            int[] angles = new int[maxNodeId + 1];
            for (ImmutableArcInst a : cellRevision.arcs) {
                if (a.getGridFullWidth() == 0L) continue;
                if (a.tailNodeId == a.headNodeId && a.tailPortId == a.headPortId) {
                    this.registerArcEnd(angles, a.tailNodeId, 0, false, false);
                    continue;
                }
                boolean is90 = a.isManhattan();
                this.registerArcEnd(angles, a.tailNodeId, a.getOppositeAngle(), is90, a.isTailExtended());
                this.registerArcEnd(angles, a.headNodeId, a.getAngle(), is90, a.isHeadExtended());
            }
            short[] shrink = new short[maxNodeId + 1];
            for (int nodeIndex = 0; nodeIndex < cellRevision.nodes.size(); ++nodeIndex) {
                ImmutableNodeInst n = (ImmutableNodeInst)cellRevision.nodes.get(nodeIndex);
                NodeProtoId np = n.protoId;
                if (!(np instanceof PrimitiveNode) || !((PrimitiveNode)np).isArcsShrink()) continue;
                shrink[n.nodeId] = Shrinkage.computeShrink(angles[nodeIndex]);
            }
            this.shrink = shrink;
        }

        public short get(int nodeId) {
            return nodeId < this.shrink.length ? this.shrink[nodeId] : (short)0;
        }

        private void registerArcEnd(int[] angles, int nodeId, int angle, boolean is90, boolean extended) {
            assert (angle >= 0 && angle < 3600);
            int ang = angles[nodeId];
            if (extended) {
                int count = ang >>> 25;
                switch (count) {
                    case 0: {
                        ang |= angle;
                        ang += 0x2000000;
                        break;
                    }
                    case 1: {
                        ang |= angle << 12;
                        ang += 0x2000000;
                        break;
                    }
                    case 2: {
                        ang += 0x2000000;
                    }
                }
                if (!is90) {
                    ang |= 0x1000000;
                }
            } else {
                ang |= 0x6000000;
            }
            angles[nodeId] = ang;
        }

        static short computeShrink(int angs) {
            boolean hasAny = (angs & 0x1000000) != 0;
            int count = angs >>> 25;
            if (hasAny && count == 2) {
                int da;
                int ang0 = angs & 0xFFF;
                int ang1 = angs >> 12 & 0xFFF;
                int n = da = ang0 > ang1 ? ang0 - ang1 : ang1 - ang0;
                if (da == 900 || da == 2700) {
                    return 0;
                }
                if (da == 1800) {
                    return 1;
                }
                if (900 < da && da < 2700) {
                    int a = ang0 + ang1;
                    if (a >= 3600) {
                        a -= 3600;
                    }
                    return (short)(2 + a);
                }
            }
            return 0;
        }
    }
}

