/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.EpicAnalysis;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.ncc.NccCrossProbing;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.DigitalSignal;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.TimedSignal;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.HorizRuler;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.SweepSignal;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.print.attribute.standard.ColorSupported;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WaveformWindow
implements WindowContent,
PropertyChangeListener {
    private static final int MINANALOGPANELSIZE = 30;
    private static final int MINDIGITALPANELSIZE = 20;
    public static final boolean USETABLES = true;
    private WindowFrame wf;
    private Stimuli sd;
    private Engine se;
    private Signal xAxisSignalAll;
    private JPanel overall;
    private JButton xAxisLockButton;
    private JButton refresh;
    private JButton showPoints;
    private JButton growPanel;
    private JButton shrinkPanel;
    private JComboBox signalNameList;
    private HashMap<Analysis, TreePath> treePathFromAnalysis = new HashMap();
    private boolean rebuildingSignalNameList = false;
    private JScrollPane scrollAll;
    private JSplitPane split;
    private JPanel left;
    private JPanel right;
    private WaveTable table;
    private WaveCellEditor leftSideColumn;
    private WaveCellEditor rightSideColumn;
    private TableModel tableModel;
    private JLabel mainPos;
    private JLabel extPos;
    private JLabel delta;
    private JLabel diskLabel;
    private JButton centerMain;
    private JButton centerExt;
    private List<Panel> wavePanels;
    private List<SweepSignal> sweepSignals;
    private HorizRuler mainHorizRulerPanel;
    private boolean mainHorizRulerPanelLogarithmic;
    private Timer vcrTimer;
    private boolean vcrPlayingBackwards = false;
    private long vcrLastAdvance;
    private int vcrAdvanceSpeed = 3;
    private double mainXPosition;
    private double extXPosition;
    private double minXPosition;
    private double maxXPosition;
    private boolean xAxisLocked;
    private int highlightedSweep = -1;
    private int linePointMode;
    private boolean showGrid;
    private int screenLowX;
    private int screenHighX;
    private WaveComponentListener wcl;
    private Highlighter highlighter;
    private int nowPrinting;
    private static int panelSizeDigital = 25;
    private static int panelSizeAnalog = 75;
    private static boolean freezeWaveformHighlighting = false;
    private static boolean freezeEditWindowHighlighting = false;
    private static WaveformWindowHighlightListener waveHighlighter = new WaveformWindowHighlightListener();
    private static Font waveWindowFont;
    private static FontRenderContext waveWindowFRC;
    private static Color offStrengthColor;
    private static Color nodeStrengthColor;
    private static Color gateStrengthColor;
    private static Color powerStrengthColor;
    public static WaveFormDropTarget waveformDropTarget;
    private static final ImageIcon iconAddPanel;
    private static final ImageIcon iconLockXAxes;
    private static final ImageIcon iconUnLockXAxes;
    private static final ImageIcon iconRefresh;
    private static final ImageIcon iconLineOnPointOn;
    private static final ImageIcon iconLineOnPointOff;
    private static final ImageIcon iconLineOffPointOn;
    private static final ImageIcon iconToggleGrid;
    private static final ImageIcon iconGrowPanel;
    private static final ImageIcon iconShrinkPanel;
    private static final ImageIcon iconVCRRewind;
    private static final ImageIcon iconVCRPlayBackward;
    private static final ImageIcon iconVCRStop;
    private static final ImageIcon iconVCRPlay;
    private static final ImageIcon iconVCRToEnd;
    private static final ImageIcon iconVCRFaster;
    private static final ImageIcon iconVCRSlower;
    private static final Cursor resizeRowCursor;
    private static final Cursor resizeColumnCursor;
    private int oldBackground;
    private int oldForeground;
    private boolean changedColors = false;
    private HashMap<Network, Integer> netValues;
    private static HashMap<String, String> savedSignalOrder;

    public WaveformWindow(Stimuli sd, WindowFrame wf) {
        Rectangle2D dataBounds;
        this.wf = wf;
        this.sd = sd;
        sd.setWaveformWindow(this);
        this.resetSweeps();
        this.wavePanels = new ArrayList<Panel>();
        this.xAxisLocked = true;
        this.linePointMode = 0;
        this.nowPrinting = 0;
        this.showGrid = false;
        this.xAxisSignalAll = null;
        this.mainHorizRulerPanelLogarithmic = false;
        waveWindowFont = new Font(User.getDefaultFont(), 0, 12);
        waveWindowFRC = new FontRenderContext(null, false, false);
        offStrengthColor = new Color(User.getColorWaveformStrengthOff());
        nodeStrengthColor = new Color(User.getColorWaveformStrengthNode());
        gateStrengthColor = new Color(User.getColorWaveformStrengthGate());
        powerStrengthColor = new Color(User.getColorWaveformStrengthPower());
        this.highlighter = new Highlighter(0, wf);
        Highlighter.addHighlightListener(waveHighlighter);
        this.overall = new OnePanel(null, this);
        this.overall.setLayout(new GridBagLayout());
        this.wcl = new WaveComponentListener(this.overall);
        this.overall.addComponentListener(this.wcl);
        new DropTarget(this.overall, 0x40000000, waveformDropTarget, true);
        this.tableModel = new WaveTableModel();
        this.table = new WaveTable(this.tableModel, this);
        new TableMouseListener(this.table);
        this.table.getTableHeader().setPreferredSize(new Dimension(1, 1));
        TableColumn column1 = this.table.getColumnModel().getColumn(0);
        column1.setPreferredWidth(100);
        TableColumn column2 = this.table.getColumnModel().getColumn(1);
        column2.setPreferredWidth(500);
        this.leftSideColumn = new WaveCellEditor(this.table, 0);
        this.rightSideColumn = new WaveCellEditor(this.table, 1);
        int height = this.getPanelSizeDigital();
        if (sd.isAnalog()) {
            height = this.getPanelSizeAnalog();
        }
        this.table.setRowHeight(height);
        this.scrollAll = new JScrollPane(this.table);
        new DropTarget(this.table, 0x40000000, waveformDropTarget, true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 11;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.overall.add((Component)this.scrollAll, gbc);
        if (sd.isAnalog()) {
            JButton addPanel = new JButton(iconAddPanel);
            addPanel.setBorderPainted(false);
            addPanel.setDefaultCapable(false);
            addPanel.setToolTipText("Create new waveform panel");
            Dimension minWid = new Dimension(iconAddPanel.getIconWidth() + 4, iconAddPanel.getIconHeight() + 4);
            addPanel.setMinimumSize(minWid);
            addPanel.setPreferredSize(minWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 10;
            this.overall.add((Component)addPanel, gbc);
            addPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.makeNewPanel();
                }
            });
            this.showPoints = new JButton(iconLineOnPointOff);
            this.showPoints.setBorderPainted(false);
            this.showPoints.setDefaultCapable(false);
            this.showPoints.setToolTipText("Toggle display of vertex points and lines");
            minWid = new Dimension(iconLineOnPointOff.getIconWidth() + 4, iconLineOnPointOff.getIconHeight() + 4);
            this.showPoints.setMinimumSize(minWid);
            this.showPoints.setPreferredSize(minWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 10;
            this.overall.add((Component)this.showPoints, gbc);
            this.showPoints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.toggleShowPoints();
                }
            });
            JButton toggleGrid = new JButton(iconToggleGrid);
            toggleGrid.setBorderPainted(false);
            toggleGrid.setDefaultCapable(false);
            toggleGrid.setToolTipText("Toggle display of a grid");
            minWid = new Dimension(iconToggleGrid.getIconWidth() + 4, iconToggleGrid.getIconHeight() + 4);
            toggleGrid.setMinimumSize(minWid);
            toggleGrid.setPreferredSize(minWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 10;
            this.overall.add((Component)toggleGrid, gbc);
            toggleGrid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.toggleGridPoints();
                }
            });
        }
        this.refresh = new JButton(iconRefresh);
        this.refresh.setBorderPainted(false);
        this.refresh.setDefaultCapable(false);
        this.refresh.setToolTipText("Reread stimuli data file and update waveforms");
        Dimension minWid = new Dimension(iconRefresh.getIconWidth() + 4, iconRefresh.getIconHeight() + 4);
        this.refresh.setMinimumSize(minWid);
        this.refresh.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)this.refresh, gbc);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.refreshData();
            }
        });
        this.xAxisLockButton = new JButton(iconLockXAxes);
        this.xAxisLockButton.setBorderPainted(false);
        this.xAxisLockButton.setDefaultCapable(false);
        this.xAxisLockButton.setToolTipText("Lock all panels horizontally");
        minWid = new Dimension(iconLockXAxes.getIconWidth() + 4, iconLockXAxes.getIconHeight() + 4);
        this.xAxisLockButton.setMinimumSize(minWid);
        this.xAxisLockButton.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.overall.add((Component)this.xAxisLockButton, gbc);
        this.xAxisLockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.togglePanelXAxisLock();
            }
        });
        this.signalNameList = new JComboBox();
        this.signalNameList.setToolTipText("Show or hide waveform panels");
        this.signalNameList.setLightWeightPopupEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.overall.add((Component)this.signalNameList, gbc);
        this.signalNameList.addItem("Panel 1");
        this.signalNameList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.togglePanelName();
            }
        });
        this.growPanel = new JButton(iconGrowPanel);
        this.growPanel.setBorderPainted(false);
        this.growPanel.setDefaultCapable(false);
        this.growPanel.setToolTipText("Increase minimum panel height");
        minWid = new Dimension(iconGrowPanel.getIconWidth() + 4, iconGrowPanel.getIconHeight() + 4);
        this.growPanel.setMinimumSize(minWid);
        this.growPanel.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.overall.add((Component)this.growPanel, gbc);
        this.growPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.growPanels(1.25);
            }
        });
        this.shrinkPanel = new JButton(iconShrinkPanel);
        this.shrinkPanel.setBorderPainted(false);
        this.shrinkPanel.setDefaultCapable(false);
        this.shrinkPanel.setToolTipText("Decrease minimum panel height");
        minWid = new Dimension(iconShrinkPanel.getIconWidth() + 4, iconShrinkPanel.getIconHeight() + 4);
        this.shrinkPanel.setMinimumSize(minWid);
        this.shrinkPanel.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.overall.add((Component)this.shrinkPanel, gbc);
        this.shrinkPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.growPanels(0.8);
            }
        });
        JPanel xAxisLabelPanel = new JPanel();
        xAxisLabelPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 4, 0, 4);
        this.overall.add((Component)xAxisLabelPanel, gbc);
        this.mainPos = new JLabel("Main:", 4);
        this.mainPos.setToolTipText("The main (dashed) X axis cursor");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        xAxisLabelPanel.add((Component)this.mainPos, gbc);
        this.centerMain = new JButton("Center");
        this.centerMain.setToolTipText("Center the main (dashed) X axis cursor");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 2, 0);
        xAxisLabelPanel.add((Component)this.centerMain, gbc);
        this.centerMain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.centerCursor(true);
            }
        });
        this.extPos = new JLabel("Ext:", 4);
        this.extPos.setToolTipText("The extension (dotted) X axis cursor");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        xAxisLabelPanel.add((Component)this.extPos, gbc);
        this.centerExt = new JButton("Center");
        this.centerExt.setToolTipText("Center the extension (dotted) X axis cursor");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 2, 0);
        xAxisLabelPanel.add((Component)this.centerExt, gbc);
        this.centerExt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.centerCursor(false);
            }
        });
        this.delta = new JLabel("Delta:", 0);
        this.delta.setToolTipText("X distance between cursors");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        xAxisLabelPanel.add((Component)this.delta, gbc);
        if (sd.getFileURL() != null) {
            String fileName = TextUtils.getFileNameWithoutExtension(sd.getFileURL());
            String ext = TextUtils.getExtension(sd.getFileURL());
            if (ext.length() > 0) {
                fileName = fileName + "." + ext;
            }
            this.diskLabel = new JLabel("File: " + fileName, 0);
            this.diskLabel.setToolTipText("The disk file that is being displayed");
            gbc = new GridBagConstraints();
            gbc.gridx = 5;
            gbc.gridy = 0;
            gbc.weightx = 0.4;
            gbc.weighty = 0.0;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 10, 0, 0);
            xAxisLabelPanel.add((Component)this.diskLabel, gbc);
        }
        JButton vcrButtonRewind = new JButton(iconVCRRewind);
        vcrButtonRewind.setBorderPainted(false);
        vcrButtonRewind.setDefaultCapable(false);
        vcrButtonRewind.setToolTipText("Rewind main X axis cursor to start");
        minWid = new Dimension(iconVCRRewind.getIconWidth() + 4, iconVCRRewind.getIconHeight() + 4);
        vcrButtonRewind.setMinimumSize(minWid);
        vcrButtonRewind.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonRewind, gbc);
        vcrButtonRewind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickRewind();
            }
        });
        JButton vcrButtonPlayBackwards = new JButton(iconVCRPlayBackward);
        vcrButtonPlayBackwards.setBorderPainted(false);
        vcrButtonPlayBackwards.setDefaultCapable(false);
        vcrButtonPlayBackwards.setToolTipText("Play main X axis cursor backwards");
        minWid = new Dimension(iconVCRPlayBackward.getIconWidth() + 4, iconVCRPlayBackward.getIconHeight() + 4);
        vcrButtonPlayBackwards.setMinimumSize(minWid);
        vcrButtonPlayBackwards.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonPlayBackwards, gbc);
        vcrButtonPlayBackwards.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickPlayBackwards();
            }
        });
        JButton vcrButtonStop = new JButton(iconVCRStop);
        vcrButtonStop.setBorderPainted(false);
        vcrButtonStop.setDefaultCapable(false);
        vcrButtonStop.setToolTipText("Stop moving main X axis cursor");
        minWid = new Dimension(iconVCRStop.getIconWidth() + 4, iconVCRStop.getIconHeight() + 4);
        vcrButtonStop.setMinimumSize(minWid);
        vcrButtonStop.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonStop, gbc);
        vcrButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickStop();
            }
        });
        JButton vcrButtonPlay = new JButton(iconVCRPlay);
        vcrButtonPlay.setBorderPainted(false);
        vcrButtonPlay.setDefaultCapable(false);
        vcrButtonPlay.setToolTipText("Play main X axis cursor");
        minWid = new Dimension(iconVCRPlay.getIconWidth() + 4, iconVCRPlay.getIconHeight() + 4);
        vcrButtonPlay.setMinimumSize(minWid);
        vcrButtonPlay.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonPlay, gbc);
        vcrButtonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickPlay();
            }
        });
        JButton vcrButtonToEnd = new JButton(iconVCRToEnd);
        vcrButtonToEnd.setBorderPainted(false);
        vcrButtonToEnd.setDefaultCapable(false);
        vcrButtonToEnd.setToolTipText("Move main X axis cursor to end");
        minWid = new Dimension(iconVCRToEnd.getIconWidth() + 4, iconVCRToEnd.getIconHeight() + 4);
        vcrButtonToEnd.setMinimumSize(minWid);
        vcrButtonToEnd.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonToEnd, gbc);
        vcrButtonToEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickToEnd();
            }
        });
        JButton vcrButtonFaster = new JButton(iconVCRFaster);
        vcrButtonFaster.setBorderPainted(false);
        vcrButtonFaster.setDefaultCapable(false);
        vcrButtonFaster.setToolTipText("Move main X axis cursor faster");
        minWid = new Dimension(iconVCRFaster.getIconWidth() + 4, iconVCRFaster.getIconHeight() + 4);
        vcrButtonFaster.setMinimumSize(minWid);
        vcrButtonFaster.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonFaster, gbc);
        vcrButtonFaster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickFaster();
            }
        });
        JButton vcrButtonSlower = new JButton(iconVCRSlower);
        vcrButtonSlower.setBorderPainted(false);
        vcrButtonSlower.setDefaultCapable(false);
        vcrButtonSlower.setToolTipText("Move main X axis cursor slower");
        minWid = new Dimension(iconVCRSlower.getIconWidth() + 4, iconVCRSlower.getIconHeight() + 4);
        vcrButtonSlower.setMinimumSize(minWid);
        vcrButtonSlower.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonSlower, gbc);
        vcrButtonSlower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickSlower();
            }
        });
        if (this.xAxisLocked) {
            this.addMainHorizRulerPanel();
        }
        if ((dataBounds = sd.getBounds()) != null) {
            double lowTime = dataBounds.getMinX();
            double highTime = dataBounds.getMaxX();
            double timeRange = highTime - lowTime;
            this.setMainXPositionCursor(timeRange * 0.2 + lowTime);
            this.setExtensionXPositionCursor(timeRange * 0.8 + lowTime);
            this.setDefaultHorizontalRange(lowTime, highTime);
        }
    }

    public void stopEditing() {
        this.leftSideColumn.stopCellEditing();
        this.rightSideColumn.stopCellEditing();
    }

    public void reloadTable() {
        this.table.tableChanged(new TableModelEvent(this.tableModel));
    }

    @Override
    public void finished() {
        for (Panel wp : this.wavePanels) {
            wp.finished();
        }
        this.overall.removeComponentListener(this.wcl);
        this.highlighter.delete();
        if (this.sd != null) {
            this.sd.finished();
        }
    }

    @Override
    public void fullRepaint() {
        this.repaint();
    }

    @Override
    public void repaint() {
        for (Panel wp : this.wavePanels) {
            wp.repaintContents();
        }
        if (this.mainHorizRulerPanel != null) {
            this.mainHorizRulerPanel.repaint();
        }
    }

    @Override
    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set<TextUtils.WhatToSearch> whatToSearch) {
        System.out.println("Text search not implemented for waveform windows");
    }

    @Override
    public boolean findNextText(boolean reverse) {
        return false;
    }

    @Override
    public void replaceText(String replace) {
    }

    @Override
    public void replaceAllText(String replace) {
    }

    @Override
    public void writeImage(ElectricPrinter ep, String filePath) {
        BufferedImage img = this.getPrintImage(ep);
        PNG.writeImage(img, filePath);
    }

    @Override
    public boolean initializePrinting(ElectricPrinter ep, PageFormat pageFormat) {
        this.oldForeground = User.getColorWaveformForeground();
        this.oldBackground = User.getColorWaveformBackground();
        User.setColorWaveformForeground(0);
        User.setColorWaveformBackground(0xFFFFFF);
        this.changedColors = true;
        PrinterJob pj = ep.getPrintJob();
        if (pj == null) {
            return false;
        }
        ColorSupported cs = pj.getPrintService().getAttribute(ColorSupported.class);
        if (cs == null) {
            return false;
        }
        this.nowPrinting = 1;
        if (cs.getValue() == 0) {
            this.nowPrinting = 2;
        }
        Dimension oldSize = ep.getOldSize();
        int pageWid = (int)pageFormat.getImageableWidth() * ep.getDesiredDPI() / 72;
        int pageHei = (int)pageFormat.getImageableHeight() * ep.getDesiredDPI() / 72;
        double scaleX = (double)pageWid / (double)oldSize.width;
        double scaleY = (double)pageHei / (double)oldSize.height;
        double scale = Math.min(scaleX, scaleY);
        pageWid = (int)((double)oldSize.width * scale);
        pageHei = (int)((double)oldSize.height * scale);
        this.overall.setSize(pageWid, pageHei);
        this.overall.validate();
        this.redrawAllPanels();
        this.overall.repaint();
        return true;
    }

    @Override
    public BufferedImage getPrintImage(ElectricPrinter ep) {
        Dimension szOld;
        Graphics2D g2d;
        BufferedImage bImage = ep.getBufferedImage();
        Dimension sz = this.getPanel().getSize();
        if (bImage == null) {
            bImage = (BufferedImage)this.overall.createImage(sz.width, sz.height);
            ep.setBufferedImage(bImage);
        }
        if ((g2d = (Graphics2D)ep.getGraphics()) == null) {
            g2d = bImage.createGraphics();
        }
        if ((szOld = ep.getOldSize()) != null) {
            double scaleX = (double)sz.width / (double)szOld.width;
            double scaleY = (double)sz.height / (double)szOld.height;
            double gSX = (double)szOld.width / (double)szOld.height;
            double gSY = gSX * scaleY / scaleX;
            g2d.translate(ep.getPageFormat().getImageableX(), ep.getPageFormat().getImageableY());
            g2d.scale(72.0 / (double)ep.getDesiredDPI() / gSX, 72.0 / (double)ep.getDesiredDPI() / gSY);
        }
        this.overall.paint(g2d);
        if (this.changedColors) {
            User.setColorWaveformForeground(this.oldForeground);
            User.setColorWaveformBackground(this.oldBackground);
            this.changedColors = false;
        }
        this.nowPrinting = 0;
        return bImage;
    }

    @Override
    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
        double hRange = this.maxXPosition - this.minXPosition;
        double vRange = -1.0;
        double vRangeAny = -1.0;
        for (Panel wp : this.wavePanels) {
            vRangeAny = wp.getYAxisRange();
            if (!wp.isSelected()) continue;
            hRange = wp.getMaxXAxis() - wp.getMinXAxis();
            vRange = wp.getYAxisRange();
            break;
        }
        if (vRange < 0.0) {
            vRange = vRangeAny;
        }
        double distance = (double)ticks * panningAmounts[User.getPanningDistance()];
        for (Panel wp : this.wavePanels) {
            double high;
            double low;
            if (direction == 0) {
                if (!this.xAxisLocked && !wp.isSelected()) continue;
                low = wp.getMinXAxis() - hRange * distance;
                high = wp.getMaxXAxis() - hRange * distance;
                wp.setXAxisRange(low, high);
            } else {
                if (!wp.isSelected()) continue;
                low = wp.getYAxisLowValue() - vRange * distance;
                high = wp.getYAxisHighValue() - vRange * distance;
                wp.setYAxisRange(low, high);
            }
            wp.repaintWithRulers();
        }
    }

    @Override
    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        String title = "";
        title = this.sd.getEngine() != null ? "Simulation of" : "Waveforms of ";
        if (this.sd != null && this.sd.getDataType() != null) {
            title = this.sd.getEngine() != null ? this.sd.getDataType().getName() + " simulation of " : this.sd.getDataType().getName() + " of ";
        }
        this.wf.setTitle(this.wf.composeTitle(this.sd.getCell(), title, 0));
    }

    @Override
    public JPanel getPanel() {
        return this.overall;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.overall.setCursor(cursor);
        this.table.setCursor(cursor);
        for (Panel p : this.wavePanels) {
            p.setCursor(cursor);
        }
    }

    @Override
    public void setCell(Cell cell, VarContext context, WindowFrame.DisplayAttributes displayAttributes) {
        this.sd.setCell(cell);
        this.setWindowTitle();
    }

    @Override
    public Cell getCell() {
        return this.sd.getCell();
    }

    @Override
    public void bottomScrollChanged(int e) {
    }

    @Override
    public void rightScrollChanged(int e) {
    }

    private WindowFrame findSchematicsWindow() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            if (wf.getContent().getCell() != cell || !(wf.getContent() instanceof EditWindow)) continue;
            return wf;
        }
        return null;
    }

    public static WaveformWindow findWaveformWindow(Cell cell) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            if (wf.getContent().getCell() != cell || !(wf.getContent() instanceof WaveformWindow)) continue;
            return (WaveformWindow)wf.getContent();
        }
        return null;
    }

    public WindowFrame getWindowFrame() {
        return this.wf;
    }

    public int getScreenLowX() {
        return this.screenLowX;
    }

    public int getScreenHighX() {
        return this.screenHighX;
    }

    public void setScreenXSize(int lowX, int highX) {
        this.screenLowX = lowX;
        this.screenHighX = highX;
    }

    public JPanel getSignalNamesPanel() {
        return this.left;
    }

    public JPanel getSignalTracesPanel() {
        return this.right;
    }

    public JTable getWaveformTable() {
        return this.table;
    }

    public Engine getSimEngine() {
        return this.se;
    }

    public void setSimEngine(Engine se) {
        this.se = se;
    }

    public Panel makeNewPanel() {
        int i;
        Analysis.AnalysisType analysisType = Analysis.ANALYSIS_SIGNALS;
        int panelSize = panelSizeDigital;
        if (this.sd.isAnalog()) {
            panelSize = panelSizeAnalog;
            if (this.sd.getNumAnalyses() > 0) {
                analysisType = this.sd.getAnalyses().next().getAnalysisType();
            }
            if (this.xAxisLocked && this.xAxisSignalAll != null) {
                AnalogSignal as = (AnalogSignal)this.xAxisSignalAll;
                analysisType = as.getAnalysis().getAnalysisType();
            }
        }
        Rectangle2D bounds = null;
        Analysis an = this.sd.findAnalysis(analysisType);
        bounds = an != null ? an.getBounds() : this.sd.getBounds();
        double lowValue = bounds.getMinY();
        double highValue = bounds.getMaxY();
        double lowXValue = bounds.getMinX();
        double highXValue = bounds.getMaxX();
        int vertAxisPos = -1;
        if (this.xAxisLocked && this.wavePanels.size() > 0) {
            Panel aPanel = this.wavePanels.get(0);
            lowXValue = aPanel.getMinXAxis();
            highXValue = aPanel.getMaxXAxis();
            vertAxisPos = aPanel.getVertAxisPos();
        }
        int[] rowHeights = null;
        int rows = this.table.getRowCount();
        rowHeights = new int[rows + 1];
        for (i = 0; i < rows; ++i) {
            rowHeights[i] = this.table.getRowHeight(i);
        }
        rowHeights[rows] = panelSize;
        Panel panel = new Panel(this, this.sd.isAnalog(), analysisType);
        panel.setXAxisRange(lowXValue, highXValue);
        if (analysisType != null) {
            panel.setYAxisRange(lowValue, highValue);
        }
        if (vertAxisPos > 0) {
            panel.setVertAxisPos(vertAxisPos);
        }
        panel.makeSelectedPanel();
        this.getPanel().validate();
        if (this.getMainHorizRuler() != null) {
            this.getMainHorizRuler().repaint();
        }
        this.table.tableChanged(new TableModelEvent(this.tableModel));
        for (i = 0; i < rowHeights.length; ++i) {
            this.table.setRowHeight(i, rowHeights[i]);
        }
        return panel;
    }

    public int getNumPanels() {
        return this.wavePanels.size();
    }

    public Panel getPanel(int index) {
        return this.wavePanels.get(index);
    }

    public int getPanelIndex(Panel panel) {
        return this.wavePanels.indexOf(panel);
    }

    public void addPanel(Panel panel) {
        this.wavePanels.add(panel);
    }

    public void addPanel(Panel panel, int index) {
        this.wavePanels.add(index, panel);
    }

    public void removePanel(Panel panel) {
        this.wavePanels.remove(panel);
    }

    public Iterator<Panel> getPanels() {
        return this.wavePanels.iterator();
    }

    public int getPrintingMode() {
        return this.nowPrinting;
    }

    private Panel getPanelFromNumber(int panelNumber) {
        for (Panel wp : this.wavePanels) {
            if (wp.getPanelNumber() != panelNumber) continue;
            return wp;
        }
        return null;
    }

    private void togglePanelName() {
        if (this.rebuildingSignalNameList) {
            return;
        }
        String panelName = (String)this.signalNameList.getSelectedItem();
        int spacePos = panelName.indexOf(32);
        if (spacePos >= 0) {
            panelName = panelName.substring(spacePos + 1);
        }
        int index = TextUtils.atoi(panelName);
        for (Panel wp : this.wavePanels) {
            if (wp.getPanelNumber() != index) continue;
            if (wp.isHidden()) {
                this.showPanel(wp);
                break;
            }
            this.hidePanel(wp);
            break;
        }
    }

    public void validatePanel() {
        this.overall.validate();
    }

    public void rebuildPanelList() {
        this.rebuildingSignalNameList = true;
        this.signalNameList.removeAllItems();
        boolean hasSignals = false;
        for (Panel wp : this.wavePanels) {
            this.signalNameList.addItem("Panel " + Integer.toString(wp.getPanelNumber()) + (wp.isHidden() ? " (HIDDEN)" : ""));
            hasSignals = true;
        }
        if (hasSignals) {
            this.signalNameList.setSelectedIndex(0);
        }
        this.rebuildingSignalNameList = false;
    }

    public void redrawAllPanels() {
        if (this.mainHorizRulerPanel != null) {
            this.mainHorizRulerPanel.repaint();
        }
        for (Panel wp : this.wavePanels) {
            wp.repaintContents();
        }
        this.table.repaint();
    }

    public void closePanel(Panel wp) {
        int i;
        int rows = this.wavePanels.size();
        int[] rowHeights = new int[rows];
        int closedPanelIndex = this.wavePanels.indexOf(wp);
        int validPanels = 0;
        int visRow = 0;
        for (i = 0; i < rows; ++i) {
            if (this.wavePanels.get(i).isHidden()) continue;
            int rowHeight = this.table.getRowHeight(visRow++);
            if (i == closedPanelIndex) continue;
            rowHeights[validPanels++] = rowHeight;
        }
        this.stopEditing();
        this.reloadTable();
        this.wavePanels.remove(wp);
        for (i = 0; i < validPanels; ++i) {
            this.table.setRowHeight(i, rowHeights[i]);
        }
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void hidePanel(Panel wp) {
        int i;
        if (wp.isHidden()) {
            return;
        }
        int rows = this.wavePanels.size();
        int[] rowHeights = new int[rows];
        int hiddenPanelIndex = this.wavePanels.indexOf(wp);
        int validPanels = 0;
        int visRow = 0;
        for (i = 0; i < rows; ++i) {
            if (this.wavePanels.get(i).isHidden()) continue;
            int rowHeight = this.table.getRowHeight(visRow++);
            if (i == hiddenPanelIndex) continue;
            rowHeights[validPanels++] = rowHeight;
        }
        wp.setHidden(true);
        this.stopEditing();
        this.reloadTable();
        for (i = 0; i < validPanels; ++i) {
            this.table.setRowHeight(i, rowHeights[i]);
        }
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void showPanel(Panel wp) {
        int i;
        if (!wp.isHidden()) {
            return;
        }
        int rows = this.wavePanels.size();
        int[] rowHeights = new int[rows];
        int openedPanelIndex = this.wavePanels.indexOf(wp);
        int validPanels = 0;
        int visRow = 0;
        int openedPanelHeightIndex = -1;
        int averageHeight = 0;
        int numAverages = 0;
        for (i = 0; i < rows; ++i) {
            if (i == openedPanelIndex) {
                openedPanelHeightIndex = validPanels;
                int height = this.getPanelSizeDigital();
                if (this.sd.isAnalog()) {
                    height = this.getPanelSizeAnalog();
                }
                rowHeights[validPanels++] = height;
                continue;
            }
            if (this.wavePanels.get(i).isHidden()) continue;
            int rowHeight = this.table.getRowHeight(visRow++);
            rowHeights[validPanels++] = rowHeight;
            averageHeight += rowHeight;
            ++numAverages;
        }
        wp.setHidden(false);
        this.stopEditing();
        this.reloadTable();
        if (numAverages != 0) {
            rowHeights[openedPanelHeightIndex] = averageHeight / numAverages;
        }
        for (i = 0; i < validPanels; ++i) {
            this.table.setRowHeight(i, rowHeights[i]);
        }
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void growPanels(double scale) {
        int origDigitalPanelSize = panelSizeDigital;
        if ((panelSizeDigital = (int)((double)panelSizeDigital * scale)) < 20) {
            panelSizeDigital = 20;
        }
        int origAnalogPanelSize = panelSizeAnalog;
        if ((panelSizeAnalog = (int)((double)panelSizeAnalog * scale)) < 30) {
            panelSizeAnalog = 30;
        }
        if (this.sd.isAnalog() ? origAnalogPanelSize == panelSizeAnalog : origDigitalPanelSize == panelSizeDigital) {
            return;
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int rowHeight = this.table.getRowHeight(i);
            this.table.setRowHeight(i, (int)((double)rowHeight * scale));
        }
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void deleteSignalFromPanel(Panel wp) {
        boolean found = true;
        block0: while (found) {
            found = false;
            for (WaveSignal ws : wp.getSignals()) {
                if (!ws.isHighlighted()) continue;
                wp.removeHighlightedSignal(ws, true);
                wp.removeSignal(ws.getButton());
                found = true;
                continue block0;
            }
        }
        if (wp.getSignalButtons() != null) {
            wp.getSignalButtons().validate();
            wp.getSignalButtons().repaint();
        }
        wp.repaintContents();
        this.saveSignalOrder();
    }

    public void deleteAllSignalsFromPanel(Panel wp) {
        wp.clearHighlightedSignals();
        wp.getSignalButtons().removeAll();
        wp.getSignalButtons().validate();
        wp.getSignalButtons().repaint();
        wp.removeAllSignals();
        wp.repaintContents();
        this.saveSignalOrder();
    }

    public int getPanelSizeDigital() {
        return panelSizeDigital;
    }

    public int getPanelSizeAnalog() {
        return panelSizeAnalog;
    }

    public HorizRuler getMainHorizRuler() {
        return this.mainHorizRulerPanel;
    }

    public Signal getXAxisSignalAll() {
        return this.xAxisSignalAll;
    }

    public void setXAxisSignalAll(Signal sig) {
        this.xAxisSignalAll = sig;
    }

    private void addMainHorizRulerPanel() {
        this.mainHorizRulerPanel = new HorizRuler(null, this);
        this.mainHorizRulerPanel.setToolTipText("One X axis ruler applies to all signals when the X axes are locked");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.overall.add((Component)this.mainHorizRulerPanel, gbc);
    }

    private void removeMainHorizRulerPanel() {
        this.overall.remove(this.mainHorizRulerPanel);
        this.mainHorizRulerPanel = null;
    }

    private void resetSweeps() {
        this.sweepSignals = new ArrayList<SweepSignal>();
        Iterator<Analysis> it = this.sd.getAnalyses();
        while (it.hasNext()) {
            Analysis an = it.next();
            int maxNum = an.getNumSweeps();
            for (int i = 0; i < maxNum; ++i) {
                Object obj = an.getSweep(i);
                new SweepSignal(obj, this, an);
            }
        }
    }

    public int addSweep(SweepSignal ss) {
        if (this.sweepSignals.add(ss)) {
            return this.sweepSignals.size() - 1;
        }
        return -1;
    }

    public void setIncludeInAllSweeps(List<SweepSignal> sweeps, boolean include) {
        for (int i = 0; i < sweeps.size(); ++i) {
            SweepSignal ss = sweeps.get(i);
            boolean update = i == sweeps.size() - 1;
            ss.setIncluded(include, update);
        }
    }

    public boolean isSweepSignalIncluded(Analysis an, int index) {
        Object sweep = an.getSweep(index);
        for (SweepSignal ss : this.sweepSignals) {
            if (ss.getObject() != sweep) continue;
            return ss.isIncluded();
        }
        return true;
    }

    public int getHighlightedSweep() {
        return this.highlightedSweep;
    }

    public void setHighlightedSweep(int sweep) {
        this.highlightedSweep = sweep;
    }

    private void tick() {
        long curtime = System.currentTimeMillis();
        if (curtime - this.vcrLastAdvance < 100L) {
            return;
        }
        this.vcrLastAdvance = curtime;
        if (this.wavePanels.size() == 0) {
            return;
        }
        Panel wp = this.wavePanels.iterator().next();
        int xValueScreen = wp.convertXDataToScreen(this.mainXPosition);
        Rectangle2D bounds = this.sd.getBounds();
        if (this.vcrPlayingBackwards) {
            double lowXValue;
            int newXValueScreen = xValueScreen - this.vcrAdvanceSpeed;
            double newXValue = wp.convertXScreenToData(newXValueScreen);
            if (newXValue <= (lowXValue = bounds.getMinX())) {
                newXValue = lowXValue;
                this.vcrClickStop();
            }
            this.setMainXPositionCursor(newXValue);
        } else {
            double highXValue;
            int newXValueScreen = xValueScreen + this.vcrAdvanceSpeed;
            double newXValue = wp.convertXScreenToData(newXValueScreen);
            if (newXValue >= (highXValue = bounds.getMaxX())) {
                newXValue = highXValue;
                this.vcrClickStop();
            }
            this.setMainXPositionCursor(newXValue);
        }
        this.redrawAllPanels();
    }

    private void vcrClickRewind() {
        this.vcrClickStop();
        Rectangle2D bounds = this.sd.getBounds();
        double lowXValue = bounds.getMinX();
        this.setMainXPositionCursor(lowXValue);
        this.redrawAllPanels();
    }

    private void vcrClickPlayBackwards() {
        if (this.vcrTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.tick();
                }
            };
            this.vcrTimer = new Timer(100, taskPerformer);
            this.vcrLastAdvance = System.currentTimeMillis();
            this.vcrTimer.start();
        }
        this.vcrPlayingBackwards = true;
    }

    public void vcrClickStop() {
        if (this.vcrTimer == null) {
            return;
        }
        this.vcrTimer.stop();
        this.vcrTimer = null;
    }

    private void vcrClickPlay() {
        if (this.vcrTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.tick();
                }
            };
            this.vcrTimer = new Timer(100, taskPerformer);
            this.vcrLastAdvance = System.currentTimeMillis();
            this.vcrTimer.start();
        }
        this.vcrPlayingBackwards = false;
    }

    private void vcrClickToEnd() {
        this.vcrClickStop();
        Rectangle2D bounds = this.sd.getBounds();
        double highXValue = bounds.getMaxX();
        this.setMainXPositionCursor(highXValue);
        this.redrawAllPanels();
    }

    private void vcrClickFaster() {
        int j = this.vcrAdvanceSpeed / 4;
        if (j <= 0) {
            j = 1;
        }
        this.vcrAdvanceSpeed += j;
    }

    private void vcrClickSlower() {
        int j = this.vcrAdvanceSpeed / 4;
        if (j <= 0) {
            j = 1;
        }
        this.vcrAdvanceSpeed -= j;
        if (this.vcrAdvanceSpeed <= 0) {
            this.vcrAdvanceSpeed = 1;
        }
    }

    public void clearHighlighting() {
        for (Panel wp : this.wavePanels) {
            boolean changed = false;
            for (WaveSignal ws : wp.getSignals()) {
                if (ws.isHighlighted()) {
                    changed = true;
                }
                ws.setHighlighted(false);
            }
            if (!changed) continue;
            wp.repaintContents();
        }
    }

    public List<Signal> getHighlightedNetworkNames() {
        ArrayList<Signal> highlightedSignals = new ArrayList<Signal>();
        for (Panel wp : this.wavePanels) {
            for (WaveSignal ws : wp.getSignals()) {
                if (!ws.isHighlighted()) continue;
                highlightedSignals.add(ws.getSignal());
            }
        }
        ExplorerTree sigTree = this.wf.getExplorerTab();
        Object nodeInfo = sigTree.getCurrentlySelectedObject(0);
        if (nodeInfo != null && nodeInfo instanceof Signal) {
            Signal sig = (Signal)nodeInfo;
            highlightedSignals.add(sig);
        }
        return highlightedSignals;
    }

    public Set<Network> getHighlightedNetworks() {
        Signal sig;
        Network net;
        HashSet<Network> nets = new HashSet<Network>();
        Cell cell = this.sd.getCell();
        if (cell == null) {
            return nets;
        }
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return nets;
        }
        for (Panel wp : this.wavePanels) {
            for (WaveSignal ws : wp.getSignals()) {
                Network net2 = WaveformWindow.findNetwork(netlist, ws.getSignal().getSignalName());
                if (net2 == null) continue;
                nets.add(net2);
            }
        }
        ExplorerTree sigTree = this.wf.getExplorerTab();
        Object nodeInfo = sigTree.getCurrentlySelectedObject(0);
        if (nodeInfo != null && nodeInfo instanceof Signal && (net = WaveformWindow.findNetwork(netlist, (sig = (Signal)nodeInfo).getSignalName())) != null) {
            nets.add(net);
        }
        return nets;
    }

    @Override
    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public List<PolyBase> getPolysForPrinting() {
        int offY = 0;
        ArrayList<PolyBase> override = new ArrayList<PolyBase>();
        HorizRuler mainHR = this.getMainHorizRuler();
        if (mainHR != null) {
            List<PolyBase> horizPolys = mainHR.getPolysForPrinting(this.getPanels().next());
            for (PolyBase poly : horizPolys) {
                Point2D[] pts = poly.getPoints();
                for (int i = 0; i < pts.length; ++i) {
                    poly.setPoint(i, pts[i].getX(), pts[i].getY() + (double)offY);
                }
                override.add(poly);
            }
            offY += mainHR.getHeight();
        }
        Iterator<Panel> it = this.getPanels();
        while (it.hasNext()) {
            int i;
            Point2D[] pts;
            Panel panel = it.next();
            HorizRuler hr = panel.getHorizRuler();
            if (hr != null) {
                offY += hr.getHeight();
                List<PolyBase> horizPolys = hr.getPolysForPrinting(panel);
                for (PolyBase poly : horizPolys) {
                    pts = poly.getPoints();
                    for (i = 0; i < pts.length; ++i) {
                        poly.setPoint(i, pts[i].getX(), pts[i].getY() + (double)offY);
                    }
                    override.add(poly);
                }
                offY += hr.getHeight();
            }
            List<PolyBase> panelList = panel.getPolysForPrinting();
            for (PolyBase poly : panelList) {
                pts = poly.getPoints();
                for (i = 0; i < pts.length; ++i) {
                    poly.setPoint(i, pts[i].getX(), pts[i].getY() + (double)offY);
                }
                override.add(poly);
            }
            offY += panel.getHeight();
            if (hr != null) continue;
            offY += 20;
        }
        return override;
    }

    @Override
    public List<MutableTreeNode> loadExplorerTrees() {
        TreePath rootPath = new TreePath("Explorer");
        ArrayList<MutableTreeNode> nodes = new ArrayList<MutableTreeNode>();
        this.treePathFromAnalysis.clear();
        Iterator<Analysis> it = this.sd.getAnalyses();
        while (it.hasNext()) {
            Analysis an = it.next();
            if (an.getAnalysisType() == Analysis.ANALYSIS_SIGNALS) {
                nodes.add(this.getSignalsForExplorer(an, rootPath, "SIGNALS"));
                continue;
            }
            if (an.getAnalysisType() == Analysis.ANALYSIS_TRANS) {
                nodes.add(this.getSignalsForExplorer(an, rootPath, "TRANS SIGNALS"));
                nodes.add(this.getSweepsForExplorer(an, "TRANS SWEEPS"));
                continue;
            }
            if (an.getAnalysisType() == Analysis.ANALYSIS_AC) {
                nodes.add(this.getSignalsForExplorer(an, rootPath, "AC SIGNALS"));
                nodes.add(this.getSweepsForExplorer(an, "AC SWEEPS"));
                continue;
            }
            if (an.getAnalysisType() == Analysis.ANALYSIS_DC) {
                nodes.add(this.getSignalsForExplorer(an, rootPath, "DC SIGNALS"));
                nodes.add(this.getSweepsForExplorer(an, "DC SWEEPS"));
                continue;
            }
            if (an.getAnalysisType() != Analysis.ANALYSIS_MEAS) continue;
            nodes.add(this.getSignalsForExplorer(an, rootPath, "MEASUREMENTS"));
        }
        while (nodes.remove(null)) {
        }
        return nodes;
    }

    private DefaultMutableTreeNode getSignalsForExplorer(Analysis an, TreePath parentPath, String analysis) {
        List<Signal> signals = an.getSignals();
        if (signals.size() == 0) {
            return null;
        }
        if (an instanceof EpicAnalysis) {
            DefaultMutableTreeNode analysisNode = ((EpicAnalysis)an).getSignalsForExplorer(analysis);
            this.treePathFromAnalysis.put(an, parentPath.pathByAddingChild(analysisNode));
            return analysisNode;
        }
        DefaultMutableTreeNode signalsExplorerTree = new DefaultMutableTreeNode(analysis);
        TreePath analysisPath = parentPath.pathByAddingChild(signalsExplorerTree);
        this.treePathFromAnalysis.put(an, analysisPath);
        HashMap<String, TreePath> contextMap = new HashMap<String, TreePath>();
        contextMap.put("", analysisPath);
        Collections.sort(signals, new SignalsByName());
        char separatorChar = this.sd.getSeparatorChar();
        for (Signal sSig : signals) {
            if (!(sSig instanceof TimedSignal) || sSig.getSignalContext() == null) continue;
            this.makeContext(sSig.getSignalContext(), contextMap, separatorChar);
        }
        for (Signal sSig : signals) {
            if (!(sSig instanceof TimedSignal)) continue;
            TreePath thisTree = analysisPath;
            if (sSig.getSignalContext() != null) {
                thisTree = this.makeContext(sSig.getSignalContext(), contextMap, separatorChar);
            }
            DefaultMutableTreeNode sigLeaf = new DefaultMutableTreeNode(sSig);
            ((DefaultMutableTreeNode)thisTree.getLastPathComponent()).add(sigLeaf);
        }
        return signalsExplorerTree;
    }

    private TreePath makeContext(String branchName, HashMap<String, TreePath> contextMap, char separatorChar) {
        TreePath branchTree = contextMap.get(branchName);
        if (branchTree != null) {
            return branchTree;
        }
        String parent = "";
        String leaf = branchName;
        int dotPos = leaf.lastIndexOf(separatorChar);
        if (dotPos >= 0) {
            parent = leaf.substring(0, dotPos);
            leaf = leaf.substring(dotPos + 1);
        }
        TreePath parentBranch = this.makeContext(parent, contextMap, separatorChar);
        DefaultMutableTreeNode thisTree = new DefaultMutableTreeNode(leaf);
        ((DefaultMutableTreeNode)parentBranch.getLastPathComponent()).add(thisTree);
        TreePath thisPath = parentBranch.pathByAddingChild(thisTree);
        contextMap.put(branchName, thisPath);
        return thisPath;
    }

    private DefaultMutableTreeNode getSweepsForExplorer(Analysis an, String analysis) {
        DefaultMutableTreeNode sweepsExplorerTree = null;
        boolean first = true;
        for (SweepSignal ss : this.sweepSignals) {
            if (ss.getAnalysis() != an) continue;
            if (first) {
                first = false;
                sweepsExplorerTree = new DefaultMutableTreeNode(analysis);
            }
            sweepsExplorerTree.add(new DefaultMutableTreeNode(ss));
        }
        return sweepsExplorerTree;
    }

    private Signal findSignal(String name, Analysis an) {
        for (Signal sSig : an.getSignals()) {
            String sigName = sSig.getFullName();
            if (!sigName.equals(name)) continue;
            return sSig;
        }
        return null;
    }

    public void showSignals(Signal[] sigs, boolean newPanel) {
        ArrayList<Signal> these = new ArrayList<Signal>();
        for (int i = 0; i < sigs.length; ++i) {
            these.add(sigs[i]);
        }
        this.showTheseSignals(these, newPanel);
    }

    public void showSignals(Highlighter h, VarContext context, boolean newPanel) {
        List<Signal> found = this.findSelectedSignals(h, context);
        this.showTheseSignals(found, newPanel);
    }

    private void showTheseSignals(List<Signal> found, boolean newPanel) {
        Panel wp = null;
        for (Panel oWp : this.wavePanels) {
            if (!oWp.isSelected()) continue;
            wp = oWp;
            break;
        }
        if (!this.sd.isAnalog()) {
            newPanel = true;
        }
        if (!newPanel && wp == null) {
            System.out.println("No current waveform panel to add signals");
            return;
        }
        boolean added = false;
        for (Signal sSig : found) {
            if (newPanel) {
                wp = this.makeNewPanel();
                boolean isAnalog = false;
                if (sSig instanceof AnalogSignal) {
                    isAnalog = true;
                }
                if (isAnalog) {
                    AnalogSignal as = (AnalogSignal)sSig;
                    Rectangle2D rangeBounds = as.getBounds();
                    double lowValue = rangeBounds.getMinY();
                    double highValue = rangeBounds.getMaxY();
                    double range = highValue - lowValue;
                    if (range == 0.0) {
                        range = 2.0;
                    }
                    double rangeExtra = range / 10.0;
                    wp.setYAxisRange(lowValue - rangeExtra, highValue + rangeExtra);
                    wp.makeSelectedPanel();
                    newPanel = false;
                }
                if (!this.xAxisLocked) {
                    Rectangle2D rangeBounds = sSig.getBounds();
                    wp.setXAxisRange(rangeBounds.getMinX(), rangeBounds.getMaxX());
                }
            }
            boolean alreadyPlotted = false;
            for (WaveSignal ws : wp.getSignals()) {
                String name = ws.getSignal().getFullName();
                if (!name.equals(sSig.getFullName())) continue;
                alreadyPlotted = true;
                WaveSignal.addSignalToPanel(ws.getSignal(), wp, null);
            }
            if (!alreadyPlotted) {
                new WaveSignal(wp, sSig);
            }
            added = true;
            wp.repaintContents();
        }
        if (added) {
            this.overall.validate();
            this.saveSignalOrder();
        }
    }

    public void removeSignals(Set<Network> nets, VarContext context) {
        for (Network net : nets) {
            String netName = WaveformWindow.getSpiceNetName(context, net);
            Iterator<Analysis> aIt = this.sd.getAnalyses();
            while (aIt.hasNext()) {
                Analysis an = aIt.next();
                Signal sSig = an.findSignalForNetwork(netName);
                if (sSig == null) continue;
                boolean found = true;
                block2: while (found) {
                    found = false;
                    Iterator<Panel> pIt = this.getPanels();
                    while (pIt.hasNext()) {
                        Panel wp = pIt.next();
                        if (wp.getAnalysisType() != an.getAnalysisType()) continue;
                        for (WaveSignal ws : wp.getSignals()) {
                            if (ws.getSignal() != sSig) continue;
                            wp.removeHighlightedSignal(ws, true);
                            wp.removeSignal(ws.getButton());
                            wp.getSignalButtons().validate();
                            wp.getSignalButtons().repaint();
                            wp.repaintContents();
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        continue block2;
                    }
                }
            }
        }
    }

    public static String getSpiceNetName(Network net) {
        return Spice.getSafeNetName(net.getName());
    }

    public static String getSpiceNetName(VarContext context, Network net) {
        boolean isGlobal = false;
        if (net != null) {
            Network tempnet;
            Netlist netlist = net.getNetlist();
            while (net.isExported() && context != VarContext.globalContext && (tempnet = WaveformWindow.getNetworkInParent(net, context.getNodable())) != null) {
                net = tempnet;
                context = context.pop();
            }
            netlist = net.getNetlist();
            Global.Set globNets = netlist.getGlobals();
            for (int i = 0; i < globNets.size(); ++i) {
                Global g = globNets.get(i);
                Network netG = netlist.getNetwork(g);
                if (netG != net) continue;
                isGlobal = true;
                break;
            }
        }
        String contextStr = context.getInstPath(".");
        contextStr = TextUtils.canonicString(contextStr);
        if (net == null) {
            return contextStr;
        }
        if (context == VarContext.globalContext || isGlobal) {
            return WaveformWindow.getSpiceNetName(net);
        }
        return contextStr + "." + WaveformWindow.getSpiceNetName(net);
    }

    public static Network getNetworkInParent(Network childNetwork, Nodable childNodable) {
        if (childNodable == null || childNetwork == null) {
            return null;
        }
        if (!childNodable.isCellInstance()) {
            return null;
        }
        Cell childCell = (Cell)childNodable.getProto();
        if (childCell.contentsView() != null) {
            childCell = childCell.contentsView();
        }
        boolean found = false;
        Export export = null;
        int i = 0;
        Iterator<PortProto> it = childCell.getPorts();
        while (it.hasNext()) {
            export = (Export)it.next();
            for (i = 0; i < export.getNameKey().busWidth(); ++i) {
                Netlist netlist = childCell.acquireUserNetlist();
                if (netlist == null) {
                    System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
                    return null;
                }
                Network net = netlist.getNetwork(export, i);
                if (net != childNetwork) continue;
                found = true;
                break;
            }
            if (!found) continue;
        }
        if (!found) {
            return null;
        }
        Export pp = (Export)childNodable.getProto().findPortProto(export.getNameKey());
        Cell parentCell = childNodable.getParent();
        Netlist netlist = parentCell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return null;
        }
        Network parentNet = netlist.getNetwork(childNodable, pp, i);
        return parentNet;
    }

    public WaveSignal findDisplayedSignal(Signal sSig) {
        for (Panel wp : this.wavePanels) {
            WaveSignal ws = wp.findWaveSignal(sSig);
            if (ws == null) continue;
            return ws;
        }
        return null;
    }

    public double getMainXPositionCursor() {
        return this.mainXPosition;
    }

    public void setMainXPositionCursor(double value) {
        this.mainXPosition = value;
        String amount = TextUtils.convertToEngineeringNotation(this.mainXPosition, "s");
        this.mainPos.setText("Main: " + amount);
        String diff = TextUtils.convertToEngineeringNotation(Math.abs(this.mainXPosition - this.extXPosition), "s");
        this.delta.setText("Delta: " + diff);
        this.updateAssociatedLayoutWindow();
    }

    public double getExtensionXPositionCursor() {
        return this.extXPosition;
    }

    public void setExtensionXPositionCursor(double value) {
        this.extXPosition = value;
        String amount = TextUtils.convertToEngineeringNotation(this.extXPosition, "s");
        this.extPos.setText("Ext: " + amount);
        String diff = TextUtils.convertToEngineeringNotation(Math.abs(this.mainXPosition - this.extXPosition), "s");
        this.delta.setText("Delta: " + diff);
    }

    public void setDefaultHorizontalRange(double minXPosition, double maxXPosition) {
        this.minXPosition = minXPosition;
        this.maxXPosition = maxXPosition;
    }

    public double getLowDefaultHorizontalRange() {
        return this.minXPosition;
    }

    public double getHighDefaultHorizontalRange() {
        return this.maxXPosition;
    }

    public void setZoomExtents(double lowVert, double highVert, double lowHoriz, double highHoriz, Panel thePanel) {
        for (Panel wp : this.wavePanels) {
            boolean changed = false;
            if (wp == thePanel) {
                wp.setYAxisRange(lowVert, highVert);
                changed = true;
            }
            if (this.xAxisLocked || wp == thePanel) {
                wp.setXAxisRange(lowHoriz, highHoriz);
                changed = true;
            }
            if (!changed) continue;
            wp.repaintWithRulers();
        }
    }

    public void togglePanelXAxisLock() {
        boolean bl = this.xAxisLocked = !this.xAxisLocked;
        if (this.xAxisLocked) {
            this.xAxisLockButton.setIcon(iconLockXAxes);
            this.addMainHorizRulerPanel();
            double minXPosition = 0.0;
            double maxXPosition = 0.0;
            int vertAxis = 0;
            boolean first = true;
            for (Panel wp : this.wavePanels) {
                wp.removeHorizRulerPanel();
                if (first) {
                    first = false;
                    minXPosition = wp.getMinXAxis();
                    maxXPosition = wp.getMaxXAxis();
                    vertAxis = wp.getVertAxisPos();
                    continue;
                }
                if (wp.getMinXAxis() < minXPosition) {
                    minXPosition = wp.getMinXAxis();
                    maxXPosition = wp.getMaxXAxis();
                }
                wp.setVertAxisPos(vertAxis);
            }
            for (Panel wp : this.wavePanels) {
                wp.setXAxisRange(minXPosition, maxXPosition);
            }
        } else {
            this.xAxisLockButton.setIcon(iconUnLockXAxes);
            for (Panel wp : this.wavePanels) {
                wp.addHorizRulerPanel();
            }
            this.removeMainHorizRulerPanel();
        }
        this.overall.validate();
        this.overall.repaint();
    }

    public boolean isXAxisLocked() {
        return this.xAxisLocked;
    }

    private void crossProbeEditWindowToWaveform(EditWindow wnd, Highlighter which) {
        Locator loc = new Locator(wnd, this);
        if (loc.getWaveformWindow() != this) {
            return;
        }
        freezeEditWindowHighlighting = true;
        for (Panel wp : this.wavePanels) {
            wp.clearHighlightedSignals();
        }
        ExplorerTree tree = this.wf.getExplorerTab();
        tree.setSelectionPath(null);
        tree.clearCurrentlySelectedObjects();
        List<Signal> found = this.findSelectedSignals(which, loc.getContext());
        boolean foundSignal = false;
        for (Panel wp : this.wavePanels) {
            for (WaveSignal ws : wp.getSignals()) {
                for (Signal sSig : found) {
                    if (ws.getSignal() != sSig) continue;
                    wp.addHighlightedSignal(ws, false);
                    foundSignal = true;
                }
            }
        }
        if (foundSignal) {
            this.repaint();
        }
        Collections.sort(found, new SignalsByName());
        for (Signal sSig : found) {
            TreePath treePath = this.treePathFromSignal(sSig);
            if (treePath == null) continue;
            tree.setSelectionPath(treePath);
            break;
        }
        freezeEditWindowHighlighting = false;
    }

    private TreePath treePathFromSignal(Signal sig) {
        Analysis an = sig.getAnalysis();
        TreePath treePath = this.treePathFromAnalysis.get(an);
        if (treePath == null) {
            return null;
        }
        String fullName = sig.getFullName();
        char separator = an.getStimuli().getSeparatorChar();
        int sBeg = 0;
        while (sBeg < fullName.length()) {
            int sEnd = fullName.indexOf(separator, sBeg);
            if (sEnd < 0) {
                sEnd = fullName.length();
            }
            String s = fullName.substring(sBeg, sEnd);
            TreeNode parentNode = (TreeNode)treePath.getLastPathComponent();
            TreeNode child = WaveformWindow.findChild(parentNode, s);
            if (child == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(child);
            sBeg = sEnd + 1;
        }
        return sBeg == fullName.length() + 1 ? treePath : null;
    }

    private static TreeNode findChild(TreeNode parent, String name) {
        int numChilds = parent.getChildCount();
        for (int i = 0; i < numChilds; ++i) {
            DefaultMutableTreeNode node;
            Object o;
            TreeNode child = parent.getChildAt(i);
            String s = child instanceof DefaultMutableTreeNode ? ((o = (node = (DefaultMutableTreeNode)child).getUserObject()) instanceof Signal ? ((Signal)o).getSignalName() : o.toString()) : child.toString();
            if (!name.equals(s)) continue;
            return child;
        }
        return null;
    }

    private List<Signal> findSelectedSignals(Highlighter h, VarContext context) {
        Geometric geom;
        ArrayList<Signal> found = new ArrayList<Signal>();
        List<Geometric> highlightedObjects = h.getHighlightedEObjs(true, true);
        if (highlightedObjects.size() == 1 && (geom = highlightedObjects.get(0)) instanceof NodeInst) {
            NodeInst ni = (NodeInst)geom;
            String nodeName = "I(v" + ni.getName();
            Iterator<Analysis> it = this.sd.getAnalyses();
            while (it.hasNext()) {
                Analysis an = it.next();
                Signal sSig = an.findSignalForNetworkQuickly(nodeName);
                if (sSig == null) continue;
                found.add(sSig);
                return found;
            }
        }
        Set<Network> nets = h.getHighlightedNetworks();
        found.addAll(this.findSelectedSignals(nets, context, false));
        Collections.sort(found, new CompSignals());
        return found;
    }

    private List<Signal> findSelectedSignals(Set<Network> nets, VarContext context, boolean sort) {
        ArrayList<Signal> found = new ArrayList<Signal>();
        for (Network net : nets) {
            String netName = WaveformWindow.getSpiceNetName(context, net);
            Iterator<Analysis> aIt = this.sd.getAnalyses();
            while (aIt.hasNext()) {
                Analysis an = aIt.next();
                Signal sSig = an.findSignalForNetworkQuickly(netName);
                if (sSig == null) {
                    HierarchyEnumerator.NetNameProxy proxy;
                    Cell cell = net.getParent();
                    NccResult result = NccCrossProbing.getResults(cell);
                    if (result == null) {
                        for (VarContext checkContext = context; checkContext != VarContext.globalContext && (result = NccCrossProbing.getResults(cell = checkContext.getNodable().getParent())) == null; checkContext = checkContext.pop()) {
                        }
                    }
                    if (result != null && (proxy = result.getEquivalence().findEquivalentNet(context, net)) != null) {
                        String otherName = WaveformWindow.getSpiceNetName(proxy.getContext(), proxy.getNet());
                        System.out.println("Mapped " + netName + " to " + otherName);
                        sSig = an.findSignalForNetworkQuickly(otherName);
                    }
                }
                if (sSig != null) {
                    found.add(sSig);
                    continue;
                }
                System.out.println("Can't find net " + netName + " in cell " + context.getInstPath("."));
            }
        }
        if (sort) {
            Collections.sort(found, new CompSignals());
        }
        return found;
    }

    public List<Signal> findAllSignals(Cell cell, VarContext context, boolean sort, boolean recurse) {
        HashSet<Network> nets = new HashSet<Network>();
        ArrayList<Signal> found = new ArrayList<Signal>();
        Iterator<Object> it = cell.getNetlist(false).getNetworks();
        while (it.hasNext()) {
            nets.add(it.next());
        }
        found.addAll(this.findSelectedSignals(nets, context, false));
        if (recurse) {
            it = cell.getNetlist(false).getNodables();
            while (it.hasNext()) {
                Nodable no = (Nodable)it.next();
                if (!(no.getProto() instanceof Cell)) continue;
                Cell subCell = (Cell)no.getProto();
                VarContext subContext = context.push(no);
                found.addAll(this.findAllSignals(subCell, subContext, false, true));
            }
        }
        if (sort) {
            Collections.sort(found, new CompSignals());
        }
        return found;
    }

    private static Network findNetwork(Netlist netlist, String name) {
        Network net;
        Iterator<Network> nIt = netlist.getNetworks();
        while (nIt.hasNext()) {
            net = nIt.next();
            if (!WaveformWindow.getSpiceNetName(net).equalsIgnoreCase(name)) continue;
            return net;
        }
        nIt = netlist.getNetworks();
        while (nIt.hasNext()) {
            net = nIt.next();
            String convertedName = WaveformWindow.getSpiceNetName(net).replace('@', '_');
            if (!convertedName.equalsIgnoreCase(name)) continue;
            return net;
        }
        nIt = netlist.getNetworks();
        while (nIt.hasNext()) {
            net = nIt.next();
            String netName = WaveformWindow.getSpiceNetName(net);
            if (netName.length() != name.length()) continue;
            boolean matches = true;
            for (int i = 0; i < netName.length(); ++i) {
                char netChar = netName.charAt(i);
                char nameChar = name.charAt(i);
                if (nameChar == '_') {
                    if (!TextUtils.isLetterOrDigit(netChar)) continue;
                    matches = false;
                    break;
                }
                if (TextUtils.canonicChar(nameChar) == TextUtils.canonicChar(netChar)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return net;
        }
        return null;
    }

    public void crossProbeWaveformToEditWindow() {
        if (freezeEditWindowHighlighting) {
            return;
        }
        freezeWaveformHighlighting = true;
        Iterator<WindowFrame> wIt = WindowFrame.getWindows();
        while (wIt.hasNext()) {
            EditWindow wnd;
            Locator loc;
            WindowFrame wfr = wIt.next();
            if (!(wfr.getContent() instanceof EditWindow) || (loc = new Locator(wnd = (EditWindow)wfr.getContent(), this)).getWaveformWindow() != this) continue;
            VarContext context = loc.getContext();
            Cell cell = wnd.getCell();
            if (cell == null) continue;
            Highlighter hl = wnd.getHighlighter();
            Netlist netlist = cell.acquireUserNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
                freezeWaveformHighlighting = false;
                return;
            }
            hl.clear();
            for (Panel wp : this.wavePanels) {
                block2: for (WaveSignal ws : wp.getSignals()) {
                    if (!ws.isHighlighted()) continue;
                    String want = ws.getSignal().getFullName();
                    Stack<Nodable> upNodables = new Stack<Nodable>();
                    Network net = null;
                    while (true) {
                        NodeInst ni;
                        String desired;
                        String contextStr;
                        if ((contextStr = WaveformWindow.getSpiceNetName(context, null)).length() > 0) {
                            boolean matches = false;
                            if (want.startsWith(contextStr = contextStr + ".")) {
                                matches = true;
                            } else if (want.startsWith(contextStr = contextStr.replace('@', '_'))) {
                                matches = true;
                            }
                            if (!matches) {
                                if (context == VarContext.globalContext) continue block2;
                                cell = context.getNodable().getParent();
                                upNodables.push(context.getNodable());
                                context = context.pop();
                                continue;
                            }
                        }
                        if ((net = WaveformWindow.findNetwork(netlist, desired = want.substring(contextStr.length()))) != null) {
                            Nodable no;
                            while (!upNodables.isEmpty() && (net = HierarchyEnumerator.getNetworkInChild(net, no = (Nodable)upNodables.pop())) != null) {
                            }
                            if (net == null) continue block2;
                            hl.addNetwork(net, cell);
                            continue block2;
                        }
                        String cellName = cell.getName();
                        if (desired.startsWith(cellName) && (net = WaveformWindow.findNetwork(netlist, desired = desired.substring(cellName.length() + 1))) != null) {
                            Nodable no;
                            while (!upNodables.isEmpty() && (net = HierarchyEnumerator.getNetworkInChild(net, no = (Nodable)upNodables.pop())) != null) {
                            }
                            if (net == null) continue block2;
                            hl.addNetwork(net, cell);
                            continue block2;
                        }
                        if (desired.startsWith("I(v") && (ni = cell.findNode(desired.substring(3))) != null) {
                            hl.addElectricObject(ni, cell);
                        }
                        if (context == VarContext.globalContext) continue block2;
                        cell = context.getNodable().getParent();
                        upNodables.push(context.getNodable());
                        context = context.pop();
                    }
                }
            }
            ExplorerTree sigTree = this.wf.getExplorerTab();
            Object nodeInfo = sigTree.getCurrentlySelectedObject(0);
            if (nodeInfo != null && nodeInfo instanceof Signal) {
                NodeInst ni;
                Signal sig = (Signal)nodeInfo;
                String desired = sig.getSignalName();
                Network net = WaveformWindow.findNetwork(netlist, desired);
                if (net != null) {
                    if (net.getParent() == cell) {
                        hl.addNetwork(net, cell);
                    }
                } else if (desired.startsWith("I(v") && (ni = cell.findNode(desired.substring(3))) != null) {
                    hl.addElectricObject(ni, cell);
                }
            }
            hl.finished();
        }
        freezeWaveformHighlighting = false;
    }

    private void updateAssociatedLayoutWindow() {
        if (this.sd.isAnalog()) {
            return;
        }
        WindowFrame oWf = this.findSchematicsWindow();
        if (oWf == null) {
            return;
        }
        EditWindow schemWnd = (EditWindow)oWf.getContent();
        boolean crossProbeChanged = schemWnd.hasCrossProbeData();
        schemWnd.clearCrossProbeLevels();
        Cell cell = this.getCell();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return;
        }
        this.netValues = new HashMap();
        for (Panel wp : this.wavePanels) {
            if (wp.isHidden()) continue;
            for (WaveSignal ws : wp.getSignals()) {
                DigitalSignal ds = (DigitalSignal)ws.getSignal();
                List<Signal> bussedSignals = ds.getBussedSignals();
                if (bussedSignals != null) {
                    for (Signal subSig : bussedSignals) {
                        DigitalSignal subDS = (DigitalSignal)subSig;
                        this.putValueOnTrace(subDS, cell, this.netValues, netlist);
                    }
                    continue;
                }
                this.putValueOnTrace(ds, cell, this.netValues, netlist);
            }
        }
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            Integer state;
            NodeInst ni = it.next();
            if (ni.getProto() != Generic.tech.simProbeNode) continue;
            Network net = null;
            Iterator<Connection> cIt = ni.getConnections();
            if (cIt.hasNext()) {
                Connection con = cIt.next();
                net = netlist.getNetwork(con.getArc(), 0);
            }
            if (net == null || (state = this.netValues.get(net)) == null) continue;
            Color col = this.getHighlightColor(state);
            schemWnd.addCrossProbeBox(ni.getBounds(), col);
            crossProbeChanged = true;
            this.netValues.remove(net);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            int width = netlist.getBusWidth(ai);
            for (int i = 0; i < width; ++i) {
                Network net = netlist.getNetwork(ai, i);
                Integer state = this.netValues.get(net);
                if (state == null) continue;
                Color col = this.getHighlightColor(state);
                schemWnd.addCrossProbeLine(ai.getHeadLocation(), ai.getTailLocation(), col);
                crossProbeChanged = true;
            }
        }
        if (crossProbeChanged) {
            schemWnd.repaint();
        }
    }

    private Color getHighlightColor(int state) {
        switch (state & 3) {
            case 0: {
                return new Color(User.getColorWaveformCrossProbeLow());
            }
            case 2: {
                return new Color(User.getColorWaveformCrossProbeHigh());
            }
            case 1: {
                return new Color(User.getColorWaveformCrossProbeX());
            }
            case 3: {
                return new Color(User.getColorWaveformCrossProbeZ());
            }
        }
        return Color.RED;
    }

    private void putValueOnTrace(DigitalSignal ds, Cell cell, HashMap<Network, Integer> netValues, Netlist netlist) {
        Network net = WaveformWindow.findNetwork(netlist, ds.getSignalName());
        if (net == null) {
            return;
        }
        int numEvents = ds.getNumEvents();
        int state = 1;
        for (int i = numEvents - 1; i >= 0; --i) {
            double xValue = ds.getTime(i);
            if (!(xValue <= this.mainXPosition)) continue;
            state = ds.getState(i) & 3;
            break;
        }
        netValues.put(net, new Integer(state));
    }

    public void centerCursor(boolean main) {
        boolean havePanel = false;
        double lowXValue = 0.0;
        double highXValue = 0.0;
        for (Panel wp : this.wavePanels) {
            double low = wp.getMinXAxis();
            double high = wp.getMaxXAxis();
            if (havePanel) {
                lowXValue = Math.max(lowXValue, low);
                highXValue = Math.min(highXValue, high);
                continue;
            }
            lowXValue = low;
            highXValue = high;
            havePanel = true;
        }
        if (!havePanel) {
            return;
        }
        double center = (lowXValue + highXValue) / 2.0;
        if (main) {
            this.setMainXPositionCursor(center);
        } else {
            this.setExtensionXPositionCursor(center);
        }
        for (Panel wp : this.wavePanels) {
            wp.repaintWithRulers();
        }
    }

    public void setSimData(Stimuli sd) {
        if (this.sd != null) {
            this.sd.finished();
        }
        this.sd = sd;
        this.resetSweeps();
        String oldXAxisSignalAllName = null;
        if (this.xAxisSignalAll != null) {
            oldXAxisSignalAllName = this.xAxisSignalAll.getFullName();
            this.xAxisSignalAll = null;
        }
        ArrayList<Panel> panelList = new ArrayList<Panel>();
        for (Panel wp : this.wavePanels) {
            panelList.add(wp);
        }
        for (Panel wp : panelList) {
            Analysis an = sd.findAnalysis(wp.getAnalysisType());
            boolean redoPanel = false;
            if (wp.getXAxisSignal() != null) {
                String oldSigName = wp.getXAxisSignal().getFullName();
                wp.setXAxisSignal(null);
                for (Signal newSs : an.getSignals()) {
                    String newSigName = newSs.getFullName();
                    if (!newSigName.equals(oldSigName)) continue;
                    wp.setXAxisSignal(newSs);
                    break;
                }
                if (wp.getXAxisSignal() == null) {
                    System.out.println("Could not find X axis signal " + oldSigName + " in the new data");
                    redoPanel = true;
                }
            }
            if (oldXAxisSignalAllName != null) {
                for (Signal newSs : an.getSignals()) {
                    String newSigName = newSs.getFullName();
                    if (!newSigName.equals(oldXAxisSignalAllName)) continue;
                    this.xAxisSignalAll = newSs;
                    break;
                }
            }
            for (WaveSignal ws : wp.getSignals()) {
                Signal ss = ws.getSignal();
                if (ss.getBussedSignals() != null) {
                    List<Signal> inBus = ss.getBussedSignals();
                    for (int b = 0; b < inBus.size(); ++b) {
                        Signal subDS = inBus.get(b);
                        String oldSigName = subDS.getFullName();
                        Signal newBus = null;
                        for (Signal newSs : an.getSignals()) {
                            String newSigName = newSs.getFullName();
                            if (!newSigName.equals(oldSigName)) continue;
                            newBus = newSs;
                            break;
                        }
                        if (newBus == null) {
                            inBus.remove(b);
                            --b;
                            System.out.println("Could not find signal " + oldSigName + " in the new data");
                            redoPanel = true;
                            continue;
                        }
                        inBus.set(b, newBus);
                    }
                    continue;
                }
                String oldSigName = ss.getFullName();
                ws.setSignal(null);
                for (Signal newSs : an.getSignals()) {
                    String newSigName = newSs.getFullName();
                    if (!newSigName.equals(oldSigName)) continue;
                    ws.setSignal(newSs);
                    break;
                }
                if (ws.getSignal() != null) continue;
                System.out.println("Could not find signal " + oldSigName + " in the new data");
                redoPanel = true;
            }
            block8: while (redoPanel) {
                redoPanel = false;
                for (WaveSignal ws : wp.getSignals()) {
                    if (ws.getSignal() != null && (ws.getSignal().getBussedSignals() == null || ws.getSignal().getBussedSignals().size() != 0)) continue;
                    redoPanel = true;
                    if (wp.getSignalButtons() == null) continue block8;
                    wp.removeSignal(ws.getButton());
                    continue block8;
                }
            }
            if (wp.getNumSignals() == 0) {
                wp.getWaveWindow().closePanel(wp);
                continue;
            }
            if (wp.getSignalButtons() != null) {
                wp.getSignalButtons().validate();
                wp.getSignalButtons().repaint();
            }
            wp.repaintContents();
        }
        if (oldXAxisSignalAllName != null && this.xAxisSignalAll == null) {
            System.out.println("Could not find main X axis signal " + oldXAxisSignalAllName + " in the new data");
        }
        this.wf.wantToRedoSignalTree();
        System.out.println("Simulation data refreshed from disk");
    }

    public Stimuli getSimData() {
        return this.sd;
    }

    public static void exportSimulationData() {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Must select a Waveform window first");
            return;
        }
        WaveformWindow ww = (WaveformWindow)content;
        String configurationFileName = OpenFile.chooseOutputFile(FileType.TEXT, "Waveform Export File", "wavedata.txt");
        if (configurationFileName == null) {
            return;
        }
        try {
            int i;
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(configurationFileName)));
            ArrayList<Signal> dumpSignals = new ArrayList<Signal>();
            ArrayList<Integer> dumpSweeps = new ArrayList<Integer>();
            for (Panel wp : ww.wavePanels) {
                if (wp.isHidden()) continue;
                Signal signalInX = ww.xAxisSignalAll;
                if (!ww.xAxisLocked) {
                    signalInX = wp.getXAxisSignal();
                }
                if (signalInX != null) {
                    WaveformWindow.addSignalSweep(signalInX, -1, dumpSignals, dumpSweeps);
                }
                for (WaveSignal ws : wp.getSignals()) {
                    Signal sig = ws.getSignal();
                    if (sig instanceof AnalogSignal) {
                        AnalogSignal as = (AnalogSignal)sig;
                        Analysis an = as.getAnalysis();
                        int numSweeps = as.getNumSweeps();
                        if (numSweeps <= 1) {
                            WaveformWindow.addSignalSweep(sig, -1, dumpSignals, dumpSweeps);
                            continue;
                        }
                        for (int s = 0; s < numSweeps; ++s) {
                            if (!ww.isSweepSignalIncluded(an, s)) continue;
                            WaveformWindow.addSignalSweep(sig, s, dumpSignals, dumpSweeps);
                        }
                        continue;
                    }
                    WaveformWindow.addSignalSweep(sig, -1, dumpSignals, dumpSweeps);
                }
            }
            int numEntries = dumpSignals.size() + 1;
            String[] entries = new String[numEntries];
            entries[0] = "TIME";
            for (i = 1; i < numEntries; ++i) {
                Signal sig = (Signal)dumpSignals.get(i - 1);
                entries[i] = sig.getFullName();
                int s = (Integer)dumpSweeps.get(i - 1);
                if (s < 0) continue;
                Analysis an = sig.getAnalysis();
                Object sweepObj = an.getSweep(s);
                int n = i;
                entries[n] = entries[n] + "/S=" + sweepObj;
            }
            for (i = 0; i < numEntries; ++i) {
                if (i > 0) {
                    printWriter.print("\t");
                }
                printWriter.print(entries[i]);
            }
            printWriter.println();
            double[] result = new double[3];
            int j = 0;
            while (true) {
                int i2;
                boolean haveData = false;
                entries[0] = null;
                for (i2 = 1; i2 < numEntries; ++i2) {
                    DigitalSignal ds;
                    entries[i2] = "";
                    Signal sig = (Signal)dumpSignals.get(i2 - 1);
                    if (sig instanceof AnalogSignal) {
                        AnalogSignal as = (AnalogSignal)sig;
                        int s = (Integer)dumpSweeps.get(i2 - 1);
                        if (s < 0) {
                            s = 0;
                        }
                        if (j >= as.getNumEvents(s)) continue;
                        as.getEvent(s, j, result);
                        if (entries[0] == null) {
                            entries[0] = "" + result[0];
                        }
                        entries[i2] = "" + result[1];
                        haveData = true;
                        continue;
                    }
                    if (!(sig instanceof DigitalSignal) || j >= (ds = (DigitalSignal)sig).getNumEvents()) continue;
                    if (entries[0] == null) {
                        entries[0] = "" + ds.getTime(j);
                    }
                    entries[i2] = "" + ds.getState(j);
                    haveData = true;
                }
                if (!haveData) break;
                if (entries[0] == null) {
                    entries[0] = "";
                }
                for (i2 = 0; i2 < numEntries; ++i2) {
                    if (i2 > 0) {
                        printWriter.print("\t");
                    }
                    printWriter.print(entries[i2]);
                }
                printWriter.println();
                ++j;
            }
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error writing configuration");
            return;
        }
        System.out.println("Wrote " + configurationFileName);
    }

    private static void addSignalSweep(Signal sig, int s, List<Signal> dumpSignals, List<Integer> dumpSweeps) {
        for (int i = 0; i < dumpSignals.size(); ++i) {
            if (dumpSignals.get(i) != sig || dumpSweeps.get(i) != s) continue;
            return;
        }
        dumpSignals.add(sig);
        dumpSweeps.add(new Integer(s));
    }

    public static void refreshSimulationData() {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Nothing to refresh in non Waveform window");
            return;
        }
        ((WaveformWindow)content).refreshData();
    }

    private void refreshData() {
        if (this.se != null) {
            this.se.refresh();
            return;
        }
        if (this.sd.getDataType() == null) {
            System.out.println("This simulation data did not come from disk...cannot refresh");
            return;
        }
        Simulate.plotSimulationResults(this.sd.getDataType(), this.sd.getCell(), this.sd.getFileURL(), this);
    }

    public static void saveConfiguration() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        WaveformWindow ww = WaveformWindow.findWaveformWindow(cell);
        if (ww == null) {
            System.out.println("There is no waveform window to save");
            return;
        }
        String configurationFileName = OpenFile.chooseOutputFile(FileType.TEXT, "Waveform Configuration File", "waveform.txt");
        if (configurationFileName == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(configurationFileName)));
            for (int i = 0; i < ww.wavePanels.size(); ++i) {
                Panel wp = ww.wavePanels.get(i);
                if (wp.isHidden()) continue;
                boolean first = true;
                for (WaveSignal ws : wp.getSignals()) {
                    String sigName = ws.getSignal().getFullName();
                    if (first) {
                        first = false;
                        String analysisName = "";
                        if (wp.getAnalysisType() != null) {
                            analysisName = " " + wp.getAnalysisType();
                        }
                        String log = "";
                        if (wp.isPanelLogarithmicHorizontally()) {
                            log = " xlog";
                        }
                        if (wp.isPanelLogarithmicVertically()) {
                            log = log + " ylog";
                        }
                        if (i > 0) {
                            printWriter.println();
                        }
                        printWriter.println("panel" + analysisName + log);
                        printWriter.println("zoom " + wp.getYAxisLowValue() + " " + wp.getYAxisHighValue() + " " + wp.getMinXAxis() + " " + wp.getMaxXAxis());
                        Signal signalInX = ww.xAxisSignalAll;
                        if (!ww.xAxisLocked) {
                            signalInX = wp.getXAxisSignal();
                        }
                        if (signalInX != null) {
                            printWriter.println("x-axis " + signalInX.getFullName());
                        }
                    }
                    Color color = ws.getColor();
                    printWriter.println("signal " + sigName + " " + color.getRed() + "," + color.getGreen() + "," + color.getBlue());
                }
            }
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error writing configuration");
            return;
        }
        System.out.println("Wrote " + configurationFileName);
    }

    public static void restoreConfiguration() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        WaveformWindow ww = WaveformWindow.findWaveformWindow(cell);
        if (ww == null) {
            System.out.println("There is no waveform window to restore");
            return;
        }
        String configurationFileName = OpenFile.chooseInputFile(FileType.TEXT, "Waveform Configuration File");
        if (configurationFileName == null) {
            return;
        }
        ArrayList<Panel> closeList = new ArrayList<Panel>();
        for (Panel wp : ww.wavePanels) {
            closeList.add(wp);
        }
        for (Panel wp : closeList) {
            ww.closePanel(wp);
        }
        URL url = TextUtils.makeURLToFile(configurationFileName);
        Panel curPanel = null;
        Analysis.AnalysisType oneType = null;
        try {
            String buf;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            while ((buf = lineReader.readLine()) != null) {
                Signal sig;
                Stimuli sd;
                String[] keywords = buf.split(" ");
                if (keywords.length == 0) continue;
                if (keywords[0].equals("panel")) {
                    Analysis.AnalysisType analysisType = null;
                    boolean xLog = false;
                    boolean yLog = false;
                    for (int i = 1; i < keywords.length; ++i) {
                        if (keywords[i].equals("xlog")) {
                            xLog = true;
                            continue;
                        }
                        if (keywords[i].equals("ylog")) {
                            yLog = true;
                            continue;
                        }
                        analysisType = Analysis.AnalysisType.findAnalysisType(keywords[i]);
                        if (analysisType == null) continue;
                        if (oneType == null) {
                            oneType = analysisType;
                        }
                        if (oneType == analysisType || !ww.isXAxisLocked()) continue;
                        ww.togglePanelXAxisLock();
                    }
                    curPanel = new Panel(ww, ww.getSimData().isAnalog(), analysisType);
                    if (xLog) {
                        if (ww.isXAxisLocked()) {
                            ww.togglePanelXAxisLock();
                        }
                        curPanel.setPanelLogarithmicHorizontally(true);
                    }
                    if (!yLog) continue;
                    curPanel.setPanelLogarithmicVertically(true);
                    continue;
                }
                if (keywords[0].equals("zoom")) {
                    if (curPanel == null) continue;
                    double lowYValue = TextUtils.atof(keywords[1]);
                    double highYValue = TextUtils.atof(keywords[2]);
                    double lowXValue = TextUtils.atof(keywords[3]);
                    double highXValue = TextUtils.atof(keywords[4]);
                    curPanel.setXAxisRange(lowXValue, highXValue);
                    if (!curPanel.isAnalog()) continue;
                    curPanel.setYAxisRange(lowYValue, highYValue);
                    continue;
                }
                if (keywords[0].equals("x-axis")) {
                    Signal sig2;
                    if (curPanel == null) continue;
                    sd = ww.getSimData();
                    Analysis an = sd.getAnalyses().next();
                    if (curPanel.getAnalysisType() != null) {
                        an = sd.findAnalysis(curPanel.getAnalysisType());
                    }
                    if (an == null || (sig2 = an.findSignalForNetwork(keywords[1])) == null) continue;
                    if (ww.isXAxisLocked()) {
                        ww.togglePanelXAxisLock();
                    }
                    curPanel.setXAxisSignal(sig2);
                    continue;
                }
                if (!keywords[0].equals("signal") || curPanel == null) continue;
                sd = ww.getSimData();
                Analysis an = sd.getAnalyses().next();
                if (curPanel.getAnalysisType() != null) {
                    an = sd.findAnalysis(curPanel.getAnalysisType());
                }
                if (an == null || (sig = an.findSignalForNetwork(keywords[1])) == null) continue;
                String[] colorNames = keywords[2].split(",");
                int red = TextUtils.atoi(colorNames[0]);
                int green = TextUtils.atoi(colorNames[1]);
                int blue = TextUtils.atoi(colorNames[2]);
                Color color = new Color(red, green, blue);
                WaveSignal ws = new WaveSignal(curPanel, sig);
                ws.setColor(color);
            }
            lineReader.close();
            for (Panel panel : ww.wavePanels) {
                panel.repaintWithRulers();
            }
            ww.saveSignalOrder();
        }
        catch (IOException e) {
            System.out.println("Error reading " + configurationFileName);
            return;
        }
    }

    public void saveSignalOrder() {
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (Panel wp : this.wavePanels) {
            boolean first = true;
            for (WaveSignal ws : wp.getSignals()) {
                String sigName = ws.getSignal().getFullName();
                if (first) {
                    sb.append("\t" + wp.getAnalysisType());
                    Signal signalInX = this.xAxisSignalAll;
                    if (!this.xAxisLocked) {
                        signalInX = wp.getXAxisSignal();
                    }
                    first = false;
                    if (signalInX != null) {
                        sb.append("(" + signalInX.getFullName() + ")");
                    }
                }
                sb.append("\t");
                sb.append(sigName);
            }
            sb.append("\n");
        }
        savedSignalOrder.put(cell.getLibrary().getName() + ":" + cell.getName(), sb.toString());
    }

    public static void preserveSignalOrder() {
        Pref.delayPrefFlushing();
        for (String cellName : savedSignalOrder.keySet()) {
            Library lib;
            String savedOrder = savedSignalOrder.get(cellName);
            int colonPos = cellName.indexOf(58);
            if (colonPos < 0 || (lib = Library.findLibrary(cellName.substring(0, colonPos))) == null) continue;
            cellName = cellName.substring(colonPos + 1);
            Pref savedSignalPref = Pref.makeStringPref("SavedSignalsForCell" + cellName, lib.getPrefs(), "");
            savedSignalPref.setString(savedOrder);
        }
        Pref.resumePrefFlushing();
    }

    public static String[] getSignalOrder(Cell cell) {
        int endCh;
        Pref savedSignalPref;
        String savedOrder = savedSignalOrder.get(cell.getLibrary().getName() + ":" + cell.getName());
        if (savedOrder == null && (savedOrder = (savedSignalPref = Pref.makeStringPref("SavedSignalsForCell" + cell.getName(), cell.getLibrary().getPrefs(), "")).getString()).length() == 0) {
            return new String[0];
        }
        ArrayList<String> panels = new ArrayList<String>();
        int startPos = 0;
        while ((endCh = savedOrder.indexOf(10, startPos)) >= 0) {
            String panel = savedOrder.substring(startPos, endCh);
            panels.add(panel);
            startPos = endCh + 1;
        }
        String[] ret = new String[panels.size()];
        int i = 0;
        for (String s : panels) {
            ret[i++] = s;
        }
        return ret;
    }

    public Font getFont() {
        return waveWindowFont;
    }

    public FontRenderContext getFontRenderContext() {
        return waveWindowFRC;
    }

    public Color getOffStrengthColor() {
        return offStrengthColor;
    }

    public Color getNodeStrengthColor() {
        return nodeStrengthColor;
    }

    public Color getGateStrengthColor() {
        return gateStrengthColor;
    }

    public Color getPowerStrengthColor() {
        return powerStrengthColor;
    }

    private void toggleShowPoints() {
        this.linePointMode = (this.linePointMode + 1) % 3;
        switch (this.linePointMode) {
            case 0: {
                this.showPoints.setIcon(iconLineOnPointOff);
                break;
            }
            case 1: {
                this.showPoints.setIcon(iconLineOnPointOn);
                break;
            }
            case 2: {
                this.showPoints.setIcon(iconLineOffPointOn);
            }
        }
        for (Panel wp : this.wavePanels) {
            wp.repaintWithRulers();
        }
    }

    public int getLinePointMode() {
        return this.linePointMode;
    }

    public void toggleGridPoints() {
        this.showGrid = !this.showGrid;
        for (Panel wp : this.wavePanels) {
            wp.repaintWithRulers();
        }
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void addSignal(Signal sig) {
        if (sig instanceof AnalogSignal) {
            AnalogSignal as = (AnalogSignal)sig;
            for (Panel wp : this.wavePanels) {
                if (!wp.isSelected()) continue;
                if (as.getAnalysis().getAnalysisType() != wp.getAnalysisType()) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot drop a " + as.getAnalysis().getAnalysisType() + " signal onto a " + wp.getAnalysisType() + " panel.  " + "First convert the panel with the popup in the upper-left.", "Error Displaying Signals", 0);
                    return;
                }
                WaveSignal.addSignalToPanel(sig, wp, null);
                if (this.getMainHorizRuler() != null) {
                    this.getMainHorizRuler().repaint();
                }
                break;
            }
        } else {
            Panel wp = this.makeNewPanel();
            new WaveSignal(wp, sig);
            this.overall.validate();
            wp.repaintContents();
        }
        this.saveSignalOrder();
    }

    public void deleteSelectedSignals() {
        for (Panel wp : this.wavePanels) {
            if (!wp.isSelected()) continue;
            for (WaveSignal ws : wp.getSignals()) {
                if (ws.getSelectedControlPoints() == null || this.se == null) continue;
                this.se.removeSelectedStimuli();
            }
            if (wp.getAnalysisType() == null) break;
            this.deleteSignalFromPanel(wp);
            break;
        }
    }

    @Override
    public void fillScreen() {
        Analysis an;
        Rectangle2D xBounds = null;
        for (Panel wp : this.wavePanels) {
            Rectangle2D bounds;
            if (wp.getXAxisSignal() != null || (bounds = (an = this.sd.findAnalysis(wp.getAnalysisType())).getBounds()) == null) continue;
            if (xBounds == null) {
                xBounds = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                continue;
            }
            Rectangle2D.union(xBounds, bounds, xBounds);
        }
        if (this.xAxisLocked && this.xAxisSignalAll != null) {
            Rectangle2D sigBounds = this.xAxisSignalAll.getBounds();
            xBounds.setRect(sigBounds.getMinY(), sigBounds.getMinX(), sigBounds.getHeight(), sigBounds.getWidth());
        }
        for (Panel wp : this.wavePanels) {
            Analysis an2;
            Rectangle2D anBounds;
            if (!this.xAxisLocked) {
                if (!wp.isSelected()) continue;
                an = this.sd.findAnalysis(wp.getAnalysisType());
                Rectangle2D anBounds2 = an.getBounds();
                if (anBounds2 != null) {
                    xBounds = new Rectangle2D.Double(anBounds2.getMinX(), anBounds2.getMinY(), anBounds2.getWidth(), anBounds2.getHeight());
                }
                if (wp.getXAxisSignal() != null) {
                    Rectangle2D sigBounds = wp.getXAxisSignal().getBounds();
                    xBounds = new Rectangle2D.Double(sigBounds.getMinY(), sigBounds.getMinX(), sigBounds.getHeight(), sigBounds.getWidth());
                }
            }
            RectangularShape yBounds = null;
            for (WaveSignal ws : wp.getSignals()) {
                Rectangle2D sigBounds = ws.getSignal().getBounds();
                if (yBounds == null) {
                    yBounds = new Rectangle2D.Double(sigBounds.getMinX(), sigBounds.getMinY(), sigBounds.getWidth(), sigBounds.getHeight());
                    continue;
                }
                Rectangle2D.union((Rectangle2D)yBounds, sigBounds, (Rectangle2D)yBounds);
            }
            if (yBounds == null && (anBounds = (an2 = this.sd.findAnalysis(wp.getAnalysisType())).getBounds()) != null) {
                yBounds = new Rectangle2D.Double(anBounds.getMinX(), anBounds.getMinY(), anBounds.getWidth(), anBounds.getHeight());
            }
            boolean repaint = false;
            if (xBounds != null && (wp.getMinXAxis() != xBounds.getMinX() || wp.getMaxXAxis() != xBounds.getMaxX())) {
                wp.setXAxisRange(xBounds.getMinX(), xBounds.getMaxX());
                repaint = true;
            }
            if (yBounds != null) {
                double lowValue = yBounds.getMinY();
                double highValue = yBounds.getMaxY();
                double valueRange = (highValue - lowValue) / 8.0;
                if (valueRange == 0.0) {
                    valueRange = 0.5;
                }
                if (wp.getYAxisLowValue() != (lowValue -= valueRange) || wp.getYAxisHighValue() != (highValue += valueRange)) {
                    wp.setYAxisRange(lowValue, highValue);
                    repaint = true;
                }
            }
            if (!repaint) continue;
            wp.repaintWithRulers();
        }
    }

    @Override
    public void zoomOutContents() {
        for (Panel wp : this.wavePanels) {
            if (!this.xAxisLocked && !wp.isSelected()) continue;
            boolean timeInXAxis = true;
            if (this.xAxisLocked) {
                if (this.xAxisSignalAll != null) {
                    timeInXAxis = false;
                }
            } else if (wp.getXAxisSignal() != null) {
                timeInXAxis = false;
            }
            double range = wp.getMaxXAxis() - wp.getMinXAxis();
            wp.setXAxisRange(wp.getMinXAxis() - range / 2.0, wp.getMaxXAxis() + range / 2.0);
            if (wp.getMinXAxis() < 0.0 && timeInXAxis) {
                wp.setXAxisRange(0.0, wp.getMaxXAxis() - wp.getMinXAxis());
            }
            wp.repaintWithRulers();
        }
    }

    @Override
    public void zoomInContents() {
        for (Panel wp : this.wavePanels) {
            if (!this.xAxisLocked && !wp.isSelected()) continue;
            double range = wp.getMaxXAxis() - wp.getMinXAxis();
            wp.setXAxisRange(wp.getMinXAxis() + range / 4.0, wp.getMaxXAxis() - range / 4.0);
            wp.repaintWithRulers();
        }
    }

    @Override
    public void focusOnHighlighted() {
        double minXPosition;
        double maxXPosition;
        double size;
        if (this.mainXPosition == this.extXPosition) {
            return;
        }
        if (this.mainXPosition > this.extXPosition) {
            size = (this.mainXPosition - this.extXPosition) / 20.0;
            maxXPosition = this.mainXPosition + size;
            minXPosition = this.extXPosition - size;
        } else {
            size = (this.extXPosition - this.mainXPosition) / 20.0;
            maxXPosition = this.extXPosition + size;
            minXPosition = this.mainXPosition - size;
        }
        for (Panel wp : this.wavePanels) {
            if (!this.xAxisLocked && !wp.isSelected() || wp.getMinXAxis() == minXPosition && wp.getMaxXAxis() == maxXPosition) continue;
            wp.setXAxisRange(minXPosition, maxXPosition);
            wp.repaintWithRulers();
        }
    }

    public boolean isWaveWindowLogarithmic() {
        return this.mainHorizRulerPanelLogarithmic;
    }

    public void setWaveWindowLogarithmic(boolean logarithmic) {
        this.mainHorizRulerPanelLogarithmic = logarithmic;
        this.mainHorizRulerPanel.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    static {
        waveformDropTarget = new WaveFormDropTarget();
        iconAddPanel = Resources.getResource(WaveformWindow.class, "ButtonSimAddPanel.gif");
        iconLockXAxes = Resources.getResource(WaveformWindow.class, "ButtonSimLockTime.gif");
        iconUnLockXAxes = Resources.getResource(WaveformWindow.class, "ButtonSimUnLockTime.gif");
        iconRefresh = Resources.getResource(WaveformWindow.class, "ButtonSimRefresh.gif");
        iconLineOnPointOn = Resources.getResource(WaveformWindow.class, "ButtonSimLineOnPointOn.gif");
        iconLineOnPointOff = Resources.getResource(WaveformWindow.class, "ButtonSimLineOnPointOff.gif");
        iconLineOffPointOn = Resources.getResource(WaveformWindow.class, "ButtonSimLineOffPointOn.gif");
        iconToggleGrid = Resources.getResource(WaveformWindow.class, "ButtonSimGrid.gif");
        iconGrowPanel = Resources.getResource(WaveformWindow.class, "ButtonSimGrow.gif");
        iconShrinkPanel = Resources.getResource(WaveformWindow.class, "ButtonSimShrink.gif");
        iconVCRRewind = Resources.getResource(WaveformWindow.class, "ButtonVCRRewind.gif");
        iconVCRPlayBackward = Resources.getResource(WaveformWindow.class, "ButtonVCRPlayBackward.gif");
        iconVCRStop = Resources.getResource(WaveformWindow.class, "ButtonVCRStop.gif");
        iconVCRPlay = Resources.getResource(WaveformWindow.class, "ButtonVCRPlay.gif");
        iconVCRToEnd = Resources.getResource(WaveformWindow.class, "ButtonVCRToEnd.gif");
        iconVCRFaster = Resources.getResource(WaveformWindow.class, "ButtonVCRFaster.gif");
        iconVCRSlower = Resources.getResource(WaveformWindow.class, "ButtonVCRSlower.gif");
        resizeRowCursor = Cursor.getPredefinedCursor(8);
        resizeColumnCursor = Cursor.getPredefinedCursor(11);
        savedSignalOrder = new HashMap();
    }

    private static class WaveComponentListener
    implements ComponentListener {
        private JPanel panel;

        public WaveComponentListener(JPanel panel) {
            this.panel = panel;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.panel.repaint();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private static class WaveformWindowHighlightListener
    implements HighlightListener {
        private WaveformWindowHighlightListener() {
        }

        @Override
        public void highlightChanged(Highlighter which) {
            if (freezeWaveformHighlighting) {
                return;
            }
            WindowFrame highWF = which.getWindowFrame();
            if (highWF == null) {
                return;
            }
            if (!(highWF.getContent() instanceof EditWindow)) {
                return;
            }
            EditWindow wnd = (EditWindow)highWF.getContent();
            if (which == wnd.getHighlighter()) {
                Iterator<WindowFrame> wIt = WindowFrame.getWindows();
                while (wIt.hasNext()) {
                    WindowFrame wf = wIt.next();
                    if (!(wf.getContent() instanceof WaveformWindow)) continue;
                    WaveformWindow ww = (WaveformWindow)wf.getContent();
                    ww.crossProbeEditWindowToWaveform(wnd, which);
                }
            }
        }

        @Override
        public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        }
    }

    public static class Locator {
        private WaveformWindow ww;
        private VarContext context;

        public Locator(EditWindow wnd) {
            Cell cellInWindow = wnd.getCell();
            VarContext curContext = wnd.getVarContext();
            this.ww = null;
            Stack<Nodable> contextStack = new Stack<Nodable>();
            while (true) {
                Nodable no;
                this.ww = WaveformWindow.findWaveformWindow(cellInWindow);
                if (this.ww != null || (no = curContext.getNodable()) == null) break;
                contextStack.push(no);
                cellInWindow = no.getParent();
                curContext = curContext.pop();
            }
            this.context = VarContext.globalContext;
            while (!contextStack.isEmpty()) {
                this.context = this.context.push((Nodable)contextStack.pop());
            }
        }

        public Locator(EditWindow wnd, WaveformWindow wantWW) {
            Cell cellInWindow = wnd.getCell();
            VarContext curContext = wnd.getVarContext();
            this.ww = null;
            Stack<Nodable> contextStack = new Stack<Nodable>();
            while (true) {
                if (wantWW.getCell() == cellInWindow) {
                    this.ww = wantWW;
                    break;
                }
                Nodable no = curContext.getNodable();
                if (no == null) break;
                contextStack.push(no);
                cellInWindow = no.getParent();
                curContext = curContext.pop();
            }
            this.context = VarContext.globalContext;
            while (!contextStack.isEmpty()) {
                this.context = this.context.push((Nodable)contextStack.pop());
            }
        }

        public WaveformWindow getWaveformWindow() {
            return this.ww;
        }

        public VarContext getContext() {
            return this.context;
        }
    }

    private static class WaveFormDropTarget
    implements DropTargetListener {
        private WaveFormDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Panel panel;
            Object data = null;
            try {
                dtde.acceptDrop(0x40000000);
                data = dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (data == null) {
                    dtde.dropComplete(false);
                    return;
                }
            }
            catch (Throwable t) {
                ActivityLogger.logException(t);
                dtde.dropComplete(false);
                return;
            }
            if (!(data instanceof String)) {
                dtde.dropComplete(false);
                return;
            }
            String sigNameData = (String)data;
            String[] sigNames = sigNameData.split("\n");
            Analysis.AnalysisType analysisType = null;
            for (int i = 0; i < sigNames.length; ++i) {
                Analysis.AnalysisType anAnalysisType = Analysis.ANALYSIS_SIGNALS;
                String aSigName = sigNames[i];
                if (aSigName.startsWith("TRANS ")) {
                    sigNames[i] = aSigName.substring(6);
                    anAnalysisType = Analysis.ANALYSIS_TRANS;
                } else if (aSigName.startsWith("MEASUREMENT ")) {
                    sigNames[i] = aSigName.substring(12);
                    anAnalysisType = Analysis.ANALYSIS_MEAS;
                } else if (aSigName.startsWith("AC ")) {
                    sigNames[i] = aSigName.substring(3);
                    anAnalysisType = Analysis.ANALYSIS_AC;
                } else if (aSigName.startsWith("DC ")) {
                    sigNames[i] = aSigName.substring(3);
                    anAnalysisType = Analysis.ANALYSIS_DC;
                }
                if (analysisType == null) {
                    analysisType = anAnalysisType;
                    continue;
                }
                if (analysisType == anAnalysisType) continue;
                Job.getUserInterface().showErrorMessage("All signals must be the same type", "Incorrect Signal Selection");
                dtde.dropComplete(false);
                return;
            }
            if (analysisType == null) {
                dtde.dropComplete(false);
                return;
            }
            DropTarget dt = (DropTarget)dtde.getSource();
            if (dt.getComponent() instanceof HorizRuler) {
                if (sigNames.length != 1) {
                    Job.getUserInterface().showErrorMessage("Only one signal can be dragged to a ruler", "Too Much Selected");
                    dtde.dropComplete(false);
                    return;
                }
                HorizRuler hr = (HorizRuler)dt.getComponent();
                panel = hr.getPanel();
                WaveformWindow ww = hr.getWaveformWindow();
                Signal sSig = null;
                if (sigNames[0].startsWith("PANEL ")) {
                    int sigPos = Math.max(sigNames[0].indexOf("MOVEBUTTON "), sigNames[0].indexOf("COPYBUTTON "));
                    if (sigPos >= 0) {
                        int panelNumber = TextUtils.atoi(sigNames[0].substring(6));
                        Panel sourcePanel = ww.getPanelFromNumber(panelNumber);
                        analysisType = sourcePanel.getAnalysisType();
                        String signalName = sigNames[0].substring(sigPos + 11);
                        for (WaveSignal ws : sourcePanel.getSignals()) {
                            if (!ws.getSignal().getFullName().equals(signalName)) continue;
                            sSig = ws.getSignal();
                            break;
                        }
                    }
                } else {
                    Analysis an = ww.getSimData().findAnalysis(analysisType);
                    if (an == null) {
                        System.out.println("Cannot find " + analysisType + " data");
                        dtde.dropComplete(true);
                        return;
                    }
                    sSig = ww.findSignal(sigNames[0], an);
                }
                if (sSig != null) {
                    Rectangle2D bounds = sSig.getBounds();
                    if (panel == null) {
                        boolean warn = false;
                        for (Panel wp : ww.wavePanels) {
                            if (wp.getAnalysisType() == analysisType || wp.getNumSignals() <= 0) continue;
                            warn = true;
                        }
                        if (warn) {
                            String warning = "The waveform window is not showing " + analysisType + " data.  Remove all traces and convert panels to show " + analysisType + " data?";
                            int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), warning);
                            if (response != 0) {
                                dtde.dropComplete(true);
                                return;
                            }
                            for (Panel wp : ww.wavePanels) {
                                ww.deleteAllSignalsFromPanel(wp);
                            }
                        }
                        ww.xAxisSignalAll = sSig;
                        for (Panel wp : ww.wavePanels) {
                            wp.setAnalysisType(analysisType);
                            wp.setXAxisRange(bounds.getMinY(), bounds.getMaxY());
                        }
                        ww.redrawAllPanels();
                    } else {
                        if (panel.getAnalysisType() != analysisType) {
                            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot drop a " + analysisType + " signal onto the horizontal ruler of a " + panel.getAnalysisType() + " panel.  " + "First convert the panel with the popup in the upper-left.", "Error Displaying Signals", 0);
                            dtde.dropComplete(true);
                            return;
                        }
                        panel.setXAxisSignal(sSig);
                        panel.setXAxisRange(bounds.getMinY(), bounds.getMaxY());
                        panel.repaintContents();
                    }
                    hr.repaint();
                    ww.saveSignalOrder();
                }
                dtde.dropComplete(false);
                return;
            }
            WaveformWindow ww = null;
            panel = null;
            if (dt.getComponent() instanceof Panel) {
                panel = (Panel)dt.getComponent();
                ww = panel.getWaveWindow();
            }
            if (dt.getComponent() instanceof OnePanel) {
                OnePanel op = (OnePanel)dt.getComponent();
                ww = op.getWaveformWindow();
                panel = op.getPanel();
            }
            if (dt.getComponent() instanceof WaveTable) {
                WaveTable table = (WaveTable)dt.getComponent();
                ww = table.ww;
                int column = table.columnAtPoint(dtde.getLocation());
                int row = table.rowAtPoint(dtde.getLocation());
                if (column != -1 && row != -1) {
                    OnePanel op = (OnePanel)ww.tableModel.getValueAt(row, column);
                    panel = op.getPanel();
                }
            }
            if (panel == null) {
                dtde.dropComplete(false);
                return;
            }
            if (sigNames[0].startsWith("PANEL ")) {
                int panelNumber = TextUtils.atoi(sigNames[0].substring(6));
                Panel sourcePanel = ww.getPanelFromNumber(panelNumber);
                if (sourcePanel == panel) {
                    dtde.dropComplete(false);
                    return;
                }
                int sigMovePos = sigNames[0].indexOf("MOVEBUTTON ");
                int sigCopyPos = sigNames[0].indexOf("COPYBUTTON ");
                if (!panel.isAnalog()) {
                    sigCopyPos = -1;
                    sigMovePos = -1;
                }
                if (sigMovePos < 0 && sigCopyPos < 0) {
                    ww.stopEditing();
                    ww.wavePanels.remove(sourcePanel);
                    int destIndex = ww.wavePanels.indexOf(panel);
                    if (dtde.getLocation().y > panel.getBounds().height / 2) {
                        ++destIndex;
                    }
                    ww.wavePanels.add(destIndex, sourcePanel);
                    ww.reloadTable();
                    ww.table.repaint();
                    ww.getPanel().validate();
                    dtde.dropComplete(true);
                    ww.saveSignalOrder();
                    return;
                }
                int sigPos = Math.max(sigMovePos, sigCopyPos);
                String signalName = sigNames[0].substring(sigPos + 11);
                Signal sSig = null;
                Color oldColor = null;
                for (WaveSignal ws : sourcePanel.getSignals()) {
                    if (!ws.getSignal().getFullName().equals(signalName)) continue;
                    sSig = ws.getSignal();
                    if (sSig.getAnalysis().getAnalysisType() != panel.getAnalysisType()) {
                        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot drop a " + sSig.getAnalysis().getAnalysisType() + " signal onto a " + panel.getAnalysisType() + " panel.  " + "First convert the panel with the popup in the upper-left.", "Error Displaying Signals", 0);
                        dtde.dropComplete(true);
                        return;
                    }
                    oldColor = ws.getColor();
                    if (sigCopyPos >= 0) break;
                    sourcePanel.removeHighlightedSignal(ws, true);
                    sourcePanel.removeSignal(ws.getButton());
                    break;
                }
                if (sSig != null) {
                    sourcePanel.getSignalButtons().validate();
                    sourcePanel.getSignalButtons().repaint();
                    sourcePanel.repaintContents();
                    WaveSignal.addSignalToPanel(sSig, panel, oldColor);
                }
                ww.saveSignalOrder();
                dtde.dropComplete(true);
                return;
            }
            Analysis an = ww.getSimData().findAnalysis(analysisType);
            for (int i = 0; i < sigNames.length; ++i) {
                Signal sSig = ww.findSignal(sigNames[i], an);
                if (sSig == null) {
                    dtde.dropComplete(false);
                    return;
                }
                if (sSig instanceof DigitalSignal) {
                    panel = null;
                }
                if (panel != null) {
                    AnalogSignal as = (AnalogSignal)sSig;
                    if (as.getAnalysis().getAnalysisType() != panel.getAnalysisType()) {
                        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot drop a " + as.getAnalysis().getAnalysisType() + " signal onto a " + panel.getAnalysisType() + " panel.  " + "First convert the panel with the popup in the upper-left.", "Error Displaying Signals", 0);
                        dtde.dropComplete(true);
                        return;
                    }
                    WaveSignal.addSignalToPanel(sSig, panel, null);
                    panel.makeSelectedPanel();
                    continue;
                }
                panel = ww.makeNewPanel();
                panel.fitToSignal(sSig);
                new WaveSignal(panel, sSig);
            }
            ww.overall.validate();
            panel.repaintContents();
            panel.getWaveWindow().saveSignalOrder();
            dtde.dropComplete(true);
        }
    }

    public static class OnePanel
    extends JPanel {
        Panel panel;
        WaveformWindow ww;

        public OnePanel(Panel panel, WaveformWindow ww) {
            this.panel = panel;
            this.ww = ww;
        }

        public Panel getPanel() {
            return this.panel;
        }

        public WaveformWindow getWaveformWindow() {
            return this.ww;
        }
    }

    private static class CompSignals
    implements Comparator<Signal> {
        private CompSignals() {
        }

        @Override
        public int compare(Signal s1, Signal s2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(s1.getFullName(), s2.getFullName());
        }
    }

    private static class SignalsByName
    implements Comparator<Signal> {
        private SignalsByName() {
        }

        @Override
        public int compare(Signal s1, Signal s2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(s1.getFullName(), s2.getFullName());
        }
    }

    private class TableMouseListener
    implements MouseListener,
    MouseMotionListener {
        private int mouseXOffset;
        private int mouseYOffset;
        private int resizingRow;
        private TableColumn resizingColumn;
        private JTable table;

        public TableMouseListener(JTable table) {
            this.table = table;
            table.addMouseListener(this);
            table.addMouseMotionListener(this);
        }

        private TableColumn getResizingColumn(Point p) {
            int columnIndex;
            int column = this.table.columnAtPoint(p);
            if (column == -1) {
                return null;
            }
            int row = this.table.rowAtPoint(p);
            if (row == -1) {
                return null;
            }
            Rectangle r = this.table.getCellRect(row, column, true);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return null;
            }
            int midPoint = r.x + r.width / 2;
            int n = columnIndex = p.x < midPoint ? column - 1 : column;
            if (columnIndex == -1) {
                return null;
            }
            return this.table.getTableHeader().getColumnModel().getColumn(columnIndex);
        }

        private int getResizingRow(Point p) {
            int row = this.table.rowAtPoint(p);
            if (row == -1) {
                return -1;
            }
            int col = this.table.columnAtPoint(p);
            if (col == -1) {
                return -1;
            }
            Rectangle r = this.table.getCellRect(row, col, true);
            r.grow(0, -3);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.y + r.height / 2;
            int rowIndex = p.y < midPoint ? row - 1 : row;
            return rowIndex;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.forwardEventToPanel(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.table.getTableHeader().setResizingColumn(null);
            Point p = e.getPoint();
            this.resizingColumn = this.getResizingColumn(p);
            if (this.resizingColumn != null) {
                this.resizingRow = -1;
                this.table.getTableHeader().setResizingColumn(this.resizingColumn);
                this.mouseXOffset = p.x - this.resizingColumn.getWidth();
                return;
            }
            this.resizingRow = this.getResizingRow(p);
            if (this.resizingRow >= 0) {
                this.mouseYOffset = p.y - this.table.getRowHeight(this.resizingRow);
                return;
            }
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.getResizingColumn(e.getPoint()) != null) {
                this.table.setCursor(resizeColumnCursor);
                return;
            }
            if (this.getResizingRow(e.getPoint()) >= 0) {
                this.table.setCursor(resizeRowCursor);
                return;
            }
            this.table.setCursor(null);
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int newHeight;
            if (this.resizingColumn != null) {
                this.resizingColumn.setWidth(e.getX() - this.mouseXOffset);
                if (WaveformWindow.this.mainHorizRulerPanel != null) {
                    WaveformWindow.this.mainHorizRulerPanel.repaint();
                }
                return;
            }
            if (this.resizingRow >= 0 && (newHeight = e.getY() - this.mouseYOffset) > 0) {
                this.table.setRowHeight(this.resizingRow, newHeight);
                return;
            }
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.resizingColumn != null) {
                this.table.getTableHeader().setResizingColumn(null);
                return;
            }
            this.forwardEventToPanel(e);
        }

        public void forwardEventToPanel(MouseEvent e) {
            Point p = e.getPoint();
            int row = this.table.rowAtPoint(p);
            int col = this.table.columnAtPoint(p);
            if (row < 0 || col < 0) {
                return;
            }
            JPanel panel = (JPanel)this.table.getValueAt(row, col);
            MouseEvent panelEvent = SwingUtilities.convertMouseEvent(this.table, e, panel);
            panel.dispatchEvent(panelEvent);
            this.table.repaint();
        }
    }

    static class WaveCellEditor
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private Component lastOne;

        public WaveCellEditor(JTable table, int column) {
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.getColumn(column).setCellRenderer(this);
            columnModel.getColumn(column).setCellEditor(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (Component)table.getValueAt(row, column);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.lastOne = (Component)table.getValueAt(row, column);
            return this.lastOne;
        }

        @Override
        public Object getCellEditorValue() {
            return this.lastOne;
        }
    }

    private class WaveTableModel
    extends DefaultTableModel {
        private WaveTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            int numVisPanels = 0;
            for (Panel wp : WaveformWindow.this.wavePanels) {
                if (wp.isHidden()) continue;
                ++numVisPanels;
            }
            return numVisPanels;
        }

        @Override
        public Object getValueAt(int row, int col) {
            int rowNo = 0;
            for (Panel panel : WaveformWindow.this.wavePanels) {
                if (panel.isHidden()) continue;
                if (rowNo == row) {
                    if (col == 0) {
                        return panel.getLeftHalf();
                    }
                    return panel.getRightHalf();
                }
                ++rowNo;
            }
            return null;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return JPanel.class;
        }
    }

    private class WaveTable
    extends JTable {
        private WaveformWindow ww;

        WaveTable(TableModel model, WaveformWindow ww) {
            super(model);
            this.ww = ww;
        }
    }
}

