/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.CellId;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LibToTech {
    private static final int TOEDGELEFT = 1;
    private static final int TOEDGERIGHT = 2;
    private static final int TOEDGETOP = 4;
    private static final int TOEDGEBOT = 8;
    private static final int FROMCENTX = 16;
    private static final int FROMCENTY = 32;
    private static final int RATIOCENTX = 64;
    private static final int RATIOCENTY = 128;

    public static void makeTechFromLib() {
        GenerateTechnology dialog = new GenerateTechnology();
        dialog.initComponents();
        dialog.setVisible(true);
    }

    public static Technology makeTech(String newName, String fileName) {
        Library lib = Library.getCurrent();
        String newTechName = newName;
        boolean modified = false;
        while (Technology.findTechnology(newTechName) != null) {
            newTechName = newTechName + "X";
            modified = true;
        }
        if (modified) {
            System.out.println("Warning: already a technology called " + newName + ".  Naming this " + newTechName);
        }
        Library[] dependentLibs = Info.getDependentLibraries(lib);
        Cell np = null;
        for (int i = dependentLibs.length - 1; i >= 0 && (np = dependentLibs[i].findNodeProto("factors")) == null; --i) {
        }
        if (np == null) {
            System.out.println("Cell with general information, called 'factors', is missing");
            return null;
        }
        GeneralInfo gi = GeneralInfo.parseCell(np);
        LayerInfo[] lList = LibToTech.extractLayers(dependentLibs);
        if (lList == null) {
            return null;
        }
        ArcInfo[] aList = LibToTech.extractArcs(dependentLibs, lList);
        if (aList == null) {
            return null;
        }
        NodeInfo[] nList = LibToTech.extractNodes(dependentLibs, lList, aList);
        if (nList == null) {
            return null;
        }
        for (NodeInfo ni : nList) {
            ni.arcsShrink = ni.func == PrimitiveNode.Function.PIN && !ni.wipes;
        }
        block3: for (int i = 0; i < lList.length; ++i) {
            if (lList[i].pseudo) continue;
            for (int j = 0; j < nList.length; ++j) {
                if (nList[j].func != PrimitiveNode.Function.NODE) continue;
                NodeInfo.LayerDetails nld = nList[j].nodeLayers[0];
                if (nld.layer != lList[i]) continue;
                lList[i].pureLayerNode = nList[j];
                continue block3;
            }
        }
        Xml.Technology t = LibToTech.makeXml(newTechName, gi, lList, nList, aList);
        if (fileName != null) {
            t.writeXml(fileName);
        }
        Technology tech = new Technology(t);
        tech.setup();
        System.out.println("Technology " + tech.getTechName() + " built.");
        WindowFrame.updateTechnologyLists();
        return tech;
    }

    private static void checkAndWarn(LayerInfo[] lList, ArcInfo[] aList, NodeInfo[] nList) {
        NodeInfo nIn;
        int j;
        boolean found;
        int i;
        for (i = 0; i < lList.length; ++i) {
            if (lList[i].pseudo) continue;
            found = false;
            for (j = 0; j < nList.length; ++j) {
                nIn = nList[j];
                if (nIn.func != PrimitiveNode.Function.NODE || nIn.nodeLayers[0].layer != lList[i]) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("Warning: Layer " + lList[i].name + " has no associated pure-layer node");
        }
        for (i = 0; i < aList.length; ++i) {
            found = false;
            for (j = 0; j < nList.length; ++j) {
                nIn = nList[j];
                if (nIn.func != PrimitiveNode.Function.PIN) continue;
                for (int k = 0; k < nIn.nodePortDetails.length; ++k) {
                    ArcInfo[] connections = nIn.nodePortDetails[k].connections;
                    for (int l = 0; l < connections.length; ++l) {
                        if (connections[l] != aList[i]) continue;
                        boolean allPseudo = true;
                        for (int m = 0; m < nIn.nodeLayers.length; ++m) {
                            LayerInfo lin = nIn.nodeLayers[m].layer;
                            if (lin.pseudo) continue;
                            allPseudo = false;
                            break;
                        }
                        if (!allPseudo) {
                            System.out.println("Warning: Pin " + nIn.name + " is not composed of pseudo-layers");
                        }
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (found) break;
            }
            if (found) continue;
            System.out.println("Warning: Arc " + aList[i].name + " has no associated pin node");
        }
    }

    private static LayerInfo[] extractLayers(Library[] dependentLibs) {
        Cell[] layerCells = Info.findCellSequence(dependentLibs, "layer-", Info.LAYERSEQUENCE_KEY);
        if (layerCells.length <= 0) {
            System.out.println("No layers found");
            return null;
        }
        LayerInfo[] lis = new LayerInfo[layerCells.length];
        for (int i = 0; i < layerCells.length; ++i) {
            lis[i] = LayerInfo.parseCell(layerCells[i]);
            if (lis[i] != null) continue;
            System.out.println("Error parsing description for " + layerCells[i].describe(false));
        }
        return lis;
    }

    private static ArcInfo[] extractArcs(Library[] dependentLibs, LayerInfo[] lList) {
        Cell[] arcCells = Info.findCellSequence(dependentLibs, "arc-", Info.ARCSEQUENCE_KEY);
        if (arcCells.length <= 0) {
            System.out.println("No arcs found");
            return null;
        }
        ArcInfo[] allArcs = new ArcInfo[arcCells.length];
        for (int i = 0; i < arcCells.length; ++i) {
            Cell np = arcCells[i];
            allArcs[i] = ArcInfo.parseCell(np);
            Example neList = Example.getExamples(np, false);
            if (neList == null) {
                return null;
            }
            if (neList.nextExample != null) {
                LibToTech.pointOutError(null, np);
                System.out.println("Can only be one example of " + np + " but more were found");
                return null;
            }
            double maxWid = -1.0;
            double hWid = -1.0;
            int count = 0;
            for (Sample ns : neList.samples) {
                double wid = Math.min(ns.node.getXSize(), ns.node.getYSize());
                if (wid > maxWid) {
                    maxWid = wid;
                }
                if (ns.layer == null) {
                    hWid = wid;
                    continue;
                }
                ++count;
            }
            allArcs[i].widthOffset = maxWid - hWid;
            allArcs[i].maxWidth = maxWid;
            if (hWid < 0.0) {
                LibToTech.pointOutError(null, np);
                System.out.println("No highlight layer found in " + np);
                return null;
            }
            allArcs[i].arcDetails = new ArcInfo.LayerDetails[count];
            int layerIndex = 0;
            for (int k = 0; k < 2; ++k) {
                for (Sample ns : neList.samples) {
                    if (ns.layer == null) continue;
                    String sampleLayer = ns.layer.getName().substring(6);
                    LayerInfo li = null;
                    for (int j = 0; j < lList.length; ++j) {
                        if (!sampleLayer.equals(lList[j].name)) continue;
                        li = lList[j];
                        break;
                    }
                    if (li == null) {
                        System.out.println("Cannot find layer " + sampleLayer + ", used in " + np);
                        return null;
                    }
                    if (k == 0 ? li.desc.getTransparentLayer() == 0 : li.desc.getTransparentLayer() != 0) continue;
                    allArcs[i].arcDetails[layerIndex] = new ArcInfo.LayerDetails();
                    allArcs[i].arcDetails[layerIndex].layer = li;
                    Poly.Type style = Poly.Type.CLOSED;
                    if (ns.node.getProto() == Artwork.tech.filledBoxNode) {
                        style = Poly.Type.FILLED;
                    }
                    allArcs[i].arcDetails[layerIndex].style = style;
                    double wid = Math.min(ns.node.getXSize(), ns.node.getYSize());
                    allArcs[i].arcDetails[layerIndex].width = maxWid - wid;
                    ++layerIndex;
                }
            }
        }
        return allArcs;
    }

    private static NodeInfo[] extractNodes(Library[] dependentLibs, LayerInfo[] lList, ArcInfo[] aList) {
        Cell[] nodeCells = Info.findCellSequence(dependentLibs, "node-", Info.NODESEQUENCE_KEY);
        if (nodeCells.length <= 0) {
            System.out.println("No nodes found");
            return null;
        }
        NodeInfo[] nList = new NodeInfo[nodeCells.length];
        int nodeIndex = 0;
        for (int pass = 0; pass < 3; ++pass) {
            for (int m = 0; m < nodeCells.length; ++m) {
                Cell np = nodeCells[m];
                NodeInfo nIn = NodeInfo.parseCell(np);
                Netlist netList = np.acquireUserNetlist();
                if (netList == null) {
                    System.out.println("Sorry, a deadlock technology generation (network information unavailable).  Please try again");
                    return null;
                }
                if (pass == 0 && nIn.func != PrimitiveNode.Function.PIN || pass == 1 && (nIn.func == PrimitiveNode.Function.PIN || nIn.func == PrimitiveNode.Function.NODE) || pass == 2 && nIn.func != PrimitiveNode.Function.NODE) continue;
                if (nIn.func == PrimitiveNode.Function.NODE) {
                    if (nIn.serp) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Pure layer " + nIn.name + " can not be serpentine");
                        return null;
                    }
                    nIn.specialType = 2;
                }
                nList[nodeIndex] = nIn;
                nIn.name = np.getName().substring(5);
                Example neList = Example.getExamples(np, true);
                if (neList == null) {
                    System.out.println("Cannot analyze " + np);
                    return null;
                }
                nIn.xSize = neList.hx - neList.lx;
                nIn.ySize = neList.hy - neList.ly;
                if (LibToTech.associateExamples(neList, np)) {
                    System.out.println("Cannot match different examples in " + np);
                    return null;
                }
                nIn.nodeLayers = LibToTech.makePrimitiveNodeLayers(neList, np, lList);
                if (nIn.nodeLayers == null) {
                    System.out.println("Cannot derive stretching rules for " + np);
                    return null;
                }
                int portCount = 0;
                for (Sample ns : neList.samples) {
                    if (ns.layer != Generic.tech.portNode) continue;
                    ++portCount;
                }
                if (portCount == 0) {
                    LibToTech.pointOutError(null, np);
                    System.out.println("No ports found in " + np);
                    return null;
                }
                nIn.nodePortDetails = new NodeInfo.PortDetails[portCount];
                int pol1Port = -1;
                int pol2Port = -1;
                int dif1Port = -1;
                int dif2Port = -1;
                int i = 0;
                for (Sample ns : neList.samples) {
                    if (ns.layer != Generic.tech.portNode) continue;
                    nIn.nodePortDetails[i] = new NodeInfo.PortDetails();
                    nIn.nodePortDetails[i].connections = new ArcInfo[0];
                    Variable var = ns.node.getVar(Info.CONNECTION_KEY);
                    if (var != null) {
                        CellId[] arcCells = (CellId[])var.getObject();
                        ArcInfo[] connections = new ArcInfo[arcCells.length];
                        nIn.nodePortDetails[i].connections = connections;
                        boolean portChecked = false;
                        for (int j = 0; j < arcCells.length; ++j) {
                            Cell arcCell = EDatabase.serverDatabase().getCell(arcCells[j]);
                            connections[j] = null;
                            if (arcCell != null) {
                                String cellName = arcCell.getName().substring(4);
                                for (int k = 0; k < aList.length; ++k) {
                                    if (!aList[k].name.equalsIgnoreCase(cellName)) continue;
                                    connections[j] = aList[k];
                                    break;
                                }
                            }
                            if (connections[j] == null) {
                                LibToTech.pointOutError(ns.node, ns.node.getParent());
                                System.out.println("Invalid connection list on port in " + np);
                                return null;
                            }
                            if (portChecked) continue;
                            if (connections[j].func.isPoly()) {
                                if (pol1Port < 0) {
                                    pol1Port = i;
                                    portChecked = true;
                                    continue;
                                }
                                if (pol2Port >= 0) continue;
                                pol2Port = i;
                                portChecked = true;
                                continue;
                            }
                            if (!connections[j].func.isDiffusion()) continue;
                            if (dif1Port < 0) {
                                dif1Port = i;
                                portChecked = true;
                                continue;
                            }
                            if (dif2Port >= 0) continue;
                            dif2Port = i;
                            portChecked = true;
                        }
                    }
                    if (nIn.nodePortDetails[i].connections == null) {
                        return null;
                    }
                    String portName = Info.getPortName(ns.node);
                    if (portName == null) {
                        LibToTech.pointOutError(ns.node, np);
                        System.out.println("Cell " + np.describe(true) + ": port does not have a name");
                        return null;
                    }
                    for (int c = 0; c < portName.length(); ++c) {
                        char str = portName.charAt(c);
                        if (str > ' ' && str < '\u007f') continue;
                        LibToTech.pointOutError(ns.node, np);
                        System.out.println("Invalid port name '" + portName + "' in " + np);
                        return null;
                    }
                    nIn.nodePortDetails[i].name = portName;
                    nIn.nodePortDetails[i].angle = 0;
                    Variable varAngle = ns.node.getVar(Info.PORTANGLE_KEY);
                    if (varAngle != null) {
                        nIn.nodePortDetails[i].angle = (Integer)varAngle.getObject();
                    }
                    nIn.nodePortDetails[i].range = 180;
                    Variable varRange = ns.node.getVar(Info.PORTRANGE_KEY);
                    if (varRange != null) {
                        nIn.nodePortDetails[i].range = (Integer)varRange.getObject();
                    }
                    nIn.nodePortDetails[i].netIndex = i;
                    if (ns.node.hasConnections()) {
                        ArcInst ai1 = ns.node.getConnections().next().getArc();
                        Network net1 = netList.getNetwork(ai1, 0);
                        int j = 0;
                        for (Sample oNs : neList.samples) {
                            ArcInst ai2;
                            Network net2;
                            if (oNs == ns) break;
                            if (oNs.layer != Generic.tech.portNode) continue;
                            if (oNs.node.hasConnections() && net1 == (net2 = netList.getNetwork(ai2 = oNs.node.getConnections().next().getArc(), 0))) {
                                nIn.nodePortDetails[i].netIndex = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    nIn.nodePortDetails[i].values = ns.values;
                    ++i;
                }
                if (nIn.func == PrimitiveNode.Function.TRANMOS || nIn.func == PrimitiveNode.Function.TRADMOS || nIn.func == PrimitiveNode.Function.TRAPMOS || nIn.func == PrimitiveNode.Function.TRADMES || nIn.func == PrimitiveNode.Function.TRAEMES) {
                    NodeInfo.PortDetails formerPortB;
                    NodeInfo.PortDetails formerPortA;
                    if (pol1Port < 0 || pol2Port < 0 || dif1Port < 0 || dif2Port < 0) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Need 2 gate and 2 active ports on field-effect transistor " + np.describe(true));
                        return null;
                    }
                    if (pol1Port != 0) {
                        if (pol2Port == 0) {
                            formerPortA = nIn.nodePortDetails[pol1Port];
                            formerPortB = nIn.nodePortDetails[pol2Port];
                            int swap = pol1Port;
                            pol1Port = pol2Port;
                            pol2Port = swap;
                            nIn.nodePortDetails[pol1Port] = formerPortA;
                            nIn.nodePortDetails[pol2Port] = formerPortB;
                        } else if (dif1Port == 0) {
                            formerPortA = nIn.nodePortDetails[pol1Port];
                            formerPortB = nIn.nodePortDetails[dif1Port];
                            int swap = pol1Port;
                            pol1Port = dif1Port;
                            dif1Port = swap;
                            nIn.nodePortDetails[pol1Port] = formerPortA;
                            nIn.nodePortDetails[dif1Port] = formerPortB;
                        } else if (dif2Port == 0) {
                            formerPortA = nIn.nodePortDetails[pol1Port];
                            formerPortB = nIn.nodePortDetails[dif2Port];
                            int swap = pol1Port;
                            pol1Port = dif2Port;
                            dif2Port = swap;
                            nIn.nodePortDetails[pol1Port] = formerPortA;
                            nIn.nodePortDetails[dif2Port] = formerPortB;
                        }
                    }
                    if (pol2Port != 2) {
                        if (dif1Port == 2) {
                            formerPortA = nIn.nodePortDetails[pol2Port];
                            formerPortB = nIn.nodePortDetails[dif1Port];
                            int swap = pol2Port;
                            pol2Port = dif1Port;
                            dif1Port = swap;
                            nIn.nodePortDetails[pol2Port] = formerPortA;
                            nIn.nodePortDetails[dif1Port] = formerPortB;
                        } else if (dif2Port == 2) {
                            formerPortA = nIn.nodePortDetails[pol2Port];
                            formerPortB = nIn.nodePortDetails[dif2Port];
                            int swap = pol2Port;
                            pol2Port = dif2Port;
                            dif2Port = swap;
                            nIn.nodePortDetails[pol2Port] = formerPortA;
                            nIn.nodePortDetails[dif2Port] = formerPortB;
                        }
                    }
                    if (dif1Port != 1) {
                        formerPortA = nIn.nodePortDetails[dif1Port];
                        formerPortB = nIn.nodePortDetails[dif2Port];
                        int swap = dif1Port;
                        dif1Port = dif2Port;
                        dif2Port = swap;
                        nIn.nodePortDetails[dif1Port] = formerPortA;
                        nIn.nodePortDetails[dif2Port] = formerPortB;
                    }
                    double x1Pos = (nIn.nodePortDetails[dif1Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() + nIn.nodePortDetails[dif1Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif1Port].values[1].getX().getAdder()) / 2.0;
                    double x2Pos = (nIn.nodePortDetails[dif2Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif2Port].values[0].getX().getAdder() + nIn.nodePortDetails[dif2Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif2Port].values[1].getX().getAdder()) / 2.0;
                    double y1Pos = (nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() + nIn.nodePortDetails[dif1Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif1Port].values[1].getY().getAdder()) / 2.0;
                    double y2Pos = (nIn.nodePortDetails[dif2Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif2Port].values[0].getY().getAdder() + nIn.nodePortDetails[dif2Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif2Port].values[1].getY().getAdder()) / 2.0;
                    if (Math.abs(x1Pos - x2Pos) > Math.abs(y1Pos - y2Pos)) {
                        if (x1Pos < x2Pos) {
                            NodeInfo.PortDetails formerPortA2 = nIn.nodePortDetails[dif1Port];
                            NodeInfo.PortDetails formerPortB2 = nIn.nodePortDetails[dif2Port];
                            nIn.nodePortDetails[dif1Port] = formerPortA2;
                            nIn.nodePortDetails[dif2Port] = formerPortB2;
                        }
                    } else if (y1Pos < y2Pos) {
                        NodeInfo.PortDetails formerPortA3 = nIn.nodePortDetails[dif1Port];
                        NodeInfo.PortDetails formerPortB3 = nIn.nodePortDetails[dif2Port];
                        nIn.nodePortDetails[dif1Port] = formerPortA3;
                        nIn.nodePortDetails[dif2Port] = formerPortB3;
                    }
                    x1Pos = (nIn.nodePortDetails[pol1Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol1Port].values[0].getX().getAdder() + nIn.nodePortDetails[pol1Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol1Port].values[1].getX().getAdder()) / 2.0;
                    x2Pos = (nIn.nodePortDetails[pol2Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol2Port].values[0].getX().getAdder() + nIn.nodePortDetails[pol2Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol2Port].values[1].getX().getAdder()) / 2.0;
                    y1Pos = (nIn.nodePortDetails[pol1Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol1Port].values[0].getY().getAdder() + nIn.nodePortDetails[pol1Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol1Port].values[1].getY().getAdder()) / 2.0;
                    y2Pos = (nIn.nodePortDetails[pol2Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol2Port].values[0].getY().getAdder() + nIn.nodePortDetails[pol2Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol2Port].values[1].getY().getAdder()) / 2.0;
                    if (Math.abs(x1Pos - x2Pos) > Math.abs(y1Pos - y2Pos)) {
                        if (x1Pos > x2Pos) {
                            NodeInfo.PortDetails formerPortA4 = nIn.nodePortDetails[pol1Port];
                            NodeInfo.PortDetails formerPortB4 = nIn.nodePortDetails[pol2Port];
                            nIn.nodePortDetails[pol1Port] = formerPortA4;
                            nIn.nodePortDetails[pol2Port] = formerPortB4;
                        }
                    } else if (y1Pos > y2Pos) {
                        NodeInfo.PortDetails formerPortA5 = nIn.nodePortDetails[pol1Port];
                        NodeInfo.PortDetails formerPortB5 = nIn.nodePortDetails[pol2Port];
                        nIn.nodePortDetails[pol1Port] = formerPortA5;
                        nIn.nodePortDetails[pol2Port] = formerPortB5;
                    }
                }
                int layerCount = 0;
                for (Sample ns : neList.samples) {
                    if (ns.values == null || ns.layer == Generic.tech.portNode || ns.layer == Generic.tech.cellCenterNode || ns.layer == null) continue;
                    ++layerCount;
                }
                if (nIn.serp) {
                    int k;
                    nIn.specialType = 1;
                    int polIndex = -1;
                    int difIndex = -1;
                    for (k = 0; k < nIn.nodeLayers.length; ++k) {
                        int funExtraNew;
                        int funExtraOld;
                        NodeInfo.LayerDetails nld = nIn.nodeLayers[k];
                        if (nld.layer.fun.isPoly()) {
                            polIndex = k;
                            continue;
                        }
                        if (!nld.layer.fun.isDiff() || difIndex >= 0 && ((funExtraOld = nIn.nodeLayers[difIndex].layer.funExtra) == (funExtraNew = nld.layer.funExtra) || funExtraOld == 0)) continue;
                        difIndex = k;
                    }
                    if (difIndex < 0 || polIndex < 0) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("No diffusion and polysilicon layers in transistor " + np);
                        return null;
                    }
                    nIn.specialValues = new double[6];
                    nIn.specialValues[0] = layerCount + 1;
                    if (nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() > nIn.nodePortDetails[dif1Port].values[0].getY().getAdder()) {
                        nIn.specialValues[3] = nIn.ySize * nIn.nodeLayers[polIndex].values[1].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getY().getAdder());
                        nIn.specialValues[1] = nIn.xSize * nIn.nodePortDetails[dif1Port].values[0].getX().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[difIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getX().getAdder());
                        nIn.specialValues[2] = nIn.ySize * nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[1].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getY().getAdder());
                        nIn.specialValues[4] = nIn.ySize * nIn.nodePortDetails[pol1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[pol1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getY().getAdder());
                        nIn.specialValues[5] = nIn.xSize * nIn.nodeLayers[difIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getX().getAdder() - (nIn.xSize * nIn.nodePortDetails[pol1Port].values[1].getX().getMultiplier() + nIn.nodePortDetails[pol1Port].values[1].getX().getAdder());
                    } else {
                        nIn.specialValues[3] = nIn.xSize * nIn.nodeLayers[polIndex].values[1].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder());
                        nIn.specialValues[1] = nIn.ySize * nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[difIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getY().getAdder());
                        nIn.specialValues[2] = nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder() - (nIn.xSize * nIn.nodePortDetails[dif1Port].values[1].getX().getMultiplier() + nIn.nodePortDetails[dif1Port].values[1].getX().getAdder());
                        nIn.specialValues[4] = nIn.xSize * nIn.nodePortDetails[pol1Port].values[0].getX().getMultiplier() + nIn.nodePortDetails[pol1Port].values[0].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder());
                        nIn.specialValues[5] = nIn.ySize * nIn.nodeLayers[difIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getY().getAdder() - (nIn.ySize * nIn.nodePortDetails[pol1Port].values[1].getY().getMultiplier() + nIn.nodePortDetails[pol1Port].values[1].getY().getAdder());
                    }
                    for (k = 0; k < nIn.nodeLayers.length; ++k) {
                        NodeInfo.LayerDetails nld = nIn.nodeLayers[k];
                        Sample ns = nld.ns;
                        Rectangle2D nodeBounds = ns.node.getBounds();
                        Sample polNs = nIn.nodeLayers[polIndex].ns;
                        Rectangle2D polNodeBounds = polNs.node.getBounds();
                        Sample difNs = nIn.nodeLayers[difIndex].ns;
                        Rectangle2D difNodeBounds = difNs.node.getBounds();
                        if (polNodeBounds.getWidth() > polNodeBounds.getHeight()) {
                            nld.lWidth = nodeBounds.getMaxY() - (ns.parent.ly + ns.parent.hy) / 2.0;
                            nld.rWidth = (ns.parent.ly + ns.parent.hy) / 2.0 - nodeBounds.getMinY();
                            nld.extendT = difNodeBounds.getMinX() - nodeBounds.getMinX();
                        } else {
                            nld.lWidth = nodeBounds.getMaxX() - (ns.parent.lx + ns.parent.hx) / 2.0;
                            nld.rWidth = (ns.parent.lx + ns.parent.hx) / 2.0 - nodeBounds.getMinX();
                            nld.extendT = difNodeBounds.getMinY() - nodeBounds.getMinY();
                        }
                        nld.extendB = nld.extendT;
                    }
                }
                double lX = 0.0;
                double hX = 0.0;
                double lY = 0.0;
                double hY = 0.0;
                boolean found = false;
                for (Sample ns : neList.samples) {
                    if (ns.layer != null) continue;
                    found = true;
                    if (ns.values != null) {
                        boolean err = false;
                        if (ns.values[0].getX().getMultiplier() == -0.5) {
                            lX = ns.values[0].getX().getAdder();
                        } else if (ns.values[0].getX().getMultiplier() == 0.5) {
                            lX = nIn.xSize + ns.values[0].getX().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns.values[0].getY().getMultiplier() == -0.5) {
                            lY = ns.values[0].getY().getAdder();
                        } else if (ns.values[0].getY().getMultiplier() == 0.5) {
                            lY = nIn.ySize + ns.values[0].getY().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns.values[1].getX().getMultiplier() == 0.5) {
                            hX = -ns.values[1].getX().getAdder();
                        } else if (ns.values[1].getX().getMultiplier() == -0.5) {
                            hX = nIn.xSize - ns.values[1].getX().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns.values[1].getY().getMultiplier() == 0.5) {
                            hY = -ns.values[1].getY().getAdder();
                        } else if (ns.values[1].getY().getMultiplier() == -0.5) {
                            hY = nIn.ySize - ns.values[1].getY().getAdder();
                        } else {
                            err = true;
                        }
                        if (!err) continue;
                        LibToTech.pointOutError(ns.node, ns.node.getParent());
                        System.out.println("Highlighting cannot scale from center in " + np);
                        return null;
                    }
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("No rule found for highlight in " + np);
                    return null;
                }
                if (!found) {
                    LibToTech.pointOutError(null, np);
                    System.out.println("No highlight found in " + np);
                    return null;
                }
                if (lX != 0.0 || hX != 0.0 || lY != 0.0 || hY != 0.0) {
                    nList[nodeIndex].so = new SizeOffset(lX, hX, lY, hY);
                }
                ++nodeIndex;
            }
        }
        return nList;
    }

    private static boolean associateExamples(Example neList, Cell np) {
        if (neList.nextExample == null) {
            return false;
        }
        Example ne = neList.nextExample;
        while (ne != null) {
            for (Sample ns : ne.samples) {
                ns.assoc = null;
            }
            for (Sample ns : ne.samples) {
                Sample thisSample;
                if (ns.assoc != null) continue;
                if (ns.layer == Generic.tech.cellCenterNode) {
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Grab point should only be in main example of " + np);
                    return true;
                }
                int total = 0;
                Sample nsFound = null;
                for (Sample nsList : neList.samples) {
                    if (nsList.layer != ns.layer) continue;
                    ++total;
                    nsFound = nsList;
                }
                if (total == 0) {
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Layer " + LibToTech.getSampleName(ns.layer) + " not found in main example of " + np);
                    return true;
                }
                if (total == 1) {
                    ns.assoc = nsFound;
                    continue;
                }
                if (ns.layer == Generic.tech.portNode) {
                    String name = Info.getPortName(ns.node);
                    if (name == null) {
                        LibToTech.pointOutError(ns.node, ns.node.getParent());
                        System.out.println("Cell " + np.describe(true) + ": port does not have a name");
                        return true;
                    }
                    boolean found = false;
                    for (Sample nsList : neList.samples) {
                        if (nsList.layer != Generic.tech.portNode) continue;
                        String otherName = Info.getPortName(nsList.node);
                        if (otherName == null) {
                            LibToTech.pointOutError(nsList.node, nsList.node.getParent());
                            System.out.println("Cell " + np.describe(true) + ": port does not have a name");
                            return true;
                        }
                        if (!name.equalsIgnoreCase(otherName)) continue;
                        ns.assoc = nsList;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LibToTech.pointOutError(null, np);
                    System.out.println("Could not find port " + name + " in all examples of " + np);
                    return true;
                }
                int i = 0;
                for (Sample nsList : ne.samples) {
                    if (nsList.layer != ns.layer) continue;
                    ++i;
                }
                if (total != i) {
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Layer " + LibToTech.getSampleName(ns.layer) + " found " + total + " times in main example, " + i + " in other");
                    System.out.println("Make the counts consistent");
                    return true;
                }
                ArrayList<Sample> mainList = new ArrayList<Sample>();
                i = 0;
                for (Sample nsList : neList.samples) {
                    if (nsList.layer != ns.layer) continue;
                    mainList.add(nsList);
                }
                ArrayList<Sample> thisList = new ArrayList<Sample>();
                i = 0;
                for (Sample nsList : ne.samples) {
                    if (nsList.layer != ns.layer) continue;
                    thisList.add(nsList);
                }
                Collections.sort(mainList, new SampleCoordAscending());
                Collections.sort(thisList, new SampleCoordAscending());
                for (i = 1; i < total; ++i) {
                    thisSample = (Sample)thisList.get(i);
                    Sample lastSample = (Sample)thisList.get(i - 1);
                    Sample thisMainSample = (Sample)mainList.get(i);
                    Sample lastMainSample = (Sample)mainList.get(i - 1);
                    if (thisSample.xPos == lastSample.xPos && thisSample.yPos == lastSample.yPos && thisSample.node.getProto() == lastSample.node.getProto() || thisMainSample.xPos == lastMainSample.xPos && thisMainSample.yPos == lastMainSample.yPos && thisMainSample.node.getProto() == lastMainSample.node.getProto()) break;
                }
                if (i >= total) {
                    for (i = 0; i < total; ++i) {
                        thisSample = (Sample)thisList.get(i);
                        thisSample.assoc = (Sample)mainList.get(i);
                    }
                    continue;
                }
                thisSample = (Sample)thisList.get(i);
                LibToTech.pointOutError(thisSample.node, thisSample.node.getParent());
                System.out.println("Sample " + LibToTech.getSampleName(thisSample.layer) + " is unassociated in " + np);
                return true;
            }
            for (Sample nsList : neList.samples) {
                nsList.assoc = null;
            }
            Iterator<Sample> i$ = ne.samples.iterator();
            while (i$.hasNext()) {
                Sample ns;
                ns.assoc.assoc = ns = i$.next();
            }
            for (Sample nsList : neList.samples) {
                if (nsList.assoc != null || nsList.layer == Generic.tech.cellCenterNode) continue;
                LibToTech.pointOutError(nsList.node, nsList.node.getParent());
                System.out.println("Layer " + LibToTech.getSampleName(nsList.layer) + " found in main example, but not others in " + np);
                return true;
            }
            ne = ne.nextExample;
        }
        return false;
    }

    static void pointOutError(NodeInst ni, Cell cell) {
        Job.getUserInterface().setCurrentCell(cell.getLibrary(), cell);
        EditWindow_ wnd = Job.getUserInterface().needCurrentEditWindow_();
        if (wnd != null && ni != null) {
            wnd.clearHighlighting();
            wnd.addElectricObject(ni, cell);
            wnd.finishedHighlighting();
        }
    }

    private static Poly.Type getStyle(NodeInst ni) {
        Variable var;
        Poly.Type sty = null;
        if (ni.getProto() == Artwork.tech.filledBoxNode) {
            sty = Poly.Type.FILLED;
        } else if (ni.getProto() == Artwork.tech.boxNode) {
            sty = Poly.Type.CLOSED;
        } else if (ni.getProto() == Artwork.tech.crossedBoxNode) {
            sty = Poly.Type.CROSSED;
        } else if (ni.getProto() == Artwork.tech.filledPolygonNode) {
            sty = Poly.Type.FILLED;
        } else if (ni.getProto() == Artwork.tech.closedPolygonNode) {
            sty = Poly.Type.CLOSED;
        } else if (ni.getProto() == Artwork.tech.openedPolygonNode) {
            sty = Poly.Type.OPENED;
        } else if (ni.getProto() == Artwork.tech.openedDottedPolygonNode) {
            sty = Poly.Type.OPENEDT1;
        } else if (ni.getProto() == Artwork.tech.openedDashedPolygonNode) {
            sty = Poly.Type.OPENEDT2;
        } else if (ni.getProto() == Artwork.tech.openedThickerPolygonNode) {
            sty = Poly.Type.OPENEDT3;
        } else if (ni.getProto() == Artwork.tech.filledCircleNode) {
            sty = Poly.Type.DISC;
        } else if (ni.getProto() == Artwork.tech.circleNode) {
            sty = Poly.Type.CIRCLE;
            double[] angles = ni.getArcDegrees();
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                sty = Poly.Type.CIRCLEARC;
            }
        } else if (ni.getProto() == Artwork.tech.thickCircleNode) {
            sty = Poly.Type.THICKCIRCLE;
            double[] angles = ni.getArcDegrees();
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                sty = Poly.Type.THICKCIRCLEARC;
            }
        } else if (ni.getProto() == Generic.tech.invisiblePinNode && (var = ni.getVar(Artwork.ART_MESSAGE)) != null) {
            AbstractTextDescriptor.Position pos = var.getTextDescriptor().getPos();
            if (pos == AbstractTextDescriptor.Position.BOXED) {
                sty = Poly.Type.TEXTBOX;
            } else if (pos == AbstractTextDescriptor.Position.CENT) {
                sty = Poly.Type.TEXTCENT;
            } else if (pos == AbstractTextDescriptor.Position.UP) {
                sty = Poly.Type.TEXTBOT;
            } else if (pos == AbstractTextDescriptor.Position.DOWN) {
                sty = Poly.Type.TEXTTOP;
            } else if (pos == AbstractTextDescriptor.Position.LEFT) {
                sty = Poly.Type.TEXTRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.RIGHT) {
                sty = Poly.Type.TEXTLEFT;
            } else if (pos == AbstractTextDescriptor.Position.UPLEFT) {
                sty = Poly.Type.TEXTBOTRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.UPRIGHT) {
                sty = Poly.Type.TEXTBOTLEFT;
            } else if (pos == AbstractTextDescriptor.Position.DOWNLEFT) {
                sty = Poly.Type.TEXTTOPRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.DOWNRIGHT) {
                sty = Poly.Type.TEXTTOPLEFT;
            }
        }
        if (sty == null) {
            System.out.println("Cannot determine style to use for " + ni.getProto() + " node in " + ni.getParent());
        }
        return sty;
    }

    private static NodeInfo.LayerDetails[] makeNodeScaledUniformly(Example neList, NodeProto np, LayerInfo[] lis) {
        int count = 0;
        for (Sample ns : neList.samples) {
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            ++count;
        }
        NodeInfo.LayerDetails[] nodeLayers = new NodeInfo.LayerDetails[count];
        count = 0;
        for (Sample ns : neList.samples) {
            Rectangle2D nodeBounds = LibToTech.getBoundingBox(ns.node);
            AffineTransform trans = ns.node.rotateOut();
            Point2D[] pointList = null;
            int[] pointFactor = null;
            Point2D[] points = null;
            if (ns.node.getProto() == Artwork.tech.filledPolygonNode || ns.node.getProto() == Artwork.tech.closedPolygonNode || ns.node.getProto() == Artwork.tech.openedPolygonNode || ns.node.getProto() == Artwork.tech.openedDottedPolygonNode || ns.node.getProto() == Artwork.tech.openedDashedPolygonNode || ns.node.getProto() == Artwork.tech.openedThickerPolygonNode) {
                points = ns.node.getTrace();
            }
            if (points != null) {
                pointList = new Point2D[points.length];
                pointFactor = new int[points.length];
                for (int i = 0; i < points.length; ++i) {
                    pointList[i] = new Point2D.Double(nodeBounds.getCenterX() + points[i].getX(), nodeBounds.getCenterY() + points[i].getY());
                    trans.transform(pointList[i], pointList[i]);
                    pointFactor[i] = 192;
                }
            } else {
                double[] angles = null;
                if ((ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode) && (angles = ns.node.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                    angles = null;
                }
                if (angles != null) {
                    pointList = new Point2D[3];
                    pointFactor = new int[3];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    double dist = nodeBounds.getMaxX() - nodeBounds.getCenterX();
                    pointList[1] = new Point2D.Double(nodeBounds.getCenterX() + dist * Math.cos(angles[0]), nodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                    trans.transform(pointList[1], pointList[1]);
                    pointFactor[0] = 48;
                    pointFactor[1] = 192;
                    pointFactor[2] = 192;
                } else if (ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode || ns.node.getProto() == Artwork.tech.filledCircleNode) {
                    pointList = new Point2D[2];
                    pointFactor = new int[2];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getCenterY());
                    pointFactor[0] = 48;
                    pointFactor[1] = 34;
                } else {
                    pointList = new Point2D[2];
                    pointFactor = new int[2];
                    pointList[0] = new Point2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getMaxY());
                    pointFactor[0] = 9;
                    pointFactor[1] = 6;
                }
            }
            Technology.TechPoint[] newRule = LibToTech.stretchPoints(pointList, pointFactor, ns, np, neList);
            if (newRule == null) {
                System.out.println("Error creating stretch point in " + np);
                return null;
            }
            ns.msg = Info.getValueOnNode(ns.node);
            if (ns.msg != null && ns.msg.length() == 0) {
                ns.msg = null;
            }
            ns.values = newRule;
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            LayerInfo layer = null;
            String desiredLayer = ns.layer.getName().substring(6);
            for (int i = 0; i < lis.length; ++i) {
                if (!desiredLayer.equals(lis[i].name)) continue;
                layer = lis[i];
                break;
            }
            if (layer == null) {
                System.out.println("Cannot find layer " + desiredLayer);
                return null;
            }
            nodeLayers[count] = new NodeInfo.LayerDetails();
            nodeLayers[count].layer = layer;
            nodeLayers[count].ns = ns;
            nodeLayers[count].style = LibToTech.getStyle(ns.node);
            nodeLayers[count].representation = 0;
            nodeLayers[count].values = LibToTech.fixValues(np, ns.values);
            if (nodeLayers[count].values.length == 2 && (nodeLayers[count].style == Poly.Type.CROSSED || nodeLayers[count].style == Poly.Type.FILLED || nodeLayers[count].style == Poly.Type.CLOSED)) {
                nodeLayers[count].representation = 1;
            }
            ++count;
        }
        return nodeLayers;
    }

    private static Technology.TechPoint[] fixValues(NodeProto np, Technology.TechPoint[] currentList) {
        EdgeH h1 = null;
        EdgeH h2 = null;
        EdgeH h3 = null;
        EdgeV v1 = null;
        EdgeV v2 = null;
        EdgeV v3 = null;
        for (int p = 0; p < currentList.length; ++p) {
            EdgeH h = currentList[p].getX();
            if (h.equals(h1) || h.equals(h2) || h.equals(h3)) continue;
            if (h1 == null) {
                h1 = h;
            } else if (h2 == null) {
                h2 = h;
            } else {
                h3 = h;
            }
            EdgeV v = currentList[p].getY();
            if (v.equals(v1) || v.equals(v2) || v.equals(v3)) continue;
            if (v1 == null) {
                v1 = v;
                continue;
            }
            if (v2 == null) {
                v2 = v;
                continue;
            }
            v3 = v;
        }
        if (h1 != null && h2 != null && h3 == null && v1 != null && v2 != null && v3 == null) {
            currentList = new Technology.TechPoint[]{new Technology.TechPoint(h1, v1), new Technology.TechPoint(h2, v2)};
        }
        return currentList;
    }

    private static NodeInfo.LayerDetails[] makePrimitiveNodeLayers(Example neList, Cell np, LayerInfo[] lis) {
        if (neList.nextExample == null) {
            return LibToTech.makeNodeScaledUniformly(neList, np, lis);
        }
        int count = 0;
        for (Sample ns : neList.samples) {
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            ++count;
        }
        NodeInfo.LayerDetails[] nodeLayers = new NodeInfo.LayerDetails[count];
        count = 0;
        for (Sample ns : neList.samples) {
            Technology.TechPoint[] newRule;
            if (ns.layer == Generic.tech.cellCenterNode) continue;
            AffineTransform trans = ns.node.rotateOut();
            Rectangle2D nodeBounds = LibToTech.getBoundingBox(ns.node);
            LayerInfo giLayer = null;
            if (ns.layer != null && ns.layer != Generic.tech.portNode) {
                String desiredLayer = ns.layer.getName().substring(6);
                for (int i = 0; i < lis.length; ++i) {
                    if (!desiredLayer.equals(lis[i].name)) continue;
                    giLayer = lis[i];
                    break;
                }
                if (giLayer == null) {
                    System.out.println("Cannot find layer " + desiredLayer);
                    return null;
                }
            }
            neList.studySample = ns;
            NodeInfo.LayerDetails multiRule = null;
            Example ne = neList.nextExample;
            while (ne != null) {
                int total = 0;
                for (Sample nso : ne.samples) {
                    if (nso.assoc != ns) continue;
                    ne.studySample = nso;
                    ++total;
                }
                if (total == 0) {
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Still unassociated sample in " + np + " (shouldn't happen)");
                    return null;
                }
                if (total > 1) {
                    if (ns.layer == null || ns.layer == Generic.tech.portNode) {
                        LibToTech.pointOutError(ns.node, ns.node.getParent());
                        System.out.println("Only contact layers may be iterated in examples of " + np);
                        return null;
                    }
                    multiRule = LibToTech.getMultiCutRule(ns, neList, np);
                    if (multiRule != null) break;
                }
                ne = ne.nextExample;
            }
            if (multiRule != null) {
                multiRule.layer = giLayer;
                nodeLayers[count] = multiRule;
                ++count;
                continue;
            }
            Point2D[] pointList = null;
            int[] pointFactor = null;
            Point2D[] points = null;
            if (ns.node.getProto() == Artwork.tech.filledPolygonNode || ns.node.getProto() == Artwork.tech.closedPolygonNode || ns.node.getProto() == Artwork.tech.openedPolygonNode || ns.node.getProto() == Artwork.tech.openedDottedPolygonNode || ns.node.getProto() == Artwork.tech.openedDashedPolygonNode || ns.node.getProto() == Artwork.tech.openedThickerPolygonNode) {
                points = ns.node.getTrace();
            }
            int trueCount = 0;
            int minFactor = 0;
            if (points != null) {
                pointList = new Point2D[points.length];
                pointFactor = new int[points.length];
                for (int i = 0; i < points.length; ++i) {
                    pointList[i] = new Point2D.Double(nodeBounds.getCenterX() + points[i].getX(), nodeBounds.getCenterY() + points[i].getY());
                    trans.transform(pointList[i], pointList[i]);
                }
                trueCount = points.length;
            } else {
                double[] angles = null;
                if ((ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode) && (angles = ns.node.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                    angles = null;
                }
                if (angles != null) {
                    pointList = new Point2D[3];
                    pointFactor = new int[3];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    double dist = nodeBounds.getMaxX() - nodeBounds.getCenterX();
                    pointList[1] = new Point2D.Double(nodeBounds.getCenterX() + dist * Math.cos(angles[0]), nodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                    trans.transform(pointList[1], pointList[1]);
                    trueCount = 3;
                } else if (ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode || ns.node.getProto() == Artwork.tech.filledCircleNode) {
                    pointList = new Point2D[2 + minFactor];
                    pointFactor = new int[2 + minFactor];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getCenterY());
                    trueCount = 2;
                } else {
                    pointList = new Point2D[2 + minFactor];
                    pointFactor = new int[2 + minFactor];
                    pointList[0] = new Point2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getMaxY());
                    trueCount = 2;
                }
            }
            double[] pointLeftDist = new double[pointFactor.length];
            double[] pointRightDist = new double[pointFactor.length];
            double[] pointBottomDist = new double[pointFactor.length];
            double[] pointTopDist = new double[pointFactor.length];
            double[] centerXDist = new double[pointFactor.length];
            double[] centerYDist = new double[pointFactor.length];
            double[] pointXRatio = new double[pointFactor.length];
            double[] pointYRatio = new double[pointFactor.length];
            for (int i = 0; i < pointFactor.length; ++i) {
                pointLeftDist[i] = pointList[i].getX() - neList.lx;
                pointRightDist[i] = neList.hx - pointList[i].getX();
                pointBottomDist[i] = pointList[i].getY() - neList.ly;
                pointTopDist[i] = neList.hy - pointList[i].getY();
                centerXDist[i] = pointList[i].getX() - (neList.lx + neList.hx) / 2.0;
                centerYDist[i] = pointList[i].getY() - (neList.ly + neList.hy) / 2.0;
                pointXRatio[i] = neList.hx == neList.lx ? 0.0 : (pointList[i].getX() - (neList.lx + neList.hx) / 2.0) / (neList.hx - neList.lx);
                pointYRatio[i] = neList.hy == neList.ly ? 0.0 : (pointList[i].getY() - (neList.ly + neList.hy) / 2.0) / (neList.hy - neList.ly);
                pointFactor[i] = i < trueCount ? 255 : 48;
            }
            Point2D[] pointCoords = new Point2D[pointFactor.length];
            Example ne2 = neList.nextExample;
            while (ne2 != null) {
                NodeInst ni = ne2.studySample.node;
                AffineTransform oTrans = ni.rotateOut();
                Rectangle2D oNodeBounds = LibToTech.getBoundingBox(ni);
                Point2D[] oPoints = null;
                if (ni.getProto() == Artwork.tech.filledPolygonNode || ni.getProto() == Artwork.tech.closedPolygonNode || ni.getProto() == Artwork.tech.openedPolygonNode || ni.getProto() == Artwork.tech.openedDottedPolygonNode || ni.getProto() == Artwork.tech.openedDashedPolygonNode || ni.getProto() == Artwork.tech.openedThickerPolygonNode) {
                    oPoints = ni.getTrace();
                }
                int newCount = 2;
                if (oPoints != null) {
                    newCount = oPoints.length;
                    int numPoints = Math.min(trueCount, newCount);
                    int bestOffset = 0;
                    double bestDist = Double.MAX_VALUE;
                    for (int offset = 0; offset < numPoints; ++offset) {
                        double dist = 0.0;
                        for (int i = 0; i < numPoints; ++i) {
                            double dX = points[i].getX() - oPoints[(i + offset) % numPoints].getX();
                            double dY = points[i].getY() - oPoints[(i + offset) % numPoints].getY();
                            dist += Math.hypot(dX, dY);
                        }
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                        bestOffset = offset;
                    }
                    for (int i = 0; i < numPoints; ++i) {
                        pointCoords[i] = new Point2D.Double(oNodeBounds.getCenterX() + oPoints[(i + bestOffset) % numPoints].getX(), oNodeBounds.getCenterY() + oPoints[(i + bestOffset) % numPoints].getY());
                        oTrans.transform(pointCoords[i], pointCoords[i]);
                    }
                } else {
                    double[] angles = null;
                    if ((ni.getProto() == Artwork.tech.circleNode || ni.getProto() == Artwork.tech.thickCircleNode) && (angles = ni.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                        angles = null;
                    }
                    if (angles != null) {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getCenterX(), oNodeBounds.getCenterY());
                        double dist = oNodeBounds.getMaxX() - oNodeBounds.getCenterX();
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getCenterX() + dist * Math.cos(angles[0]), oNodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                        oTrans.transform(pointCoords[1], pointCoords[1]);
                    } else if (ni.getProto() == Artwork.tech.circleNode || ni.getProto() == Artwork.tech.thickCircleNode || ni.getProto() == Artwork.tech.filledCircleNode) {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getCenterX(), oNodeBounds.getCenterY());
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getMaxX(), oNodeBounds.getCenterY());
                    } else {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getMinX(), oNodeBounds.getMinY());
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getMaxX(), oNodeBounds.getMaxY());
                    }
                }
                if (newCount != trueCount) {
                    LibToTech.pointOutError(ni, ni.getParent());
                    System.out.println("Main example of " + LibToTech.getSampleName(ne2.studySample.layer) + " has " + trueCount + " points but this has " + newCount + " in " + np);
                    return null;
                }
                for (int i = 0; i < trueCount; ++i) {
                    if (!DBMath.areEquals(pointLeftDist[i], pointCoords[i].getX() - ne2.lx)) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFFE;
                    }
                    if (!DBMath.areEquals(pointRightDist[i], ne2.hx - pointCoords[i].getX())) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFFD;
                    }
                    if (!DBMath.areEquals(pointBottomDist[i], pointCoords[i].getY() - ne2.ly)) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFF7;
                    }
                    if (!DBMath.areEquals(pointTopDist[i], ne2.hy - pointCoords[i].getY())) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFFB;
                    }
                    if (!DBMath.areEquals(centerXDist[i], pointCoords[i].getX() - (ne2.lx + ne2.hx) / 2.0)) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFEF;
                    }
                    if (!DBMath.areEquals(centerYDist[i], pointCoords[i].getY() - (ne2.ly + ne2.hy) / 2.0)) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFDF;
                    }
                    double r = 0.0;
                    if (ne2.hx != ne2.lx) {
                        r = (pointCoords[i].getX() - (ne2.lx + ne2.hx) / 2.0) / (ne2.hx - ne2.lx);
                    }
                    if (!DBMath.areEquals(r, pointXRatio[i])) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFBF;
                    }
                    if (DBMath.areEquals(r = ne2.hy == ne2.ly ? 0.0 : (pointCoords[i].getY() - (ne2.ly + ne2.hy) / 2.0) / (ne2.hy - ne2.ly), pointYRatio[i])) continue;
                    int n = i;
                    pointFactor[n] = pointFactor[n] & 0xFFFFFF7F;
                }
                if (ns.layer == Generic.tech.portNode) {
                    Variable var = ns.node.getVar(Info.PORTANGLE_KEY);
                    Variable var2 = ni.getVar(Info.PORTANGLE_KEY);
                    if (var == null && var2 != null) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Warning: moving port angle to main example of " + np);
                        ns.node.newVar(Info.PORTANGLE_KEY, var2.getObject());
                    }
                    var = ns.node.getVar(Info.PORTRANGE_KEY);
                    var2 = ni.getVar(Info.PORTRANGE_KEY);
                    if (var == null && var2 != null) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Warning: moving port range to main example of " + np);
                        ns.node.newVar(Info.PORTRANGE_KEY, var2.getObject());
                    }
                    var = ns.node.getVar(Info.CONNECTION_KEY);
                    var2 = ni.getVar(Info.CONNECTION_KEY);
                    if (var == null && var2 != null) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Warning: moving port connections to main example of " + np);
                        ns.node.newVar(Info.CONNECTION_KEY, var2.getObject());
                    }
                }
                ne2 = ne2.nextExample;
            }
            if (ns.layer == null) {
                for (int i = 0; i < trueCount; ++i) {
                    if ((pointFactor[i] & 3) != 0 && (pointFactor[i] & 0xC) != 0) continue;
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Highlight must be constant distance from edge in " + np);
                    return null;
                }
            }
            if ((newRule = LibToTech.stretchPoints(pointList, pointFactor, ns, np, neList)) == null) {
                return null;
            }
            ns.msg = Info.getValueOnNode(ns.node);
            if (ns.msg != null && ns.msg.length() == 0) {
                ns.msg = null;
            }
            ns.values = newRule;
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            nodeLayers[count] = new NodeInfo.LayerDetails();
            nodeLayers[count].layer = giLayer;
            nodeLayers[count].ns = ns;
            nodeLayers[count].style = LibToTech.getStyle(ns.node);
            nodeLayers[count].representation = 0;
            nodeLayers[count].values = LibToTech.fixValues(np, ns.values);
            if (nodeLayers[count].values.length == 2 && (nodeLayers[count].style == Poly.Type.CROSSED || nodeLayers[count].style == Poly.Type.FILLED || nodeLayers[count].style == Poly.Type.CLOSED)) {
                nodeLayers[count].representation = 1;
            }
            ++count;
        }
        if (count != nodeLayers.length) {
            System.out.println("Generated only " + count + " of " + nodeLayers.length + " layers for " + np);
        }
        return nodeLayers;
    }

    private static Rectangle2D getBoundingBox(NodeInst ni) {
        Rectangle2D bounds = ni.getBounds();
        if (ni.getProto() == Generic.tech.portNode) {
            double portShrink = 2.0;
            bounds.setRect(bounds.getMinX() + portShrink, bounds.getMinY() + portShrink, bounds.getWidth() - portShrink * 2.0, bounds.getHeight() - portShrink * 2.0);
        }
        bounds.setRect(DBMath.round(bounds.getMinX()), DBMath.round(bounds.getMinY()), DBMath.round(bounds.getWidth()), DBMath.round(bounds.getHeight()));
        return bounds;
    }

    private static Technology.TechPoint[] stretchPoints(Point2D[] pts, int[] factor, Sample ns, NodeProto np, Example neList) {
        Technology.TechPoint[] newRule = new Technology.TechPoint[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            EdgeH horiz = null;
            if ((factor[i] & 1) != 0) {
                horiz = EdgeH.fromLeft(pts[i].getX() - neList.lx);
            } else if ((factor[i] & 2) != 0) {
                horiz = EdgeH.fromRight(neList.hx - pts[i].getX());
            } else if ((factor[i] & 0x10) != 0) {
                horiz = EdgeH.fromCenter(pts[i].getX() - (neList.lx + neList.hx) / 2.0);
            } else if ((factor[i] & 0x40) != 0) {
                horiz = neList.hx == neList.lx ? EdgeH.makeCenter() : new EdgeH((pts[i].getX() - (neList.lx + neList.hx) / 2.0) / (neList.hx - neList.lx), 0.0);
            } else {
                LibToTech.pointOutError(ns.node, ns.node.getParent());
                System.out.println("Cannot determine X stretching rule for layer " + LibToTech.getSampleName(ns.layer) + " in " + np);
                return null;
            }
            EdgeV vert = null;
            if ((factor[i] & 8) != 0) {
                vert = EdgeV.fromBottom(pts[i].getY() - neList.ly);
            } else if ((factor[i] & 4) != 0) {
                vert = EdgeV.fromTop(neList.hy - pts[i].getY());
            } else if ((factor[i] & 0x20) != 0) {
                vert = EdgeV.fromCenter(pts[i].getY() - (neList.ly + neList.hy) / 2.0);
            } else if ((factor[i] & 0x80) != 0) {
                vert = neList.hy == neList.ly ? EdgeV.makeCenter() : new EdgeV((pts[i].getY() - (neList.ly + neList.hy) / 2.0) / (neList.hy - neList.ly), 0.0);
            } else {
                LibToTech.pointOutError(ns.node, ns.node.getParent());
                System.out.println("Cannot determine Y stretching rule for layer " + LibToTech.getSampleName(ns.layer) + " in " + np);
                return null;
            }
            newRule[i] = new Technology.TechPoint(horiz, vert);
        }
        return newRule;
    }

    private static Sample needHighlightLayer(Example neList, Cell np) {
        for (Sample ns : neList.samples) {
            if (ns.layer != null) continue;
            return ns;
        }
        LibToTech.pointOutError(null, np);
        System.out.println("No highlight layer on contact " + np.describe(true));
        return null;
    }

    private static NodeInfo.LayerDetails getMultiCutRule(Sample ns, Example neList, Cell np) {
        Sample hs = LibToTech.needHighlightLayer(neList, np);
        if (hs == null) {
            return null;
        }
        Rectangle2D highlightBounds = hs.node.getBounds();
        Rectangle2D nodeBounds = ns.node.getBounds();
        double multiXS = nodeBounds.getWidth();
        double multiYS = nodeBounds.getHeight();
        double multiIndent = nodeBounds.getMinX() - highlightBounds.getMinX();
        double realIndentX = nodeBounds.getMinX() - neList.lx + multiXS / 2.0;
        double realIndentY = nodeBounds.getMinY() - neList.ly + multiYS / 2.0;
        if (highlightBounds.getMaxX() - nodeBounds.getMaxX() != multiIndent || nodeBounds.getMinY() - highlightBounds.getMinY() != multiIndent || highlightBounds.getMaxY() - nodeBounds.getMaxY() != multiIndent) {
            LibToTech.pointOutError(ns.node, ns.node.getParent());
            System.out.println("Multiple contact cuts must be indented uniformly in " + np);
            return null;
        }
        double xSep = -1.0;
        double ySep = -1.0;
        Example ne = neList.nextExample;
        while (ne != null) {
            double sepY;
            double sepX;
            Rectangle2D lastNodeBounds;
            Rectangle2D thisNodeBounds;
            int i;
            int total = 0;
            for (Sample nso : ne.samples) {
                if (nso.assoc != ns) continue;
                Rectangle2D oNodeBounds = nso.node.getBounds();
                if (multiXS != oNodeBounds.getWidth() || multiYS != oNodeBounds.getHeight()) {
                    LibToTech.pointOutError(nso.node, nso.node.getParent());
                    System.out.println("Multiple contact cuts must not differ in size in " + np);
                    return null;
                }
                ++total;
            }
            Sample[] nsList = new Sample[total];
            int fill = 0;
            for (Sample nso : ne.samples) {
                if (nso.assoc != ns) continue;
                nsList[fill++] = nso;
            }
            for (i = 1; i < total; ++i) {
                thisNodeBounds = nsList[i].node.getBounds();
                lastNodeBounds = nsList[i - 1].node.getBounds();
                sepX = Math.abs(lastNodeBounds.getCenterX() - thisNodeBounds.getCenterX());
                sepY = Math.abs(lastNodeBounds.getCenterY() - thisNodeBounds.getCenterY());
                if (sepX < multiXS && sepY < multiYS) {
                    LibToTech.pointOutError(nsList[i].node, nsList[i].node.getParent());
                    System.out.println("Multiple contact cuts must not overlap in " + np);
                    return null;
                }
                if (sepX >= multiXS) {
                    if (xSep < 0.0) {
                        xSep = sepX;
                    } else if (xSep > sepX) {
                        xSep = sepX;
                    }
                }
                if (!(sepY >= multiYS)) continue;
                if (ySep < 0.0) {
                    ySep = sepY;
                    continue;
                }
                if (!(ySep > sepY)) continue;
                ySep = sepY;
            }
            for (i = 1; i < total; ++i) {
                thisNodeBounds = nsList[i].node.getBounds();
                lastNodeBounds = nsList[i - 1].node.getBounds();
                sepX = Math.abs(lastNodeBounds.getCenterX() - thisNodeBounds.getCenterX());
                sepY = Math.abs(lastNodeBounds.getCenterY() - thisNodeBounds.getCenterY());
                if (sepX / xSep * xSep != sepX) {
                    LibToTech.pointOutError(nsList[i].node, nsList[i].node.getParent());
                    System.out.println("Multiple contact cut X spacing must be uniform in " + np);
                    return null;
                }
                if (sepY / ySep * ySep == sepY) continue;
                LibToTech.pointOutError(nsList[i].node, nsList[i].node.getParent());
                System.out.println("Multiple contact cut Y spacing must be uniform in " + np);
                return null;
            }
            ne = ne.nextExample;
        }
        double multiSepX = xSep - multiXS;
        double multiSepY = ySep - multiYS;
        if (multiSepX != multiSepY) {
            LibToTech.pointOutError(null, np);
            System.out.println("Multiple contact cut X and Y spacing must be the same in " + np);
            return null;
        }
        ns.values = new Technology.TechPoint[2];
        ns.values[0] = new Technology.TechPoint(EdgeH.fromLeft(realIndentX), EdgeV.fromBottom(realIndentY));
        ns.values[1] = new Technology.TechPoint(EdgeH.fromRight(realIndentX), EdgeV.fromTop(realIndentY));
        NodeInfo.LayerDetails multiDetails = new NodeInfo.LayerDetails();
        multiDetails.style = LibToTech.getStyle(ns.node);
        multiDetails.representation = 0;
        if (multiDetails.style == Poly.Type.CROSSED || multiDetails.style == Poly.Type.FILLED || multiDetails.style == Poly.Type.CLOSED) {
            multiDetails.representation = 1;
        }
        multiDetails.values = ns.values;
        multiDetails.ns = ns;
        multiDetails.multiCut = true;
        multiDetails.representation = 3;
        multiDetails.multiXS = multiXS;
        multiDetails.multiYS = multiYS;
        multiDetails.multiIndent = multiIndent;
        multiDetails.multiSep = multiSepX;
        multiDetails.multiSep2D = multiSepX;
        return multiDetails;
    }

    private static String getSampleName(NodeProto layerCell) {
        if (layerCell == Generic.tech.portNode) {
            return "PORT";
        }
        if (layerCell == Generic.tech.cellCenterNode) {
            return "GRAB";
        }
        if (layerCell == null) {
            return "HIGHLIGHT";
        }
        return layerCell.getName().substring(6);
    }

    static void writeXml(String fileName, String newTechName, GeneralInfo gi, LayerInfo[] lList, NodeInfo[] nList, ArcInfo[] aList) {
        LibToTech.makeXml(newTechName, gi, lList, nList, aList).writeXml(fileName);
    }

    /*
     * WARNING - void declaration
     */
    static Xml.Technology makeXml(String newTechName, GeneralInfo gi, LayerInfo[] lList, NodeInfo[] nList, ArcInfo[] aList) {
        Xml.Technology t = new Xml.Technology();
        t.techName = newTechName;
        t.shortTechName = gi.shortName;
        t.description = gi.description;
        Xml.Version version = new Xml.Version();
        version.techVersion = 1;
        version.electricVersion = Version.parseVersion("8.05g");
        t.versions.add(version);
        version = new Xml.Version();
        version.techVersion = 2;
        version.electricVersion = Version.parseVersion("8.05o");
        t.versions.add(version);
        t.maxNumMetals = t.defaultNumMetals = gi.defaultNumMetals;
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = gi.scale;
        t.scaleRelevant = gi.scaleRelevant;
        t.defaultFoundry = gi.defaultFoundry;
        t.minResistance = gi.minRes;
        t.minCapacitance = gi.minCap;
        if (gi.transparentColors != null) {
            for (int i = 0; i < gi.transparentColors.length; ++i) {
                t.transparentLayers.add(gi.transparentColors[i]);
            }
        }
        for (LayerInfo layerInfo : lList) {
            if (layerInfo.pseudo) continue;
            Xml.Layer layer = new Xml.Layer();
            layer.name = layerInfo.name;
            layer.function = layerInfo.fun;
            layer.extraFunction = layerInfo.funExtra;
            layer.desc = layerInfo.desc;
            layer.thick3D = layerInfo.thick3d;
            layer.height3D = layerInfo.height3d;
            layer.mode3D = layerInfo.mode3d;
            layer.factor3D = layerInfo.factor3d;
            layer.cif = layerInfo.cif;
            layer.resistance = layerInfo.spiRes;
            layer.capacitance = layerInfo.spiCap;
            layer.edgeCapacitance = layerInfo.spiECap;
            if (layerInfo.pureLayerNode != null) {
                layer.pureLayerNode = new Xml.PureLayerNode();
                layer.pureLayerNode.name = layerInfo.pureLayerNode.name;
                layer.pureLayerNode.style = layerInfo.pureLayerNode.nodeLayers[0].style;
                layer.pureLayerNode.port = layerInfo.pureLayerNode.nodePortDetails[0].name;
                layer.pureLayerNode.size.value = DBMath.round(layerInfo.pureLayerNode.xSize);
                for (ArcInfo a : layerInfo.pureLayerNode.nodePortDetails[0].connections) {
                    layer.pureLayerNode.portArcs.add(a.name);
                }
            }
            t.layers.add(layer);
        }
        for (Info info : aList) {
            Xml.ArcProto ap = new Xml.ArcProto();
            ap.name = ((ArcInfo)info).name;
            ap.function = ((ArcInfo)info).func;
            ap.wipable = ((ArcInfo)info).wipes;
            ap.curvable = ((ArcInfo)info).curvable;
            ap.special = ((ArcInfo)info).special;
            ap.notUsed = ((ArcInfo)info).notUsed;
            ap.skipSizeInPalette = ((ArcInfo)info).skipSizeInPalette;
            ap.extended = !((ArcInfo)info).noExtend;
            ap.fixedAngle = ((ArcInfo)info).fixAng;
            ap.angleIncrement = ((ArcInfo)info).angInc;
            ap.antennaRatio = ((ArcInfo)info).antennaRatio;
            if (((ArcInfo)info).widthOffset != 0.0) {
                ap.diskOffset.put(1, DBMath.round(0.5 * ((ArcInfo)info).maxWidth));
                ap.diskOffset.put(2, DBMath.round(0.5 * (((ArcInfo)info).maxWidth - ((ArcInfo)info).widthOffset)));
            } else {
                ap.diskOffset.put(2, DBMath.round(0.5 * ((ArcInfo)info).maxWidth));
            }
            ap.defaultWidth.value = 0.0;
            for (ArcInfo.LayerDetails al : ((ArcInfo)info).arcDetails) {
                Xml.ArcLayer l = new Xml.ArcLayer();
                l.layer = al.layer.name;
                l.style = al.style == Poly.Type.FILLED ? Poly.Type.FILLED : Poly.Type.CLOSED;
                l.extend.value = DBMath.round((((ArcInfo)info).maxWidth - al.width) / 2.0);
                ap.arcLayers.add(l);
            }
            t.arcs.add(ap);
        }
        for (Info info : nList) {
            int j;
            if (((NodeInfo)info).func == PrimitiveNode.Function.NODE && ((NodeInfo)info).nodeLayers[0].layer.pureLayerNode == info) continue;
            Xml.PrimitiveNode pn = new Xml.PrimitiveNode();
            pn.name = ((NodeInfo)info).name;
            pn.function = ((NodeInfo)info).func;
            pn.shrinkArcs = ((NodeInfo)info).arcsShrink;
            pn.square = ((NodeInfo)info).square;
            pn.canBeZeroSize = ((NodeInfo)info).canBeZeroSize;
            pn.wipes = ((NodeInfo)info).wipes;
            pn.lockable = ((NodeInfo)info).lockable;
            pn.edgeSelect = ((NodeInfo)info).edgeSelect;
            pn.skipSizeInPalette = ((NodeInfo)info).skipSizeInPalette;
            pn.notUsed = ((NodeInfo)info).notUsed;
            pn.lowVt = ((NodeInfo)info).lowVt;
            pn.highVt = ((NodeInfo)info).highVt;
            pn.nativeBit = ((NodeInfo)info).nativeBit;
            pn.od18 = ((NodeInfo)info).od18;
            pn.od25 = ((NodeInfo)info).od25;
            pn.od33 = ((NodeInfo)info).od33;
            EPoint minFullSize = EPoint.fromLambda(0.5 * ((NodeInfo)info).xSize, 0.5 * ((NodeInfo)info).ySize);
            SizeOffset so = ((NodeInfo)info).so;
            if (so != null && so.getLowXOffset() == 0.0 && so.getHighXOffset() == 0.0 && so.getLowYOffset() == 0.0 && so.getHighYOffset() == 0.0) {
                so = null;
            }
            if (so != null) {
                EPoint p2 = EPoint.fromGrid(minFullSize.getGridX() - (so.getLowXGridOffset() + so.getHighXGridOffset() >> 1), minFullSize.getGridY() - (so.getLowYGridOffset() + so.getHighYGridOffset() >> 1));
                pn.diskOffset.put(1, minFullSize);
                pn.diskOffset.put(2, p2);
            } else {
                pn.diskOffset.put(2, minFullSize);
            }
            pn.sizeOffset = so;
            for (j = 0; j < ((NodeInfo)info).nodeLayers.length; ++j) {
                NodeInfo.LayerDetails nl = ((NodeInfo)info).nodeLayers[j];
                pn.nodeLayers.add(LibToTech.makeNodeLayerDetails(nl, false, minFullSize, true, true));
            }
            for (j = 0; j < ((NodeInfo)info).nodePortDetails.length; ++j) {
                NodeInfo.PortDetails pd = ((NodeInfo)info).nodePortDetails[j];
                Xml.PrimitivePort pp = new Xml.PrimitivePort();
                pp.name = pd.name;
                pp.portAngle = pd.angle;
                pp.portRange = pd.range;
                pp.portTopology = pd.netIndex;
                EdgeH left = pd.values[0].getX();
                EdgeH right = pd.values[1].getX();
                EdgeV bottom = pd.values[0].getY();
                EdgeV top = pd.values[1].getY();
                pp.lx.k = left.getMultiplier() * 2.0;
                pp.lx.value = left.getAdder() + minFullSize.getLambdaX() * left.getMultiplier() * 2.0;
                pp.hx.k = right.getMultiplier() * 2.0;
                pp.hx.value = right.getAdder() + minFullSize.getLambdaX() * right.getMultiplier() * 2.0;
                pp.ly.k = bottom.getMultiplier() * 2.0;
                pp.ly.value = bottom.getAdder() + minFullSize.getLambdaY() * bottom.getMultiplier() * 2.0;
                pp.hy.k = top.getMultiplier() * 2.0;
                pp.hy.value = top.getAdder() + minFullSize.getLambdaY() * top.getMultiplier() * 2.0;
                for (ArcInfo a : pd.connections) {
                    pp.portArcs.add(a.name);
                }
                pn.ports.add(pp);
            }
            pn.specialType = ((NodeInfo)info).specialType;
            if (pn.specialType == 1) {
                pn.specialValues = new double[6];
                for (int i = 0; i < 6; ++i) {
                    pn.specialValues[i] = ((NodeInfo)info).specialValues[i];
                }
            }
            pn.nodeSizeRule = ((NodeInfo)info).nodeSizeRule;
            t.nodes.add(pn);
        }
        LibToTech.addSpiceHeader(t, 1, gi.spiceLevel1Header);
        LibToTech.addSpiceHeader(t, 2, gi.spiceLevel2Header);
        LibToTech.addSpiceHeader(t, 3, gi.spiceLevel3Header);
        if (gi.menuPalette != null) {
            void var10_21;
            int numColumns;
            t.menuPalette = new Xml.MenuPalette();
            t.menuPalette.numColumns = numColumns = gi.menuPalette[0].length;
            Object[][] arr$ = gi.menuPalette;
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_21 < len$) {
                Object[] menuLine = arr$[var10_21];
                for (int i = 0; i < numColumns; ++i) {
                    t.menuPalette.menuBoxes.add(LibToTech.makeMenuBoxXml(t, menuLine[i]));
                }
                ++var10_21;
            }
        }
        Xml.Foundry foundry = new Xml.Foundry();
        foundry.name = gi.defaultFoundry;
        if (gi.conDist != null && gi.unConDist != null) {
            void var10_23;
            int layerTotal = lList.length;
            int ruleIndex = 0;
            boolean bl = false;
            while (var10_23 < layerTotal) {
                LayerInfo l1 = lList[var10_23];
                for (void i2 = var10_23; i2 < layerTotal; ++i2) {
                    LayerInfo l2 = lList[i2];
                    double conSpa = gi.conDist[ruleIndex];
                    double uConSpa = gi.unConDist[ruleIndex];
                    if (conSpa > -1.0) {
                        foundry.rules.add(LibToTech.makeDesignRule("C" + ruleIndex, l1, l2, DRCTemplate.DRCRuleType.CONSPA, conSpa));
                    }
                    if (uConSpa > -1.0) {
                        foundry.rules.add(LibToTech.makeDesignRule("U" + ruleIndex, l1, l2, DRCTemplate.DRCRuleType.UCONSPA, uConSpa));
                    }
                    ++ruleIndex;
                }
                ++var10_23;
            }
        }
        t.foundries.add(foundry);
        return t;
    }

    private static Xml.NodeLayer makeNodeLayerDetails(NodeInfo.LayerDetails nl, boolean isSerp, EPoint correction, boolean inLayers, boolean inElectricalLayers) {
        Xml.NodeLayer nld = new Xml.NodeLayer();
        nld.layer = nl.layer.name;
        nld.style = nl.style;
        nld.portNum = nl.portIndex;
        nld.inLayers = inLayers;
        nld.inElectricalLayers = inElectricalLayers;
        nld.representation = nl.representation;
        Technology.TechPoint[] points = nl.values;
        if (nld.representation == 1 || nld.representation == 3) {
            nld.lx.k = points[0].getX().getMultiplier() * 2.0;
            nld.lx.value = DBMath.round(points[0].getX().getAdder() + correction.getLambdaX() * points[0].getX().getMultiplier() * 2.0);
            nld.hx.k = points[1].getX().getMultiplier() * 2.0;
            nld.hx.value = DBMath.round(points[1].getX().getAdder() + correction.getLambdaX() * points[1].getX().getMultiplier() * 2.0);
            nld.ly.k = points[0].getY().getMultiplier() * 2.0;
            nld.ly.value = DBMath.round(points[0].getY().getAdder() + correction.getLambdaY() * points[0].getY().getMultiplier() * 2.0);
            nld.hy.k = points[1].getY().getMultiplier() * 2.0;
            nld.hy.value = DBMath.round(points[1].getY().getAdder() + correction.getLambdaY() * points[1].getY().getMultiplier() * 2.0);
        } else {
            for (Technology.TechPoint p : points) {
                nld.techPoints.add(LibToTech.correction(p, correction));
            }
        }
        nld.sizex = DBMath.round(nl.multiXS);
        nld.sizey = DBMath.round(nl.multiYS);
        nld.sep1d = DBMath.round(nl.multiSep);
        nld.sep2d = DBMath.round(nl.multiSep2D);
        if (isSerp) {
            nld.lWidth = DBMath.round(nl.lWidth);
            nld.rWidth = DBMath.round(nl.rWidth);
            nld.tExtent = DBMath.round(nl.extendT);
            nld.bExtent = DBMath.round(nl.extendB);
        }
        return nld;
    }

    private static Technology.TechPoint correction(Technology.TechPoint p, EPoint correction) {
        EdgeH h = p.getX();
        EdgeV v = p.getY();
        h = new EdgeH(h.getMultiplier(), h.getAdder() + correction.getLambdaX() * h.getMultiplier() * 2.0);
        v = new EdgeV(v.getMultiplier(), v.getAdder() + correction.getLambdaY() * v.getMultiplier() * 2.0);
        return new Technology.TechPoint(h, v);
    }

    private static void addSpiceHeader(Xml.Technology t, int level, String[] spiceLines) {
        if (spiceLines == null) {
            return;
        }
        Xml.SpiceHeader spiceHeader = new Xml.SpiceHeader();
        spiceHeader.level = level;
        for (String spiceLine : spiceLines) {
            spiceHeader.spiceLines.add(spiceLine);
        }
        t.spiceHeaders.add(spiceHeader);
    }

    private static ArrayList<Object> makeMenuBoxXml(Xml.Technology t, Object o) {
        ArrayList<Object> menuBox = new ArrayList<Object>();
        if (o instanceof ArcInfo) {
            menuBox.add(t.findArc(((ArcInfo)o).name));
        } else if (o instanceof NodeInfo) {
            menuBox.add(t.findNode(((NodeInfo)o).name));
        } else if (o != null) {
            menuBox.add(o.toString());
        }
        return menuBox;
    }

    private static DRCTemplate makeDesignRule(String ruleName, LayerInfo l1, LayerInfo l2, DRCTemplate.DRCRuleType type, double value) {
        return new DRCTemplate(ruleName, DRCTemplate.DRCMode.ALL.mode(), type, l1.name, l2.name, new double[]{value}, null);
    }

    private static class SampleCoordAscending
    implements Comparator<Sample> {
        private SampleCoordAscending() {
        }

        @Override
        public int compare(Sample s1, Sample s2) {
            if (s1.xPos != s2.xPos) {
                return (int)(s1.xPos - s2.xPos);
            }
            if (s1.yPos != s2.yPos) {
                return (int)(s1.yPos - s2.yPos);
            }
            return s1.node.getName().compareTo(s2.node.getName());
        }
    }

    private static class GenerateTechnology
    extends EDialog {
        private JLabel lab2;
        private JLabel lab3;
        private JTextField renameName;
        private JTextField newName;
        private JCheckBox alsoXML;

        private GenerateTechnology() {
            super((Frame)null, true);
        }

        @Override
        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            if (goodButton) {
                new TechFromLibJob(this.newName.getText(), this.alsoXML.isSelected());
            }
            this.dispose();
        }

        private void nameChanged() {
            String techName = this.newName.getText();
            if (Technology.findTechnology(techName) != null) {
                this.lab2.setEnabled(true);
                this.lab3.setEnabled(true);
                this.renameName.setEnabled(true);
                this.renameName.setEditable(true);
            } else {
                this.lab2.setEnabled(false);
                this.lab3.setEnabled(false);
                this.renameName.setEnabled(false);
                this.renameName.setEditable(false);
            }
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Convert Library to Technology");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    GenerateTechnology.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Creating new technology:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.newName = new JTextField(Library.getCurrent().getName());
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.newName, gbc);
            TechNameDocumentListener myDocumentListener = new TechNameDocumentListener(this);
            this.newName.getDocument().addDocumentListener(myDocumentListener);
            this.lab2 = new JLabel("Already a technology with this name");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.lab2, gbc);
            this.lab3 = new JLabel("Rename existing technology to:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.lab3, gbc);
            this.renameName = new JTextField();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.renameName, gbc);
            this.alsoXML = new JCheckBox("Also write XML code");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.alsoXML, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GenerateTechnology.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GenerateTechnology.this.exit(true);
                }
            });
            this.pack();
        }

        private static class TechNameDocumentListener
        implements DocumentListener {
            GenerateTechnology dialog;

            TechNameDocumentListener(GenerateTechnology dialog) {
                this.dialog = dialog;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.dialog.nameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.dialog.nameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.dialog.nameChanged();
            }
        }
    }

    private static class TechFromLibJob
    extends Job {
        private String newName;
        private String fileName;

        private TechFromLibJob(String newName, boolean alsoXML) {
            super("Make Technology from Technolog Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newName = newName;
            if (alsoXML) {
                this.fileName = OpenFile.chooseOutputFile(FileType.XML, "File for Technology's XML Code", newName + ".xml");
            }
            this.startJob();
        }

        @Override
        public boolean doIt() {
            LibToTech.makeTech(this.newName, this.fileName);
            return true;
        }
    }
}

