/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class ViewChanges {
    ViewChanges() {
    }

    public static void convertMultiPageViews() {
        ArrayList<Cell> multiPageCells = new ArrayList<Cell>();
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = lIt.next();
            if (lib.isHidden()) continue;
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                if (!cell.getView().getFullName().startsWith("schematic-page-")) continue;
                multiPageCells.add(cell);
            }
        }
        if (multiPageCells.size() == 0) {
            System.out.println("No old-style multi-page schematics to convert");
            return;
        }
        Collections.sort(multiPageCells);
        new FixOldMultiPageSchematics(multiPageCells, User.getAlignmentToGrid());
    }

    public static void changeCellView(Cell cell, View newView) {
        if (cell.getView() == newView) {
            return;
        }
        Iterator<Cell> it = cell.getLibrary().getCells();
        while (it.hasNext()) {
            Cell other = it.next();
            if (other.getView() != newView || !other.getName().equalsIgnoreCase(cell.getName())) continue;
            int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "There is already a cell with that view.  Is it okay to make it an older version, and make this the newest version?");
            if (response == 0) break;
            return;
        }
        new ChangeCellView(cell, newView);
    }

    public static void makeSkeletonViewCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        if (curCell.getView().isTextView()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot skeletonize textual views: only layout", "Skeleton creation failed", 0);
            return;
        }
        if (curCell.getView() != View.UNKNOWN && curCell.getView() != View.LAYOUT) {
            System.out.println("Warning: skeletonization only makes sense for layout cells, not " + curCell.getView().getFullName());
        }
        new MakeSkeletonView(curCell);
    }

    public static boolean skeletonizeCell(Cell curCell, Cell skeletonCell) {
        HashMap<Export, Export> newPortMap = new HashMap<Export, Export>();
        Iterator<PortProto> it = curCell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            PortOriginal fp = new PortOriginal(pp.getOriginalPort());
            PortInst bottomPort = fp.getBottomPort();
            NodeInst bottomNi = bottomPort.getNodeInst();
            PortProto bottomPp = bottomPort.getPortProto();
            AffineTransform subRot = fp.getTransformToTop();
            Orientation newOrient = fp.getOrientToTop();
            Point2D.Double center = new Point2D.Double(bottomNi.getAnchorCenterX(), bottomNi.getAnchorCenterY());
            subRot.transform(center, center);
            NodeInst newNi = NodeInst.makeInstance(bottomNi.getProto(), center, bottomNi.getXSize(), bottomNi.getYSize(), skeletonCell, newOrient, null, 0);
            if (newNi == null) {
                System.out.println("Cannot create node in this cell");
                return true;
            }
            PortInst newPi = newNi.findPortInstFromProto(bottomPp);
            Export npp = Export.newInstance(skeletonCell, newPi, pp.getName());
            if (npp == null) {
                System.out.println("Could not create port " + pp.getName());
                return true;
            }
            npp.copyTextDescriptorFrom(pp, Export.EXPORT_NAME);
            npp.copyVarsFrom(pp);
            npp.setCharacteristic(pp.getCharacteristic());
            newPortMap.put(pp, npp);
        }
        Netlist netlist = curCell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted skeletonization (network information unavailable).  Please try again");
            return true;
        }
        HashMap<Export, Network> netMap = new HashMap<Export, Network>();
        Iterator<Export> it2 = curCell.getExports();
        while (it2.hasNext()) {
            Export e = it2.next();
            Network net = netlist.getNetwork(e, 0);
            netMap.put(e, net);
        }
        int numPorts = curCell.getNumPorts();
        block2: for (int i = 0; i < numPorts; ++i) {
            Export pp = curCell.getPort(i);
            Network net = (Network)netMap.get(pp);
            for (int j = i + 1; j < numPorts; ++j) {
                Export oPp = curCell.getPort(j);
                Network oNet = (Network)netMap.get(oPp);
                if (net != oNet) continue;
                Export newPp = (Export)newPortMap.get(pp);
                Export newOPp = (Export)newPortMap.get(oPp);
                if (newPp == null || newOPp == null) continue;
                ArcProto univ = Generic.tech.universal_arc;
                ArcInst newAI = ArcInst.makeInstance(univ, newPp.getOriginalPort(), newOPp.getOriginalPort());
                if (newAI == null) {
                    System.out.println("Could not create connecting arc");
                    return true;
                }
                newAI.setFixedAngle(false);
                continue block2;
            }
        }
        Iterator<NodeInst> it3 = curCell.getNodes();
        while (it3.hasNext()) {
            NodeInst ni = it3.next();
            NodeProto np = ni.getProto();
            if (np != Generic.tech.essentialBoundsNode) continue;
            NodeInst newNi = NodeInst.makeInstance(np, ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), skeletonCell, ni.getOrient(), null, 0);
            if (newNi == null) {
                System.out.println("Cannot create node in this cell");
                return true;
            }
            newNi.setHardSelect();
            if (np != Generic.tech.cellCenterNode) continue;
            newNi.setVisInside();
        }
        ERectangle bounds = curCell.getBounds();
        NodeInst boundNi = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), skeletonCell);
        if (boundNi == null) {
            System.out.println("Cannot create boundary node");
            return true;
        }
        boundNi.setHardSelect();
        return false;
    }

    public static void makeIconViewCommand() {
        int response;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        if (!curCell.isSchematic()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "The current cell must be a schematic in order to generate an icon", "Icon creation failed", 0);
            return;
        }
        Cell iconCell = curCell.iconView();
        if (iconCell != null && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Warning: Icon " + iconCell.describe(true) + " already exists.  Create a new version?")) != 0) {
            return;
        }
        ViewChanges.makeIconViewNoGUI(curCell, false, false);
    }

    public static void makeIconViewNoGUI(Cell curCell, boolean doItNow, boolean fixedValues) {
        if (!fixedValues) {
            double leadLength = User.getIconGenLeadLength();
            double leadSpacing = User.getIconGenLeadSpacing();
            boolean reverseIconExportOrder = User.isIconGenReverseExportOrder();
            boolean drawBody = User.isIconGenDrawBody();
            boolean drawLeads = User.isIconGenDrawLeads();
            boolean placeCellCenter = User.isPlaceCellCenter();
            int exportTech = User.getIconGenExportTech();
            int exportStyle = User.getIconGenExportStyle();
            int exportLocation = User.getIconGenExportLocation();
            int inputSide = User.getIconGenInputSide();
            int outputSide = User.getIconGenOutputSide();
            int bidirSide = User.getIconGenBidirSide();
            int pwrSide = User.getIconGenPowerSide();
            int gndSide = User.getIconGenGroundSide();
            int clkSide = User.getIconGenClockSide();
            new MakeIconView(curCell, User.getAlignmentToGrid(), User.getIconGenInstanceLocation(), leadLength, leadSpacing, reverseIconExportOrder, drawBody, drawLeads, placeCellCenter, exportTech, exportStyle, exportLocation, inputSide, outputSide, bidirSide, pwrSide, gndSide, clkSide, doItNow);
        } else {
            boolean drawBodyAndLeads = Job.getDebug();
            new MakeIconView(curCell, 0.05, 0, 2.0, 2.0, false, drawBodyAndLeads, drawBodyAndLeads, true, 0, 1, 1, 0, 1, 2, 3, 3, 0, doItNow);
        }
    }

    public static Cell makeIconForCell(Cell curCell, double leadLength, double leadSpacing, boolean reverseIconExportOrder, boolean drawBody, boolean drawLeads, boolean placeCellCenter, int exportTech, int exportStyle, int exportLocation, int inputSide, int outputSide, int bidirSide, int pwrSide, int gndSide, int clkSide) throws JobException {
        ArrayList<Export> exportList = new ArrayList<Export>();
        Iterator<PortProto> it = curCell.getPorts();
        while (it.hasNext()) {
            exportList.add((Export)it.next());
        }
        if (reverseIconExportOrder) {
            Collections.reverse(exportList);
        }
        String iconCellName = curCell.getName() + "{ic}";
        Cell iconCell = Cell.makeInstance(curCell.getLibrary(), iconCellName);
        if (iconCell == null) {
            throw new JobException("Cannot create Icon cell " + iconCellName);
        }
        iconCell.setWantExpanded();
        int leftSide = 0;
        int rightSide = 0;
        int bottomSide = 0;
        int topSide = 0;
        HashMap<Export, Integer> portIndex = new HashMap<Export, Integer>();
        for (Export pp : exportList) {
            if (pp.isBodyOnly()) continue;
            int index = ViewChanges.iconPosition(pp, inputSide, outputSide, bidirSide, pwrSide, gndSide, clkSide);
            switch (index) {
                case 0: {
                    portIndex.put(pp, new Integer(leftSide++));
                    break;
                }
                case 1: {
                    portIndex.put(pp, new Integer(rightSide++));
                    break;
                }
                case 2: {
                    portIndex.put(pp, new Integer(topSide++));
                    break;
                }
                case 3: {
                    portIndex.put(pp, new Integer(bottomSide++));
                }
            }
        }
        double ySize = (double)Math.max(Math.max(leftSide, rightSide), 5) * leadSpacing;
        double xSize = (double)Math.max(Math.max(topSide, bottomSide), 3) * leadSpacing;
        NodeInst bbNi = null;
        if (drawBody) {
            bbNi = NodeInst.newInstance(Artwork.tech.openedThickerPolygonNode, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
            if (bbNi == null) {
                return null;
            }
            Point2D[] boxOutline = new EPoint[]{new EPoint(-xSize / 2.0, -ySize / 2.0), new EPoint(-xSize / 2.0, ySize / 2.0), new EPoint(xSize / 2.0, ySize / 2.0), new EPoint(xSize / 2.0, -ySize / 2.0), new EPoint(-xSize / 2.0, -ySize / 2.0)};
            bbNi.setTrace(boxOutline);
            bbNi.newDisplayVar(Schematics.SCHEM_FUNCTION, curCell.getName());
        }
        int total = 0;
        for (Export pp : exportList) {
            if (pp.isBodyOnly()) continue;
            Integer portPosition = (Integer)portIndex.get(pp);
            int index = ViewChanges.iconPosition(pp, inputSide, outputSide, bidirSide, pwrSide, gndSide, clkSide);
            double spacing = leadSpacing;
            double xPos = 0.0;
            double yPos = 0.0;
            double xBBPos = 0.0;
            double yBBPos = 0.0;
            switch (index) {
                case 0: {
                    xBBPos = -xSize / 2.0;
                    xPos = xBBPos - leadLength;
                    if (leftSide * 2 < rightSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(leftSide - 1) * spacing) / 2.0 + (double)portPosition.intValue() * spacing);
                    break;
                }
                case 1: {
                    xBBPos = xSize / 2.0;
                    xPos = xBBPos + leadLength;
                    if (rightSide * 2 < leftSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(rightSide - 1) * spacing) / 2.0 + (double)portPosition.intValue() * spacing);
                    break;
                }
                case 2: {
                    if (topSide * 2 < bottomSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(topSide - 1) * spacing) / 2.0 + (double)portPosition.intValue() * spacing);
                    yBBPos = ySize / 2.0;
                    yPos = yBBPos + leadLength;
                    break;
                }
                case 3: {
                    if (bottomSide * 2 < topSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(bottomSide - 1) * spacing) / 2.0 + (double)portPosition.intValue() * spacing);
                    yBBPos = -ySize / 2.0;
                    yPos = yBBPos - leadLength;
                }
            }
            if (!ViewChanges.makeIconExport(pp, index, xPos, yPos, xBBPos, yBBPos, iconCell, exportTech, drawLeads, exportStyle, exportLocation)) continue;
            ++total;
        }
        if (!drawBody && !drawLeads && placeCellCenter && total <= 1) {
            NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
        }
        return iconCell;
    }

    public static boolean makeIconExport(Export pp, int index, double xPos, double yPos, double xBBPos, double yBBPos, Cell np, int exportTech, boolean drawLeads, int exportStyle, int exportLocation) {
        NodeInst pinNi;
        PrimitiveNode pinType = Generic.tech.universalPinNode;
        double pinSizeX = 0.0;
        double pinSizeY = 0.0;
        if (exportTech != 0) {
            pinType = Schematics.tech.busPinNode;
            pinSizeX = pinType.getDefWidth();
            pinSizeY = pinType.getDefHeight();
        }
        ArcProto wireType = Schematics.tech.wire_arc;
        if (pp.getBasePort().connectsTo(Schematics.tech.bus_arc) && pp.getNameKey().isBus()) {
            wireType = Schematics.tech.bus_arc;
            pinType = Schematics.tech.busPinNode;
            pinSizeX = pinType.getDefWidth();
            pinSizeY = pinType.getDefHeight();
        }
        if (!drawLeads) {
            xPos = xBBPos;
            yPos = yBBPos;
        }
        if ((pinNi = NodeInst.newInstance(pinType, new Point2D.Double(xPos, yPos), pinSizeX, pinSizeY, np)) == null) {
            return false;
        }
        PortInst pi = pinNi.getOnlyPortInst();
        Export port = Export.newInstance(np, pi, pp.getName());
        if (port != null) {
            TextDescriptor td = port.getTextDescriptor(Export.EXPORT_NAME);
            block0 : switch (exportStyle) {
                case 0: {
                    td = td.withPos(AbstractTextDescriptor.Position.CENT);
                    break;
                }
                case 1: {
                    switch (index) {
                        case 0: {
                            td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                            break;
                        }
                        case 1: {
                            td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                            break;
                        }
                        case 2: {
                            td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                            break;
                        }
                        case 3: {
                            td = td.withPos(AbstractTextDescriptor.Position.UP);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (index) {
                        case 0: {
                            td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                            break block0;
                        }
                        case 1: {
                            td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                            break block0;
                        }
                        case 2: {
                            td = td.withPos(AbstractTextDescriptor.Position.UP);
                            break block0;
                        }
                        case 3: {
                            td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                        }
                    }
                }
            }
            port.setTextDescriptor(Export.EXPORT_NAME, td);
            double xOffset = 0.0;
            double yOffset = 0.0;
            int loc = exportLocation;
            if (!drawLeads) {
                loc = 0;
            }
            switch (loc) {
                case 0: {
                    xOffset = xBBPos - xPos;
                    yOffset = yBBPos - yPos;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    xOffset = (xPos + xBBPos) / 2.0 - xPos;
                    yOffset = (yPos + yBBPos) / 2.0 - yPos;
                }
            }
            port.setOff(Export.EXPORT_NAME, xOffset, yOffset);
            port.setAlwaysDrawn(pp.isAlwaysDrawn());
            port.setCharacteristic(pp.getCharacteristic());
            port.copyVarsFrom(pp);
        }
        if (drawLeads) {
            PortInst tail;
            PortInst head;
            ArcInst ai;
            double hei;
            double wid;
            NodeInst ni;
            pinType = wireType.findPinProto();
            if (pinType == Schematics.tech.busPinNode) {
                pinType = Generic.tech.invisiblePinNode;
            }
            if ((ni = NodeInst.newInstance(pinType, new Point2D.Double(xBBPos, yBBPos), wid = pinType.getDefWidth(), hei = pinType.getDefHeight(), np)) != null && (ai = ArcInst.makeInstance(wireType, head = ni.getOnlyPortInst(), tail = pinNi.getOnlyPortInst(), new Point2D.Double(xBBPos, yBBPos), new Point2D.Double(xPos, yPos), null)) != null && wireType == Schematics.tech.bus_arc) {
                ai.setHeadExtended(false);
                ai.setTailExtended(false);
            }
        }
        return true;
    }

    private static int iconPosition(Export pp, int inputSide, int outputSide, int bidirSide, int pwrSide, int gndSide, int clkSide) {
        PortCharacteristic character = pp.getCharacteristic();
        if (pp.isPower()) {
            character = PortCharacteristic.PWR;
        }
        if (pp.isGround()) {
            character = PortCharacteristic.GND;
        }
        if (character == PortCharacteristic.IN) {
            return inputSide;
        }
        if (character == PortCharacteristic.OUT) {
            return outputSide;
        }
        if (character == PortCharacteristic.BIDIR) {
            return bidirSide;
        }
        if (character == PortCharacteristic.PWR) {
            return pwrSide;
        }
        if (character == PortCharacteristic.GND) {
            return gndSide;
        }
        if (character.isClock()) {
            return clkSide;
        }
        return inputSide;
    }

    public static void makeSchematicView() {
        Cell oldCell = WindowFrame.needCurCell();
        if (oldCell == null) {
            return;
        }
        new MakeSchematicView(oldCell);
    }

    private static Cell convertSchematicCell(Cell oldCell) {
        Cell newCell = ViewChanges.makeNewCell(oldCell.getName(), View.SCHEMATIC, oldCell, null);
        if (newCell == null) {
            return null;
        }
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        ViewChanges.buildSchematicNodes(oldCell, newCell, newNodes);
        ViewChanges.buildSchematicArcs(oldCell, newCell, newNodes);
        Iterator<ArcInst> it = newCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            EPoint headPt = ai.getHeadLocation();
            EPoint tailPt = ai.getTailLocation();
            if (((Point2D)headPt).getX() == ((Point2D)tailPt).getX() && ((Point2D)headPt).getY() == ((Point2D)tailPt).getY() || GenMath.figureAngle(tailPt, headPt) % 450 != 0) continue;
            ai.setFixedAngle(true);
        }
        return newCell;
    }

    private static Cell makeNewCell(String newCellName, View newCellView, Cell cell, Library lib) {
        Cell newCell;
        String cellName = newCellName;
        if (newCellView.getAbbreviation().length() > 0) {
            cellName = newCellName + newCellView.getAbbreviationExtension();
        }
        if (lib == null) {
            lib = cell.getLibrary();
        }
        if ((newCell = Cell.makeInstance(lib, cellName)) == null) {
            System.out.println("Could not create cell: " + cellName);
        } else {
            System.out.println("Creating new cell: " + cellName);
        }
        return newCell;
    }

    private static void buildSchematicNodes(Cell cell, Cell newCell, HashMap<NodeInst, NodeInst> newNodes) {
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst mosNI = it.next();
            PrimitiveNode.Function type = ViewChanges.getNodeType(mosNI);
            NodeInst schemNI = null;
            if (type == PrimitiveNode.Function.UNKNOWN) continue;
            if (type == PrimitiveNode.Function.PIN) {
                PrimitiveNode prim = Schematics.tech.wirePinNode;
                schemNI = ViewChanges.makeSchematicNode(prim, mosNI, prim.getDefWidth(), prim.getDefHeight(), 0, 0, newCell);
            } else if (type == null) {
                Cell proto = (Cell)mosNI.getProto();
                Cell equivCell = proto.otherView(View.SCHEMATIC);
                if (equivCell == null) {
                    equivCell = ViewChanges.convertSchematicCell(proto);
                }
                schemNI = ViewChanges.makeSchematicNode(equivCell, mosNI, equivCell.getDefWidth(), equivCell.getDefHeight(), mosNI.getAngle(), 0, newCell);
            } else {
                int rotate = mosNI.getAngle();
                rotate = (rotate + 2700) % 3600;
                PrimitiveNode prim = Schematics.tech.transistorNode;
                int bits = Schematics.getPrimitiveFunctionBits(mosNI.getFunction());
                schemNI = ViewChanges.makeSchematicNode(prim, mosNI, prim.getDefWidth(), prim.getDefHeight(), rotate, bits, newCell);
                TransistorSize ts = mosNI.getTransistorSize(VarContext.globalContext);
                if (ts != null) {
                    if (mosNI.isFET()) {
                        TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withRelSize(0.5).withOff(-0.5, -1.0);
                        schemNI.newVar(Schematics.ATTR_LENGTH, (Object)new Double(ts.getDoubleLength()), td);
                        td = TextDescriptor.getNodeTextDescriptor().withRelSize(1.0).withOff(0.5, -1.0);
                        schemNI.newVar(Schematics.ATTR_WIDTH, (Object)new Double(ts.getDoubleWidth()), td);
                    } else {
                        schemNI.newVar(Schematics.ATTR_AREA, (Object)new Double(ts.getDoubleLength()));
                    }
                }
            }
            newNodes.put(mosNI, schemNI);
            if (schemNI == null) continue;
            Iterator<Export> eIt = mosNI.getExports();
            while (eIt.hasNext()) {
                Export schemPP;
                Export mosPP = eIt.next();
                PortInst schemPI = ViewChanges.convertPort(mosNI, mosPP.getOriginalPort().getPortProto(), schemNI);
                if (schemPI == null || (schemPP = Export.newInstance(newCell, schemPI, mosPP.getName())) == null) continue;
                schemPP.setCharacteristic(mosPP.getCharacteristic());
                schemPP.copyTextDescriptorFrom(mosPP, Export.EXPORT_NAME);
                schemPP.copyVarsFrom(mosPP);
            }
        }
    }

    private static NodeInst makeSchematicNode(NodeProto prim, NodeInst orig, double wid, double hei, int angle, int techSpecific, Cell newCell) {
        Point2D.Double newLoc = new Point2D.Double(orig.getAnchorCenterX(), orig.getAnchorCenterY());
        Orientation orient = Orientation.fromAngle(angle);
        NodeInst newNI = NodeInst.makeInstance(prim, newLoc, wid, hei, newCell, orient, null, techSpecific);
        return newNI;
    }

    private static void buildSchematicArcs(Cell cell, Cell newcell, HashMap<NodeInst, NodeInst> newNodes) {
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst schemAI;
            ArcInst mosAI = it.next();
            NodeInst mosHeadNI = mosAI.getHeadPortInst().getNodeInst();
            NodeInst mosTailNI = mosAI.getTailPortInst().getNodeInst();
            NodeInst schemHeadNI = newNodes.get(mosHeadNI);
            NodeInst schemTailNI = newNodes.get(mosTailNI);
            if (schemHeadNI == null || schemTailNI == null) continue;
            PortInst schemHeadPI = ViewChanges.convertPort(mosHeadNI, mosAI.getHeadPortInst().getPortProto(), schemHeadNI);
            PortInst schemTailPI = ViewChanges.convertPort(mosTailNI, mosAI.getTailPortInst().getPortProto(), schemTailNI);
            if (schemHeadPI == null || schemTailPI == null || (schemAI = ArcInst.makeInstanceBase(Schematics.tech.wire_arc, 0.0, schemHeadPI, schemTailPI, null, null, mosAI.getName())) == null) continue;
            schemAI.setFixedAngle(false);
            schemAI.setRigid(false);
        }
    }

    private static PortInst convertPort(NodeInst mosNI, PortProto mosPP, NodeInst schemNI) {
        PortProto pp;
        PrimitiveNode.Function fun = ViewChanges.getNodeType(schemNI);
        if (fun == PrimitiveNode.Function.PIN) {
            return schemNI.getOnlyPortInst();
        }
        if (fun == null) {
            PortProto schemPP = schemNI.getProto().findPortProto(mosPP.getName());
            if (schemPP == null) {
                return null;
            }
            return schemNI.findPortInstFromProto(schemPP);
        }
        int portNum = 1;
        Iterator<PortProto> it = mosNI.getProto().getPorts();
        while (it.hasNext() && (pp = it.next()) != mosPP) {
            ++portNum;
        }
        if (portNum == 4) {
            portNum = 3;
        } else if (portNum == 3) {
            portNum = 1;
        }
        it = schemNI.getProto().getPorts();
        while (it.hasNext()) {
            PortProto schemPP = it.next();
            if (--portNum > 0) continue;
            return schemNI.findPortInstFromProto(schemPP);
        }
        return null;
    }

    private static PrimitiveNode.Function getNodeType(NodeInst ni) {
        if (ni.isCellInstance()) {
            return null;
        }
        PrimitiveNode.Function fun = ni.getFunction();
        if (fun.isTransistor()) {
            return fun;
        }
        if (fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.SUBSTRATE || fun == PrimitiveNode.Function.WELL) {
            return PrimitiveNode.Function.PIN;
        }
        return PrimitiveNode.Function.UNKNOWN;
    }

    public static void makeLayoutView() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell oldCell = wnd.getCell();
        if (oldCell == null) {
            return;
        }
        VarContext context = wnd.getVarContext();
        if (context == null) {
            context = VarContext.globalContext;
        }
        Technology oldTech = oldCell.getTechnology();
        ArrayList<Technology> newTechs = new ArrayList<Technology>();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech == oldTech || !tech.isScaleRelevant()) continue;
            newTechs.add(tech);
        }
        Object[] techNames = new String[newTechs.size()];
        int i = 0;
        for (Technology tech : newTechs) {
            techNames[i++] = tech.getTechName();
        }
        String selectedValue = (String)JOptionPane.showInputDialog(null, "New technology to create", "Technology conversion", 1, null, techNames, User.getSchematicTechnology().getTechName());
        if (selectedValue == null) {
            return;
        }
        Technology newTech = Technology.findTechnology(selectedValue);
        if (newTech == null) {
            return;
        }
        if (newTech == oldTech) {
            System.out.println("Cell " + oldCell.describe(true) + " is already in the " + newTech.getTechName() + " technology");
            return;
        }
        String newLibName = Job.getUserInterface().askForInput("New library name for the converted cells (leave blank to place new cells in the current library):", "New Library Name", "");
        if (newLibName == null) {
            return;
        }
        new MakeLayoutView(oldCell, oldTech, newTech, context, newLibName);
    }

    private static class MakeLayoutView
    extends Job {
        private Cell oldCell;
        private Technology oldTech;
        private Technology newTech;
        private VarContext context;
        private String newLibName;
        private List<Cell> createdCells;

        protected MakeLayoutView(Cell oldCell, Technology oldTech, Technology newTech, VarContext context, String newLibName) {
            super("Make Alternate Layout", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.oldCell = oldCell;
            this.oldTech = oldTech;
            this.newTech = newTech;
            this.context = context;
            this.newLibName = newLibName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Library newLib = Library.getCurrent();
            if (this.newLibName.length() > 0 && (newLib = Library.findLibrary(this.newLibName)) == null) {
                newLib = Library.newInstance(this.newLibName, null);
            }
            this.createdCells = new ArrayList<Cell>();
            MakeLayoutVisitor visitor = new MakeLayoutVisitor(this.oldTech, this.newTech, this.oldCell.getLibrary(), this.createdCells, newLib);
            HierarchyEnumerator.enumerateCell(this.oldCell, this.context, visitor, true);
            this.fieldVariableChanged("createdCells");
            return true;
        }

        @Override
        public void terminateOK() {
            Cell showCell = null;
            Iterator<Cell> i$ = this.createdCells.iterator();
            while (i$.hasNext()) {
                Cell cell;
                showCell = cell = i$.next();
            }
            if (showCell != null) {
                WindowFrame.createEditWindow(showCell);
            }
        }

        private static class MakeLayoutVisitor
        extends HierarchyEnumerator.Visitor {
            private Technology oldTech;
            private Technology newTech;
            private Library defaultLib;
            private Map<Cell, Cell> convertedCells;
            private StdCellParams stdCell;
            private List<Cell> createdCells;
            private Library newLib;

            private MakeLayoutVisitor(Technology oldTech, Technology newTech, Library defaultLib, List<Cell> createdCells, Library newLib) {
                this.oldTech = oldTech;
                this.newTech = newTech;
                this.defaultLib = defaultLib;
                this.createdCells = createdCells;
                this.newLib = newLib;
                this.convertedCells = new HashMap<Cell, Cell>();
                TechType type = null;
                if (oldTech == Schematics.tech) {
                    if (newTech == Technology.findTechnology("MoCMOS")) {
                        type = TechType.MOCMOS;
                    } else if (newTech == Technology.findTechnology("TSMC180")) {
                        type = TechType.TSMC180;
                    } else if (newTech == Technology.findTechnology("CMOS90")) {
                        type = TechType.CMOS90;
                    }
                    Tech.setTechnology(type);
                    Technology cmos90 = Technology.getCMOS90Technology();
                    if (cmos90 != null && type == TechType.CMOS90) {
                        this.stdCell = GateLayoutGenerator.sportParams();
                    } else {
                        this.stdCell = GateLayoutGenerator.dividerParams(type);
                        if (type == null) {
                            this.stdCell = null;
                        }
                    }
                }
            }

            @Override
            public HierarchyEnumerator.CellInfo newCellInfo() {
                return new Info();
            }

            @Override
            public boolean enterCell(HierarchyEnumerator.CellInfo info) {
                Cell oldCell = info.getCell();
                VarContext context = info.getContext();
                Info myInfo = (Info)info;
                if (this.convertedCells.containsKey(oldCell)) {
                    return false;
                }
                if (this.stdCell != null) {
                    myInfo.generatedCells = GateLayoutGenerator.generateLayoutFromSchematics(oldCell.getLibrary(), oldCell, context, this.stdCell, true);
                }
                return true;
            }

            @Override
            public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
                Cell layCell = this.getLayoutCell(ni, (Info)info);
                return layCell == null;
            }

            private Cell getLayoutCell(Nodable no, Info myInfo) {
                if (!no.isCellInstance()) {
                    return null;
                }
                Cell layCell = null;
                Cell subCell = (Cell)no.getProto();
                layCell = (Cell)myInfo.generatedCells.get(no);
                if (layCell == null) {
                    layCell = this.convertedCells.get(subCell);
                }
                if (layCell == null && this.oldTech == Schematics.tech) {
                    Iterator<Cell> it = subCell.getCellGroup().getCells();
                    while (it.hasNext()) {
                        Cell c = it.next();
                        if (c.getView() != View.LAYOUT) continue;
                        layCell = c;
                        break;
                    }
                    if (layCell == null) {
                        String searchCellName = subCell.getName() + "{lay}";
                        layCell = this.defaultLib.findNodeProto(searchCellName);
                    }
                }
                if (layCell != null) {
                    this.convertedCells.put(subCell, layCell);
                }
                return layCell;
            }

            @Override
            public void exitCell(HierarchyEnumerator.CellInfo info) {
                Cell oldCell = info.getCell();
                String newCellName = oldCell.getName();
                Cell newCell = ViewChanges.makeNewCell(newCellName, View.LAYOUT, oldCell, this.newLib);
                if (newCell == null) {
                    return;
                }
                this.createdCells.add(newCell);
                HashMap connections = new HashMap();
                HashMap<Nodable, NodeInst> convertedNodes = new HashMap<Nodable, NodeInst>();
                PlacerGrid placer = new PlacerGrid();
                Iterator<Nodable> it = info.getNetlist().getNodables();
                while (it.hasNext()) {
                    Nodable no = it.next();
                    NodeProto np = null;
                    if (no.isCellInstance()) {
                        np = this.getLayoutCell(no, (Info)info);
                        if (np == null) {
                            System.out.println("Warning: Unable to find layout version of cell " + no.getProto().describe(false));
                        }
                    } else {
                        np = this.figureNewNodeProto(no.getNodeInst(), this.newTech);
                    }
                    if (np == null) continue;
                    if (this.oldTech != Schematics.tech) {
                        NodeInst newNi = this.placeLayoutNode(no, np, newCell, info.getContext());
                        convertedNodes.put(no, newNi);
                        continue;
                    }
                    if (np.getFunction() == PrimitiveNode.Function.PIN || np.getFunction() == PrimitiveNode.Function.CONNECT || no.getName().startsWith("fill") || no.getName().startsWith("tfill")) continue;
                    placer.insert(new Leaf(no, info.getContext(), np, newCell));
                    Iterator<PortProto> itp = no.getProto().getPorts();
                    while (itp.hasNext()) {
                        PortProto pp = itp.next();
                        Name ppname = pp.getNameKey();
                        for (int i = 0; i < ppname.busWidth(); ++i) {
                            Name subname = ppname.subname(i);
                            Conn conn = new Conn(no, pp, subname);
                            Network net = info.getNetlist().getNetwork(no, pp, i);
                            ArrayList<Conn> list = (ArrayList<Conn>)connections.get(net);
                            if (list == null) {
                                list = new ArrayList<Conn>();
                                connections.put(net, list);
                            }
                            boolean add = true;
                            for (Conn aconn : list) {
                                if (aconn.no != conn.no) continue;
                                add = false;
                                break;
                            }
                            if (!add) continue;
                            list.add(conn);
                        }
                    }
                }
                if (this.oldTech == Schematics.tech) {
                    placer.place(this, convertedNodes);
                    ArcProto ratArc = Generic.tech.unrouted_arc;
                    Iterator<Network> it2 = info.getNetlist().getNetworks();
                    while (it2.hasNext()) {
                        Network network = it2.next();
                        List list = (List)connections.get(network);
                        if (list == null || list.size() == 0) continue;
                        Conn conn = (Conn)list.get(0);
                        PortInst pi = this.getLayoutPortInst(conn, convertedNodes);
                        if (pi == null) {
                            System.out.println("Cannot find port " + conn.portName + " on " + conn.no.getName() + " in cell " + newCell.describe(false));
                            continue;
                        }
                        String exportName = null;
                        Export e = null;
                        if (network.isExported()) {
                            exportName = network.getName();
                            e = network.getExports().next();
                        }
                        for (int i = 1; i < list.size(); ++i) {
                            Conn nextConn = (Conn)list.get(i);
                            PortInst nextPi = this.getLayoutPortInst(nextConn, convertedNodes);
                            if (nextPi == null) {
                                System.out.println("Cannot find port " + nextConn.portName + " on " + nextConn.no.getName() + " in cell " + newCell.describe(false));
                                continue;
                            }
                            ArcInst newAi = ArcInst.makeInstanceBase(ratArc, 1.0, pi, nextPi, pi.getCenter(), nextPi.getCenter(), null);
                            if (newAi == null) {
                                System.out.println("Cell " + newCell.describe(true) + ": can't run " + ratArc + " from " + pi.getNodeInst() + " " + pi + " at (" + pi.getCenter().getX() + "," + pi.getCenter().getY() + ") to " + nextPi.getNodeInst() + " " + nextPi + " at (" + nextPi.getCenter().getX() + "," + nextPi.getCenter().getY() + ")");
                                continue;
                            }
                            newAi.setFixedAngle(false);
                            newAi.setRigid(false);
                            if (exportName == null || !nextPi.getPortProto().getName().equals(exportName)) continue;
                            Export pp2 = Export.newInstance(newCell, nextPi, exportName);
                            pp2.setCharacteristic(e.getCharacteristic());
                            pp2.copyTextDescriptorFrom(e, Export.EXPORT_NAME);
                            pp2.copyVarsFrom(e);
                            exportName = null;
                        }
                        if (exportName == null) continue;
                        Export pp2 = Export.newInstance(newCell, pi, exportName);
                        pp2.setCharacteristic(e.getCharacteristic());
                        pp2.copyTextDescriptorFrom(e, Export.EXPORT_NAME);
                        pp2.copyVarsFrom(e);
                        exportName = null;
                    }
                    this.convertedCells.put(oldCell, newCell);
                } else {
                    this.makeLayoutParts(oldCell, newCell, oldCell.getTechnology(), this.newTech, View.LAYOUT, this.convertedCells, convertedNodes);
                    this.convertedCells.put(oldCell, newCell);
                }
            }

            private PortInst getLayoutPortInst(Conn schConn, HashMap<Nodable, NodeInst> convertedNodes) {
                NodeInst layNi = convertedNodes.get(schConn.no);
                if (layNi == null) {
                    return null;
                }
                PortInst pi = layNi.findPortInst(schConn.portName.toString());
                if (pi != null) {
                    return pi;
                }
                int numNewPorts = layNi.getProto().getNumPorts();
                if (numNewPorts == 0) {
                    return null;
                }
                if (numNewPorts == 1) {
                    return layNi.getPortInst(0);
                }
                if (schConn.no.getNodeInst().getFunction().isTransistor()) {
                    if (schConn.portName.toString().equals("g")) {
                        return layNi.getPortInst(0);
                    }
                    if (schConn.portName.toString().equals("s")) {
                        return layNi.getPortInst(1);
                    }
                    if (schConn.portName.toString().equals("d")) {
                        return layNi.getPortInst(3);
                    }
                }
                for (int i = 0; i < schConn.no.getNodeInst().getNumPortInsts() && i < layNi.getNumPortInsts(); ++i) {
                    PortInst api = schConn.no.getNodeInst().getPortInst(i);
                    if (api.getPortProto() != schConn.pp) continue;
                    return layNi.getPortInst(i);
                }
                PrimitiveNode.Function oldFun = schConn.no.getNodeInst().getFunction();
                PrimitiveNode.Function newFun = layNi.getFunction();
                if (oldFun == PrimitiveNode.Function.CAPAC && newFun == PrimitiveNode.Function.ECAPAC) {
                    return layNi.getPortInst(0);
                }
                System.out.println("No port association between " + schConn.no.getName() + ", " + schConn.pp.getName() + " and " + layNi.getProto());
                return layNi.getPortInst(0);
            }

            private void makeLayoutParts(Cell oldCell, Cell newCell, Technology oldTech, Technology newTech, View nView, Map<Cell, Cell> convertedCells, Map<Nodable, NodeInst> convertedNodes) {
                Iterator<ArcInst> it = oldCell.getArcs();
                while (it.hasNext()) {
                    ArcInst newAi;
                    ArcInst ai = it.next();
                    NodeInst oldHeadNi = ai.getHeadPortInst().getNodeInst();
                    NodeInst oldTailNi = ai.getTailPortInst().getNodeInst();
                    NodeInst newHeadNi = convertedNodes.get(oldHeadNi);
                    NodeInst newTailNi = convertedNodes.get(oldTailNi);
                    if (newHeadNi == null || newTailNi == null) continue;
                    PortProto oldHeadPp = ai.getHeadPortInst().getPortProto();
                    PortProto oldTailPp = ai.getTailPortInst().getPortProto();
                    PortProto newHeadPp = this.convertPortName(oldHeadNi, newHeadNi, oldHeadPp.getNameKey());
                    PortProto newTailPp = this.convertPortName(oldTailNi, newTailNi, oldTailPp.getNameKey());
                    if (newHeadPp == null || newTailPp == null) continue;
                    ArcProto newAp = this.figureNewArcProto(ai.getProto(), newTech, newHeadPp, newTailPp);
                    boolean fixAng = ai.isFixedAngle();
                    double newWid = 0.0;
                    if (newAp == Generic.tech.universal_arc) {
                        fixAng = false;
                    } else {
                        double defwid = ai.getProto().getDefaultLambdaBaseWidth();
                        double curwid = ai.getLambdaBaseWidth();
                        newWid = newAp.getDefaultLambdaBaseWidth() * curwid / defwid;
                        if (!(newWid > 0.0)) {
                            newWid = newAp.getDefaultLambdaBaseWidth();
                        }
                    }
                    EPoint pHead = ai.getHeadLocation();
                    EPoint pTail = ai.getTailLocation();
                    PortInst newHeadPi = newHeadNi.findPortInstFromProto(newHeadPp);
                    PortInst newTailPi = newTailNi.findPortInstFromProto(newTailPp);
                    Poly newHeadPoly = newHeadPi.getPoly();
                    Poly newTailPoly = newTailPi.getPoly();
                    if (!newHeadPoly.contains(pHead) || !newTailPoly.contains(pTail)) {
                        if (!newHeadPoly.contains(pHead)) {
                            pHead = new EPoint(newHeadPoly.getCenterX(), newHeadPoly.getCenterY());
                        }
                        if (fixAng) {
                            Rectangle2D headBounds = newHeadPoly.getBounds2D();
                            Rectangle2D tailBounds = newTailPoly.getBounds2D();
                            Point2D[] newPoints = GenMath.arcconnects(ai.getAngle(), headBounds, tailBounds);
                            if (newPoints != null) {
                                pHead = new EPoint(newPoints[0].getX(), newPoints[0].getY());
                                pTail = new EPoint(newPoints[1].getX(), newPoints[1].getY());
                            }
                        }
                    }
                    if ((newAi = ArcInst.makeInstanceBase(newAp, newWid, newHeadPi, newTailPi, pHead, pTail, ai.getName())) == null) {
                        System.out.println("Cell " + newCell.describe(true) + ": can't run " + newAp + " from " + newHeadNi + " " + newHeadPp + " at (" + ((Point2D)pHead).getX() + "," + ((Point2D)pHead).getY() + ") to " + newTailNi + " " + newTailPp + " at (" + ((Point2D)pTail).getX() + "," + ((Point2D)pTail).getY() + ")");
                        continue;
                    }
                    newAi.copyPropertiesFrom(ai);
                    if (newAp != Generic.tech.universal_arc) continue;
                    ai.setFixedAngle(false);
                    ai.setRigid(false);
                }
            }

            private NodeProto figureNewNodeProto(NodeInst oldni, Technology newTech) {
                NodeProto oldNp = oldni.getProto();
                if (oldni.isCellInstance() || oldNp.getTechnology() == newTech) {
                    return oldNp;
                }
                PrimitiveNode.Function type = oldni.getFunction();
                if (oldni.getParent().getView() == View.SCHEMATIC && type.isTransistor()) {
                    Iterator<PrimitiveNode> it = newTech.getNodes();
                    while (it.hasNext()) {
                        PrimitiveNode node = it.next();
                        if (type != node.getFunction()) continue;
                        return node;
                    }
                }
                if (type == PrimitiveNode.Function.NODE) {
                    PrimitiveNode np = (PrimitiveNode)oldNp;
                    Technology.NodeLayer[] nodeLayers = np.getLayers();
                    Layer layer = nodeLayers[0].getLayer();
                    Layer.Function fun = layer.getFunction();
                    Iterator<PrimitiveNode> it = newTech.getNodes();
                    while (it.hasNext()) {
                        Technology.NodeLayer[] oNodeLayers;
                        Layer oLayer;
                        Layer.Function oFun;
                        PrimitiveNode oNp = it.next();
                        if (oNp.getFunction() != PrimitiveNode.Function.NODE || fun != (oFun = (oLayer = (oNodeLayers = oNp.getLayers())[0].getLayer()).getFunction())) continue;
                        return oNp;
                    }
                }
                int i = 0;
                PrimitiveNode rNp = null;
                Iterator<PrimitiveNode> it = newTech.getNodes();
                while (it.hasNext()) {
                    PrimitiveNode np = it.next();
                    if (np.getFunction() != type) continue;
                    rNp = np;
                    ++i;
                }
                if (i == 1) {
                    return rNp;
                }
                if (i > 1) {
                    PrimitiveNode pOldNp = (PrimitiveNode)oldNp;
                    PrimitivePort pOldPp = pOldNp.getPort(0);
                    ArcProto[] oldConnections = pOldPp.getConnections();
                    Iterator<PrimitiveNode> it2 = newTech.getNodes();
                    while (it2.hasNext()) {
                        PrimitiveNode pNewNp = it2.next();
                        if (pNewNp.getFunction() != type) continue;
                        PrimitivePort pNewPp = pNewNp.getPort(0);
                        ArcProto[] newConnections = pNewPp.getConnections();
                        boolean oldMatches = true;
                        for (int j = 0; j < oldConnections.length; ++j) {
                            ArcProto oap = oldConnections[j];
                            if (oap.getTechnology() == Generic.tech) continue;
                            boolean foundNew = false;
                            for (int k = 0; k < newConnections.length; ++k) {
                                ArcProto ap = newConnections[k];
                                if (ap.getTechnology() == Generic.tech || ap.getFunction() != oap.getFunction()) continue;
                                foundNew = true;
                                break;
                            }
                            if (foundNew) continue;
                            oldMatches = false;
                            break;
                        }
                        if (!oldMatches) continue;
                        rNp = pNewNp;
                        i = 1;
                        break;
                    }
                }
                return rNp;
            }

            private NodeInst placeLayoutNode(Nodable no, NodeProto newNp, Cell newCell, VarContext context) {
                NodeInst ni = no.getNodeInst();
                double newXSize = 0.0;
                double newYSize = 0.0;
                if (newNp instanceof PrimitiveNode) {
                    PrimitiveNode pNewNp = (PrimitiveNode)newNp;
                    PrimitiveNode pOldNp = (PrimitiveNode)ni.getProto();
                    newXSize = pNewNp.getDefWidth() + ni.getXSize() - pOldNp.getDefWidth();
                    newYSize = pNewNp.getDefHeight() + ni.getYSize() - pOldNp.getDefHeight();
                    if (no.getParent().getView() == View.SCHEMATIC && pNewNp.getFunction().isTransistor()) {
                        Variable length;
                        Variable width = no.getVar(Variable.newKey("ATTR_width"));
                        SizeOffset offset = newNp.getProtoSizeOffset();
                        if (width != null) {
                            newXSize = VarContext.objectToDouble(context.evalVar(width, no), newXSize);
                            newXSize = newXSize + offset.getHighXOffset() + offset.getLowXOffset();
                        }
                        if ((length = no.getVar(Variable.newKey("ATTR_length"))) != null) {
                            newYSize = VarContext.objectToDouble(context.evalVar(length, no), newYSize);
                            newYSize = newYSize + offset.getHighYOffset() + offset.getLowYOffset();
                        }
                    }
                } else {
                    Cell np = (Cell)newNp;
                    ERectangle bounds = np.getBounds();
                    newXSize = ((RectangularShape)bounds).getWidth();
                    newYSize = ((RectangularShape)bounds).getHeight();
                }
                NodeInst newNi = NodeInst.makeInstance(newNp, ni.getAnchorCenter(), newXSize, newYSize, newCell, ni.getOrient(), no.getName(), ni.getTechSpecific());
                if (newNi == null) {
                    System.out.println("Could not create " + newNp + " in " + newCell);
                    return null;
                }
                newNi.copyStateBits(ni);
                if (no.getParent().getView() != View.SCHEMATIC) {
                    newNi.copyVarsFrom(ni);
                }
                Iterator<Export> it = ni.getExports();
                while (it.hasNext()) {
                    Export e = it.next();
                    for (int i = 0; i < e.getNameKey().busWidth(); ++i) {
                        PortInst pi;
                        Export pp2;
                        Name portName = e.getOriginalPort().getPortProto().getNameKey().subname(i);
                        Name exportName = e.getNameKey().subname(i);
                        PortProto pp = this.convertPortName(ni, newNi, portName);
                        if (pp == null || (pp2 = Export.newInstance(newCell, pi = newNi.findPortInstFromProto(pp), exportName.toString())) == null) continue;
                        pp2.setCharacteristic(e.getCharacteristic());
                        pp2.copyTextDescriptorFrom(e, Export.EXPORT_NAME);
                        pp2.copyVarsFrom(e);
                    }
                }
                return newNi;
            }

            private ArcProto figureNewArcProto(ArcProto oldAp, Technology newTech, PortProto headPp, PortProto tailPp) {
                if (oldAp.getTechnology() == Generic.tech) {
                    return oldAp;
                }
                if (oldAp != Schematics.tech.wire_arc) {
                    ArcProto.Function type = oldAp.getFunction();
                    Iterator<ArcProto> it = newTech.getArcs();
                    while (it.hasNext()) {
                        ArcProto newAp = it.next();
                        if (newAp.getFunction() != type) continue;
                        return newAp;
                    }
                }
                HashSet<ArcProto> possibleArcs = new HashSet<ArcProto>();
                ArcProto[] headArcs = headPp.getBasePort().getConnections();
                ArcProto[] tailArcs = tailPp.getBasePort().getConnections();
                block1: for (int i = 0; i < headArcs.length; ++i) {
                    if (headArcs[i].getTechnology() == Generic.tech) continue;
                    for (int j = 0; j < tailArcs.length; ++j) {
                        if (tailArcs[j].getTechnology() == Generic.tech || headArcs[i] != tailArcs[j]) continue;
                        possibleArcs.add(headArcs[i]);
                        continue block1;
                    }
                }
                Iterator<ArcProto> it = newTech.getArcs();
                while (it.hasNext()) {
                    ArcProto ap = it.next();
                    if (!possibleArcs.contains(ap)) continue;
                    return ap;
                }
                System.out.println("No equivalent arc for " + oldAp);
                return Generic.tech.universal_arc;
            }

            private PortProto convertPortName(NodeInst ni, NodeInst newNi, Name portName) {
                if (newNi.isCellInstance()) {
                    PortProto pp = newNi.getProto().findPortProto(portName);
                    if (pp == null) {
                        System.out.println("Cannot find export " + portName + " in " + newNi.getProto());
                    }
                    return pp;
                }
                int numNewPorts = newNi.getProto().getNumPorts();
                if (numNewPorts == 0) {
                    return null;
                }
                if (numNewPorts == 1) {
                    return newNi.getProto().getPort(0);
                }
                PortProto pp = ni.getProto().findPortProto(portName);
                if (pp != null) {
                    int i = 0;
                    for (i = 0; i < ni.getProto().getNumPorts() && ni.getProto().getPort(i) != pp; ++i) {
                    }
                    if (i < ni.getProto().getNumPorts()) {
                        return newNi.getProto().getPort(i);
                    }
                }
                PrimitiveNode.Function oldFun = ni.getFunction();
                PrimitiveNode.Function newFun = newNi.getFunction();
                if (oldFun == PrimitiveNode.Function.CAPAC && newFun == PrimitiveNode.Function.ECAPAC) {
                    return newNi.getProto().getPort(0);
                }
                System.out.println("No port association between " + ni.getProto() + ", " + portName + " and " + newNi.getProto());
                return newNi.getProto().getPort(0);
            }

            private static class Leaf
            extends PlacerGrid {
                private Nodable schNo;
                private VarContext context;
                private NodeProto layNp;
                private NodeInst layNi;
                private Cell newCell;

                private Leaf(Nodable schNo, VarContext context, NodeProto layNp, Cell newCell) {
                    this.schNo = schNo;
                    this.layNp = layNp;
                    this.newCell = newCell;
                    this.context = context;
                }

                @Override
                protected Point2D getCenter(boolean lay) {
                    if (lay) {
                        return this.layNi.getAnchorCenter();
                    }
                    return this.schNo.getNodeInst().getAnchorCenter();
                }

                @Override
                protected PlacerGrid insert(Leaf node) {
                    PlacerGrid gridnode = new PlacerGrid();
                    gridnode.insert(this);
                    gridnode.insert(node);
                    return gridnode;
                }

                @Override
                protected Rectangle2D getLayBounds() {
                    assert (this.layNi != null);
                    return this.layNi.getBounds();
                }

                @Override
                protected Rectangle2D getSchBounds() {
                    return this.schNo.getNodeInst().getBounds();
                }

                @Override
                protected void place(MakeLayoutVisitor visitor, HashMap<Nodable, NodeInst> convertedNodes) {
                    this.layNi = visitor.placeLayoutNode(this.schNo, this.layNp, this.newCell, this.context);
                    convertedNodes.put(this.schNo, this.layNi);
                }

                @Override
                protected void move(double dx, double dy) {
                    this.layNi.modifyInstance(dx, dy, 0.0, 0.0, Orientation.IDENT);
                }

                @Override
                protected void print(int indent) {
                    this.prindent(indent);
                    System.out.println("node " + this.schNo.getName() + " at " + this.getCenter(false));
                }
            }

            private static class PlacerGrid {
                private Leaf node = null;
                private PlacerGrid aboveNode = null;
                private PlacerGrid belowNode = null;
                private PlacerGrid leftNode = null;
                private PlacerGrid rightNode = null;

                private PlacerGrid() {
                }

                protected PlacerGrid insert(Leaf leafnode) {
                    if (this.node == null) {
                        this.node = leafnode;
                        return this;
                    }
                    Location loc = PlacerGrid.getRelativeLocation(leafnode.getCenter(false), this.node.getCenter(false));
                    switch (loc) {
                        case ABOVE: {
                            if (this.aboveNode == null) {
                                this.aboveNode = leafnode;
                                break;
                            }
                            this.aboveNode = this.aboveNode.insert(leafnode);
                            break;
                        }
                        case BELOW: {
                            if (this.belowNode == null) {
                                this.belowNode = leafnode;
                                break;
                            }
                            this.belowNode = this.belowNode.insert(leafnode);
                            break;
                        }
                        case LEFT: {
                            if (this.leftNode == null) {
                                this.leftNode = leafnode;
                                break;
                            }
                            this.leftNode = this.leftNode.insert(leafnode);
                            break;
                        }
                        case RIGHT: {
                            this.rightNode = this.rightNode == null ? leafnode : this.rightNode.insert(leafnode);
                        }
                    }
                    return this;
                }

                private static Location getRelativeLocation(Point2D p, Point2D referenceP) {
                    double xDist = p.getX() - referenceP.getX();
                    double yDist = p.getY() - referenceP.getY();
                    if (Math.abs(xDist) >= Math.abs(yDist)) {
                        if (xDist < 0.0) {
                            return Location.LEFT;
                        }
                        return Location.RIGHT;
                    }
                    if (yDist < 0.0) {
                        return Location.BELOW;
                    }
                    return Location.ABOVE;
                }

                protected Point2D getCenter(boolean lay) {
                    Rectangle2D bounds = lay ? this.getLayBounds() : this.getSchBounds();
                    if (bounds == null) {
                        return null;
                    }
                    return new EPoint(bounds.getCenterX(), bounds.getCenterY());
                }

                protected Rectangle2D getLayBounds() {
                    if (this.node == null) {
                        return null;
                    }
                    Rectangle2D bounds = this.node.getLayBounds();
                    if (this.aboveNode != null) {
                        bounds = bounds.createUnion(this.aboveNode.getLayBounds());
                    }
                    if (this.belowNode != null) {
                        bounds = bounds.createUnion(this.belowNode.getLayBounds());
                    }
                    if (this.leftNode != null) {
                        bounds = bounds.createUnion(this.leftNode.getLayBounds());
                    }
                    if (this.rightNode != null) {
                        bounds = bounds.createUnion(this.rightNode.getLayBounds());
                    }
                    return bounds;
                }

                protected Rectangle2D getSchBounds() {
                    if (this.node == null) {
                        return null;
                    }
                    Rectangle2D bounds = this.node.getSchBounds();
                    if (this.aboveNode != null) {
                        bounds = bounds.createUnion(this.aboveNode.getSchBounds());
                    }
                    if (this.belowNode != null) {
                        bounds = bounds.createUnion(this.belowNode.getSchBounds());
                    }
                    if (this.leftNode != null) {
                        bounds = bounds.createUnion(this.leftNode.getSchBounds());
                    }
                    if (this.rightNode != null) {
                        bounds = bounds.createUnion(this.rightNode.getSchBounds());
                    }
                    return bounds;
                }

                protected void place(MakeLayoutVisitor visitor, HashMap<Nodable, NodeInst> convertedNodes) {
                    if (this.node == null) {
                        return;
                    }
                    this.node.place(visitor, convertedNodes);
                    if (this.aboveNode != null) {
                        this.placeRelative(this.aboveNode, this.node, Location.ABOVE, visitor, convertedNodes);
                    }
                    if (this.belowNode != null) {
                        this.placeRelative(this.belowNode, this.node, Location.BELOW, visitor, convertedNodes);
                    }
                    if (this.leftNode != null) {
                        this.placeRelative(this.leftNode, this.node, Location.LEFT, visitor, convertedNodes);
                    }
                    if (this.rightNode != null) {
                        this.placeRelative(this.rightNode, this.node, Location.RIGHT, visitor, convertedNodes);
                    }
                }

                private void placeRelative(PlacerGrid placeNode, PlacerGrid refNode, Location schRelLoc, MakeLayoutVisitor visitor, HashMap<Nodable, NodeInst> convertedNodes) {
                    placeNode.place(visitor, convertedNodes);
                    Location layRelLoc = PlacerGrid.getRelativeLocation(placeNode.getCenter(true), refNode.getCenter(true));
                    if (schRelLoc != layRelLoc || placeNode.getLayBounds().intersects(refNode.getLayBounds())) {
                        this.abut(placeNode, refNode, schRelLoc);
                    }
                }

                private void abut(PlacerGrid abutNode, PlacerGrid refNode, Location relativeLocation) {
                    double dx = 0.0;
                    double dy = 0.0;
                    Rectangle2D referenceBounds = refNode.getLayBounds();
                    Rectangle2D niBounds = abutNode.getLayBounds();
                    if (relativeLocation == Location.RIGHT) {
                        dx = referenceBounds.getMaxX() - niBounds.getMinX();
                    } else if (relativeLocation == Location.LEFT) {
                        dx = referenceBounds.getMinX() - niBounds.getMaxX();
                    } else if (relativeLocation == Location.ABOVE) {
                        dy = referenceBounds.getMaxY() - niBounds.getMinY();
                    } else if (relativeLocation == Location.BELOW) {
                        dy = referenceBounds.getMinY() - niBounds.getMaxY();
                    }
                    if (dx != 0.0 || dy != 0.0) {
                        abutNode.move(dx, dy);
                    }
                }

                protected void move(double dx, double dy) {
                    this.node.move(dx, dy);
                    if (this.aboveNode != null) {
                        this.aboveNode.move(dx, dy);
                    }
                    if (this.belowNode != null) {
                        this.belowNode.move(dx, dy);
                    }
                    if (this.leftNode != null) {
                        this.leftNode.move(dx, dy);
                    }
                    if (this.rightNode != null) {
                        this.rightNode.move(dx, dy);
                    }
                }

                protected void print(int indent) {
                }

                public void prindent(int ident) {
                    for (int i = 0; i < ident; ++i) {
                        System.out.print(" ");
                    }
                }

                public static enum Location {
                    RIGHT,
                    LEFT,
                    ABOVE,
                    BELOW;

                }
            }

            private static class Conn {
                private Nodable no;
                private PortProto pp;
                private Name portName;

                private Conn(Nodable no, PortProto pp, Name portName) {
                    this.no = no;
                    this.pp = pp;
                    this.portName = portName;
                }
            }
        }

        private static class Info
        extends HierarchyEnumerator.CellInfo {
            private Map<Nodable, Cell> generatedCells = new HashMap<Nodable, Cell>();
        }
    }

    private static class MakeSchematicView
    extends Job {
        private Cell oldCell;
        private Cell newCell;

        protected MakeSchematicView(Cell cell) {
            super("Make Schematic View", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.oldCell = cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.newCell = ViewChanges.convertSchematicCell(this.oldCell);
            if (this.newCell == null) {
                return false;
            }
            this.fieldVariableChanged("newCell");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.newCell != null) {
                System.out.println("Cell " + this.newCell.describe(true) + " created with a schematic representation of " + this.oldCell);
                WindowFrame.createEditWindow(this.newCell);
            }
        }
    }

    private static class MakeIconView
    extends Job {
        private Cell curCell;
        private double alignment;
        private int exampleLocation;
        private double leadLength;
        private double leadSpacing;
        private boolean reverseIconExportOrder;
        private boolean drawBody;
        private boolean drawLeads;
        private boolean placeCellCenter;
        private int exportTech;
        private int exportStyle;
        private int exportLocation;
        private int inputSide;
        private int outputSide;
        private int bidirSide;
        private int pwrSide;
        private int gndSide;
        private int clkSide;
        private NodeInst iconNode;
        private boolean doItNow;

        private MakeIconView(Cell cell, double alignment, int exampleLocation, double leadLength, double leadSpacing, boolean reverseIconExportOrder, boolean drawBody, boolean drawLeads, boolean placeCellCenter, int exportTech, int exportStyle, int exportLocation, int inputSide, int outputSide, int bidirSide, int pwrSide, int gndSide, int clkSide, boolean doItNow) {
            super("Make Icon View", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = cell;
            this.alignment = alignment;
            this.exampleLocation = exampleLocation;
            this.leadLength = leadLength;
            this.leadSpacing = leadSpacing;
            this.reverseIconExportOrder = reverseIconExportOrder;
            this.drawBody = drawBody;
            this.drawLeads = drawLeads;
            this.placeCellCenter = placeCellCenter;
            this.exportTech = exportTech;
            this.exportStyle = exportStyle;
            this.exportLocation = exportLocation;
            this.inputSide = inputSide;
            this.outputSide = outputSide;
            this.bidirSide = bidirSide;
            this.pwrSide = pwrSide;
            this.gndSide = gndSide;
            this.clkSide = clkSide;
            this.doItNow = doItNow;
            if (doItNow) {
                try {
                    this.doIt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() throws JobException {
            Cell iconCell = ViewChanges.makeIconForCell(this.curCell, this.leadLength, this.leadSpacing, this.reverseIconExportOrder, this.drawBody, this.drawLeads, this.placeCellCenter, this.exportTech, this.exportStyle, this.exportLocation, this.inputSide, this.outputSide, this.bidirSide, this.pwrSide, this.gndSide, this.clkSide);
            if (iconCell == null) {
                return false;
            }
            Point2D.Double iconPos = new Point2D.Double(0.0, 0.0);
            ERectangle cellBounds = this.curCell.getBounds();
            ERectangle iconBounds = iconCell.getBounds();
            double halfWidth = ((RectangularShape)iconBounds).getWidth() / 2.0;
            double halfHeight = ((RectangularShape)iconBounds).getHeight() / 2.0;
            switch (this.exampleLocation) {
                case 0: {
                    ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMaxX() + halfWidth, ((RectangularShape)cellBounds).getMaxY() + halfHeight);
                    break;
                }
                case 1: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, ((RectangularShape)cellBounds).getMaxY() + halfHeight);
                    break;
                }
                case 2: {
                    ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMaxX() + halfWidth, cellBounds.getMinY() - halfHeight);
                    break;
                }
                case 3: {
                    ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, cellBounds.getMinY() - halfHeight);
                }
            }
            DBMath.gridAlign(iconPos, this.alignment);
            double px = iconCell.getBounds().getWidth();
            double py = iconCell.getBounds().getHeight();
            this.iconNode = NodeInst.makeInstance(iconCell, iconPos, px, py, this.curCell);
            if (!this.doItNow) {
                this.fieldVariableChanged("iconNode");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            EditWindow wnd;
            if (this.iconNode != null && !this.doItNow && (wnd = EditWindow.getCurrent()) != null && wnd.getCell() == this.curCell) {
                Highlighter highlighter = wnd.getHighlighter();
                highlighter.clear();
                highlighter.addElectricObject(this.iconNode, this.curCell);
                highlighter.finished();
            }
        }
    }

    private static class MakeSkeletonView
    extends Job {
        private Cell curCell;
        private Cell skeletonCell;

        protected MakeSkeletonView(Cell curCell) {
            super("Make Skeleton View", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = curCell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            String skeletonCellName = this.curCell.getName() + "{lay.sk}";
            this.skeletonCell = Cell.makeInstance(this.curCell.getLibrary(), skeletonCellName);
            if (this.skeletonCell == null) {
                throw new JobException("Cannot create Skeleton cell " + skeletonCellName);
            }
            boolean error = ViewChanges.skeletonizeCell(this.curCell, this.skeletonCell);
            if (error) {
                this.skeletonCell = null;
            }
            this.fieldVariableChanged("skeletonCell");
            return !error;
        }

        @Override
        public void terminateOK() {
            if (this.skeletonCell != null) {
                System.out.println("Cell " + this.skeletonCell.describe(true) + " created with a skeletal representation of " + this.curCell);
                WindowFrame.createEditWindow(this.skeletonCell);
            }
        }
    }

    private static class ChangeCellView
    extends Job {
        private Cell cell;
        private View newView;
        private IdMapper idMapper;

        protected ChangeCellView(Cell cell, View newView) {
            super("Change View of " + cell + " to " + newView.getFullName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newView = newView;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EDatabase database = this.cell.getDatabase();
            this.idMapper = this.cell.setView(this.newView);
            this.fieldVariableChanged("idMapper");
            if (this.idMapper != null) {
                this.cell = this.idMapper.get(this.cell.getId()).inDatabase(database);
                this.cell.setTechnology(null);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            User.fixStaleCellReferences(this.idMapper);
            EditWindow.repaintAll();
        }
    }

    private static class FixOldMultiPageSchematics
    extends Job {
        private List<Cell> multiPageCells;
        private double alignment;

        protected FixOldMultiPageSchematics(List<Cell> multiPageCells, double alignment) {
            super("Repair old-style Multi-Page Schematics", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.multiPageCells = multiPageCells;
            this.alignment = alignment;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (Cell cell : this.multiPageCells) {
                int pageNo = TextUtils.atoi(cell.getView().getFullName().substring(15));
                String destCellName = cell.getName() + "{sch}";
                Cell destCell = cell.getLibrary().findNodeProto(destCellName);
                if (pageNo == 1 || destCell == null) {
                    destCell = Cell.makeInstance(cell.getLibrary(), destCellName);
                    if (destCell == null) {
                        System.out.println("Unable to create cell " + cell.getLibrary().getName() + ":" + destCellName);
                        return false;
                    }
                    destCell.setMultiPage(true);
                    destCell.newVar(User.FRAME_SIZE, (Object)"d");
                }
                double dY = (pageNo - 1) * 1000;
                ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                ArrayList<DisplayedText> textList = new ArrayList<DisplayedText>();
                Iterator<NodeInst> nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    geomList.add(nIt.next());
                }
                Iterator<ArcInst> aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    geomList.add(aIt.next());
                }
                Clipboard.copyListToCell(destCell, geomList, textList, null, null, new Point2D.Double(0.0, dY), true, true, this.alignment, null, null);
                Iterator<Variable> vIt = cell.getVariables();
                while (vIt.hasNext()) {
                    Variable var = vIt.next();
                    if (!var.isDisplay()) continue;
                    destCell.addVar(var.withOff(var.getXOff(), var.getYOff() + dY));
                }
                cell.kill();
            }
            return true;
        }
    }
}

