/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.IdManager;
import com.sun.electric.database.LibId;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.NetworkManager;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ActivityLogger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EDatabase {
    private static final Logger logger = Logger.getLogger("com.sun.electric.database");
    private static final String CLASS_NAME = EDatabase.class.getName();
    public static EDatabase theDatabase = new EDatabase(new IdManager());
    private final IdManager idManager;
    private final ArrayList<Library> linkedLibs = new ArrayList();
    final TreeMap<String, Library> libraries = new TreeMap(TextUtils.STRING_NUMBER_ORDER);
    final ArrayList<Cell> linkedCells = new ArrayList();
    private Snapshot snapshot;
    private boolean snapshotFresh;
    private boolean invariantsFailed;
    private final NetworkManager networkManager;
    private volatile Thread writingThread;
    private boolean canChanging;
    private boolean canUndoing;
    private Tool changingTool;

    public static EDatabase serverDatabase() {
        return theDatabase;
    }

    public static EDatabase clientDatabase() {
        return theDatabase;
    }

    public EDatabase(IdManager idManager) {
        this.idManager = idManager;
        this.setSnapshot(this.getInitialSnapshot(), true);
        this.networkManager = new NetworkManager(this);
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public Snapshot getInitialSnapshot() {
        return this.idManager.getInitialSnapshot();
    }

    public NetworkManager getNetworkManager() {
        return this.networkManager;
    }

    public Library getLib(LibId libId) {
        return this.getLib(libId.libIndex);
    }

    void addLib(Library lib) {
        int libIndex = lib.getId().libIndex;
        while (libIndex >= this.linkedLibs.size()) {
            this.linkedLibs.add(null);
        }
        Library oldLib = this.linkedLibs.set(libIndex, lib);
        assert (oldLib == null);
        this.libraries.put(lib.getName(), lib);
    }

    void removeLib(LibId libId) {
        Library oldLib = this.linkedLibs.set(libId.libIndex, null);
        while (!this.linkedLibs.isEmpty() && this.linkedLibs.get(this.linkedLibs.size() - 1) == null) {
            this.linkedLibs.remove(this.linkedLibs.size() - 1);
        }
        this.libraries.remove(oldLib.getName());
    }

    public Cell getCell(CellId cellId) {
        return this.getCell(cellId.cellIndex);
    }

    void addCell(Cell cell) {
        int cellIndex = cell.getCellIndex();
        while (cellIndex >= this.linkedCells.size()) {
            this.linkedCells.add(null);
        }
        Cell oldCell = this.linkedCells.set(cellIndex, cell);
        assert (oldCell == null);
    }

    void removeCell(CellId cellId) {
        Cell oldCell = this.linkedCells.set(cellId.cellIndex, null);
        assert (oldCell != null);
        while (!this.linkedCells.isEmpty() && this.linkedCells.get(this.linkedCells.size() - 1) == null) {
            this.linkedCells.remove(this.linkedCells.size() - 1);
        }
    }

    Library getLib(int libIndex) {
        return libIndex < this.linkedLibs.size() ? this.linkedLibs.get(libIndex) : null;
    }

    Cell getCell(int cellIndex) {
        return cellIndex < this.linkedCells.size() ? this.linkedCells.get(cellIndex) : null;
    }

    public void lock(boolean exclusive) {
        assert (this.writingThread == null);
        if (exclusive) {
            this.writingThread = Thread.currentThread();
        }
        this.canUndoing = false;
        this.canChanging = false;
    }

    public void unlock() {
        this.writingThread = null;
    }

    public void checkChanging() {
        if (Thread.currentThread() == this.writingThread && this.canChanging) {
            return;
        }
        IllegalStateException e = new IllegalStateException("Database changes are forbidden");
        logger.logp(Level.WARNING, CLASS_NAME, "checkChanging", e.getMessage(), e);
        throw e;
    }

    public void checkUndoing() {
        if (Thread.currentThread() == this.writingThread && this.canUndoing) {
            return;
        }
        IllegalStateException e = new IllegalStateException("Database undo is forbidden");
        logger.logp(Level.WARNING, CLASS_NAME, "checkUndoing", e.getMessage(), e);
        throw e;
    }

    public boolean canComputeBounds() {
        return Thread.currentThread() == this.writingThread && (this.canChanging || this.canUndoing);
    }

    public boolean canComputeNetlist() {
        return Thread.currentThread() == this.writingThread && (this.canChanging || this.canUndoing);
    }

    public void checkExamine() {
        if (this.writingThread == null || Thread.currentThread() == this.writingThread) {
            return;
        }
        IllegalStateException e = new IllegalStateException("Cuncurrent database examine");
        logger.logp(Level.FINE, CLASS_NAME, "checkExamine", e.getMessage(), e);
    }

    public void lowLevelBeginChanging(Tool changingTool) {
        if (Thread.currentThread() != this.writingThread) {
            this.checkChanging();
        }
        this.canChanging = true;
        this.changingTool = changingTool;
    }

    public void lowLevelEndChanging() {
        if (Thread.currentThread() != this.writingThread) {
            this.checkChanging();
        }
        this.changingTool = null;
        this.canChanging = false;
    }

    public void lowLevelSetCanUndoing(boolean b) {
        if (Thread.currentThread() != this.writingThread) {
            this.checkUndoing();
        }
        this.canUndoing = b;
    }

    public Set<Cell> findReferenceInCell(Library elib) {
        TreeSet<Cell> set = new TreeSet<Cell>();
        for (Library l : this.libraries.values()) {
            if (l == elib) continue;
            for (Cell cell : l.cells.values()) {
                cell.findReferenceInCell(elib, set);
            }
        }
        return set;
    }

    public Library findLibrary(String libName) {
        if (libName == null) {
            return null;
        }
        Library lib = this.libraries.get(libName);
        if (lib != null) {
            return lib;
        }
        for (Library l : this.libraries.values()) {
            if (!l.getName().equalsIgnoreCase(libName)) continue;
            return l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Library> getLibraries() {
        TreeMap<String, Library> treeMap = this.libraries;
        synchronized (treeMap) {
            ArrayList<Library> librariesCopy = new ArrayList<Library>(this.libraries.values());
            return librariesCopy.iterator();
        }
    }

    public int getNumLibraries() {
        return this.libraries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Library> getVisibleLibraries() {
        TreeMap<String, Library> treeMap = this.libraries;
        synchronized (treeMap) {
            ArrayList<Library> visibleLibraries = new ArrayList<Library>();
            for (Library lib : this.libraries.values()) {
                if (lib.isHidden()) continue;
                visibleLibraries.add(lib);
            }
            return visibleLibraries;
        }
    }

    void unfreshSnapshot() {
        this.checkChanging();
        this.snapshotFresh = false;
    }

    private synchronized void setSnapshot(Snapshot snapshot, boolean fresh) {
        this.snapshot = snapshot;
        this.snapshotFresh = fresh;
    }

    public synchronized Snapshot getFreshSnapshot() {
        return this.snapshotFresh ? this.snapshot : null;
    }

    public Snapshot backup() {
        if (this.snapshotFresh) {
            return this.snapshot;
        }
        if (!this.canComputeBounds()) {
            throw new IllegalStateException();
        }
        return this.doBackup();
    }

    public Snapshot backupUnsafe() {
        if (this.snapshotFresh || !this.canComputeBounds()) {
            return this.snapshot;
        }
        return this.doBackup();
    }

    private Snapshot doBackup() {
        boolean cellsChanged;
        LibraryBackup[] libBackups = new LibraryBackup[this.linkedLibs.size()];
        boolean libsChanged = libBackups.length != this.snapshot.libBackups.size();
        for (int libIndex = 0; libIndex < libBackups.length; ++libIndex) {
            LibraryBackup libBackup;
            Library lib = this.linkedLibs.get(libIndex);
            libBackups[libIndex] = libBackup = lib != null ? lib.backup() : null;
            libsChanged = libsChanged || this.snapshot.libBackups.get(libIndex) != libBackup;
        }
        if (!libsChanged) {
            libBackups = null;
        }
        CellBackup[] cellBackups = new CellBackup[this.linkedCells.size()];
        ERectangle[] cellBounds = new ERectangle[cellBackups.length];
        boolean cellBoundsChanged = cellsChanged = cellBackups.length != this.snapshot.cellBackups.size();
        for (int cellIndex = 0; cellIndex < cellBackups.length; ++cellIndex) {
            Cell cell = this.getCell(cellIndex);
            if (cell != null) {
                cellBackups[cellIndex] = cell.backup();
                cell.getMemoization();
                cellBounds[cellIndex] = cell.getBounds();
                cell.getTopology().getRTree();
            }
            cellsChanged = cellsChanged || cellBackups[cellIndex] != this.snapshot.getCell(cellIndex);
            cellBoundsChanged = cellBoundsChanged || cellBounds[cellIndex] != this.snapshot.getCellBounds(cellIndex);
        }
        if (!cellsChanged) {
            cellBackups = null;
        }
        if (!cellBoundsChanged) {
            cellBounds = null;
        }
        this.setSnapshot(this.snapshot.with(this.changingTool, cellBackups, cellBounds, libBackups), true);
        return this.snapshot;
    }

    public void recover(Snapshot snapshot) {
        long startTime = System.currentTimeMillis();
        this.setSnapshot(snapshot, false);
        this.recoverLibraries();
        this.recycleCells();
        BitSet recovered = new BitSet();
        for (CellBackup newBackup : snapshot.cellBackups) {
            if (newBackup == null) continue;
            this.recoverRecursively(newBackup.d.cellId, recovered);
        }
        for (Library lib : this.libraries.values()) {
            lib.collectCells();
        }
        this.recoverCellGroups();
        this.snapshotFresh = true;
        long endTime = System.currentTimeMillis();
        if (Job.getDebug()) {
            System.out.println("recover took: " + (endTime - startTime) + " msec");
            this.checkInvariants();
        }
    }

    private void recoverRecursively(CellId cellId, BitSet recovered) {
        int cellIndex = cellId.cellIndex;
        if (recovered.get(cellIndex)) {
            return;
        }
        CellBackup newBackup = this.snapshot.getCell(cellId);
        int numUsages = cellId.numUsagesIn();
        for (int i = 0; i < numUsages; ++i) {
            CellUsage u = cellId.getUsageIn(i);
            if (newBackup.getInstCount(u) <= 0) continue;
            this.recoverRecursively(u.protoId, recovered);
        }
        Cell cell = this.getCell(cellId);
        cell.recover(newBackup, this.snapshot.getCellBounds(cellId));
        recovered.set(cellIndex);
    }

    public void undo(Snapshot snapshot) {
        boolean cellGroupsChanged;
        long startTime = System.currentTimeMillis();
        Snapshot oldSnapshot = this.backup();
        if (oldSnapshot == snapshot) {
            return;
        }
        this.setSnapshot(snapshot, false);
        boolean bl = cellGroupsChanged = oldSnapshot.cellGroups != snapshot.cellGroups;
        if (oldSnapshot.libBackups != snapshot.libBackups) {
            this.recoverLibraries();
            cellGroupsChanged = true;
        }
        this.recycleCells();
        BitSet cellNamesChangedInLibrary = new BitSet();
        ImmutableArrayList<CellBackup> cellBackups = snapshot.cellBackups;
        if (oldSnapshot.cellBackups.size() == cellBackups.size()) {
            for (int cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
                CellBackup newBackup;
                CellBackup oldBackup = oldSnapshot.getCell(cellIndex);
                if (oldBackup == (newBackup = snapshot.getCell(cellIndex))) continue;
                if (oldBackup == null) {
                    cellNamesChangedInLibrary.set(newBackup.d.getLibId().libIndex);
                    assert (cellGroupsChanged);
                    continue;
                }
                if (newBackup != null) continue;
                cellNamesChangedInLibrary.set(oldBackup.d.getLibId().libIndex);
                assert (cellGroupsChanged);
            }
        } else {
            cellGroupsChanged = true;
            if (snapshot.libBackups.size() > 0) {
                cellNamesChangedInLibrary.set(0, snapshot.libBackups.size());
            }
        }
        BitSet updated = new BitSet();
        BitSet exportsModified = new BitSet();
        BitSet boundsModified = new BitSet();
        for (CellBackup newBackup : snapshot.cellBackups) {
            if (newBackup == null) continue;
            this.undoRecursively(oldSnapshot, newBackup.d.cellId, updated, exportsModified, boundsModified);
        }
        if (!cellNamesChangedInLibrary.isEmpty()) {
            for (Library lib : this.libraries.values()) {
                if (!cellNamesChangedInLibrary.get(lib.getId().libIndex)) continue;
                lib.collectCells();
            }
        }
        if (cellGroupsChanged) {
            this.recoverCellGroups();
        }
        this.snapshotFresh = true;
        long endTime = System.currentTimeMillis();
        if (Job.getDebug()) {
            System.out.println("undo took: " + (endTime - startTime) + " msec");
        }
    }

    private void undoRecursively(Snapshot oldSnapshot, CellId cellId, BitSet updated, BitSet exportsModified, BitSet boundsModified) {
        int cellIndex = cellId.cellIndex;
        if (updated.get(cellIndex)) {
            return;
        }
        CellBackup newBackup = this.snapshot.getCell(cellId);
        assert (cellId != null);
        boolean subCellsExportsModified = false;
        boolean subCellsBoundsModified = false;
        int numUsages = cellId.numUsagesIn();
        for (int i = 0; i < numUsages; ++i) {
            CellUsage u = cellId.getUsageIn(i);
            if (newBackup.getInstCount(u) <= 0) continue;
            this.undoRecursively(oldSnapshot, u.protoId, updated, exportsModified, boundsModified);
            int subCellIndex = u.protoId.cellIndex;
            if (exportsModified.get(subCellIndex)) {
                subCellsExportsModified = true;
            }
            if (!boundsModified.get(subCellIndex)) continue;
            subCellsBoundsModified = true;
        }
        Cell cell = this.getCell(cellId);
        CellBackup oldBackup = oldSnapshot.getCell(cellId);
        ERectangle oldBounds = oldSnapshot.getCellBounds(cellId);
        cell.undo(newBackup, this.snapshot.getCellBounds(cellId), subCellsExportsModified ? exportsModified : null, subCellsBoundsModified ? boundsModified : null);
        updated.set(cellIndex);
        if (oldBackup == null || !newBackup.sameExports(oldBackup)) {
            exportsModified.set(cellIndex);
        }
        if (oldBackup == null || this.snapshot.getCellBounds(cellId) != oldBounds) {
            boundsModified.set(cellIndex);
        }
    }

    private void recoverLibraries() {
        Library lib;
        LibraryBackup libBackup;
        int libIndex;
        while (this.linkedLibs.size() > this.snapshot.libBackups.size()) {
            Library lib2 = this.linkedLibs.remove(this.linkedLibs.size() - 1);
            if (lib2 == null) continue;
            lib2.cells.clear();
        }
        while (this.linkedLibs.size() < this.snapshot.libBackups.size()) {
            this.linkedLibs.add(null);
        }
        for (libIndex = 0; libIndex < this.snapshot.libBackups.size(); ++libIndex) {
            libBackup = (LibraryBackup)this.snapshot.libBackups.get(libIndex);
            lib = this.linkedLibs.get(libIndex);
            if (libBackup == null && lib != null) {
                this.linkedLibs.set(libIndex, null);
                continue;
            }
            if (libBackup == null || lib != null) continue;
            this.linkedLibs.set(libIndex, new Library(this, libBackup.d));
        }
        this.libraries.clear();
        for (libIndex = 0; libIndex < this.snapshot.libBackups.size(); ++libIndex) {
            libBackup = (LibraryBackup)this.snapshot.libBackups.get(libIndex);
            if (libBackup == null) continue;
            lib = this.linkedLibs.get(libIndex);
            lib.recover(libBackup);
            this.libraries.put(lib.getName(), lib);
        }
    }

    private void recycleCells() {
        ImmutableArrayList<CellBackup> cellBackups = this.snapshot.cellBackups;
        while (this.linkedCells.size() > cellBackups.size()) {
            this.linkedCells.remove(this.linkedCells.size() - 1);
        }
        while (this.linkedCells.size() < cellBackups.size()) {
            this.linkedCells.add(null);
        }
        for (int cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
            CellBackup newBackup = (CellBackup)cellBackups.get(cellIndex);
            Cell cell = this.linkedCells.get(cellIndex);
            if (newBackup == null) {
                if (cell == null) continue;
                this.linkedCells.set(cellIndex, null);
                continue;
            }
            if (cell != null) continue;
            this.linkedCells.set(cellIndex, new Cell(this, newBackup.d));
        }
    }

    private void recoverCellGroups() {
        ArrayList groups = new ArrayList();
        for (int cellIndex = 0; cellIndex < this.snapshot.cellBackups.size(); ++cellIndex) {
            CellBackup cellBackup = (CellBackup)this.snapshot.cellBackups.get(cellIndex);
            int cellGroupIndex = this.snapshot.cellGroups[cellIndex];
            if (cellBackup == null) continue;
            if (cellGroupIndex == groups.size()) {
                groups.add(new TreeSet());
            }
            Cell cell = this.getCell(cellIndex);
            assert (cell != null);
            ((TreeSet)groups.get(cellGroupIndex)).add(cell);
        }
        for (int i = 0; i < groups.size(); ++i) {
            new Cell.CellGroup((TreeSet)groups.get(i));
        }
    }

    public boolean checkInvariants() {
        try {
            long startTime = System.currentTimeMillis();
            this.idManager.checkInvariants();
            this.backup();
            this.snapshot.check();
            this.check();
            long endTime = System.currentTimeMillis();
            float finalTime = (float)(endTime - startTime) / 1000.0f;
            if (Job.getDebug()) {
                System.out.println("**** Check Invariants took " + finalTime + " seconds");
            }
            return true;
        }
        catch (Throwable e) {
            if (!this.invariantsFailed) {
                System.out.println("Exception checking database invariants");
                e.printStackTrace();
                ActivityLogger.logException(e);
                this.invariantsFailed = true;
            }
            return false;
        }
    }

    private void check() {
        if (this.snapshotFresh) {
            assert (this.linkedLibs.size() == this.snapshot.libBackups.size());
            assert (this.linkedCells.size() == this.snapshot.cellBackups.size());
        }
        for (int libIndex = 0; libIndex < this.linkedLibs.size(); ++libIndex) {
            Library lib = this.linkedLibs.get(libIndex);
            if (lib == null) {
                if (this.snapshotFresh) assert (this.snapshot.libBackups.get(libIndex) == null);
                continue;
            }
            assert (lib.getId() == this.getIdManager().getLibId(libIndex));
            assert (this.libraries.get(lib.getName()) == lib);
            lib.check();
            if (this.snapshotFresh) assert (lib.libBackupFresh && lib.backup == this.snapshot.libBackups.get(libIndex));
        }
        for (int cellIndex = 0; cellIndex < this.linkedCells.size(); ++cellIndex) {
            Cell cell = this.linkedCells.get(cellIndex);
            if (cell == null) {
                if (this.snapshotFresh) assert (this.snapshot.cellBackups.get(cellIndex) == null);
                continue;
            }
            CellId cellId = cell.getId();
            assert (cellId == this.idManager.getCellId(cellIndex));
            Library lib = cell.getLibrary();
            assert (lib.cells.get(cell.getCellName()) == cell);
            cell.check();
            if (!this.snapshotFresh) continue;
            assert (cell.cellBackupFresh);
            assert (cell.backup == this.snapshot.cellBackups.get(cellIndex));
            assert (cell.getBounds() == this.snapshot.getCellBounds(cellId));
        }
        TreeSet<String> libNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, Library> e : this.libraries.entrySet()) {
            String libName = e.getKey();
            Library lib = e.getValue();
            assert (libName == lib.getName());
            assert (this.linkedLibs.get(lib.getId().libIndex) == lib);
            assert (!libNames.contains(libName)) : "case insensitive " + libName;
            libNames.add(libName);
        }
        if (this.snapshotFresh) {
            HashMap<Cell.CellGroup, Integer> groupNums = new HashMap<Cell.CellGroup, Integer>();
            for (int i = 0; i < this.snapshot.cellBackups.size(); ++i) {
                CellBackup cellBackup = this.snapshot.getCell(i);
                if (cellBackup == null) {
                    assert (this.snapshot.cellGroups[i] == -1);
                    continue;
                }
                Cell cell = this.getCell(cellBackup.d.cellId);
                Cell.CellGroup cellGroup = cell.getCellGroup();
                Integer gn = (Integer)groupNums.get(cellGroup);
                if (gn == null) {
                    gn = groupNums.size();
                    groupNums.put(cellGroup, gn);
                }
                assert (this.snapshot.cellGroups[i] == gn);
            }
        }
    }

    public void checkFresh(Snapshot expectedSnapshot) {
        assert (this.snapshotFresh && this.snapshot == expectedSnapshot);
        this.check();
    }
}

