/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.CellUsage;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HierarchyEnumerator {
    private Visitor visitor;
    private boolean shortResistors;
    private boolean shortPolyResistors;
    private boolean shortSpiceAmmeters;
    private boolean caching;
    private int cellCnt = 0;
    private int instCnt = 0;
    private List<NetDescription> netIdToNetDesc = new ArrayList<NetDescription>();
    private HashMap<Cell, CellShorts> cellShortsMap = new HashMap();

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private HierarchyEnumerator() {
    }

    private CellShorts getShortened(Cell cell, Netlist netlist) {
        CellShorts shorts = this.cellShortsMap.get(cell);
        if (shorts != null) {
            return shorts;
        }
        shorts = new CellShorts(netlist);
        Library spiceParts = Library.findLibrary("spiceparts");
        Cell ammeterIcon = spiceParts == null ? null : spiceParts.findNodeProto("Ammeter{ic}");
        Iterator<Nodable> it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable ni = it.next();
            NodeProto np = ni.getProto();
            if (ni.isCellInstance() && !((Cell)np).isIcon()) {
                int i;
                Cell subCell = (Cell)np;
                CellShorts subShorts = this.getShortened(subCell, netlist.getNetlist(ni));
                Netlist subNetlist = netlist.getNetlist(ni);
                int[] externalIds = subShorts.externalIds;
                Arrays.fill(externalIds, -1);
                Global.Set gs = subNetlist.getGlobals();
                int numGlobals = gs.size();
                for (i = 0; i < numGlobals; ++i) {
                    Global g = gs.get(i);
                    Network net = netlist.getNetwork(ni, g);
                    Network subNet = subNetlist.getNetwork(g);
                    int extID = subShorts.net2id[subNet.getNetIndex()];
                    if (externalIds[extID] >= 0) {
                        shorts.connect(net.getNetIndex(), externalIds[extID]);
                        continue;
                    }
                    externalIds[extID] = net.getNetIndex();
                }
                int numPorts = subCell.getNumPorts();
                for (i = 0; i < numPorts; ++i) {
                    Export export = subCell.getPort(i);
                    int busWidth = subNetlist.getBusWidth(export);
                    for (int j = 0; j < busWidth; ++j) {
                        Network net = netlist.getNetwork(ni, export, j);
                        Network subNet = subNetlist.getNetwork(export, j);
                        int extID = subShorts.net2id[subNet.getNetIndex()];
                        if (externalIds[extID] >= 0) {
                            shorts.connect(net.getNetIndex(), externalIds[extID]);
                            continue;
                        }
                        externalIds[extID] = net.getNetIndex();
                    }
                }
                continue;
            }
            if (!ni.isCellInstance()) {
                PrimitiveNode.Function fun = ((NodeInst)ni).getFunction();
                if ((fun != PrimitiveNode.Function.RESIST || !this.shortResistors) && (fun != PrimitiveNode.Function.PRESIST || !this.shortPolyResistors)) continue;
                Network net0 = netlist.getNetwork(ni, np.getPort(0), 0);
                Network net1 = netlist.getNetwork(ni, np.getPort(1), 0);
                shorts.connect(net0.getNetIndex(), net1.getNetIndex());
                continue;
            }
            if (np != ammeterIcon || !this.shortSpiceAmmeters) continue;
            Network net0 = netlist.getNetwork(ni, np.getPort(0), 0);
            Network net1 = netlist.getNetwork(ni, np.getPort(1), 0);
            shorts.connect(net0.getNetIndex(), net1.getNetIndex());
        }
        shorts.fixup(netlist.getNumExternalNetworks());
        this.cellShortsMap.put(cell, shorts);
        return shorts;
    }

    private int nextNetID() {
        return this.netIdToNetDesc.size();
    }

    private int[] numberNets(Cell cell, Netlist netlist, int[][] portNdxToNetIDs, CellInfo info) {
        int numNets = netlist.getNumNetworks();
        CellShorts shorts = this.cellShortsMap.get(cell);
        int[] netNdxToNetID = new int[numNets];
        int baseId = this.nextNetID();
        Arrays.fill(shorts.externalIds, -1);
        if (portNdxToNetIDs != null) {
            int i;
            assert (portNdxToNetIDs.length == cell.getNumPorts() + 1);
            Global.Set globals = netlist.getGlobals();
            assert (portNdxToNetIDs[0].length == globals.size());
            for (i = 0; i < globals.size(); ++i) {
                Global global = globals.get(i);
                int netIndex = netlist.getNetwork(global).getNetIndex();
                shorts.externalIds[shorts.net2id[netIndex]] = portNdxToNetIDs[0][i];
            }
            int numPorts = cell.getNumPorts();
            for (i = 0; i < numPorts; ++i) {
                Export export = cell.getPort(i);
                int[] ids = portNdxToNetIDs[i + 1];
                assert (ids.length == export.getNameKey().busWidth());
                for (int j = 0; j < ids.length; ++j) {
                    int netIndex = netlist.getNetwork(export, j).getNetIndex();
                    shorts.externalIds[shorts.net2id[netIndex]] = ids[j];
                }
            }
            for (i = 0; i < shorts.externalIds.length; ++i) {
                assert (shorts.externalIds[i] >= 0);
            }
            baseId -= shorts.externalIds.length;
        }
        for (int i = 0; i < numNets; ++i) {
            int id;
            Network net = netlist.getNetwork(i);
            int localId = shorts.net2id[i];
            assert (baseId + localId <= this.nextNetID());
            if (baseId + localId == this.nextNetID()) {
                if (portNdxToNetIDs == null && localId < shorts.externalIds.length) {
                    shorts.externalIds[localId] = localId;
                }
                assert (this.nextNetID() == baseId + localId);
                this.netIdToNetDesc.add(new NetDescription(net, info));
            } else if (localId >= shorts.externalIds.length || portNdxToNetIDs == null) {
                int cmp;
                NetDescription nd = this.netIdToNetDesc.get(baseId + localId);
                int n = !net.isUsernamed() ? 1 : (cmp = nd.net.isUsernamed() ? 0 : -1);
                if (cmp == 0 && net.isExported() != nd.net.isExported()) {
                    int n2 = cmp = net.isExported() ? -1 : 1;
                }
                if (cmp == 0) {
                    cmp = TextUtils.STRING_NUMBER_ORDER.compare(net.getName(), nd.net.getName());
                }
                if (cmp < 0) {
                    nd.net = net;
                }
            }
            netNdxToNetID[i] = id = localId < shorts.externalIds.length ? shorts.externalIds[localId] : baseId + localId;
        }
        return netNdxToNetID;
    }

    private static int[] getGlobalNetIDs(Nodable no, Netlist netlist, int[] netNdxToNetID) {
        Global.Set gs = netlist.getNetlist(no).getGlobals();
        int[] netIDs = new int[gs.size()];
        for (int i = 0; i < gs.size(); ++i) {
            int netIndex = netlist.getNetwork(no, gs.get(i)).getNetIndex();
            int netID = netNdxToNetID[netIndex];
            HierarchyEnumerator.error(netID < 0, "no netID for net");
            netIDs[i] = netID;
        }
        return netIDs;
    }

    private static int[] getPortNetIDs(Nodable no, PortProto pp, Netlist netlist, int[] netNdxToNetID) {
        int busWidth = pp.getNameKey().busWidth();
        int[] netIDs = new int[busWidth];
        for (int j = 0; j < busWidth; ++j) {
            int netIndex = netlist.getNetwork(no, pp, j).getNetIndex();
            int netID = netNdxToNetID[netIndex];
            HierarchyEnumerator.error(netID < 0, "no netID for net");
            netIDs[j] = netID;
        }
        return netIDs;
    }

    private static int[][] buildPortMap(Netlist netlist, Nodable ni, int[] netNdxToNetID) {
        Cell cell = (Cell)ni.getProto();
        int numPorts = cell.getNumPorts();
        int[][] portNdxToNetIDs = new int[numPorts + 1][];
        portNdxToNetIDs[0] = HierarchyEnumerator.getGlobalNetIDs(ni, netlist, netNdxToNetID);
        for (int i = 0; i < numPorts; ++i) {
            Export pp = cell.getPort(i);
            portNdxToNetIDs[i + 1] = HierarchyEnumerator.getPortNetIDs(ni, pp, netlist, netNdxToNetID);
        }
        return portNdxToNetIDs;
    }

    private void enumerateCell(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[][] portNdxToNetIDs, AffineTransform xformToRoot, CellInfo parent) {
        CellInfo info = this.visitor.newCellInfo();
        int firstNetID = this.nextNetID();
        int[] netNdxToNetID = this.numberNets(cell, netlist, portNdxToNetIDs, info);
        int lastNetIDPlusOne = this.nextNetID();
        ++this.cellCnt;
        info.init(parentInst, cell, this.cellShortsMap.get(cell), context, netlist, netNdxToNetID, portNdxToNetIDs, xformToRoot, this.netIdToNetDesc, parent);
        boolean enumInsts = this.visitor.enterCell(info);
        if (!enumInsts) {
            return;
        }
        Iterator<Nodable> it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable ni = it.next();
            ++this.instCnt;
            boolean descend = this.visitor.visitNodeInst(ni, info);
            NodeProto np = ni.getProto();
            if (!descend || !ni.isCellInstance() || ((Cell)np).isIcon()) continue;
            int[][] portNmToNetIDs2 = HierarchyEnumerator.buildPortMap(netlist, ni, netNdxToNetID);
            AffineTransform xformToRoot2 = xformToRoot;
            if (ni instanceof NodeInst) {
                xformToRoot2 = new AffineTransform(xformToRoot);
                xformToRoot2.concatenate(((NodeInst)ni).rotateOut());
                xformToRoot2.concatenate(((NodeInst)ni).translateOut());
            }
            this.enumerateCell(ni, (Cell)np, this.caching ? context.pushCaching(ni) : context.push(ni), netlist.getNetlist(ni), portNmToNetIDs2, xformToRoot2, info);
        }
        this.visitor.exitCell(info);
        context.deleteVariableCache();
        for (int i = firstNetID; i < lastNetIDPlusOne; ++i) {
            this.netIdToNetDesc.set(i, null);
        }
    }

    private void doIt(Cell root, VarContext context, Netlist netlist, Visitor visitor, boolean shortResistors, boolean shortPolyResistors, boolean shortSpiceAmmeters, boolean cache) {
        this.visitor = visitor;
        this.shortResistors = shortResistors;
        this.shortPolyResistors = shortPolyResistors;
        this.shortSpiceAmmeters = shortSpiceAmmeters;
        this.caching = cache;
        if (context == null) {
            context = VarContext.globalContext;
        }
        int[][] exportNdxToNetIDs = null;
        this.getShortened(root, netlist);
        this.enumerateCell(null, root, context, netlist, exportNdxToNetIDs, new AffineTransform(), null);
    }

    public static void enumerateCell(Cell root, VarContext context, Visitor visitor) {
        HierarchyEnumerator.enumerateCell(root, context, visitor, false);
    }

    public static void enumerateCell(Cell root, VarContext context, Visitor visitor, boolean shorten) {
        HierarchyEnumerator.enumerateCell(root, context, visitor, shorten, shorten, shorten, false);
    }

    public static void enumerateCell(Cell root, VarContext context, Visitor visitor, boolean shortResistors, boolean shortPolyResistors, boolean shortSpiceAmmeters, boolean caching) {
        Netlist netlist = NetworkTool.getNetlist(root, shortResistors & shortPolyResistors);
        new HierarchyEnumerator().doIt(root, context, netlist, visitor, shortResistors, shortPolyResistors, shortSpiceAmmeters, caching);
    }

    public static int getNumUniqueChildCells(Cell cell) {
        HashMap<Cell, Cell> uniqueChildCells = new HashMap<Cell, Cell>();
        HierarchyEnumerator.hierCellsRecurse(cell, uniqueChildCells);
        return uniqueChildCells.size();
    }

    private static void hierCellsRecurse(Cell cell, HashMap<Cell, Cell> uniqueCells) {
        Iterator<CellUsage> uit = cell.getUsagesIn();
        while (uit.hasNext()) {
            CellUsage u = uit.next();
            Cell subCell = u.getProto();
            if (subCell.isIcon()) continue;
            uniqueCells.put(subCell, subCell);
            HierarchyEnumerator.hierCellsRecurse(subCell, uniqueCells);
        }
    }

    public static Network getNetworkInChild(Network parentNet, Nodable childNodable) {
        if (childNodable == null || parentNet == null) {
            return null;
        }
        if (!childNodable.isCellInstance()) {
            return null;
        }
        Cell childCell = (Cell)childNodable.getProto();
        Netlist parentNetlist = parentNet.getNetlist();
        Netlist childNetlist = parentNetlist.getNetlist(childNodable);
        PortProto pp = null;
        int i = 0;
        boolean found = false;
        NodeInst ni = childNodable.getNodeInst();
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            pp = pi.getPortProto();
            for (i = 0; i < pp.getNameKey().busWidth(); ++i) {
                Network net = parentNetlist.getNetwork(childNodable, pp, i);
                if (net != parentNet) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            return null;
        }
        if (childCell.contentsView() != null) {
            childCell = childCell.contentsView();
        }
        Export export = childCell.findExport(pp.getNameKey());
        Network childNet = childNetlist.getNetwork(export, i);
        return childNet;
    }

    public static boolean searchNetworkInParent(Network net, CellInfo info, Network visitorNet) {
        if (visitorNet == net) {
            return true;
        }
        CellInfo cinfo = info;
        while (net != null && cinfo.getParentInst() != null) {
            if (visitorNet == (net = cinfo.getNetworkInParent(net))) {
                return true;
            }
            cinfo = cinfo.getParentInfo();
        }
        return false;
    }

    public static boolean searchInExportNetwork(Network net, CellInfo info, Network visitorNet) {
        boolean found = false;
        Iterator<Export> it = net.getExports();
        while (!found && it.hasNext()) {
            Export exp = it.next();
            Network tmpNet = info.getNetlist().getNetwork(exp, 0);
            found = HierarchyEnumerator.searchNetworkInParent(tmpNet, info, visitorNet);
        }
        return found;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellInfo {
        private Nodable parentInst;
        private Cell cell;
        private CellShorts shorts;
        private VarContext context;
        private Netlist netlist;
        private int[] netNdxToNetID;
        private int[][] exportNdxToNetIDs;
        private AffineTransform xformToRoot;
        private List<NetDescription> netIdToNetDesc;
        private CellInfo parentInfo;

        void init(Nodable parentInst, Cell cell, CellShorts shorts, VarContext context, Netlist netlist, int[] netToNetID, int[][] exportNdxToNetIDs, AffineTransform xformToRoot, List<NetDescription> netIdToNetDesc, CellInfo parentInfo) {
            this.parentInst = parentInst;
            this.cell = cell;
            this.shorts = shorts;
            this.context = context;
            this.netlist = netlist;
            this.netNdxToNetID = netToNetID;
            this.exportNdxToNetIDs = exportNdxToNetIDs;
            this.xformToRoot = xformToRoot;
            this.netIdToNetDesc = netIdToNetDesc;
            this.parentInfo = parentInfo;
        }

        public final Cell getCell() {
            return this.cell;
        }

        public final boolean isRootCell() {
            return this.parentInfo == null;
        }

        public final VarContext getContext() {
            return this.context;
        }

        public final Netlist getNetlist() {
            return this.netlist;
        }

        public final CellInfo getParentInfo() {
            return this.parentInfo;
        }

        public final Nodable getParentInst() {
            return this.parentInst;
        }

        public final CellInfo getRootInfo() {
            CellInfo i = this;
            while (i.getParentInfo() != null) {
                i = i.getParentInfo();
            }
            return i;
        }

        public final int[] getExportNetIDs(Export e) {
            if (this.isRootCell()) {
                int width = this.netlist.getBusWidth(e);
                int[] netIDs = new int[width];
                for (int i = 0; i < width; ++i) {
                    netIDs[i] = this.shorts.net2id[this.netlist.getNetwork(e, i).getNetIndex()];
                }
                return netIDs;
            }
            return this.exportNdxToNetIDs[e.getPortIndex() + 1];
        }

        public final int getNetID(Network net) {
            return this.getNetID(net.getNetIndex());
        }

        private int getNetID(int netIndex) {
            return this.netNdxToNetID[netIndex];
        }

        public final int[] getPortNetIDs(Nodable no, PortProto pp) {
            return HierarchyEnumerator.getPortNetIDs(no, pp, this.netlist, this.netNdxToNetID);
        }

        public final String getUniqueNetName(Network net, String sep) {
            NetNameProxy proxy = this.getUniqueNetNameProxy(net, sep);
            return proxy.toString();
        }

        public final NetNameProxy getUniqueNetNameProxy(Network net, String sep) {
            return this.getUniqueNetNameProxy(this.getNetID(net), sep);
        }

        public final String getUniqueNetName(int netID, String sep) {
            NetNameProxy proxy = this.getUniqueNetNameProxy(netID, sep);
            return proxy.toString();
        }

        public final NetNameProxy getUniqueNetNameProxy(int netID, String sep) {
            NetDescription ns = this.netIdToNetDesc.get(netID);
            VarContext netContext = ns.getCellInfo().getContext();
            return new NetNameProxy(netContext, sep, ns.getNet());
        }

        public final String getUniqueNodableName(Nodable no, String sep) {
            return this.getUniqueNodableNameProxy(no, sep).toString();
        }

        public final NodableNameProxy getUniqueNodableNameProxy(Nodable no, String sep) {
            return new NodableNameProxy(this.getContext(), sep, no);
        }

        public final NetDescription netIdToNetDescription(int netID) {
            return this.netIdToNetDesc.get(netID);
        }

        public Network getNetworkInParent(Network network) {
            if (this.parentInfo == null) {
                return null;
            }
            if (network == null) {
                return null;
            }
            if (network.getNetlist() != this.netlist) {
                return null;
            }
            boolean found = false;
            Export export = null;
            int i = 0;
            Iterator<Export> it = this.cell.getExports();
            while (it.hasNext()) {
                export = it.next();
                for (i = 0; i < export.getNameKey().busWidth(); ++i) {
                    Network net = this.netlist.getNetwork(export, i);
                    if (net != network) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (found) {
                Nodable no = this.context.getNodable();
                PortProto pp = no.getProto().findPortProto(export.getNameKey());
                Network parentNet = this.parentInfo.getNetlist().getNetwork(no, pp, i);
                return parentNet;
            }
            Global.Set globals = this.netlist.getGlobals();
            for (i = 0; i < globals.size(); ++i) {
                Global global = globals.get(i);
                if (this.netlist.getNetwork(global) != network) continue;
                return this.parentInfo.getNetlist().getNetwork(global);
            }
            return null;
        }

        public AffineTransform getTransformToRoot() {
            return this.xformToRoot;
        }
    }

    public static class NetDescription {
        private Network net;
        private CellInfo info;

        NetDescription(Network net, CellInfo info) {
            this.net = net;
            this.info = info;
        }

        public Network getNet() {
            return this.net;
        }

        public CellInfo getCellInfo() {
            return this.info;
        }
    }

    public static abstract class Visitor {
        public CellInfo newCellInfo() {
            return new CellInfo();
        }

        public abstract boolean enterCell(CellInfo var1);

        public abstract void exitCell(CellInfo var1);

        public abstract boolean visitNodeInst(Nodable var1, CellInfo var2);
    }

    private static class CellShorts {
        int totalIds;
        int[] net2id;
        int[] externalIds;

        private CellShorts(Netlist netlist) {
            int numNets = netlist.getNumNetworks();
            this.net2id = new int[numNets];
            for (int i = 0; i < numNets; ++i) {
                this.net2id[i] = i;
            }
        }

        private void connect(int netIndex1, int netIndex2) {
            Netlist.connectMap(this.net2id, netIndex1, netIndex2);
        }

        private void fixup(int numExternalsInMap) {
            int numExternals = 0;
            for (int i = 0; i < this.net2id.length; ++i) {
                int id = this.net2id[i];
                assert (id <= i);
                if (id < i) {
                    this.net2id[i] = this.net2id[id];
                    continue;
                }
                ++this.totalIds;
                if (i >= numExternalsInMap) continue;
                ++numExternals;
            }
            this.externalIds = new int[numExternals];
        }
    }

    public static class NodableNameProxy
    extends NameProxy {
        static final long serialVersionUID = 0L;
        private Nodable nodable;

        public String leafName() {
            return this.nodable.getName();
        }

        public NodableNameProxy(VarContext context, String sep, Nodable node) {
            super(context, sep);
            this.nodable = node;
        }

        public Cell leafCell() {
            return this.nodable.getParent();
        }

        public Nodable getNodable() {
            return this.nodable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetNameProxy
    extends NameProxy {
        static final long serialVersionUID = 0L;
        private Network net;

        @Override
        public String leafName() {
            Iterator<String> it = this.net.getNames();
            if (it.hasNext()) {
                return it.next();
            }
            return "netIndex" + this.net.getNetIndex();
        }

        public Iterator<String> leafNames() {
            return this.net.getNames();
        }

        public NetNameProxy(VarContext context, String sep, Network net) {
            super(context, sep);
            this.net = net;
        }

        @Override
        public Cell leafCell() {
            return this.net.getParent();
        }

        public Network getNet() {
            return this.net;
        }
    }

    public static abstract class NameProxy
    implements Serializable {
        private VarContext context;
        private String sep;

        private String makePath(VarContext context, String sep) {
            String path = context.getInstPath(sep);
            if (!path.equals("")) {
                path = path + sep;
            }
            return path;
        }

        protected NameProxy(VarContext context, String sep) {
            this.context = context;
            this.sep = sep;
        }

        public abstract String leafName();

        public abstract Cell leafCell();

        public VarContext getContext() {
            return this.context;
        }

        public String toString() {
            return this.makePath(this.context, this.sep) + this.leafName();
        }

        public String toString(int numRemoveParents) {
            VarContext localContext = this.context.removeParentContext(numRemoveParents);
            String ret = this.makePath(localContext, this.sep) + this.leafName();
            return ret;
        }
    }
}

