/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.Main;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.GDSMap;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class FileMenu {
    private static PageFormat pageFormat = null;

    protected static void addFileMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu fileMenu = MenuBar.makeMenu("_File");
        menuBar.add(fileMenu);
        fileMenu.addMenuItem("_New Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.newLibraryCommand();
            }
        });
        fileMenu.addMenuItem("_Open Library...", KeyStroke.getKeyStroke(79, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.openLibraryCommand();
            }
        });
        MenuBar.Menu importSubMenu = MenuBar.makeMenu("_Import");
        fileMenu.add(importSubMenu);
        importSubMenu.addMenuItem("_CIF (Caltech Intermediate Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.CIF);
            }
        });
        importSubMenu.addMenuItem("_GDS II (Stream)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.GDS);
            }
        });
        importSubMenu.addMenuItem("GDS _Map File...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GDSMap.importMapFile();
            }
        });
        importSubMenu.addMenuItem("_EDIF (Electronic Design Interchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.EDIF);
            }
        });
        importSubMenu.addMenuItem("_LEF (Library Exchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.LEF);
            }
        });
        importSubMenu.addMenuItem("_DEF (Design Exchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.DEF);
            }
        });
        importSubMenu.addMenuItem("D_XF (AutoCAD)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.DXF);
            }
        });
        importSubMenu.addMenuItem("S_UE (Schematic User Environment)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.SUE);
            }
        });
        importSubMenu.addSeparator();
        importSubMenu.addMenuItem("ELI_B...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.ELIB);
            }
        });
        importSubMenu.addMenuItem("_Readable Dump...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand(FileType.READABLEDUMP);
            }
        });
        importSubMenu.addMenuItem("_Text Cell Contents...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextWindow.readTextCell();
            }
        });
        importSubMenu.addMenuItem("_Preferences...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Pref.importPrefs();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("_Close Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.closeLibraryCommand(Library.getCurrent());
            }
        });
        fileMenu.addMenuItem("Sa_ve Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveLibraryCommand(Library.getCurrent(), FileType.DEFAULTLIB, false, true);
                }
            }
        });
        fileMenu.addMenuItem("Save Library _As...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAsLibraryCommand(Library.getCurrent());
                }
            }
        });
        fileMenu.addMenuItem("_Save All Libraries", KeyStroke.getKeyStroke(83, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAllLibrariesCommand();
                }
            }
        });
        fileMenu.addMenuItem("Save All Libraries in _Format...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAllLibrariesInFormatCommand();
                }
            }
        });
        MenuBar.Menu exportSubMenu = MenuBar.makeMenu("_Export");
        fileMenu.add(exportSubMenu);
        exportSubMenu.addMenuItem("_CIF (Caltech Intermediate Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.CIF, false);
            }
        });
        exportSubMenu.addMenuItem("_GDS II (Stream)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.GDS, false);
            }
        });
        exportSubMenu.addMenuItem("ED_IF (Electronic Design Interchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.EDIF, false);
            }
        });
        exportSubMenu.addMenuItem("LE_F (Library Exchange Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.LEF, false);
            }
        });
        exportSubMenu.addMenuItem("_L...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.L, false);
            }
        });
        if (IOTool.hasSkill()) {
            exportSubMenu.addMenuItem("S_kill (Cadence Commands)...", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileMenu.exportCommand(FileType.SKILL, false);
                }
            });
            exportSubMenu.addMenuItem("Skill Exports _Only (Cadence Commands)...", null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileMenu.exportCommand(FileType.SKILLEXPORTSONLY, false);
                }
            });
        }
        exportSubMenu.addSeparator();
        exportSubMenu.addMenuItem("_Eagle...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.EAGLE, false);
            }
        });
        exportSubMenu.addMenuItem("EC_AD...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.ECAD, false);
            }
        });
        exportSubMenu.addMenuItem("Pad_s...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.PADS, false);
            }
        });
        exportSubMenu.addSeparator();
        exportSubMenu.addMenuItem("_Text Cell Contents...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextWindow.writeTextCell();
            }
        });
        exportSubMenu.addMenuItem("_PostScript...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.POSTSCRIPT, false);
            }
        });
        exportSubMenu.addMenuItem("P_NG (Portable Network Graphics)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.PNG, false);
            }
        });
        exportSubMenu.addMenuItem("_HPGL...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.HPGL, false);
            }
        });
        exportSubMenu.addMenuItem("D_XF (AutoCAD)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCommand(FileType.DXF, false);
            }
        });
        exportSubMenu.addSeparator();
        exportSubMenu.addMenuItem("ELI_B (Version 6)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveLibraryCommand(Library.getCurrent(), FileType.ELIB, true, false);
                }
            }
        });
        exportSubMenu.addMenuItem("P_references...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Pref.exportPrefs();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Change Current _Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.changeCurrentLibraryCommand();
            }
        });
        fileMenu.addMenuItem("List Li_braries", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.listLibrariesCommand();
            }
        });
        fileMenu.addMenuItem("Rena_me Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.renameLibrary(Library.getCurrent());
            }
        });
        fileMenu.addMenuItem("Mar_k All Libraries for Saving", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.markAllLibrariesForSavingCommand();
            }
        });
        MenuBar.Menu checkSubMenu = MenuBar.makeMenu("C_heck Libraries");
        fileMenu.add(checkSubMenu);
        checkSubMenu.addMenuItem("_Check", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.checkAndRepairCommand(false);
            }
        });
        checkSubMenu.addMenuItem("_Repair", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.checkAndRepairCommand(true);
            }
        });
        fileMenu.addSeparator();
        MenuBar.Menu projectSubMenu = MenuBar.makeMenu("Project Management");
        fileMenu.add(projectSubMenu);
        projectSubMenu.addMenuItem("_Update", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.updateProject();
            }
        });
        projectSubMenu.addMenuItem("Check _Out This Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.checkOutThisCell();
            }
        });
        projectSubMenu.addMenuItem("Check _In This Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.checkInThisCell();
            }
        });
        projectSubMenu.addSeparator();
        projectSubMenu.addMenuItem("_Cancel Check-Out", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.cancelCheckOutThisCell();
            }
        });
        projectSubMenu.addMenuItem("_Add This Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.addThisCell();
            }
        });
        projectSubMenu.addMenuItem("_Remove This Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.removeThisCell();
            }
        });
        projectSubMenu.addMenuItem("Show _History of This Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.examineThisHistory();
            }
        });
        projectSubMenu.addSeparator();
        projectSubMenu.addMenuItem("Get Library From Repository...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.getALibrary();
            }
        });
        projectSubMenu.addMenuItem("Add Current _Library To Repository", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.addThisLibrary();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Pa_ge Setup...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.pageSetupCommand();
            }
        });
        fileMenu.addMenuItem("_Print...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.printCommand();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("P_references...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesFrame.preferencesCommand();
            }
        });
        if (TopLevel.getOperatingSystem() != TopLevel.OS.MACINTOSH) {
            fileMenu.addMenuItem("_Quit", KeyStroke.getKeyStroke(81, buckyBit), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileMenu.quitCommand();
                }
            });
        }
        fileMenu.addMenuItem("Force Q_uit (and Save)", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.forceQuit();
            }
        });
    }

    public static void newLibraryCommand() {
        String newLibName = JOptionPane.showInputDialog("New Library Name", (Object)"");
        if (newLibName == null) {
            return;
        }
        NewLibrary job = new NewLibrary(newLibName);
    }

    public static void openLibraryCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.LIBRARYFORMATS, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library deleteLib = Library.findLibrary(libName);
            if (deleteLib != null) {
                if (FileMenu.preventLoss(deleteLib, 2)) {
                    return;
                }
                WindowFrame.removeLibraryReferences(deleteLib);
            }
            FileType type = FileMenu.getLibraryFormat(fileName, FileType.DEFAULTLIB);
            ReadLibrary job = new ReadLibrary(fileURL, type, deleteLib);
        }
    }

    public static FileType getLibraryFormat(String fileName, FileType defaultType) {
        for (int i = 0; i < FileType.libraryTypes.length; ++i) {
            FileType type = FileType.libraryTypes[i];
            if (!fileName.endsWith("." + type.getExtensions()[0])) continue;
            return type;
        }
        return defaultType;
    }

    private static boolean openALibrary(URL fileURL, FileType type) {
        Library noname;
        Library lib = null;
        lib = type == FileType.ELIB || type == FileType.JELIB || type == FileType.READABLEDUMP ? LibraryFiles.readLibrary(fileURL, null, type, false) : Input.importLibrary(fileURL, type);
        if (lib != null && (noname = Library.findLibrary("noname")) != null && !noname.getCells().hasNext()) {
            noname.kill("delete");
        }
        Undo.noUndoAllowed();
        if (lib == null) {
            return false;
        }
        lib.setCurrent();
        Cell cell = lib.getCurCell();
        if (cell == null) {
            System.out.println("No current cell in this library");
        } else if (!Main.BATCHMODE) {
            CreateCellWindow creator = new CreateCellWindow(cell);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(creator);
            } else {
                creator.run();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowFrame.wantToRedoLibraryTree();
                WindowFrame.wantToOpenCurrentLibrary(true);
            }
        });
        return true;
    }

    public static void importLibraryCommand(FileType type) {
        String fileName = OpenFile.chooseInputFile(type, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library deleteLib = Library.findLibrary(libName);
            if (deleteLib != null) {
                if (FileMenu.preventLoss(deleteLib, 2)) {
                    return;
                }
                WindowFrame.removeLibraryReferences(deleteLib);
            }
            ReadLibrary job = new ReadLibrary(fileURL, type, deleteLib);
        }
    }

    public static void closeLibraryCommand(Library lib) {
        Cell cell;
        Set found = Library.findReferenceInCell(lib);
        boolean clearClipboard = false;
        boolean nonClipboard = false;
        Iterator i = found.iterator();
        while (i.hasNext()) {
            cell = (Cell)i.next();
            if (cell.getLibrary().isHidden()) {
                clearClipboard = true;
                continue;
            }
            nonClipboard = true;
        }
        if (nonClipboard) {
            System.out.println("Cannot close " + lib + ":");
            System.out.print("\t Cells ");
            i = found.iterator();
            while (i.hasNext()) {
                cell = (Cell)i.next();
                System.out.print("'" + cell.getName() + "'(" + cell.getLibrary().getName() + ") ");
            }
            System.out.println("refer to it.");
            return;
        }
        if (FileMenu.preventLoss(lib, 1)) {
            return;
        }
        WindowFrame.removeLibraryReferences(lib);
        CloseLibrary job = new CloseLibrary(lib, clearClipboard);
    }

    public static boolean saveLibraryCommand(Library lib, FileType type, boolean compatibleWith6, boolean forceToType) {
        String[] extensions = type.getExtensions();
        String extension = extensions[0];
        String fileName = null;
        if (lib.isFromDisk()) {
            File file;
            if (type == FileType.JELIB || type == FileType.ELIB && !compatibleWith6) {
                fileName = lib.getLibFile().getPath();
                if (forceToType) {
                    type = OpenFile.getOpenFileType(fileName, FileType.DEFAULTLIB);
                }
            }
            if (fileName != null && (file = new File(fileName)).exists() && !file.canWrite()) {
                fileName = null;
            }
        }
        if (fileName == null) {
            fileName = OpenFile.chooseOutputFile(FileType.libraryTypes, null, lib.getName() + "." + extension);
            if (fileName == null) {
                return false;
            }
            type = FileMenu.getLibraryFormat(fileName, type);
            Iterator it = Library.getLibraries();
            while (it.hasNext()) {
                Library oLib = (Library)it.next();
                if (oLib.isHidden() || oLib == lib || oLib.isChangedMajor() || !oLib.referencesLib(lib)) continue;
                oLib.setChangedMajor();
            }
        }
        SaveLibrary job = new SaveLibrary(lib, fileName, type, compatibleWith6, false);
        return true;
    }

    public static void saveAsLibraryCommand(Library lib) {
        lib.clearFromDisk();
        FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true);
        WindowFrame.wantToRedoTitleNames();
    }

    public static void saveAllLibrariesCommand() {
        FileMenu.saveAllLibrariesCommand(FileType.DEFAULTLIB, false, true);
    }

    public static void saveAllLibrariesCommand(FileType type, boolean compatibleWith6, boolean forceToType) {
        HashMap<Library, FileType> libsToSave = new HashMap<Library, FileType>();
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || !lib.isChanged()) continue;
            if (lib.getLibFile() != null) {
                type = FileMenu.getLibraryFormat(lib.getLibFile().getFile(), type);
            }
            libsToSave.put(lib, type);
        }
        boolean justSkip = false;
        Iterator it2 = libsToSave.keySet().iterator();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            if (FileMenu.saveLibraryCommand(lib, type = (FileType)libsToSave.get(lib), compatibleWith6, forceToType) || justSkip) continue;
            if (!it2.hasNext()) break;
            Object[] options = new String[]{"Cancel", "Skip this Library"};
            int ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Cancel all library saving, or just skip saving this library?", "Save Cancelled", -1, 3, null, options, "Cancel");
            if (ret != 1) break;
            justSkip = true;
        }
    }

    public static void saveAllLibrariesInFormatCommand() {
        Object[] formats = new Object[]{FileType.JELIB, FileType.ELIB, FileType.READABLEDUMP};
        Object format = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Output file format for all libraries:", "Save All Libraries In Format...", -1, null, formats, FileType.DEFAULTLIB);
        if (format == null) {
            return;
        }
        FileType outType = (FileType)format;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            if (lib.getLibFile() != null) {
                String fullName = lib.getLibFile().getFile();
                fullName = fullName.replaceAll("\\.\\w*?$", "." + outType.getExtensions()[0]);
                lib.setLibFile(TextUtils.makeURLToFile(fullName));
            }
            lib.setChanged();
        }
        FileMenu.saveAllLibrariesCommand(outType, false, false);
    }

    private static boolean checkInvariants() {
        if (!Library.checkInvariants()) {
            String[] messages = new String[]{"Database invariants are not valid", "You may use \"Force Quit (and Save)\" to save in a panic directory", "Do you really want to write libraries into the working directory?"};
            Object[] options = new Object[]{"Continue Writing", "Cancel", "ForceQuit"};
            int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), messages, "Invalid database invariants", -1, 2, null, options, options[1]);
            if (val == 1) {
                return false;
            }
            if (val == 2) {
                FileMenu.forceQuit();
                return false;
            }
        }
        return true;
    }

    public static void exportCommand(FileType type, boolean isNetlist) {
        VarContext context;
        WindowContent wnd;
        if (type == FileType.POSTSCRIPT && PostScript.syncAll()) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        WindowContent windowContent = wnd = wf != null ? wf.getContent() : null;
        if (wnd == null) {
            System.out.println("No current window");
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell in this window");
            return;
        }
        VarContext varContext = context = wnd instanceof EditWindow ? ((EditWindow)wnd).getVarContext() : null;
        if (type == FileType.POSTSCRIPT) {
            if (IOTool.isPrintEncapsulated()) {
                type = FileType.EPS;
            }
            if (wnd instanceof WaveformWindow) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot write PostScript for a Waveform window.  Try printing it instead", "Cannot Write PostScript", 0);
                return;
            }
        }
        String[] extensions = type.getExtensions();
        String filePath = (cell != null ? cell.getName() : "") + "." + extensions[0];
        if (type == FileType.SPICE && !Simulation.getSpiceRunChoice().equals("Don't Run")) {
            filePath = Simulation.getSpiceUseRunDir() ? Simulation.getSpiceRunDir() + File.separator + filePath : User.getWorkingDirectory() + File.separator + filePath;
            if (User.isShowFileSelectionForNetlists() && !Simulation.getSpiceOutputOverwrite()) {
                String saveDir = User.getWorkingDirectory();
                filePath = OpenFile.chooseOutputFile(type, null, filePath);
                User.setWorkingDirectory(saveDir);
                if (filePath == null) {
                    return;
                }
            }
            Output.exportCellCommand(cell, context, filePath, type, true);
            return;
        }
        if (User.isShowFileSelectionForNetlists() || !isNetlist) {
            if ((filePath = OpenFile.chooseOutputFile(type, null, filePath)) == null) {
                return;
            }
        } else {
            filePath = User.getWorkingDirectory() + File.separator + filePath;
        }
        if (type == FileType.PNG) {
            String name = cell != null ? cell.toString() : filePath;
            ExportImage job = new ExportImage(name, wnd, filePath);
            return;
        }
        Output.exportCellCommand(cell, context, filePath, type, true);
    }

    public static void pageSetupCommand() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pageFormat = pageFormat == null ? pj.pageDialog(pj.defaultPage()) : pj.pageDialog(pageFormat);
    }

    private static ElectricPrinter getOutputPreferences(WindowContent context, PrinterJob pj) {
        if (pageFormat == null) {
            pageFormat = pj.defaultPage();
            pageFormat.setOrientation(0);
            pageFormat = pj.validatePage(pageFormat);
        }
        ElectricPrinter ep = new ElectricPrinter(context, pageFormat);
        pj.setPrintable(ep, pageFormat);
        return ep;
    }

    public static void printCommand() {
        HashPrintRequestAttributeSet aset;
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            System.out.println("No current window to print");
            return;
        }
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(wf.getTitle());
        ElectricPrinter ep = FileMenu.getOutputPreferences(wf.getContent(), pj);
        String pName = IOTool.getPrinterName();
        PrintService[] printers = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService printerToUse = null;
        for (int i = 0; i < printers.length; ++i) {
            if (!pName.equals(printers[i].getName())) continue;
            printerToUse = printers[i];
            break;
        }
        if (printerToUse != null) {
            try {
                pj.setPrintService(printerToUse);
            }
            catch (PrinterException e) {
                System.out.println("Printing error " + e);
            }
        }
        if (pj.printDialog(aset = new HashPrintRequestAttributeSet())) {
            JPanel overall = wf.getContent().getPanel();
            RepaintManager currentManager = RepaintManager.currentManager(overall);
            currentManager.setDoubleBufferingEnabled(false);
            Dimension oldSize = null;
            if (wf.getContent() instanceof WaveformWindow) {
                int iw = (int)pageFormat.getImageableWidth();
                int ih = (int)pageFormat.getImageableHeight();
                oldSize = overall.getSize();
                overall.setSize(iw, ih);
                overall.validate();
                overall.repaint();
            }
            if ((printerToUse = pj.getPrintService()) != null) {
                IOTool.setPrinterName(printerToUse.getName());
            }
            SwingUtilities.invokeLater(new PrintJobAWT(wf, pj, oldSize, aset));
        }
    }

    public static boolean quitCommand() {
        if (FileMenu.preventLoss(null, 0)) {
            return false;
        }
        try {
            QuitJob job = new QuitJob();
        }
        catch (NoClassDefFoundError e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean preventLoss(Library desiredLib, int action) {
        boolean checkedInvariants = false;
        boolean saveCancelled = false;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (desiredLib != null && desiredLib != lib || lib.isHidden() || !lib.isChanged()) continue;
            if (!checkedInvariants) {
                if (!FileMenu.checkInvariants()) {
                    return true;
                }
                checkedInvariants = true;
            }
            String how = "significantly";
            String toolTipMessage = "Major changes include creation, deletion, or modification of circuit\nelements including variable and export renaming.";
            if (!lib.isChangedMajor()) {
                how = "insignificantly";
                toolTipMessage = "Minor changes include DRC dates, expanded flag.";
            }
            String theAction = "Save before quitting?";
            if (action == 1) {
                theAction = "Save before closing?";
            } else if (action == 2) {
                theAction = "Save before replacing?";
            }
            Object[] options = new String[]{"Yes", "No", "Cancel", "No to All"};
            int ret = FileMenu.showFileMenuOptionDialog(TopLevel.getCurrentJFrame(), "Library '" + lib.getName() + "' has changed " + how + ".  " + theAction, "Save Library?", -1, 2, null, options, options[0], toolTipMessage);
            if (ret == 0) {
                if (FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true)) continue;
                saveCancelled = true;
                continue;
            }
            if (ret == 1) continue;
            if (ret == 2) {
                return true;
            }
            if (ret != 3) continue;
            break;
        }
        return saveCancelled;
    }

    public static int showFileMenuOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, String toolTipMessage) throws HeadlessException {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        pane.setMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
        pane.setToolTipText(toolTipMessage);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static void forceQuit() {
        int i;
        boolean dirty = false;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || !lib.isChanged()) continue;
            dirty = true;
            break;
        }
        if (dirty) {
            Object[] options = new String[]{"Force Save and Quit", "Cancel", "Quit without Saving"};
            int i2 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning!  Libraries Changed!  Saving changes now may create bad libraries!"}, "Force Quit", -1, 2, null, options, options[1]);
            if (i2 == 0) {
                if (!FileMenu.forceSave(false)) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error during forced library save, not quiting", "Saving Failed", 0);
                    return;
                }
                System.exit(1);
            }
            if (i2 == 1) {
                return;
            }
            if (i2 == 2) {
                System.exit(1);
            }
        }
        if ((i = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning! You are about to kill Electric!", "Do you really want to force quit?"}, "Force Quit", 0, 2)) == 0) {
            System.exit(1);
        }
    }

    public static boolean forceSave(boolean confirm) {
        boolean dirty = false;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden() || !lib.isChanged()) continue;
            dirty = true;
            break;
        }
        if (!dirty) {
            System.out.println("Libraries have not changed, not saving");
            return true;
        }
        if (confirm) {
            Object[] options = new String[]{"Cancel", "Force Save"};
            int i = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning! Saving changes now may create bad libraries!", "Libraries will be saved to \"Panic\" directory in current directory", "Do you really want to force save?"}, "Force Save", -1, 2, null, options, options[0]);
            if (i == 0) {
                return false;
            }
        }
        String currentDir = User.getWorkingDirectory();
        System.out.println("Saving libraries in panic directory under " + currentDir);
        System.out.flush();
        File panicDir = new File(currentDir, "panic");
        if (!panicDir.exists() && !panicDir.mkdir()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Could not create panic directory", panicDir.getAbsolutePath()}, "Error creating panic directory", 0);
            return false;
        }
        boolean retValue = true;
        FileType type = FileType.DEFAULTLIB;
        Iterator it2 = Library.getLibraries();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            if (lib.isHidden()) continue;
            System.out.print(".");
            System.out.flush();
            URL libURL = lib.getLibFile();
            File newLibFile = null;
            if (libURL.getPath() == null) {
                newLibFile = new File(panicDir.getAbsolutePath(), lib.getName() + type.getExtensions()[0]);
            } else {
                File libFile = new File(libURL.getPath());
                String fileName = libFile.getName();
                if (fileName == null) {
                    fileName = lib.getName() + type.getExtensions()[0];
                }
                newLibFile = new File(panicDir.getAbsolutePath(), fileName);
            }
            URL newLibURL = TextUtils.makeURLToFile(newLibFile.getAbsolutePath());
            lib.setLibFile(newLibURL);
            boolean error = Output.writeLibrary(lib, type, false);
            if (!error) continue;
            System.out.println("Error saving " + lib);
            retValue = false;
        }
        System.out.println(" Libraries saved");
        return retValue;
    }

    static class CellMouseMotionAdapter
    extends MouseMotionAdapter {
        JOptionPane pane;

        CellMouseMotionAdapter(JOptionPane p) {
            this.pane = p;
        }

        public void mouseMoved(MouseEvent e) {
            System.out.println(" Point " + this.pane.getToolTipLocation(e));
        }
    }

    private static class QuitJob
    extends Job {
        public QuitJob() {
            super("Quitting", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            if (Library.saveExpandStatus(true)) {
                Layer.preserveVisibility();
                WaveformWindow.preserveSignalOrder();
                ActivityLogger.finished();
                System.exit(0);
            }
            return true;
        }
    }

    private static class PrintJobAWT
    implements Runnable {
        private WindowFrame wf;
        private PrinterJob pj;
        private Dimension oldSize;
        private PrintRequestAttributeSet aset;

        PrintJobAWT(WindowFrame wf, PrinterJob pj, Dimension oldSize, PrintRequestAttributeSet aset) {
            this.wf = wf;
            this.pj = pj;
            this.oldSize = oldSize;
            this.aset = aset;
        }

        public void run() {
            try {
                this.pj.print(this.aset);
            }
            catch (PrinterException pe) {
                System.out.println("Print aborted.");
            }
            JPanel overall = this.wf.getContent().getPanel();
            RepaintManager currentManager = RepaintManager.currentManager(overall);
            currentManager.setDoubleBufferingEnabled(true);
            if (this.oldSize != null) {
                overall.setSize(this.oldSize);
                overall.validate();
            }
        }
    }

    private static class ExportImage
    extends Job {
        String filePath;
        WindowContent wnd;

        public ExportImage(String description, WindowContent wnd, String filePath) {
            super("Export " + description + " (" + FileType.PNG + ")", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.filePath = filePath;
            this.startJob();
        }

        public boolean doIt() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            ElectricPrinter ep = FileMenu.getOutputPreferences(this.wnd, pj);
            this.wnd.writeImage(ep, this.filePath);
            return true;
        }
    }

    public static class SaveLibrary
    extends Job {
        Library lib;
        String newName;
        FileType type;
        boolean compatibleWith6;

        public SaveLibrary(Library lib, String newName, FileType type, boolean compatibleWith6, boolean batchJob) {
            super("Write " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.type = type;
            this.compatibleWith6 = compatibleWith6;
            if (!batchJob) {
                this.startJob();
            }
        }

        public boolean doIt() {
            boolean retVal = false;
            try {
                retVal = this.performTask();
                if (!retVal) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Error saving files", "Please check your disk libraries"}, "Saving Failed", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Exception caught when saving files", e.getMessage(), "Please check your disk libraries"}, "Saving Failed", 0);
                ActivityLogger.logException(e);
            }
            return retVal;
        }

        public boolean performTask() {
            boolean error;
            if (this.newName != null) {
                URL libURL = TextUtils.makeURLToFile(this.newName);
                this.lib.setLibFile(libURL);
                this.lib.setName(TextUtils.getFileNameWithoutExtension(libURL));
            }
            return !(error = Output.writeLibrary(this.lib, this.type, this.compatibleWith6));
        }
    }

    private static class CloseLibrary
    extends Job {
        private Library lib;
        private boolean clearClipboard;

        public CloseLibrary(Library lib, boolean clearClipboard) {
            super("Close " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.clearClipboard = clearClipboard;
            this.startJob();
        }

        public boolean doIt() {
            if (this.clearClipboard) {
                Clipboard.clear();
            }
            if (this.lib.kill("delete")) {
                System.out.println("Library '" + this.lib.getName() + "' closed");
                WindowFrame.wantToRedoTitleNames();
                EditWindow.repaintAll();
                TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
            }
            return true;
        }
    }

    public static class CreateCellWindow
    implements Runnable {
        private Cell cell;

        public CreateCellWindow(Cell cell) {
            this.cell = cell;
        }

        public void run() {
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                WindowContent content = wf.getContent();
                if (content.getCell() != null) continue;
                wf.setCellWindow(this.cell);
                TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
                return;
            }
            WindowFrame.createEditWindow(this.cell);
            TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
        }
    }

    public static class ReadInitialELIBs
    extends Job {
        List fileURLs;

        public ReadInitialELIBs(List fileURLs) {
            super("Read Initial Libraries", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURLs = fileURLs;
            this.startJob();
        }

        public boolean doIt() {
            Library mainLib = Library.newInstance("noname", null);
            if (mainLib == null) {
                return false;
            }
            mainLib.setCurrent();
            boolean success = false;
            Iterator it = this.fileURLs.iterator();
            while (it.hasNext()) {
                URL f;
                URL file = (URL)it.next();
                FileType defType = null;
                String fileName = file.getFile();
                defType = FileMenu.getLibraryFormat(fileName, defType);
                if (defType == null && TextUtils.URLExists(f = TextUtils.makeURLToFile(fileName + "." + FileType.JELIB.getExtensions()[0]), null)) {
                    defType = FileType.JELIB;
                    file = f;
                }
                if (defType == null && TextUtils.URLExists(f = TextUtils.makeURLToFile(fileName + "." + FileType.ELIB.getExtensions()[0]), null)) {
                    defType = FileType.ELIB;
                    file = f;
                }
                if (defType == null && TextUtils.URLExists(f = TextUtils.makeURLToFile(fileName + "." + FileType.READABLEDUMP.getExtensions()[0]), null)) {
                    defType = FileType.READABLEDUMP;
                    file = f;
                }
                if (defType == null) {
                    defType = FileType.DEFAULTLIB;
                }
                User.setWorkingDirectory(TextUtils.getFilePath(file));
                if (!FileMenu.openALibrary(file, defType)) continue;
                success = true;
            }
            if (success) {
                // empty if block
            }
            return true;
        }
    }

    public static class ReadLibrary
    extends Job {
        private URL fileURL;
        private FileType type;
        private Library deleteLib;

        public ReadLibrary(URL fileURL, FileType type, Library deleteLib) {
            super("Read External Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.type = type;
            this.deleteLib = deleteLib;
            this.startJob();
        }

        public boolean doIt() {
            if (this.deleteLib != null) {
                if (Library.getVisibleLibraries().size() > 1) {
                    if (!this.deleteLib.kill("replace")) {
                        return false;
                    }
                    this.deleteLib = null;
                } else {
                    this.deleteLib.setName("FORMERVERSIONOF" + this.deleteLib.getName());
                }
            }
            FileMenu.openALibrary(this.fileURL, this.type);
            if (this.deleteLib != null) {
                this.deleteLib.kill("replace");
            }
            return true;
        }
    }

    private static class NewLibrary
    extends Job {
        private String newLibName;

        public NewLibrary(String newLibName) {
            super("New Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newLibName = newLibName;
            this.startJob();
        }

        public boolean doIt() {
            Library lib = Library.newInstance(this.newLibName, null);
            if (lib == null) {
                return false;
            }
            lib.setCurrent();
            EditWindow.repaintAll();
            TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
            System.out.println("New " + lib + " created");
            return true;
        }
    }
}

