/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CellProperties
extends EDialog {
    private JList cellList;
    private DefaultListModel cellListModel;
    private HashMap origValues;
    private boolean initialCheckDatesDuringCreation;
    private boolean initialAutoTechnologySwitch;
    private boolean initialPlaceCellCenter;
    private boolean changing = false;
    private JButton cancel;
    private JScrollPane cellPane;
    private JTextField charXSpacing;
    private JTextField charYSpacing;
    private JButton clearDisallowModAnyInCell;
    private JButton clearDisallowModInstInCell;
    private JButton clearPartOfCellLib;
    private JButton clearUseTechEditor;
    private JCheckBox disallowModAnyInCell;
    private JCheckBox disallowModInstInCell;
    private JRadioButton expandNewInstances;
    private ButtonGroup expansion;
    private JTextField frameDesigner;
    private JRadioButton frameLandscape;
    private ButtonGroup frameOrientation;
    private JRadioButton framePortrait;
    private JComboBox frameSize;
    private JCheckBox frameTitleBox;
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JComboBox libraryPopup;
    private JButton ok;
    private JCheckBox partOfCellLib;
    private JButton setDisallowModAnyInCell;
    private JButton setDisallowModInstInCell;
    private JButton setPartOfCellLib;
    private JButton setUseTechEditor;
    private JRadioButton unexpandNewInstances;
    private JCheckBox useTechEditor;
    private JComboBox whichTechnology;
    static /* synthetic */ Class class$java$lang$String;

    public CellProperties(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.origValues = new HashMap();
        this.cellListModel = new DefaultListModel();
        this.cellList = new JList(this.cellListModel);
        this.cellList.setSelectionMode(0);
        this.cellPane.setViewportView(this.cellList);
        this.cellList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CellProperties.this.cellListClick();
            }
        });
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            this.whichTechnology.addItem(tech.getTechName());
        }
        this.frameSize.addItem("None");
        this.frameSize.addItem("Half-A-Size");
        this.frameSize.addItem("A-Size");
        this.frameSize.addItem("B-Size");
        this.frameSize.addItem("C-Size");
        this.frameSize.addItem("D-Size");
        this.frameSize.addItem("E-Size");
        List libList = Library.getVisibleLibraries();
        Iterator it2 = libList.iterator();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            this.libraryPopup.addItem(lib.getName());
        }
        int curIndex = libList.indexOf(Library.getCurrent());
        if (curIndex >= 0) {
            this.libraryPopup.setSelectedIndex(curIndex);
        }
        this.charXSpacing.getDocument().addDocumentListener(new TextFieldListener(this));
        this.charYSpacing.getDocument().addDocumentListener(new TextFieldListener(this));
        this.frameDesigner.getDocument().addDocumentListener(new TextFieldListener(this));
        this.loadCellList();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void loadCellList() {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        boolean any = false;
        this.cellListModel.clear();
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            this.cellListModel.addElement(cell.noLibDescribe());
            any = true;
        }
        if (any) {
            Library curLib = Library.getCurrent();
            if (lib == curLib && curLib.getCurCell() != null) {
                this.cellList.setSelectedValue(curLib.getCurCell().noLibDescribe(), true);
            } else {
                this.cellList.setSelectedIndex(0);
            }
        } else {
            this.cellList.setSelectedValue(null, false);
        }
        this.cellListClick();
    }

    private Cell getSelectedCell() {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        String cellName = (String)this.cellList.getSelectedValue();
        if (cellName == null) {
            return null;
        }
        Cell cell = lib.findNodeProto(cellName);
        return cell;
    }

    private PerCellValues getPCV(Cell cell) {
        PerCellValues pcv = (PerCellValues)this.origValues.get(cell);
        if (pcv == null) {
            pcv = new PerCellValues(cell);
            this.origValues.put(cell, pcv);
        }
        return pcv;
    }

    private void cellListClick() {
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        if (pcv == null) {
            return;
        }
        this.changing = true;
        this.disallowModAnyInCell.setSelected(pcv.disAllMod.getBoolean());
        this.disallowModInstInCell.setSelected(pcv.disInstMod.getBoolean());
        this.partOfCellLib.setSelected(pcv.inCellLib.getBoolean());
        this.useTechEditor.setSelected(pcv.useTechEditor.getBoolean());
        this.expandNewInstances.setSelected(pcv.defExpanded.getBoolean());
        this.unexpandNewInstances.setSelected(!pcv.defExpanded.getBoolean());
        this.charXSpacing.setText(TextUtils.formatDouble(pcv.charX.getDouble()));
        this.charYSpacing.setText(TextUtils.formatDouble(pcv.charY.getDouble()));
        this.frameDesigner.setText(pcv.designerName.getString());
        this.whichTechnology.setSelectedItem(pcv.technologyName.getString());
        this.frameSize.setSelectedIndex(0);
        this.frameLandscape.setSelected(true);
        this.frameTitleBox.setSelected(false);
        String fs = pcv.frameSize.getString();
        if (fs.length() > 0) {
            char chr = fs.charAt(0);
            if (chr == 'h') {
                this.frameSize.setSelectedIndex(1);
            } else if (chr == 'a') {
                this.frameSize.setSelectedIndex(2);
            } else if (chr == 'b') {
                this.frameSize.setSelectedIndex(3);
            } else if (chr == 'c') {
                this.frameSize.setSelectedIndex(4);
            } else if (chr == 'd') {
                this.frameSize.setSelectedIndex(5);
            } else if (chr == 'e') {
                this.frameSize.setSelectedIndex(6);
            }
            this.frameTitleBox.setSelected(true);
            for (int i = 1; i < fs.length(); ++i) {
                chr = fs.charAt(i);
                if (chr == 'v') {
                    this.framePortrait.setSelected(true);
                    continue;
                }
                if (chr != 'n') continue;
                this.frameTitleBox.setSelected(false);
            }
        }
        this.changing = false;
    }

    private void textInfoChanged() {
        if (this.changing) {
            return;
        }
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        if (pcv == null) {
            return;
        }
        pcv.charX.setDouble(TextUtils.atof(this.charXSpacing.getText()));
        pcv.charY.setDouble(TextUtils.atof(this.charYSpacing.getText()));
        pcv.designerName.setString(this.frameDesigner.getText());
    }

    private void frameInfoChanged() {
        if (this.changing) {
            return;
        }
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        if (pcv == null) {
            return;
        }
        String currentFrameSize = "";
        int index = this.frameSize.getSelectedIndex();
        if (index > 0) {
            switch (index) {
                case 1: {
                    currentFrameSize = "h";
                    break;
                }
                case 2: {
                    currentFrameSize = "a";
                    break;
                }
                case 3: {
                    currentFrameSize = "b";
                    break;
                }
                case 4: {
                    currentFrameSize = "c";
                    break;
                }
                case 5: {
                    currentFrameSize = "d";
                    break;
                }
                case 6: {
                    currentFrameSize = "e";
                }
            }
            if (this.framePortrait.isSelected()) {
                currentFrameSize = currentFrameSize + "v";
            }
            if (!this.frameTitleBox.isSelected()) {
                currentFrameSize = currentFrameSize + "n";
            }
        } else if (this.frameTitleBox.isSelected()) {
            currentFrameSize = "x";
        }
        pcv.frameSize.setString(currentFrameSize);
    }

    private void initComponents() {
        this.expansion = new ButtonGroup();
        this.frameOrientation = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cellPane = new JScrollPane();
        this.disallowModAnyInCell = new JCheckBox();
        this.setDisallowModAnyInCell = new JButton();
        this.clearDisallowModAnyInCell = new JButton();
        this.disallowModInstInCell = new JCheckBox();
        this.setDisallowModInstInCell = new JButton();
        this.clearDisallowModInstInCell = new JButton();
        this.partOfCellLib = new JCheckBox();
        this.setPartOfCellLib = new JButton();
        this.clearPartOfCellLib = new JButton();
        this.useTechEditor = new JCheckBox();
        this.setUseTechEditor = new JButton();
        this.clearUseTechEditor = new JButton();
        this.expandNewInstances = new JRadioButton();
        this.unexpandNewInstances = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.charXSpacing = new JTextField();
        this.jLabel4 = new JLabel();
        this.charYSpacing = new JTextField();
        this.libraryPopup = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel14 = new JLabel();
        this.frameSize = new JComboBox();
        this.frameLandscape = new JRadioButton();
        this.framePortrait = new JRadioButton();
        this.frameTitleBox = new JCheckBox();
        this.jLabel18 = new JLabel();
        this.frameDesigner = new JTextField();
        this.jLabel5 = new JLabel();
        this.whichTechnology = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Cell Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CellProperties.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Every cell:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.cellPane.setMinimumSize(new Dimension(200, 250));
        this.cellPane.setPreferredSize(new Dimension(200, 250));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cellPane, gridBagConstraints);
        this.disallowModAnyInCell.setText("Disallow modification of anything in this cell");
        this.disallowModAnyInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.disallowModAnyInCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.disallowModAnyInCell, gridBagConstraints);
        this.setDisallowModAnyInCell.setText("Set");
        this.setDisallowModAnyInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.setDisallowModAnyInCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.setDisallowModAnyInCell, gridBagConstraints);
        this.clearDisallowModAnyInCell.setText("Clear");
        this.clearDisallowModAnyInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.clearDisallowModAnyInCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.clearDisallowModAnyInCell, gridBagConstraints);
        this.disallowModInstInCell.setText("Disallow modification of instances in this cell");
        this.disallowModInstInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.disallowModInstInCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.disallowModInstInCell, gridBagConstraints);
        this.setDisallowModInstInCell.setText("Set");
        this.setDisallowModInstInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.setDisallowModInstInCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.setDisallowModInstInCell, gridBagConstraints);
        this.clearDisallowModInstInCell.setText("Clear");
        this.clearDisallowModInstInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.clearDisallowModInstInCellActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.clearDisallowModInstInCell, gridBagConstraints);
        this.partOfCellLib.setText("Part of a cell-library");
        this.partOfCellLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.partOfCellLibActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.partOfCellLib, gridBagConstraints);
        this.setPartOfCellLib.setText("Set");
        this.setPartOfCellLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.setPartOfCellLibActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.setPartOfCellLib, gridBagConstraints);
        this.clearPartOfCellLib.setText("Clear");
        this.clearPartOfCellLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.clearPartOfCellLibActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.clearPartOfCellLib, gridBagConstraints);
        this.useTechEditor.setText("Part of technology editor library");
        this.useTechEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.useTechEditorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.useTechEditor, gridBagConstraints);
        this.setUseTechEditor.setText("Set");
        this.setUseTechEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.setUseTechEditorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.setUseTechEditor, gridBagConstraints);
        this.clearUseTechEditor.setText("Clear");
        this.clearUseTechEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.clearUseTechEditorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.clearUseTechEditor, gridBagConstraints);
        this.expandNewInstances.setText("Expand new instances");
        this.expansion.add(this.expandNewInstances);
        this.expandNewInstances.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.expandNewInstancesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.expandNewInstances, gridBagConstraints);
        this.unexpandNewInstances.setText("Unexpand new instances");
        this.expansion.add(this.unexpandNewInstances);
        this.unexpandNewInstances.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.unexpandNewInstancesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.unexpandNewInstances, gridBagConstraints);
        this.jLabel3.setText("Characteristic X Spacing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.charXSpacing, gridBagConstraints);
        this.jLabel4.setText("Characteristic Y Spacing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.charYSpacing, gridBagConstraints);
        this.libraryPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.libraryPopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.libraryPopup, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Cell Frame"));
        this.jLabel14.setText("Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabel14, gridBagConstraints);
        this.frameSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.frameSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.frameSize, gridBagConstraints);
        this.frameLandscape.setText("Landscape");
        this.frameOrientation.add(this.frameLandscape);
        this.frameLandscape.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.frameLandscapeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.jPanel1.add((Component)this.frameLandscape, gridBagConstraints);
        this.framePortrait.setText("Portrait");
        this.frameOrientation.add(this.framePortrait);
        this.framePortrait.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.framePortraitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.jPanel1.add((Component)this.framePortrait, gridBagConstraints);
        this.frameTitleBox.setText("Title Box");
        this.frameTitleBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.frameTitleBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.frameTitleBox, gridBagConstraints);
        this.jLabel18.setText("Designer Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabel18, gridBagConstraints);
        this.frameDesigner.setColumns(15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.frameDesigner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.whichTechnology.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellProperties.this.whichTechnologyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.whichTechnology, gridBagConstraints);
        this.pack();
    }

    private void whichTechnologyActionPerformed(ActionEvent evt) {
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        pcv.technologyName.setString((String)this.whichTechnology.getSelectedItem());
    }

    private void frameTitleBoxActionPerformed(ActionEvent evt) {
        this.frameInfoChanged();
    }

    private void framePortraitActionPerformed(ActionEvent evt) {
        this.frameInfoChanged();
    }

    private void frameLandscapeActionPerformed(ActionEvent evt) {
        this.frameInfoChanged();
    }

    private void frameSizeActionPerformed(ActionEvent evt) {
        this.frameInfoChanged();
    }

    private void unexpandNewInstancesActionPerformed(ActionEvent evt) {
        this.expandNewInstancesActionPerformed(evt);
    }

    private void expandNewInstancesActionPerformed(ActionEvent evt) {
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        pcv.defExpanded.setBoolean(this.expandNewInstances.isSelected());
    }

    private void libraryPopupActionPerformed(ActionEvent evt) {
        this.loadCellList();
    }

    private void useTechEditorActionPerformed(ActionEvent evt) {
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        pcv.useTechEditor.setBoolean(this.useTechEditor.isSelected());
    }

    private void partOfCellLibActionPerformed(ActionEvent evt) {
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        pcv.inCellLib.setBoolean(this.partOfCellLib.isSelected());
    }

    private void disallowModInstInCellActionPerformed(ActionEvent evt) {
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        pcv.disInstMod.setBoolean(this.disallowModInstInCell.isSelected());
    }

    private void disallowModAnyInCellActionPerformed(ActionEvent evt) {
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        PerCellValues pcv = this.getPCV(cell);
        pcv.disAllMod.setBoolean(this.disallowModAnyInCell.isSelected());
    }

    private void clearUseTechEditorActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            PerCellValues pcv = this.getPCV(cell);
            pcv.useTechEditor.setBoolean(false);
        }
        this.cellListClick();
    }

    private void setUseTechEditorActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            PerCellValues pcv = this.getPCV(cell);
            pcv.useTechEditor.setBoolean(true);
        }
        this.cellListClick();
    }

    private void clearPartOfCellLibActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            PerCellValues pcv = this.getPCV(cell);
            pcv.inCellLib.setBoolean(false);
        }
        this.cellListClick();
    }

    private void setPartOfCellLibActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            PerCellValues pcv = this.getPCV(cell);
            pcv.inCellLib.setBoolean(true);
        }
        this.cellListClick();
    }

    private void clearDisallowModInstInCellActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            PerCellValues pcv = this.getPCV(cell);
            pcv.disInstMod.setBoolean(false);
        }
        this.cellListClick();
    }

    private void setDisallowModInstInCellActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            PerCellValues pcv = this.getPCV(cell);
            pcv.disInstMod.setBoolean(true);
        }
        this.cellListClick();
    }

    private void clearDisallowModAnyInCellActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            PerCellValues pcv = this.getPCV(cell);
            pcv.disAllMod.setBoolean(false);
        }
        this.cellListClick();
    }

    private void setDisallowModAnyInCellActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            PerCellValues pcv = this.getPCV(cell);
            pcv.disAllMod.setBoolean(true);
        }
        this.cellListClick();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        SetCellOptions job = new SetCellOptions(this);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SetCellOptions
    extends Job {
        CellProperties dialog;

        protected SetCellOptions(CellProperties dialog) {
            super("Change Cell Options", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it = this.dialog.origValues.keySet().iterator();
            while (it.hasNext()) {
                Technology tech;
                Cell cell = (Cell)it.next();
                PerCellValues pcv = this.dialog.getPCV(cell);
                if (pcv.disAllMod.getBoolean() != pcv.disAllMod.getBooleanFactoryValue()) {
                    if (pcv.disAllMod.getBoolean()) {
                        cell.setAllLocked();
                    } else {
                        cell.clearAllLocked();
                    }
                }
                if (pcv.disInstMod.getBoolean() != pcv.disInstMod.getBooleanFactoryValue()) {
                    if (pcv.disInstMod.getBoolean()) {
                        cell.setInstancesLocked();
                    } else {
                        cell.clearInstancesLocked();
                    }
                }
                if (pcv.inCellLib.getBoolean() != pcv.inCellLib.getBooleanFactoryValue()) {
                    if (pcv.inCellLib.getBoolean()) {
                        cell.setInCellLibrary();
                    } else {
                        cell.clearInCellLibrary();
                    }
                }
                if (pcv.useTechEditor.getBoolean() != pcv.useTechEditor.getBooleanFactoryValue()) {
                    if (pcv.useTechEditor.getBoolean()) {
                        cell.setInTechnologyLibrary();
                    } else {
                        cell.clearInTechnologyLibrary();
                    }
                }
                if (pcv.defExpanded.getBoolean() != pcv.defExpanded.getBooleanFactoryValue()) {
                    if (pcv.defExpanded.getBoolean()) {
                        cell.setWantExpanded();
                    } else {
                        cell.clearWantExpanded();
                    }
                }
                if (pcv.charX.getDouble() != ((Double)pcv.charX.getFactoryValue()).doubleValue() || pcv.charY.getDouble() != ((Double)pcv.charY.getFactoryValue()).doubleValue()) {
                    cell.setCharacteristicSpacing(pcv.charX.getDouble(), pcv.charY.getDouble());
                }
                if (!pcv.frameSize.getString().equals(pcv.frameSize.getFactoryValue())) {
                    cell.newVar(User.FRAME_SIZE, (Object)pcv.frameSize.getString());
                }
                if (pcv.frameSize.getString().length() != 0 && pcv.designerName.getString().length() == 0) {
                    pcv.designerName.setString(System.getProperty("user.name"));
                }
                if (!pcv.designerName.getString().equals(pcv.designerName.getFactoryValue())) {
                    cell.newVar(User.FRAME_DESIGNER_NAME, (Object)pcv.designerName.getString());
                }
                if (pcv.technologyName.getString().equals(pcv.technologyName.getFactoryValue()) || (tech = Technology.findTechnology(pcv.technologyName.getString())) == null) continue;
                cell.setTechnology(tech);
            }
            return true;
        }
    }

    private static class TextFieldListener
    implements DocumentListener {
        CellProperties dialog;

        TextFieldListener(CellProperties dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.textInfoChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.textInfoChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.textInfoChanged();
        }
    }

    private static class PerCellValues {
        Pref disAllMod;
        Pref disInstMod;
        Pref inCellLib;
        Pref useTechEditor;
        Pref defExpanded;
        Pref charX;
        Pref charY;
        Pref frameSize;
        Pref designerName;
        Pref technologyName;

        private PerCellValues(Cell cell) {
            this.disAllMod = Pref.makeBooleanPref(null, null, cell.isAllLocked());
            this.disInstMod = Pref.makeBooleanPref(null, null, cell.isInstancesLocked());
            this.inCellLib = Pref.makeBooleanPref(null, null, cell.isInCellLibrary());
            this.useTechEditor = Pref.makeBooleanPref(null, null, cell.isInTechnologyLibrary());
            this.defExpanded = Pref.makeBooleanPref(null, null, cell.isWantExpanded());
            double cX = 0.0;
            double cY = 0.0;
            Dimension2D spacing = cell.getCharacteristicSpacing();
            if (spacing != null) {
                cX = spacing.getWidth();
                cY = spacing.getHeight();
            }
            this.charX = Pref.makeDoublePref(null, null, cX);
            this.charY = Pref.makeDoublePref(null, null, cY);
            String fSize = "";
            Variable var = cell.getVar(User.FRAME_SIZE, class$java$lang$String == null ? (class$java$lang$String = CellProperties.class$("java.lang.String")) : class$java$lang$String);
            if (var != null) {
                fSize = (String)var.getObject();
            }
            this.frameSize = Pref.makeStringPref(null, null, fSize);
            String dName = "";
            var = cell.getVar(User.FRAME_DESIGNER_NAME, class$java$lang$String == null ? (class$java$lang$String = CellProperties.class$("java.lang.String")) : class$java$lang$String);
            if (var != null) {
                dName = (String)var.getObject();
            }
            this.designerName = Pref.makeStringPref(null, null, dName);
            String tName = cell.getTechnology().getTechName();
            this.technologyName = Pref.makeStringPref(null, null, tName);
        }
    }
}

