/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StratPartType
extends Strategy {
    private Map typeCodeToTypeName = new HashMap();
    private Set pinTypes;

    private StratPartType(Set pinTypes, NccGlobals globals) {
        super(globals);
        this.pinTypes = pinTypes;
    }

    private LeafList doYourJob2() {
        EquivRecord parts = this.globals.getParts();
        LeafList offspring = this.doFor(parts);
        this.setReasons(offspring);
        this.summary(offspring);
        return offspring;
    }

    private void setReasons(LeafList offspring) {
        Iterator it = offspring.iterator();
        while (it.hasNext()) {
            EquivRecord r = (EquivRecord)it.next();
            int value = r.getValue();
            String reason = "part type is " + this.typeCodeToTypeName.get(new Integer(value));
            this.globals.status2(reason);
            r.setPartitionReason(reason);
        }
    }

    private void summary(LeafList offspring) {
        this.globals.status2("StratPartType produced " + offspring.size() + " offspring");
        if (offspring.size() != 0) {
            this.globals.status2(offspring.sizeInfoString());
            this.globals.status2(this.offspringStats(offspring));
        }
    }

    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Part), "StratPartType expects only Parts");
        Part p = (Part)n;
        Integer typeCode = new Integer(p.typeCode());
        String typeName = p.typeString();
        String oldTypeName = (String)this.typeCodeToTypeName.get(typeCode);
        if (oldTypeName != null) {
            this.globals.error(!typeName.equals(oldTypeName), "type code maps to multiple type names");
        } else {
            this.typeCodeToTypeName.put(typeCode, typeName);
            Set partPinTypes = p.getPinTypes();
            this.pinTypes.addAll(partPinTypes);
        }
        return typeCode;
    }

    public static LeafList doYourJob(Set pinTypes, NccGlobals globals) {
        StratPartType pow = new StratPartType(pinTypes, globals);
        return pow.doYourJob2();
    }
}

