/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StratAdjacent
extends Strategy {
    private int numEquivProcessed;
    private int numAdjacentUnique;
    private Set adjacent = new HashSet();

    private StratAdjacent(NccGlobals globals) {
        super(globals);
    }

    public static LeafList doYourJob(RecordList l, NccGlobals globals) {
        StratAdjacent ja = new StratAdjacent(globals);
        return ja.doFor(l);
    }

    private void preamble(RecordList j) {
    }

    private LeafList summary() {
        LeafList offspring = new LeafList();
        Iterator it = this.adjacent.iterator();
        while (it.hasNext()) {
            offspring.add((EquivRecord)it.next());
        }
        this.globals.println(" StratAdjacent" + this.offspringStats(offspring));
        return offspring.selectActive(this.globals);
    }

    public LeafList doFor(RecordList g) {
        this.preamble(g);
        super.doFor(g);
        return this.summary();
    }

    private void addAdjacentEquivRecs(EquivRecord er) {
        Iterator ci = er.getCircuits();
        while (ci.hasNext()) {
            Circuit jc = (Circuit)ci.next();
            Iterator ni = jc.getNetObjs();
            while (ni.hasNext()) {
                NetObject netObj = (NetObject)ni.next();
                Iterator it = netObj.getConnected();
                while (it.hasNext()) {
                    netObj = (NetObject)it.next();
                    EquivRecord sg = netObj.getParent().getParent();
                    if (!sg.isActive()) continue;
                    this.adjacent.add(sg);
                }
            }
        }
    }

    public LeafList doFor(EquivRecord g) {
        if (g.isLeaf()) {
            ++this.numEquivProcessed;
            this.addAdjacentEquivRecs(g);
        } else {
            this.globals.println("processing " + g.nameString());
            super.doFor(g);
        }
        return new LeafList();
    }
}

