/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Mart.nez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_EXCEPTION
    Description : General GNU/EDMA exception class
    Author      : David Martnez Oliveira
    Date        : March, 25th, 2002
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <../include/edma.h>


/*
***************************************************
  Private Data Struct for class EDMA_EXCEPTION
***************************************************
*/
 
typedef struct
{
	ESint32		type;
	EPChar		desc;
}DtEDMA_EXCEPTION;
/*
***************************************************
  Method Declaration for class EDMA_EXCEPTION
***************************************************
*/
 
ESint32 EDMAPROC
EDMA_EXCEPTIONprint(OBJID IdObj)
{
  DtEDMA_EXCEPTION	*m;
  
  m = (DtEDMA_EXCEPTION *) edma_get_data_ref (IdObj);

  edma_print  (">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
  edma_print  ("[EDMA_EXCEPTION] print");
  edma_printf ("    Type        : %ld", m->type);
  edma_printf ("    Description : %s", m->desc);
  edma_print  (">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
  
  return 0;
}


ESint32 EDMAPROC
EDMA_EXCEPTIONbrief(OBJID IdObj)
{
  DtEDMA_EXCEPTION	*m;
  
  m = (DtEDMA_EXCEPTION *) edma_get_data_ref (IdObj);
  
  edma_printf ("[EDMA_EXCEPTION] <%ld> :: %s", m->type, m->desc);

  return 0;
}


ESint32 EDMAPROC
EDMA_EXCEPTIONthrow(OBJID IdObj)
{
  DtEDMA_EXCEPTION	*m;
  
  m = (DtEDMA_EXCEPTION *) edma_get_data_ref (IdObj);

  edma_exception_throw (IdObj);
  return 0;
}


ESint32 EDMAPROC
EDMA_EXCEPTIONsetS32Z(OBJID IdObj, ESint32 type, EPChar msg)
{
  DtEDMA_EXCEPTION	*m;

  m = (DtEDMA_EXCEPTION *) edma_get_data_ref (IdObj);
  edma_wprop3 (IdObj, "type", type);
  edma_wprop3 (IdObj, "desc", msg);
  return 0;
}


ESint32
EDMA_EXCEPTION_class_factory ()
{
CLASSID    cid;

cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

edma_idf_set_class_name (cid, "EDMA_EXCEPTION");

edma_idf_set_class_namespace (cid, "");
edma_idf_set_class_version (cid, 0, 0);

edma_add_local_class_property (cid, "type", DT_ESINT32, E_L, 0);
edma_add_local_class_property (cid, "desc", DT_EZSTRING, E_L, 0);

	/*UNKNOW ()*/
	/*UNKNOW ()*/
 /* Method registration */
edma_add_local_class_method (cid, "print", "", (PPROC)EDMA_EXCEPTIONprint, 1, 0, 0);
edma_add_local_class_method (cid, "throw", "", (PPROC)EDMA_EXCEPTIONthrow, 1, 0, 0);
edma_add_local_class_method (cid, "set", "S32Z", (PPROC)EDMA_EXCEPTIONsetS32Z, 1, 0, 0);
edma_add_local_class_method (cid, "brief", "", (PPROC)EDMA_EXCEPTIONbrief, 1, 0, 0);


edma_idf_set_class_id (cid);

return cid;
}


/********** END C IMPLEMENTATION SKELETON ******************/
