// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonne.h"
#include <cc++/slog.h>

#define TiNG_USE_RESOURCE_MANAGER

#ifdef	__linux__
#define	TiNGTYPE_LINUX
#endif

extern "C" {

#include <mvcldrvr.h>
#include <mvswdrvr.h>
#include <smdrvr.h>
#include <smbesp.h>
#include <smhlib.h>
#include <smclib.h>
#include <smwavlib.h>
#include <smbfhlib.h>
#include <smbfwavlib.h>
#include <smdc.h>
#ifdef HAVE_ACULAB_ASR
#include "smcwr_api.h"
#endif

};

#define MAXTIMESLOTS    32
#define MAXCHANNELS     30

/* Maximum number of channel identifiers (see sm_get_channel_ix() api
 * call in Aculab API docs).  Range is 0 <= index <= (2*x64*N) where
 * N is maximum number of Prosody modules installable in the system.
 */
#define MAX_CH_IDX      (2*64*10)


/*
 * MVIP bus definitions
 *    
 * The MVIP bus is defined as 16 streams, each capable of
 * carrying 32 unidirectional 64kbit speech paths (timeslots).
 *
 * Streams DSi0->DSi7 are input (network to DSP)
 * Streams DSo0->DSo7 are output (DSP to network)
 *
 * A full-duplex call would thus require timeslots two timelots
 * (one in, one out).  The total number of full-duplex streams is
 * thus half, for a total of 8.
 */
#ifdef MVIP_BASED
        #define MVIP_FD_STREAMS         8
        #define MVIP_TIMESLOTS          32
#else
        #define MVIP_FD_STREAMS         16
        #define MVIP_TIMESLOTS          128
#endif

namespace acudriver {
using namespace ost;
using namespace std;

class Session;
class Span;

typedef struct
{
	enum
	{
        	INVALID_PORT,
        	FAILED_PORT,
        	PRI_PORT,
       	 	BRI_PORT
	}	ptype;
}  endpoint_t;

typedef struct
{
	int port;
	int timeslot;
} devnode_t;

class Driver : public BayonneDriver, public Thread
{
public:
	friend class Session;
	static Driver aculab;	// plugin activation
	
	Driver();

protected:
	endpoint_t endpoint[MAXPORT];
	struct siginfo_xparms siginfo[MAXPORT];
        int MVIP[MVIP_FD_STREAMS * MVIP_TIMESLOTS];
	unsigned bri_count, pri_count;

	unsigned getMaxPorts(void);

	Session **pmaps;
	Session **imaps;
	Session **omaps;
	Session **ixmaps;
	devnode_t *devnodes;
	char *tsmap;

	void startDriver(void);
	void stopDriver(void);

	void run(void);
};

class Session : public BayonneSession, public TimerPort
{
protected:
	friend class Driver;
	devnode_t *devnode;

public:
	Session(BayonneSpan *span, timeslot_t ts, devnode_t *node);
	~Session();

        // core timer virtuals all port session objects need to define
        timeout_t getRemaining(void);
        void startTimer(timeout_t timer);
        void stopTimer(void);
};


} // end namespace
