// Copyright (C) 2000-2002 Open Source Telecom Corporation.
// 
// Author: Jeremy J. McNamara 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif

char OH323Trunk::status[250];

OH323Trunk::OH323Trunk(tpport_t port, int ts) :
Trunk(ts), TimerPort()
{
	handler = NULL;
	lastring = 0;
}

OH323Trunk::~OH323Trunk()
{
}

void OH323Trunk::initSyms(void)
{
	setConst(SYM_NETWORK, "none");
	setConst(SYM_INTERFACE, "h323");
}

bool OH323Trunk::postEvent(TrunkEvent *event)
{
	bool rtn = true;
	trunkhandler_t prior;

	enterMutex();

	switch(event->id)
	{
	case TRUNK_TIMER_EXPIRED:
		if(!TimerPort::getTimer())
			rtn = false;
		break;
	case TRUNK_DTMF_KEYUP:
		if(Trunk::flags.offhook)
			time(&idletime);
		if(!Trunk::flags.dtmf)
			rtn = false;
		break;
	}

	if(!rtn)
	{
		leaveMutex();
		return false;
	}

	if(!handler)
	{
		leaveMutex();
		return false;
	}
	leaveMutex();

	return true;
}

void OH323Trunk::getName(char *buffer)
{
	sprintf(buffer, "rtp(%d)", id);
}

void OH323Trunk::exit(void)
{
	char buffer[33];
	getName(buffer);
	slog(Slog::levelDebug) << buffer << ": script exiting" << endl;
//	handler = &OH323Trunk::hangupHandler;
}

unsigned long OH323Trunk::getIdleTime(void) 
{
        time_t now;
 

	time(&now); 
// 	if(handler == &OH323Trunk::idleHandler) 
		// return now - idle;
 
        return 0; 
}
 
void OH323Trunk::timerTick(void)
{
	TrunkEvent event;

	enterMutex();
	if(TimerPort::getTimer())
	{
		leaveMutex();
		return;
	}
	TimerPort::endTimer();
	event.id = TRUNK_TIMER_EXPIRED;
	postEvent(&event);
	leaveMutex();
}
		 
#ifdef	CCXX_NAMESPACES
};
#endif     
