/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (pseudo.x)
 *  
 *  It has been AutoGen-ed  Sunday April 15, 2001 at 02:29:01 PM PDT
 *  From the definitions    pseudo.def
 *  and the template file   fsm
 *
 *  Automated Finite State Machine
 *
 *  This file describes a finite state machine.  It consists of three
 *  enumerations:
 *
 *  1.  The available states.  FSS_INIT is always defined to be zero
 *      and FSS_INVALID and FSS_DONE are always made the last entries.
 *  2.  The transition tokens.  These enumerate the token values used
 *      to select the next state from the current state.
 *      FST_INVALID is always defined at the end.
 *  3.  The list of valid state + transition token names.  Only the
 *      transitions defined to be valid are enumerated.
 *
 *  Plus a transition table indexed by current state and then the
 *  transition token enumeration.  The table contains both the next
 *  state *and* the appropriate state/transition enumeration.
 *
 *  If you AutoGen this with "EXAMPLE" defined in your environment,
 *  this template will also produce example code for your FSM.
 *
 *  AutoFSM is free software copyrighted by Bruce Korb.
 *  
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name ``Bruce Korb'' nor the name of any other
 *     contributor may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *  
 *  AutoFSM IS PROVIDED BY Bruce Korb ``AS IS'' AND ANY EXPRESS
 *  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL Bruce Korb OR ANY OTHER CONTRIBUTORS
 *  BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Here are the available states.
 */
typedef enum {
    FSS_INIT = 0,  FSS_ST_MARK,   FSS_AGEN,      FSS_TEMPL,     FSS_END_MARK,
    FSS_INVALID,   FSS_DONE
} te_fsm_state;

/*
 *  The transition tokens.
 */
typedef enum {
    FST_ED_MODE,      FST_MARKER,       FST_END_PSEUDO,   FST_AUTOGEN,
    FST_TEMPLATE,     FST_SUFFIX,       FST_INVALID
} te_fsm_token;

/*
 *  This enumerates all the valid state + token-name transitions.
 *  It is actually possible to have multiple specifications for a single
 *  pair, but we unique sort the list and eliminate dups that way.
 *  The last one specified will be the only one effective.
 */
typedef enum {
    FSX_AGEN_ED_MODE,
    FSX_AGEN_TEMPLATE,
    FSX_END_MARK_ED_MODE,
    FSX_END_MARK_END_PSEUDO,
    FSX_INIT_ED_MODE,
    FSX_INIT_MARKER,
    FSX_ST_MARK_AUTOGEN,
    FSX_ST_MARK_ED_MODE,
    FSX_TEMPL_ED_MODE,
    FSX_TEMPL_MARKER,
    FSX_TEMPL_SUFFIX,
    FSX_INVALID
}  te_transition;

typedef struct transition t_transition;
struct transition {
    te_fsm_state     next_state;
    te_transition    trans_type;
};

/*
 *  This table maps the state enumeration + the token enumeration to
 *  the transition enumeration code and the new state.
 *  It is indexed by first the current state and then the token code.
 *  There are no transition entries defined for the INVALID or DONE
 *  states, obviously  :-).
 */
static t_transition trans_table[ 5 ][ 6 ] = {
  { { FSS_INIT, FSX_INIT_ED_MODE },     { FSS_ST_MARK, FSX_INIT_MARKER },
    { FSS_INVALID, FSX_INVALID },       { FSS_INVALID, FSX_INVALID },
    { FSS_INVALID, FSX_INVALID },       { FSS_INVALID, FSX_INVALID } },

  { { FSS_ST_MARK, FSX_ST_MARK_ED_MODE },
    { FSS_INVALID, FSX_INVALID },
    { FSS_INVALID, FSX_INVALID },
    { FSS_AGEN, FSX_ST_MARK_AUTOGEN },
    { FSS_INVALID, FSX_INVALID },
    { FSS_INVALID, FSX_INVALID } },

  { { FSS_AGEN, FSX_AGEN_ED_MODE },     { FSS_INVALID, FSX_INVALID },
    { FSS_INVALID, FSX_INVALID },       { FSS_INVALID, FSX_INVALID },
    { FSS_TEMPL, FSX_AGEN_TEMPLATE },   { FSS_INVALID, FSX_INVALID } },

  { { FSS_TEMPL, FSX_TEMPL_ED_MODE },     { FSS_END_MARK, FSX_TEMPL_MARKER },
    { FSS_INVALID, FSX_INVALID },         { FSS_INVALID, FSX_INVALID },
    { FSS_INVALID, FSX_INVALID },         { FSS_TEMPL, FSX_TEMPL_SUFFIX } },

  { { FSS_INVALID, FSX_END_MARK_ED_MODE },
    { FSS_INVALID, FSX_INVALID },
    { FSS_DONE, FSX_END_MARK_END_PSEUDO },
    { FSS_INVALID, FSX_INVALID },
    { FSS_INVALID, FSX_INVALID },
    { FSS_INVALID, FSX_INVALID } }
};

#ifndef tSCC
#  define tSCC static const char
#endif

    int
fsm_invalid_transition( te_fsm_state old_state, te_fsm_token tkn )
{
    tSCC zBogus[]   = "** OUT-OF-RANGE **";
    tSCC zInvalid[] = "* Invalid Token *";
    tSCC zStInit[]  = "init";
    tSCC zFsmErr[]  =
        "FSM Error:  in state %d (%s), token %d (%s) is invalid\n";

    tSCC zStSt_Mark[] = "st_mark";
    tSCC zStAgen[] = "agen";
    tSCC zStTempl[] = "templ";
    tSCC zStEnd_Mark[] = "end_mark";
    tSCC* apzStates[] = {
        zStInit,      zStSt_Mark,   zStAgen,      zStTempl,     zStEnd_Mark };

    tSCC zTkEd_Mode[] = "ed_mode";
    tSCC zTkMarker[] = "marker";
    tSCC zTkEnd_Pseudo[] = "end_pseudo";
    tSCC zTkAutogen[] = "autogen";
    tSCC zTkTemplate[] = "template";
    tSCC zTkSuffix[] = "suffix";
    tSCC* apzTokens[] = {
        zTkEd_Mode,      zTkMarker,       zTkEnd_Pseudo,   zTkAutogen,
        zTkTemplate,     zTkSuffix,       zInvalid };

    const char* pzState;
    const char* pzToken;

    if ((unsigned)old_state >= FSS_INVALID)
         pzState = zBogus;
    else pzState = apzStates[ old_state ];

    if ((unsigned)tkn > FST_INVALID)
         pzToken = zBogus;
    else pzToken = apzTokens[ tkn ];

    fprintf( stderr, zFsmErr, old_state, pzState, tkn, pzToken );
    return EXIT_FAILURE;
}
