/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 10 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 september 2007, Siracusa, Jean Michel Sellier

// Initial configuration of the simulated particles and device

void device_setup(void)
{
 long int n=0; 
 int i,np,m;
 double c1,c2=0.,c3,c4,c5,c6,c7;
 
// calculation of the volume of every element
 for(i=0;i<Ne;i++){
    double xa,ya,za;
    double xb,yb,zb;
    double xc,yc,zc;
    double xd,yd,zd;
    double ambx, amby, ambz;
    double bmcx, bmcy, bmcz;
    double cmdx, cmdy, cmdz;
//    printf("i = %d\n",i);
    xa=coord[0][noeud_geo[0][i]-1]; 
    ya=coord[1][noeud_geo[0][i]-1]; 
    za=coord[2][noeud_geo[0][i]-1];
    
    xb=coord[0][noeud_geo[1][i]-1]; 
    yb=coord[1][noeud_geo[1][i]-1]; 
    zb=coord[2][noeud_geo[1][i]-1];
    
    xc=coord[0][noeud_geo[2][i]-1]; 
    yc=coord[1][noeud_geo[2][i]-1]; 
    zc=coord[2][noeud_geo[2][i]-1];
    
    xd=coord[0][noeud_geo[3][i]-1]; 
    yd=coord[1][noeud_geo[3][i]-1]; 
    zd=coord[2][noeud_geo[3][i]-1];
    
    ambx=xa-xb; amby=ya-yb; ambz=za-zb;
    bmcx=xb-xc; bmcy=yb-yc; bmcz=zb-zc;
    cmdx=xc-xd; cmdy=yc-yd; cmdz=zc-zd;
//printf("qui\n");
    VOLUME[i]=fabs(ambx*bmcy*cmdz+amby*bmcz*cmdx+ambz*bmcx*cmdy
              -cmdx*bmcy*ambz-cmdy*bmcz*ambx-cmdz*bmcx*amby)/6.;    
//if(VOLUME[i]==0.){
//    printf("volume[%d]=%g\n",i,VOLUME[i]);
//    printf("%g %g %g\n",xa,ya,za);
//    printf("%g %g %g\n",xb,yb,zb);
//    printf("%g %g %g\n",xc,yc,zc);
//    printf("%g %g %g\n",xd,yd,zd);
//}
 }

// Number of carriers per particle in every element
 for(i=0;i<Ne;i++) EPP[i]=DDMAX*VOLUME[i]/NP1;

 for(i=0;i<Ne;i++){
//     printf("i=%d\n",i);
// np=number of particles in the i-th element
     np=(int)(ND[i]*VOLUME[i]/EPP[i]+0.5);
     if(ND[i]==0.) np=0;
//if(np<NP1) printf("i = %d    np = %d \n",i,np);
     if(vois[0][i]==-1 || vois[1][i]==-1 ||
        vois[2][i]==-1 || vois[3][i]==-1) np/=2;
     if(np>0){
      for(m=1;m<=np;m++){
        n++;
        if(n>NPMAX){
         printf("device setup error : too much particles n = %ld > %d!\n",n,NPMAX);
         exit(EXIT_FAILURE);
        }
// We assume that the particles are initially at near thermal equilibrium

// In the case of 2-valleys materials, 80% of the electrons are considered in 
// the first valley in the starting simulation time, while the other 20% are
// in the second valley.
      IV=1;
      c1=log(rnd());
      if(i_dom[i]!=SIO2 && NOVALLEY[i_dom[i]]==1) 
       c2=SMH[i_dom[i]][IV]*sqrt(-1.5*BKTQ*c1*(1.-alphaK[i_dom[i]][1]*1.5*BKTQ*c1));
      if(i_dom[i]!=SIO2 && NOVALLEY[i_dom[i]]==2){
       IV=1;
       c2=SMH[i_dom[i]][IV]*sqrt(-1.5*BKTQ*c1*(1.-alphaK[i_dom[i]][1]*1.5*BKTQ*c1));
       if(rnd()>0.8){
        IV=2;
        c2=SMH[i_dom[i]][IV]*sqrt(-1.5*BKTQ*c1*(1.-alphaK[i_dom[i]][2]*1.5*BKTQ*c1));
       }
      }
      c3=1.-2.*rnd();
      c4=sqrt(1.-c3*c3);
      c5=2.*PI*rnd();
      c6=sin(c5);
      c7=cos(c5);
// IV-th valley
      P[n][0]=IV;
// x-, y- and z-component of pseudo wave vector
      P[n][1]=c2*c3*c6;
      P[n][2]=c2*c4*c6;
      P[n][3]=c2*c7;
// free flight time
      P[n][4]=-log(rnd())/GM[i_dom[i]];
// baricentric coordinates of the n-th particle
      P[n][5]=rnd();
      P[n][6]=rnd();
      P[n][7]=rnd();
      P[n][8]=4.-(P[n][5]+P[n][6]+P[n][7]);

// P[n][9]=i means that the n-th particle belongs to the i-th element
      P[n][9]=i;
      if(i_dom[i]==SIO2) n--;
     } // end of m-cycle
    } // end of if(np>0)
  } // end of i-cycle
 INUM = n;
 NPMAX0 = INUM;
 printf("Initial Number of Electron Super-particles = %d\n", INUM);
}
