/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 06 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 august 2007, Siracusa, Jean Michel Sellier

// define the vector ****d_base_K. see pag.323 par.9.2.5 of french book

void define_d_base_K(void)
{
 int k,n,m;
 
// reset the array
// memset(&d_base_K,0,sizeof(d_base_K));
 for(k=0;k<dim;k++)
  for(n=0;n<nf;n++)
    for(m=0;m<Ne;m++)
     d_base_K[k][n][m]=0.0;
     
// compute the various components of the array
 for(k=0;k<dim;k++)
  for(n=0;n<nf;n++)
   for(m=0;m<Ne;m++){
    int k2;
    for(k2=0;k2<dim;k2++) d_base_K[k][n][m]+=d_base_ref[k2][n]*inv_jac_K[k2][k][m];
   }
/* for(k=0;k<dim;k++)
  for(n=0;n<nf;n++)
   for(l=0;l<lg;l++)
    for(m=0;m<Ne;m++) printf("d_base_K[%d][%d][%d][%d]= %g\n",k,n,l,m,d_base_K[k][n][l][m]);
*/
 printf("components of derivatives of shape functions computed...\n");
}

