/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 17 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 august 2007, Siracusa, Jean Michel Sellier

// The input file unit is the micron
//   Purpose       : Load the 3D msh (Version 1.0) format device.msh

// warning! this subroutine has to be used only if the user is 
// well experienced with GMSH.

void load_mshV1(char inp[])
{
 int i;
 int dum;
 int nodes_offset=0;
 int elements_offset=0;
 char s[180];
 
 FILE *fp;

 fp=fopen(inp,"r");

// check the existence of the input file
// *************************************
// if the file does not exist the code close the PETSc library and exit.
 if(fp==NULL){
   printf("INPUT file 'device.msh' does not exist\nexit\n");
   system("PAUSE");
   exit(0);
 }

// *************************************************************
//  Load 'device.geo' and store the mesh in the correct arrays
// *************************************************************

// Check if the first row is $NOD, which is equivalent to check if
// the file is really a msh v1.0 file.
 fscanf(fp,"%s",s);
 if(strcmp(s,"$NOD")!=0){
    printf("load_smhV1.0 error : the input file is not in msh v1.0 format!\n");
    printf("loaded value is : %s\n",s);
    system("PAUSE");
    exit(0);
 }
// Read the number of vertices
// ***************************
// Ng = number of vertices of the mesh (nombre total de noeuds du maillage)
 fscanf(fp,"%d",&Ng);
 printf("Number of vertices = %d\n",Ng);

// allocation for i_front
/*  printf("Allocating memory for mesh arrays...\n");
  i_front = malloc((Ng+1)*sizeof(int));
  if(i_front==NULL){
    printf("load_mshV1 : not enough memory for V allocation!\n");
    system("PAUSE");
    exit(0);
  }
  for(i=0;i<3;i++){
    coord[i] = malloc((Ng+1)*sizeof(double));
    if(coord[i]==NULL){
      printf("load_mshV1 : not enough memory for coord[%d] allocation!\n",i);
      system("PAUSE");
      exit(0);
    }
  }*/


// read the global coordinate of the mesh vertices and related reference number
// ****************************************************************************
// i_front[i] = reference number of the i-th vertex (nombre de reference du noeud)
//               This number = 0 if we are inside the device
//                 ''       != 0 if we are on the frontier
//               In this latter case this number makes one understand what
//               kind of boundary conditions one has to impose on that vertex.
// coord[0][i] = global coordinate x of the i-th vertex (i=0..Ng-1)
// coord[1][i] = global coordinate y of the i-th vertex
// coord[2][i] = global coordinate z of the i-th vertex
// French comment:
// Pour k=0..dim-1 (dim = dimension de l'espace) et n=0..Ng-1, coord[k][n] est la k-ieme
// coordonee du noeud de numero global n.


 for(i=0;i<Ng;i++){
   fscanf(fp,"%d",&dum);
   if(i==0) nodes_offset=dum;
//   printf("dum = %d\n",dum);
   fscanf(fp,"%lg %lg %lg\n",&coord[0][dum-nodes_offset],
                             &coord[1][dum-nodes_offset],
                             &coord[2][dum-nodes_offset]);
   coord[0][dum-nodes_offset]*=1.e-6;
   coord[1][dum-nodes_offset]*=1.e-6;
   coord[2][dum-nodes_offset]*=1.e-6;
   
//   printf("%d %2.20g %2.20g %2.20g\n",dum-nodes_offset,
//                                   coord[0][dum-nodes_offset],
//                                   coord[1][dum-nodes_offset],
//                                   coord[2][dum-nodes_offset]);
 }

// Read informations about the various tetrahedra
// **********************************************
// (this gives us informations about the definition of tetrahedra)
// i_dom[i] = reference number of the i-th tetrahedra
// noeud_geo[0][i] = global number of the first vertex in the i-th tetrahedra
// noeud_geo[1][i] = global number of the second vertex in the i-th tetrahedra
// noeud_geo[2][i] = global number of the third vertex in the i-th tetrahedra
// noeud_geo[3][i] = global number of the fourth vertex in the i-th tetrahedra

// check if the msh input file is not corrupted
 fscanf(fp,"%s\n",s);
 if(strcmp(s,"$ENDNOD")!=0){
    printf("load_smhV1.0 error : the input file is probably corrupted...!\n");
    printf("loaded value is : %s\n",s);
    printf("the expected value should be : $ENDNOD.\n");
    system("PAUSE");
    exit(0);
 }

 fscanf(fp,"%s\n",s);
 if(strcmp(s,"$ELM")!=0){
    printf("load_smhV1.0 error : the input file is probably corrupted...!\n");
    printf("loaded value is : %s\n",s);
    printf("the expected value should be : $ELM.\n");
    system("PAUSE");
    exit(0);
 }

 fscanf(fp,"%d",&dum);
 Ne=0;
 int flag=0;
 for(i=0;i<dum;i++){
   int j;
   int eltype=0;
   int ref;
   int nonodes;
   int dum2;
//   printf("i=%d\n",i);
   fscanf(fp,"%d %d %*d %*d %d",&ref,&eltype,&nonodes);
//   printf("%d %d\n",ref,eltype);
   if(eltype==4) flag=1;
   if(flag==0) elements_offset=ref+1;
//   printf("eo=%d\n",elements_offset);
   if(eltype!=4) for(j=1;j<=nonodes;j++) fscanf(fp,"%*d\n");
   if(eltype==4) 
      for(j=1;j<=nonodes;j++){
         fscanf(fp,"%d",&dum2);
//         noeud_geo[j-1][ref-elements_offset]=dum2-nodes_offset+1;
      }
//   if(eltype==4) printf("%d %d %d %d %d\n",ref-elements_offset,
//                        noeud_geo[0][ref-elements_offset],
//                        noeud_geo[1][ref-elements_offset],
//                        noeud_geo[2][ref-elements_offset],
//                        noeud_geo[3][ref-elements_offset]);
   if(eltype==4) Ne++;
 }

 printf("Number of elements (tetrahedra) = %d\n",Ne);

// allocation for i_dom
/*  i_dom = malloc((Ne+1)*sizeof(int));
  for(i=0;i<4;i++) noeud_geo[i] = malloc((Ne+1)*sizeof(int));
  if(i_dom==NULL){
    printf("load_mesh : not enough memory for i_front allocation!\n");
    system("PAUSE");
    exit(0);
  }*/

 fclose(fp);

// read the file a second time for the noeud_geo array
// ---------------------------------------------------
 fp=fopen(inp,"r");
 fscanf(fp,"%*s"); fscanf(fp,"%*d");
 for(i=0;i<Ng;i++){
   fscanf(fp,"%d",&dum); fscanf(fp,"%*g %*g %*g\n");
 }
 fscanf(fp,"%s\n",s); fscanf(fp,"%s\n",s);
 fscanf(fp,"%d",&dum);
 Ne=0;
 flag=0;
 for(i=0;i<dum;i++){
   int j, eltype=0, ref, nonodes, dum2;
   fscanf(fp,"%d %d %*d %*d %d",&ref,&eltype,&nonodes);
   if(eltype==4) flag=1;
   if(flag==0) elements_offset=ref+1;
   if(eltype!=4) for(j=1;j<=nonodes;j++) fscanf(fp,"%*d\n");
   if(eltype==4)
      for(j=1;j<=nonodes;j++){
         fscanf(fp,"%d",&dum2);
         noeud_geo[j-1][ref-elements_offset]=dum2-nodes_offset+1;
      }
   if(eltype==4) Ne++;
 }
 fclose(fp);
// ---------------------------------------------------
  
// various dynamical allocations
#include "../services/dynamical_allocations.h"
}
