/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 09 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 09 june 2007, Siracusa, Jean Michel Sellier

// Here we construct the neighbourhood table which is done as follows
// vois[i][j] = is the global number of the i-th neighbour, 0<=i<=3 (tetrahedra)
//              of the j-th element, 0<=j<=Ne-1.
// By convention, we put vois[n][m]=-1 if the face opposed to n-th node of the
// m-th element belongs to the frontier.

void neighbourhood_table(void)
{
 int i,j,k,l,m;
 FILE *fp;

// open the output file on which we save the computed neighbourhood table
 fp=fopen("neighbourhood_table.dat","w");
 if(fp==NULL){
  printf("neighbourhood_table error : problem in saving the file!\n");
  system("PAUSE");
  exit(0);
 }
// at the beginning all the values are a negative number
 for(i=0;i<Ne;i++) for(j=0;j<4;j++) vois[j][i]=-10;

// neighbours search on every element
 for(i=0;i<Ne;i++){
   int vertex[3];
// we store the 3 vertices of the i-th tetrahedra opposite to the j-th vertex
    for(j=0;j<4;j++){
     if(vois[j][i]==-10){ // i.e. if this neighbourhoodness has never been found...
//      printf("%d ",i);
      if(j==0){
        vertex[0]=noeud_geo[1][i];
        vertex[1]=noeud_geo[2][i];
        vertex[2]=noeud_geo[3][i];
      }
      if(j==1){
        vertex[0]=noeud_geo[0][i];
        vertex[1]=noeud_geo[2][i];
        vertex[2]=noeud_geo[3][i];        
      }
      if(j==2){
        vertex[0]=noeud_geo[0][i];
        vertex[1]=noeud_geo[1][i];
        vertex[2]=noeud_geo[3][i];
      }
      if(j==3){
        vertex[0]=noeud_geo[0][i];
        vertex[1]=noeud_geo[1][i];
        vertex[2]=noeud_geo[2][i];
      }
      int flag=0;
      for(k=0;k<Ne;k++){
        int sum=0;
        int ten=10; // 10 = 1+2+3+4
        for(m=0;m<3;m++){
          for(l=0;l<4;l++)
            if(vertex[m]==noeud_geo[l][k]){
              sum++;
//              printf("k=%d i=%d sum=%d\n",k,i,sum);
              ten-=(l+1);
            }
        } // end of m-cycle
        if((sum==3) && (i!=k)){
          vois[j][i]=k;
          vois[ten-1][k]=i;
          flag=1;
//          printf("i = %d j = %d k = %d ten = %d\n",i,j,k,ten-1);
        }
      } // end k-cycle
      if(flag==0) vois[j][i]=-1;
     } // end j-cycle
    }
 }    
// save the computed table in a file
 for(i=0;i<Ne;i++){
    for(j=0;j<4;j++) fprintf(fp,"%d ",vois[j][i]);
    fprintf(fp,"\n");
 }
// close the output file
 fclose(fp);
}
