/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 06 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 06 june 2007, Siracusa, Jean Michel Sellier

// Returns the local shape functions (fonctions de formes locales)
// n is the index, i.e. n=1 --> theta_1(xi,eta,xeta) and so on...

double theta(int n,double xi,double eta,double xeta)
{
 if(n==0) return 1-xi-eta-xeta;
 if(n==1) return xi;
 if(n==2) return eta;
 if(n==3) return xeta;
 printf("not recognized index n in function theta!!!\n");
 exit(0);
}
