Index: xstrftm.c
===================================================================
RCS file: /cvs/djgpp/djgpp/tests/libc/ansi/time/xstrftm.c,v
retrieving revision 1.1
diff -p -u -t -r1.1 xstrftm.c
--- xstrftm.c	8 Nov 2003 12:19:41 -0000	1.1
+++ xstrftm.c	17 Mar 2004 06:49:25 -0000
@@ -1,19 +1,38 @@
+#include <locale.h>
 #include <stdio.h>
 #include <string.h>
 #include <time.h>
 
-extern char __dj_date_format[10];
-extern char __dj_time_format[16];
+extern char __dj_date_format[];
+extern char __dj_time_format[];
 
 int main(int ac, char *av[])
 {
   char buf[99];
   time_t t = time(NULL);
+  char *locale;
 
+/* default C locale */
+  locale = setlocale( LC_TIME, NULL );
+  strftime(buf, sizeof(buf), "%x %X", gmtime(&t));
+  printf("%s locale %s\n", locale, buf);
+
+/* current locale */
+  locale = setlocale( LC_TIME, "" );
+  strftime(buf, sizeof(buf), "%x %X", gmtime(&t));
+  printf("%s locale %s\n", locale, buf);
+
+/* custom locale */
+  locale = "custom";
   strcpy(__dj_date_format, "%d|%m|%Y");
   strcpy(__dj_time_format, "[%H|%M|%S]");
+  strftime(buf, sizeof(buf), "%x %X", gmtime(&t));
+  printf("%s locale %s\n", locale, buf);
 
+/* default C locale */
+  locale = setlocale( LC_TIME, "C" );
   strftime(buf, sizeof(buf), "%x %X", gmtime(&t));
-  printf("%s\n", buf);
+  printf("%s locale %s\n", locale, buf);
+
   return 0;
 }
