/* whitebxf.c
   White box tests
   attempt to exercise all paths through each tested function routine.
   Float complex version.

   S. L. Moshier
   May, 2004  */

#include <stdio.h>
#include <math.h>
#include <float.h>
#include "complex.h"

#define TEST_DENORMAL 1

struct oneargument
  {
    char *name;                 /* Name of the function. */
    float complex (*func) (float complex);
    float real_arg;            /* Function argument, assumed exact.  */
    float imag_arg;
    float real_ans;
    float imag_ans;
    int thresh;                 /* Error report threshold. 2 = 1 ULP approx. */
  };


float complex csqrtf (float complex);

struct oneargument test1[] =
{
  { "casinf", casinf, 0.0f, 0.0f, 0.0f, 0.0f, 0},
  { "casinf", casinf, 1.0f, 0.0f, M_PI_2, 0.0f, 0},
  { "casinf", casinf, 2.0f, 0.0f, M_PI_2, 0.0f, 0},
  { "casinf", casinf, 1.0f, -1.0f,
	+6.66239432492515255104004895977792720667490E-1f,
	-1.06127506190503565203301891621357348580679E0f, 0},
  { "casinf", casinf, 1.0f, +1.0f,
	+6.66239432492515255104004895977792720667490E-1f,
	+1.06127506190503565203301891621357348580679E0f, 0},
  { "csinf", csinf, 0.0f, 0.0f, 0.0f, 0.0f, 0},
  { "csinf", csinf, M_PI_2, 0.0f, 1.0f, 0.0f, 0},
  { "csinf", csinf, +6.66239432492515255104004895977792720667490E-1f,
		    -1.06127506190503565203301891621357348580679E0f,
			 1.0f, -1.0f, 0},
  { "csinf", csinf, +6.66239432492515255104004895977792720667490E-1f,
		    +1.06127506190503565203301891621357348580679E0f,
			 1.0f, +1.0f, 0},
  { "catanf", catanf, 0.0f, 0.0f, 0.0f, 0.0f, 0},
  { "catanf", catanf, 0.0f, +1.0f, FLT_MAX, FLT_MAX, 0},
  { "catanf", catanf, 0.0f, -1.0f, FLT_MAX, FLT_MAX, 0},
  { "catanf", catanf, 1.0f, +1.0f,
	+1.01722196789785136772278896155048292206356E0f,
	+4.02359478108525093650189833306546909881400E-1f, 0},
  { "catanf", catanf, 1.0f, -1.0f,
	+1.01722196789785136772278896155048292206356E0f,
	-4.02359478108525093650189833306546909881400E-1f, 0},
  { "catanf", catanf, 1.0253320612293392426711606796797685569408978E0f,
		      3.7861089368147738696922570187830763998261106E0f,
		      1.5f, 0.25f, 0},
  { "catanf", catanf, -2.0f, 1.0f,
	-1.17809724509617246442349126872981358157394E0f,
	+1.73286795139986327354308030364544142018875E-1f,
	 0},
  {"csqrtf", csqrtf, 0.0f, 0.0f, 0.0f, 0.0f, 0},
  {"csqrtf", csqrtf, 1.0f, 0.0f, 1.0f, 0.0f, 0},
  {"csqrtf", csqrtf, -1.0f, 0.0f, 0.0f, 1.0f, 0},
  {"csqrtf", csqrtf, 0.0f, 1.0f,
   0.7071067811865475244008443621048490392848f,
   0.7071067811865475244008443621048490392848f, 0},
  {"csqrtf", csqrtf, 0.0f, -1.0f,
    0.7071067811865475244008443621048490392848f,
   -0.7071067811865475244008443621048490392848f, 0},
  {"csqrtf", csqrtf, 1.0f, 1.0f,
   1.098684113467809966039801195240678378544f,
   0.455089860562227341304357757822468569620f, 0},
  {"csqrtf", csqrtf, 1.0f, -1.0f,
   1.098684113467809966039801195240678378544f,
   -0.455089860562227341304357757822468569620f, 0},
  {"csqrtf", csqrtf, -1.0f, 1.0f,
   0.455089860562227341304357757822468569620f,
   1.098684113467809966039801195240678378544f, 0},
  {"csqrtf", csqrtf, -1.0f, -1.0f,
   0.455089860562227341304357757822468569620f,
   -1.098684113467809966039801195240678378544f, 0},
  {"csqrtf", csqrtf,
   1.189731495357231765021263853030970205169e4932f,	// 2^16384*(1-2^(-64))
   1.189731495357231765021263853030970205169e4932f,
   1.198387648399684544289722483367574194426e2466f,
   4.963884169475494329296140030180041297763e2465f, 0},
#if TEST_DENORMAL
  {"csqrtf", csqrtf,
   3.64519953188247460252840593361941981639905e-4951f,
   3.64519953188247460252840593361941981639905e-4951f,
   6.63335893323538141885633017618228043012283e-2476f,
   2.74762723423482089684766697470153729452931e-2476f, 0},
#endif
  { "ctanf", ctanf, 0.0f, 0.0f, 0.0f, 0.0f, 0},
  { "ctanf", ctanf, M_PI_2, 0.0f, FLT_MAX, FLT_MAX, 0},
  { "ctanf", ctanf, 1.5f, 0.25f,
    1.0253320612293392426711606796797685569408978E0f,
   +3.7861089368147738696922570187830763998261106E0f, 0},
  { "ctanf", ctanf,
	+1.01722196789785136772278896155048292206356E0f,
	+4.02359478108525093650189833306546909881400E-1f,
	1.0f, +1.0f, 0},
  { "ctanf", ctanf,
	+1.01722196789785136772278896155048292206356E0f,
	-4.02359478108525093650189833306546909881400E-1f,
	1.0f, -1.0f, 0},
  { "ctgammaf", ctgammaf, 0.0f, 0.0f, FLT_MAX, FLT_MAX,
		0},
  { "ctgammaf", ctgammaf, -21.0f, 0.0f, FLT_MAX, FLT_MAX,
		0},
  { "ctgammaf", ctgammaf, 1.e-12, 1.e-12,
	 4.9999999999942278433509945619538881588247E11f,
	-4.9999999999999999999999901094400467384240E11f,
		0},
  { "ctgammaf", ctgammaf, +18.385, +18.385, 
	+1.5545154323826133460748425489524312902105E11f,
	-2.3621847758873528928713382671927484629442E11f,
		0},
  { "ctgammaf", ctgammaf, +4.1f, +2.1f,
	-3.60250470914861418284562620959143149396635E0f,
	+1.26639445802995104654829531752728748651799E0f, 0},
  { "ctgammaf", ctgammaf, +4.1f, -2.1f,
	-3.60250470914861418284562620959143149396635E0f,
	-1.26639445802995104654829531752728748651799E0f, 0},
  { "ctgammaf", ctgammaf, -10.001f, +0.0f,
	-2.74926312890366307790512774322345359153964E-04f,
	+0.00000000000000000000000000000000000000000E+00f, 0},
  { "ctgammaf", ctgammaf, -15.001f, +0.0f,
	+7.62624375378243019824755124010594482406421E-10f,
	+0.00000000000000000000000000000000000000000E+00f, 0},
  { "ctgammaf", ctgammaf, -19.001f, +0.0f,
	+8.19626515819998213527541944686917060083919E-15f,
	+0.00000000000000000000000000000000000000000E+00f, 0},
  { "ctgammaf", ctgammaf, -20.001f, 1.0f,
	+1.41024883375626181777941991849918760645552E-20f,
	+1.13352002173482022906506961285560718613630E-19f, 0},
  { "ctgammaf", ctgammaf, +20.001f, -1.0f,
	-1.17194578784682385638957859694786349174836E+17f,
	-2.01872028382587696223259133916128792966849E+16f, 0},
  { "ctgammaf", ctgammaf, -20.0009765625f, +0.0f,
	-4.1965747118999095358392333869351103363307E-16f,
	+0.0000000000000000000000000000000000000000E+00f, 0},
  { "ctgammaf", ctgammaf, +20.001f, +0.0f,
 	+1.22006990456562495874600162466039851777127E+17f,
	+0.00000000000000000000000000000000000000000E+00f, 0},
  { "ctgammaf", ctgammaf, +20.00, M_PI_2,
	-5.09222065505852170951386495027086294931646E+15f,
	-1.14083188839310812140578978988348398098005E+17f, 0},
  { "ctgammaf", ctgammaf, -10.0f, 11.0f,
	+1.88965815515859412681832777147357374400030E-19f,
	+1.68603561429250551195150804052093225716265E-19f, 0},
  { "ctgammaf", ctgammaf, +10.0f, -11.0f,
	+1.70800206183801839174505709841176401901733E+02f,
	-1.62900082422625152423474833031818321301362E+03f, 0},
  { "ctgammaf", ctgammaf, -12.0f, +1.5625f,
	-7.7256822810600770072005801146452589845704E-11f,
	+7.3646514024840248173355097345288908744981E-11f,  0},
  { "ctgammaf", ctgammaf, -1.5f, +0.0f,
	+2.3632718012073547030642233111215269103967E+00f,
	+0.0000000000000000000000000000000000000000E+00f,  0},
  { "ctgammaf", ctgammaf, -2.5f, +0.0f,
	-9.4530872048294188122568932444861076415869E-01f,
	+0.0000000000000000000000000000000000000000E+00f,  0},
  { "ctgammaf", ctgammaf, -3.5f, +0.0f,
	+2.7008820585226910892162552127103164690248E-01f,
	+0.0000000000000000000000000000000000000000E+00f,  0},

  { "clgammaf", clgammaf, -20.0f, +79.0f,
	-2.1297308778751976010599847355093313569026E2f,
	+2.3135481408649533853040873427783779777603E2f,
	    0},
  { "clgammaf", clgammaf, -20.5f, +79.0f, 
	-2.1517448809009308863163012651937918386699E2f,
	+2.3044098659590049829633386338332350187754E2f,
	    0},
  { "clgammaf", clgammaf, +4.125f, +2.125f,
	+1.3625256036784048164604319421388171463447E0f,
	+2.8525474019523563409292929100120626164797E0f,    0},
  { "clgammaf", clgammaf, +4.125f, -2.125f,
	+1.3625256036784048164604319421388171463447E0f,
	-2.8525474019523563409292929100120626164797E0f,    0},  
  { "clgammaf", clgammaf,
	-2.0000976562500000000000000000000000000000E1f,
	+1.0000000000000000000000000000000000000000E0f,
	-4.3616038048909866376856649429072071283845E1f,
	-6.1384761187332935014593191118831774962721E1f,	0}, 
  { "clgammaf", clgammaf,
	+2.0000976562500000000000000000000000000000E1f,
	-1.0000000000000000000000000000000000000000E0f,
	+3.9317162196191172350858428817867355228747E1f,
	-2.9710116921617507487251478298443510152372E0f,	0},
  { "clgammaf", clgammaf,
	-2.0000976562500000000000000000000000000000E1f,
	+0.0000000000000000000000000000000000000000E0f,
	-3.5407092840138713477674562964289392719657E1f,
	-6.5973445725385658007715511048869560568141E1f,	0},
  { "clgammaf", clgammaf,
	-1.0000976562500000000000000000000000000000E1f,
	+0.0000000000000000000000000000000000000000E0f,
	-8.1752358775093991610978176096814198666058E0f,
	-3.4557519189487725623089077216074531726169E1f,
		0},
  { "clgammaf", clgammaf,
	-1.5000976562500000000000000000000000000000E1f,
	+0.0000000000000000000000000000000000000000E0f,
	-2.0970474811090406350643250190759942690898E1f,
	-5.0265482457436691815402294132472046147155E1f,
		0},
  { "clgammaf", clgammaf,
	-2.0001953125000000000000000000000000000000E1f,
	+0.0000000000000000000000000000000000000000E0f,
	-3.6103185114722972817877866364237396660096E1f,
	-6.5973445725385658007715511048869560568141E1f,
		0},
  { "clgammaf", clgammaf, -10.0f, +11.0f,
	-4.2819912321150102178361274654972147886802E1f,
	-5.5546720095852625829723715665556114571987E0f,
		0},
  { "clgammaf", clgammaf, +10.0f, -11.0f,
	 7.4011888473128456306813458819905920784576E0f,
	-2.6599069586433134715467690396042807588356E1f,
		0},
  { "clgammaf", clgammaf,
	-1.2000000000000000000000000000000000000000E1f,
	+1.5625000000000000000000000000000000000000E0f,
	-2.2960669115340119272182722186895587688421E1f,
	-3.5318997270899734941144532316414495132385E1f,
		0},
  { "clgammaf", clgammaf, 0.0f, 0.0f, FLT_MAX, FLT_MAX,
		0},
  {"null",   NULL, 0.0, 0.0, 0.0, 0.0, 0},
};


int
main (void);
int
main (void)
{
  float complex (*fun1) (float complex);
  float complex z, w, y, a;
  int i, errs, tests;

  errs = 0;
  tests = 0;
  i = 0;
  for (;;)
    {
      fun1 = test1[i].func;
      if (fun1 == NULL)
	break;

      z = test1[i].real_arg + test1[i].imag_arg * I;
      w = (*(fun1)) (z);
      y = test1[i].real_ans + test1[i].imag_ans * I;
      a = y - w;
      if (a)
	{
	  errs += 1;
# if 0
	  printf ("%s\n\tLine %2d: %+#.9g %+#.9g\n"
	  	  "\ts.b.     %+#.9g %+#.9g\n", test1[i].name, i + 1,
# endif
	  printf ("\n%s (%+#.9g%+#.9g*I)\n\tLine %2d: %+#.9g %+#.9g\n"
		  "\ts.b.     %+#.9g %+#.9g\n", test1[i].name, 
		  creal(z), cimag(z), i + 1,
		  creal(w), cimag(w), test1[i].real_ans, test1[i].imag_ans);
	  printf ("Diffs: Real = %+#.9g, Imag = %+#.9g\n",
	  	  creal(a), cimag(a));

	}
      i += 1;
      tests += 1;
    }
  printf ("%d errors in %d tests\n", errs, tests);
  return 0;
}
