/* whitebx.c
   White box tests
   attempt to exercise all paths through each tested function routine.
   Float complex version.

   S. L. Moshier
   May, 2004  */

#include <stdio.h>
#include <math.h>
#include <float.h>
#include "complex.h"

#define TEST_DENORMAL 1

struct oneargument
  {
    char *name;			/* Name of the function. */
    double complex (*func) (double complex);
    double real_arg;	/* Function argument, assumed exact.  */
    double imag_arg;
    double real_ans;
    double imag_ans;
    int thresh;			/* Error report threshold. 2 = 1 ULP approx. */
  };


struct oneargument test1[] =
{
  { "casin", casin, 0.0, 0.0, 0.0, 0.0, 0},
  { "casin", casin, 1.0, 0.0, M_PI_2l, 0.0, 0},
  { "casin", casin, 2.0, 0.0, M_PI_2l, 0.0, 0},
  { "casin", casin, 1.0, -1.0,
	+6.66239432492515255104004895977792720667490E-1,
	-1.06127506190503565203301891621357348580679E0, 0},
  { "casin", casin, 1.0, +1.0,
	+6.66239432492515255104004895977792720667490E-1,
	+1.06127506190503565203301891621357348580679E0, 0},
  { "csin", csin, 0.0, 0.0, 0.0, 0.0, 0},
  { "csin", csin, M_PI_2l, 0.0, 1.0, 0.0, 0},
  { "csin", csin, +6.66239432492515255104004895977792720667490E-1,
		    -1.06127506190503565203301891621357348580679E0,
			 1.0, -1.0, 0},
  { "csin", csin, +6.66239432492515255104004895977792720667490E-1,
		    +1.06127506190503565203301891621357348580679E0,
			 1.0, +1.0, 0},
  { "catan", catan, 0.0, 0.0, 0.0, 0.0, 0},
  { "catan", catan, 0.0, +1.0, DBL_MAX, DBL_MAX, 0},
  { "catan", catan, 0.0, -1.0, DBL_MAX, DBL_MAX, 0},
  { "catan", catan, 1.0, +1.0,
	+1.01722196789785136772278896155048292206356E0,
	+4.02359478108525093650189833306546909881400E-1, 0},
  { "catan", catan, 1.0, -1.0,
	+1.01722196789785136772278896155048292206356E0,
	-4.02359478108525093650189833306546909881400E-1, 0},
  { "catan", catan, 1.0253320612293392426711606796797685569408978E0,
		    3.7861089368147738696922570187830763998261106E0,
		      1.5, 0.25, 0},
  { "catan", catan, -2.0, 1.0,
	-1.17809724509617246442349126872981358157394E0,
	+1.73286795139986327354308030364544142018875E-1,
	 0},
  
  {"csqrt", csqrt, 0.0, 0.0, 0.0, 0.0, 0},
  {"csqrt", csqrt, 1.0, 0.0, 1.0, 0.0, 0},
  {"csqrt", csqrt, -1.0, 0.0, 0.0, 1.0, 0},
  {"csqrt", csqrt, 0.0, 1.0,
   0.7071067811865475244008443621048490392848,
   0.7071067811865475244008443621048490392848, 0},
  {"csqrt", csqrt, 0.0, -1.0,
    0.7071067811865475244008443621048490392848,
   -0.7071067811865475244008443621048490392848, 0},
  {"csqrt", csqrt, 1.0, 1.0,
   1.098684113467809966039801195240678378544,
   0.455089860562227341304357757822468569620, 0},
  {"csqrt", csqrt, 1.0, -1.0,
   1.098684113467809966039801195240678378544,
   -0.455089860562227341304357757822468569620, 0},
  {"csqrt", csqrt, -1.0, 1.0,
   0.455089860562227341304357757822468569620,
   1.098684113467809966039801195240678378544, 0},
  {"csqrt", csqrt, -1.0, -1.0,
   0.455089860562227341304357757822468569620,
   -1.098684113467809966039801195240678378544, 0},
  {"csqrt", csqrt, DBL_MAX, DBL_MAX,
	+1.473094556905565460763648384526620E154,
	+6.101757441282702527252660104869457E153, 0},
#if 1
  {"csqrt", csqrt,
	+4.9406564584124654417E-324,	// 2^-1074
	+4.9406564584124654417E-324,
	+2.4421097261308302567E-162,
	+1.0115549693666347261E-162, 0},
#endif
  { "ctan", ctan, 0.0, 0.0, 0.0, 0.0, 0},
  { "ctan", ctan, M_PI_2l, 0.0, DBL_MAX, DBL_MAX, 0},
  { "ctan", ctan, 1.5, 0.25,
    1.0253320612293392426711606796797685569408978E0,
   +3.7861089368147738696922570187830763998261106E0, 0},
  { "ctan", ctan,
	+1.01722196789785136772278896155048292206356E0,
	+4.02359478108525093650189833306546909881400E-1,
	1.0, +1.0, 0},
  { "ctan", ctan,
	+1.01722196789785136772278896155048292206356E0,
	-4.02359478108525093650189833306546909881400E-1,
	1.0, -1.0, 0},
  { "ctgamma", ctgamma, 0.0, 0.0, DBL_MAX, DBL_MAX,
		0},
  { "ctgamma", ctgamma, -21.0, 0.0, DBL_MAX, DBL_MAX,
		0},
  { "ctgamma", ctgamma, 1.e-12, 1.e-12,
	 4.9999999999942278433509945619538881588247E11,
	-4.9999999999999999999999901094400467384240E11,
		0},
  { "ctgamma", ctgamma, +18.385, +18.385, 
	+1.5545154323826133460748425489524312902105E11,
	-2.3621847758873528928713382671927484629442E11,
		0},
  { "ctgamma", ctgamma, +4.1, +2.1,
	-3.60250470914861418284562620959143149396635E0,
	+1.26639445802995104654829531752728748651799E0, 0},
  { "ctgamma", ctgamma, +4.1, -2.1,
	-3.60250470914861418284562620959143149396635E0,
	-1.26639445802995104654829531752728748651799E0, 0},
  { "ctgamma", ctgamma, -10.001, +0.0,
	-2.74926312890366307790512774322345359153964E-04,
	+0.00000000000000000000000000000000000000000E+00, 0},
  { "ctgamma", ctgamma, -15.001, +0.0,
	+7.62624375378243019824755124010594482406421E-10,
	+0.00000000000000000000000000000000000000000E+00, 0},
  { "ctgamma", ctgamma, -19.001, +0.0,
	+8.19626515819998213527541944686917060083919E-15,
	+0.00000000000000000000000000000000000000000E+00, 0},
  { "ctgamma", ctgamma, -20.001, 1.0,
	+1.41024883375626181777941991849918760645552E-20,
	+1.13352002173482022906506961285560718613630E-19, 0},
  { "ctgamma", ctgamma, +20.001, -1.0,
	-1.17194578784682385638957859694786349174836E+17,
	-2.01872028382587696223259133916128792966849E+16, 0},
  { "ctgamma", ctgamma, -20.0009765625, +0.0,
	-4.1965747118999095358392333869351103363307E-16,
	+0.0000000000000000000000000000000000000000E+00, 0},
  { "ctgamma", ctgamma, +20.001, +0.0,
 	+1.22006990456562495874600162466039851777127E+17,
	+0.00000000000000000000000000000000000000000E+00, 0},
  { "ctgamma", ctgamma, +20.00, M_PI_2,
	-5.09222065505852170951386495027086294931646E+15,
	-1.14083188839310812140578978988348398098005E+17, 0},
  { "ctgamma", ctgamma, -10.0, 11.0,
	+1.88965815515859412681832777147357374400030E-19,
	+1.68603561429250551195150804052093225716265E-19, 0},
  { "ctgamma", ctgamma, +10.0, -11.0,
	+1.70800206183801839174505709841176401901733E+02,
	-1.62900082422625152423474833031818321301362E+03, 0},
  { "ctgamma", ctgamma, -12.0, +1.5625,
	-7.7256822810600770072005801146452589845704E-11,
	+7.3646514024840248173355097345288908744981E-11,  0},
  { "ctgamma", ctgamma, -1.5, +0.0,
	+2.3632718012073547030642233111215269103967E+00,
	+0.0000000000000000000000000000000000000000E+00,  0},
  { "ctgamma", ctgamma, -2.5, +0.0,
	-9.4530872048294188122568932444861076415869E-01,
	+0.0000000000000000000000000000000000000000E+00,  0},
  { "ctgamma", ctgamma, -3.5, +0.0,
	+2.7008820585226910892162552127103164690248E-01,
	+0.0000000000000000000000000000000000000000E+00,  0},

  { "clgamma", clgamma, -20.0, +79.0,
	-2.1297308778751976010599847355093313569026E2,
	+2.3135481408649533853040873427783779777603E2,
	    0},
  { "clgamma", clgamma, -20.5, +79.0, 
	-2.1517448809009308863163012651937918386699E2,
	+2.3044098659590049829633386338332350187754E2,
	    0},
  { "clgamma", clgamma, +4.125, +2.125,
	+1.3625256036784048164604319421388171463447E0,
	+2.8525474019523563409292929100120626164797E0,    0},
  { "clgamma", clgamma, +4.125, -2.125,
	+1.3625256036784048164604319421388171463447E0,
	-2.8525474019523563409292929100120626164797E0,    0},  
  { "clgamma", clgamma,
	-2.0000976562500000000000000000000000000000E1,
	+1.0000000000000000000000000000000000000000E0,
	-4.3616038048909866376856649429072071283845E1,
	-6.1384761187332935014593191118831774962721E1,	0}, 
  { "clgamma", clgamma,
	+2.0000976562500000000000000000000000000000E1,
	-1.0000000000000000000000000000000000000000E0,
	+3.9317162196191172350858428817867355228747E1,
	-2.9710116921617507487251478298443510152372E0,	0},
  { "clgamma", clgamma,
	-2.0000976562500000000000000000000000000000E1,
	+0.0000000000000000000000000000000000000000E0,
	-3.5407092840138713477674562964289392719657E1,
	-6.5973445725385658007715511048869560568141E1,	0},
  { "clgamma", clgamma,
	-1.0000976562500000000000000000000000000000E1,
	+0.0000000000000000000000000000000000000000E0,
	-8.1752358775093991610978176096814198666058E0,
	-3.4557519189487725623089077216074531726169E1,
		0},
  { "clgamma", clgamma,
	-1.5000976562500000000000000000000000000000E1,
	+0.0000000000000000000000000000000000000000E0,
	-2.0970474811090406350643250190759942690898E1,
	-5.0265482457436691815402294132472046147155E1,
		0},
  { "clgamma", clgamma,
	-2.0001953125000000000000000000000000000000E1,
	+0.0000000000000000000000000000000000000000E0,
	-3.6103185114722972817877866364237396660096E1,
	-6.5973445725385658007715511048869560568141E1,
		0},
  { "clgamma", clgamma, -10.0, +11.0,
	-4.2819912321150102178361274654972147886802E1,
	-5.5546720095852625829723715665556114571987E0,
		0},
  { "clgamma", clgamma, +10.0, -11.0,
	 7.4011888473128456306813458819905920784576E0,
	-2.6599069586433134715467690396042807588356E1,
		0},
  { "clgamma", clgamma,
	-1.2000000000000000000000000000000000000000E1,
	+1.5625000000000000000000000000000000000000E0,
	-2.2960669115340119272182722186895587688421E1,
	-3.5318997270899734941144532316414495132385E1,
		0},
  { "clgamma", clgamma, 0.0, 0.0, DBL_MAX, DBL_MAX,
		0},
  {"null",   NULL, 0.0, 0.0, 0.0, 0.0, 0},
};


int
main (void);
int
main (void)
{
  double complex (*fun1) (double complex);
  double complex a, y, z, w;
  int i, errs, tests;

  errs = 0;
  tests = 0;
  i = 0;
  for (;;)
    {
      fun1 = test1[i].func;
      if (fun1 == NULL)
	break;

      z = test1[i].real_arg + test1[i].imag_arg * I;
      w = (*(fun1)) (z);
      y = test1[i].real_ans + test1[i].imag_ans * I;
      a = y - w;
      if (a)
	{
	  errs += 1;
	  printf ("\n%s (%+#.20lg%+#.20lg*I)\n\tLine %2d: %+#.20lg %+#.20lg\n"
		  "\ts.b.     %+#.20lg %+#.20lg\n", test1[i].name, 
		  creal(z), cimag(z), i + 1,
		  creal(w), cimag(w), test1[i].real_ans, test1[i].imag_ans);
	  printf ("Diffs: Real = %+#.20lg, Imag = %+#.20lg\n",
		  creal(a), cimag(a));
	}
      i += 1;
      tests += 1;
    }
  printf ("%d errors in %d tests\n", errs, tests);
  return 0;
}
