
# Makefile for W. J. Cody's tests of elementary complex functions
# transliterated from Fortran to C language.
# Fixes comprised proper naming of functions under test (e.g. FSIN for SIN)
# and revision of the test for `-FSQRT' in tcsqrt.c.

CC = gcc -s
#CC=/b/gnu/linux/gcc/xgcc -B/b/gnu/linux/gcc/ -I/b/gnu/linux/gcc/include

CFLAGS = -g -Wall $(OPTIMIZE) -I.

OPTIMIZE = #-O3

INCS = celefunt.h complex.h stubs.o

# libmc.a is the complex function library under test.
# stubs.o is compiled with the machine parameter settings in mconf.h
#LIBS = stubs.o libmc.a -lm
# These are intended to get the cephes libraries
#LIBS = libmc.a ../libmd.a ../libmf.a
#LIBS = libmc.a -lmd -lmf
LIBS = stubs.o libC99cx.a -lC99 -lm

all: tcabs.exe tcexp.exe tclog.exe tcpow.exe tcsin.exe tcsqrt.exe \
tcabsf.exe tcexpf.exe tclogf.exe tcpowf.exe tcsinf.exe tcsqrtf.exe

check: all
	-tcabs   > tcabs.log
	-tcexp   > tcexp.log
	-tclog   > tclog.log
	-tcpow   > tcpow.log
	-tcsin   > tcsin.log
	-tcsqrt  > tcsqrt.log
	-tcabsf  > tcabsf.log
	-tcexpf  > tcexpf.log
	-tclogf  > tclogf.log
	-tcpowf  > tcpowf.log
	-tcsinf  > tcsinf.log
	-tcsqrtf > tcsqrtf.log

must:	clean check

tcsqrt.exe: tcsqrt.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcsin.exe: tcsin.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcpow.exe: tcpow.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tclog.exe: tclog.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcexp.exe: tcexp.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcabs.exe: tcabs.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcsqrtf.exe: tcsqrtf.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcsinf.exe: tcsinf.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcpowf.exe: tcpowf.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tclogf.exe:  tclogf.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcexpf.exe: tcexpf.o $(INCS) libC99cx.a
	$(CC) -o $@ $<  $(LIBS)

tcabsf.exe: tcabsf.o $(INCS) libC99cx.a
	$(CC) -o $@ $< $(LIBS)

stubs.o: stubs.c
	$(CC) $(CFLAGS) -c stubs.c

tcabs.o: tcabs.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTDOUBLE -o tcabs.o -c tcabs.c

tcexp.o: tcexp.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTDOUBLE -o tcexp.o -c tcexp.c

tclog.o: tclog.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTDOUBLE -o tclog.o -c tclog.c

tcpow.o: tcpow.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTDOUBLE -o tcpow.o -c tcpow.c

tcsin.o: tcsin.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTDOUBLE -o tcsin.o -c tcsin.c

tcsqrt.o: tcsqrt.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTDOUBLE -o tcsqrt.o -c tcsqrt.c

tcabsf.o: tcabs.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTSINGLE -o tcabsf.o -c tcabs.c

tcexpf.o: tcexp.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTSINGLE -o tcexpf.o -c tcexp.c

tclogf.o: tclog.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTSINGLE -o tclogf.o -c tclog.c

tcpowf.o: tcpow.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTSINGLE -o tcpowf.o -c tcpow.c

tcsinf.o: tcsin.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTSINGLE -o tcsinf.o -c tcsin.c

tcsqrtf.o: tcsqrt.c tablat.c $(INCS)
	$(CC) $(CFLAGS) -DTSINGLE -o tcsqrtf.o -c tcsqrt.c

clean:
	rm -f tc*.o
	rm -f tc*.exe
	rm -f tc*.log
