/*	ctanhf.c
 *
 *	Complex hyperbolic tangent
 *
 *
 *
 * SYNOPSIS:
 *
 * float complex ctanhf();
 * float complex z, w;
 *
 * w = ctanhf (z);
 *
 *
 *
 * DESCRIPTION:
 *
 * tanh z = (sinh 2x  +  i sin 2y) / (cosh 2x + cos 2y) .
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    IEEE      -10,+10     30000       1.7e-14     2.4e-16
 *
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>


float   complex
ctanhf(float complex z)
{
    float complex w;
    float   x, y, d;

    x = crealf(z);
    y = cimagf(z);
    d = coshf(2.0f * x) + cosf(2.0f * y);
    w = sinhf(2.0f * x) / d + (sinf(2.0f * y) / d) * I;
    return (w);
}
