/*	csinh.c
 *
 *	Complex hyperbolic sine
 *
 *
 *
 * SYNOPSIS:
 *
 * double complex csinh();
 * double complex z, w;
 *
 * w = csinh (z);
 *
 * DESCRIPTION:
 *
 * csinh z = (cexp(z) - cexp(-z))/2
 *	   = sinh x * cos y  +	i cosh x * sin y .
 *
 * ACCURACY:
 *
 *			Relative error:
 * arithmetic	domain	   # trials	 peak	      rms
 *    IEEE	-10,+10	    30000	3.1e-16	    8.2e-17
 *
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>

double	complex
csinh(z)
double complex z;
{
    double complex w;
    double  x, y;

    x = creal(z);
    y = cimag(z);
    w = sinh(x) * cos(y) + (cosh(x) * sin(y)) * I;

    return (w);
}
