/*	cpowf.c
 *
 *	Complex power function
 *
 *
 *
 * SYNOPSIS:
 *
 * float complex cpowf();
 * float complex a, z, w;
 *
 * w = cpowf (a, z);
 *
 *
 *
 * DESCRIPTION:
 *
 * Raises complex A to the complex Zth power.
 * Definition is per AMS55 # 4.2.8,
 * analytically equivalent to cpow(a,z) = cexp(z clog(a)).
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    IEEE      -10,+10     30000       9.4e-15     1.5e-15
 *
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>


float   complex
cpowf(float complex a, float complex z)
{
    float complex w;
    float   x, y, r, theta, absa, arga;

    x = crealf(z);
    y = cimagf(z);
    absa = cabsf(a);
    if (absa == 0.0f)
    {
	return (0.0f + 0.0f * I);
    }
    arga = cargf(a);
    r = powf(absa, x);
    theta = x * arga;
    if (y != 0.0f)
    {
	r = r * expf(-y * arga);
	theta = theta + y * logf(absa);
    }
    w = r * cosf(theta) + (r * sinf(theta)) * I;
    return (w);
}
