// cchshl.c

/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


/* calculate cosh and sinh */

static void cchshl(long double, long double *, long double *);

static void
cchshl(long double x, long double *c, long double *s)
{
    long double e, ei;

    if (fabsl(x) <= 0.5L)
    {
	*c = coshl(x);
	*s = sinhl(x);
    }
    else
    {
	e = expl(x);
	ei = 0.5L / e;
	e = 0.5L * e;
	*s = e - ei;
	*c = e + ei;
    }
}
