/*							catanf()
 *
 *	Complex circular arc tangent
 *
 *
 *
 * SYNOPSIS:
 *
 * float complex catanf();
 * float complex z, w;
 *
 * w = catanf( z );
 *
 *
 *
 * DESCRIPTION:
 *
 * If
 *     z = x + iy,
 *
 * then
 *          1       (    2x     )
 * Re w  =  - arctan(-----------)  +  k PI
 *          2       (     2    2)
 *                  (1 - x  - y )
 *
 *               ( 2         2)
 *          1    (x  +  (y+1) )
 * Im w  =  - log(------------)
 *          4    ( 2         2)
 *               (x  +  (y-1) )
 *
 * Where k is an arbitrary integer.
 *
 *
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    IEEE      -10,+10     30000        2.3e-6      5.2e-8
 *
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>

#include "redupif.c"

float   complex
catanf(float complex z)
{
    float complex w;
    float   a, t, x, x2, y;

    x = crealf(z);
    y = cimagf(z);

//    if ((x == 0.0f) && (y > 1.0f))
//	goto ovrf;

    x2 = x * x;
    a = 1.0f - x2 - (y * y);
//    if (a == 0.0f)
//	goto ovrf;

    t = 0.5f * atan2f(2.0f * x, a);
    w = redupif(t);

    t = y - 1.0f;
    a = x2 + (t * t);
    if (a == 0.0f)
	goto ovrf;

    t = y + 1.0f;
    a = (x2 + (t * t)) / a;
    if (a == 0.0f)
	goto ovrf;

    w = w + (0.25f * logf(a)) * I;
    return (w);

  ovrf:
// mtherr( "catanf", OVERFLOW );
    w = FLT_MAX + FLT_MAX * I;
    return (w);
}
