/*							casinl()
 *
 *	Complex circular arc sine
 *
 *
 *
 * SYNOPSIS:
 *
 * long double complex casinl();
 * long double complex z, w;
 *
 * w = casinl( z );
 *
 *
 *
 * DESCRIPTION:
 *
 * Inverse complex sine:
 *
 *                               2
 * w = -i clog( iz + csqrt( 1 - z ) ).
 *
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    DEC       -10,+10     10100       2.1e-15     3.4e-16
 *    IEEE      -10,+10     30000       2.2e-14     2.7e-15
 * Larger relative error can be observed for z near zero.
 * Also tested by csin(casin(z)) = z.
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <math.h>
#include <float.h>

long double complex
casinl(long double complex z)
{
    long double complex w;
    long double x, y, b;
    static long double complex ca, ct, zz, z2;

    x = creall(z);
    y = cimagl(z);

    if (y == 0.0L)
    {
	if (fabsl(x) > 1.0L)
	{
	    w = M_PI_2l + 0.0L * I;
	    //mtherr( "casinl", DOMAIN );
	}
	else
	{
	    w = asinl(x) + 0.0L * I;
	}
	return (w);
    }

/* Power series expansion */

    b = cabsl(z);
    if (b < 0.125L)
    {
	long double complex sum;
	long double n, cn;

	z2 = (x - y) * (x + y) + (2.0L * x * y) * I;
	cn = 1.0L;
	n = 1.0L;
	ca = x + y * I;
	sum = x + y * I;
	do
	{
	    ct = z2 * ca;
	    ca = ct;

	    cn *= n;
	    n += 1.0L;
	    cn /= n;
	    n += 1.0L;
	    b = cn / n;

	    ct *= b;
	    sum += ct;
	    b = cabsl(ct);
	}
	while (b > LDBL_EPSILON);
	w = sum;
	return w;
    }

    ca = x + y * I;
    ct = ca * I;			/* iz */
    /* sqrt( 1 - z*z) */
    /* cmul( &ca, &ca, &zz ) */
    /*x * x  -  y * y */
    zz = (x - y) * (x + y) + (2.0L * x * y) * I;
    zz = 1.0L - creall(zz) - cimagl(zz) * I;
    z2 = csqrtl(zz);

    zz = ct + z2;
    zz = clogl(zz);
    /* multiply by 1/i = -i */
    w = zz * (-1.0L * I);
    return (w);
}
