/*
 * cabsl.c
 * -------		       
 *
 * Complex absolute value
 *
 *
 * SYNOPSIS:
 *
 * long double cabsl();
 * long double complex z;
 * long double a;
 *
 * a = cabsl( z );
 *
 *
 * DESCRIPTION:
 *
 *
 * If z = x + iy
 *
 * then
 *
 * a = hypotl( x, y ).
 * 
 */
#include "complex.h"
#include <float.h>
#include <math.h>

/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004

# if 0
long double
cabsl(long double complex z)
{
    long double x, y;

    x = creall(z);
    y = cimagl(z);

    return (hypotl(x, y));
}
# endif

#define	PREC	(LDBL_MANT_DIG >> 1)

long double
cabsl(long double complex z)
{
    long double x, y, b, re, im;
    int     ex, ey, e;

    x = creall(z);
    y = cimagl(z);

    if (isinfl(x))
	return (x);
    if (isinfl(y))
	return (y);

    if (isnanl(x))
	return (x);
    if (isnanl(y))
	return (y);

    re = fabsl(x);
    im = fabsl(y);

    if (re == 0.0L)
	return (im);
    if (im == 0.0L)
	return (re);

    /* Get the exponents of the numbers */
    x = frexpl(re, &ex);
    y = frexpl(im, &ey);

    /* Check if one number is tiny compared to the other */
    e = ex - ey;

    if (e > PREC)
	return (re);
    if (e < -PREC)
	return (im);

    /* Find approximate exponent e of the geometric mean. */
    e = (ex + ey) >> 1;

    /* Rescale so mean is about 1 */
    x = ldexpl(re, -e);
    y = ldexpl(im, -e);

    /* Hypotenuse of the right triangle */
    b = sqrtl(x * x + y * y);

    /* Compute final exponent. */
    y = frexpl(b, &ey);
    ey = e + ey;

    /* Check for overflow. */
    if (ey > LDBL_MAX_EXP)
    {
	// mtherr( "cabsl", OVERFLOW );
	return (HUGE_VALL);
    }
# if 0
    /* Check for underflow. */
    if (ey < LDBL_MIN_EXP)
	return (0.0L);
# endif
    /* Undo scaling */
    b = ldexpl(b, e);
    return (b);
}
