/*	cabs.c
 *
 *	Complex absolute value
 *
 *
 *
 * SYNOPSIS:
 *
 * double cabs();
 * double complex z;
 * double a;
 *
 * a = cabs( z );
 *
 *
 *
 * DESCRIPTION:
 *
 *
 * If z = x + iy
 *
 * then
 *
 *       a = sqrt( x^2 + y^2 ).
 * 
 * Overflow and underflow are avoided by testing the magnitudes
 * of x and y before squaring.  If either is outside half of
 * the floating point full scale range, both are rescaled.
 *
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    DEC       -30,+30     30000       3.2e-17     9.2e-18
 *    IEEE      -10,+10    100000       2.7e-16     6.9e-17
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>

# if 0
double
(cabs)(double complex z)
{
    double  x, y;

    x = creal(z);
    y = cimag(z);

    return (hypot(x, y));
}
# endif


#define PREC ((DBL_MANT_DIG+1)>>1)

double
(cabs)(z)
double complex z;
{
    double  x, y, b, re, im;
    int     ex, ey, e;

    if ((isinfd) (creal(z)) || ((isinfd) (cimag(z))))
    {
	return HUGE_VAL;
    }

    if (isnand(creal(z)))
	return (creal(z));
    if (isnand(cimag(z)))
	return (cimag(z));

    re = fabs(creal(z));
    im = fabs(cimag(z));

    if (re == 0.0)
	return (im);
    if (im == 0.0)
	return (re);

    /* Get the exponents of the numbers */
    x = frexp(re, &ex);
    y = frexp(im, &ey);

    /* Check if one number is tiny compared to the other */
    e = ex - ey;
    if (e > PREC)
	return (re);
    if (e < -PREC)
	return (im);

    /* Find approximate exponent e of the geometric mean. */
    e = (ex + ey) >> 1;

    /* Rescale so mean is about 1 */
    x = ldexp(re, -e);
    y = ldexp(im, -e);

    /* Hypotenuse of the right triangle */
    b = sqrt(x * x + y * y);

    /* Compute final exponent. */
    y = frexp(b, &ey);
    ey = e + ey;

    /* Check for overflow and underflow. */
    if (ey > DBL_MAX_EXP)
    {
	// mtherr ("cabs", OVERFLOW);
	return (HUGE_VAL);
    }
    if (ey < DBL_MIN_EXP)
	;//return (0.0);

    /* Undo scaling */
    b = ldexp(b, e);
    return (b);
}
