// --------
// trunc.c
// --------
//
// Synopsis
//
//      #include <math.h>
//
//	double Retval;
// 	Retval = trunc( double Arg);
//
// Returns integer part of Arg if |Arg| is in (1,2^53-1);
// If |Arg| < 1, zero is returned.
// If |Arg| > 2^53, Arg is returned.
//
// From C99:
//
// The trunc function rounds its argument to its integer
// value, in floating format, nearest to but no larger in
// magnitude than the argument.
//
// The trunc function uses IEC 60559 rounding toward zero
// (regardless of the current rounding direction).
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, October 2003
//
#include <fdlibml.h>
#include <fenv.h>

double trunc(double Arg)
{
    double  Retval;
    int	    CrntRndDir;

    CrntRndDir = fegetround();
    fesetround(FE_TOWARDZERO);

    ROUND_TO_INT(Arg, Retval);

    fesetround(CrntRndDir);

    return Retval;
}
