/* scalbnl.c -- long double version of s_scalbn.c.
 * Converted to long double by KB Williams, 
 * kbwms@aol.com, December 2001 & November 2003
 */
/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */
/*
 * scalbnl (long double x, int TwoPow)
 * scalbnl(x,n) returns x* 2**TwoPow  computed by  exponent
 * manipulation rather than by actually performing an
 * exponentiation or a multiplication.
 */

#include <errno.h>
#include <fdlibml.h>
#include <fenv.h>

#define TWO64	((LDBL)ULLONG_MAX + 1.0L)
#define TWOM64	(LDBL)(1.0L/TWO64)

long double scalbnl(long double Arg, int TwoPow)
{
    int	    Exp, Exp_and_Sign;
    ULLONG  FracBits;
    LDBL    Retval;

    GET64_LDOUBLE(Exp_and_Sign, FracBits, Arg);

    if (FracBits == 0 || TwoPow == 0)
    {
	Retval = Arg;
    }
    else
    {
	Exp = Exp_and_Sign & 0x7fff;			/* extract exponent */
	if (Exp == 0x7fff)
	{
	    Retval = Arg;				/* NaN or Inf */
	}
	else
	{
	    if (Exp == 0)				/* subnormal Arg */
	    {
		Arg *= TWO64;
		GET_LDOUBLE_EXP(Exp_and_Sign, Arg);
		Exp = (Exp_and_Sign & 0x7fff) - 64;
	    }
	    Exp += TwoPow;				/* Scaler + Exponent */
	    if ((TwoPow > 50000) || (Exp > 0x7ffe))
	    {
		Retval = copysignl(HUGE_VALL, Arg);	/* overflow  */
		__math_set_errno(ERANGE);
		__fp_raise_except(FE_OVERFLOW);
	    }
	    else if ((TwoPow < -50000) || (Exp < -63))
	    {
		Retval = copysignl(0.0L, Arg);		/* underflow */
		__math_set_errno(ERANGE);
		__fp_raise_except(FE_UNDERFLOW);
	    }
	    else if (Exp > 0)				/* normal result */
	    {
		SET_LDOUBLE_EXP(Arg, (Exp_and_Sign & 0x8000) | Exp);
		Retval = Arg;
	    }
	    else					/* subnormal result */
	    {
		Exp += 64;
		SET_LDOUBLE_EXP(Arg, (Exp_and_Sign & 0x8000) | Exp);
		Retval = Arg * TWOM64;
	    }
	}
    }
    return Retval;
}
