// --------
// round.c
// --------
//
// Function round
//
// Synopsis
//
//	#include <math.h>
//	double round(double x);
//
// Description
//
// Function round() rounds its argument to the nearest integer
// value in floating-point format, rounding halfway cases away
// from zero, regardless of the current rounding direction.
//
// Returns
//
// Function round() returns the rounded integer value.
//
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, September 2003
//
#include <math.h>

double
round(double Arg);

double
round(double Arg)
{
    double	FracPart, IntPart;

    FracPart = modf(Arg, &IntPart);

    if (fabs(FracPart) >= 0.5)
           IntPart += copysign(1.0, IntPart);

    return IntPart;
}
