// ------------
// nrbyintl.c
// ------------
//
// From ISO C99:
//
// Function nearbyintl
//
// Synopsis
//
//	#include <fdlibml.h>
//	long double nearbyintl(long double x);
//
// Description
//
// Function nearbyintl rounds its argument to an integer value
// in floating-point format, using the current rounding direction.
// Function nearbyintl uses IEC 60559 rounding according to the
// current rounding direction.	It does not raise the inexact
// exception if the result differs in value from the argument.
//
// Returns
//
// Function nearbyintl returns the rounded integer value.
//
// Remarks
//
// Function nearbyintl differs from the rintl function
// only in that it doesn't raise the inexact exception
// if the result differs in value from the argument.
//
// o  nearbyintl(+-0) returns +-0 (for all rounding modes).
//
// o  nearbyintl(+-Inf) returns +-Inf (for all rounding modes).
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, March 2002 & August 2003
//

#include <fdlibml.h>
#include <fenv.h>

long double nearbyintl(long double Arg)
{
    fenv_t	SavedEnv;
    long double Retval;
    int         CurrentExcepts;

    CurrentExcepts = fetestexcept(FE_ALL_EXCEPT);
    feholdexcept(&SavedEnv);

    ROUND_TO_INT(Arg, Retval);

    fesetenv(&SavedEnv);
    feclearexcept(FE_ALL_EXCEPT);
    __fp_raise_except(CurrentExcepts);

    return Retval;
}
