// -----------
// isfinitl.c
// -----------
#include <fdlibml.h>
// --------------------------------------------------
// isfinitel - Returns 1 if Arg is finite and not NaN
// --------------------------------------------------
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, October 2003
//
int isfinitel(long double Arg)
{
    union
    {
	long double	LD_Arg;
	unsigned short	S_Arg[5];
    }
    SLDU;

    SLDU.LD_Arg = Arg;

    return ((((SLDU.S_Arg[4] & 0x7fff) - 0x7fff) >> 15) & 1);
}
