// -------------
// ftestexcept.c
// -------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// Synopsis:
//
//   #include <fenv.h>
//   int fetestexcept(int Excepts);
//
//   Function fetestexcept() determines which of a specified
//   subset of the exception flags are currently set.  The
//   argument specifies the exception flags to be queried.
//   These exceptions may include:
//
//	FE_INVALID	Invalid operation
//	FE_DENORMAL	Denormalized operand  (added by KBW)
//	FE_DIVBYZERO	Division by zero
//	FE_OVERFLOW	Overflow
//	FE_UNDERFLOW	Underflow
//	FE_INEXACT	Precision loss
//
//   where Excepts is any one or a combination (logical OR) of
//   the exceptions (macros) listed above.  The numerical value
//   of each macro is given in <fenv.h>.
//
// Return:
//
//   Function fetestexcept() returns the value of the bitwise AND
//   of the currently-set exception flags and those specified in
//   argument Excepts.
//

#include <fenv.h>

#define AV	__asm__ __volatile__
#define GET_FPU_STATUS_WORD(s)		\
    {					\
	AV ("FSTSW %0" : "=a" (s));	\
    }

// --------------------------------------------------
// Returns exception flags represented by the bitwise
// logical AND of argument Excepts and flags currently
// set.
// --------------------------------------------------
int
fetestexcept (int Excepts)
{
  int StatusWord;

  GET_FPU_STATUS_WORD(StatusWord)

  // Return only currently-set FPU exception flags
  return (StatusWord & Excepts) & FE_ALL_EXCEPT;
}
