// --------------
// fsetexcptflg.c
// --------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// The fesetexceptflag function
//
// Synopsis
//
//
//   #include <fenv.h>
//   int fesetexceptflag(const fexcept_t *flagp, int excepts);
//
// Description
//
//   Function fesetexceptflag() sets the complete status for
//   those exception flags indicated by the argument excepts,
//   according to the representation in the object pointed to
//   by flagp.	The value of *flagp shall have been set by a
//   previous call to fegetexceptflag whose second argument
//   represented at least those exceptions represented by the
//   argument excepts.	This function does not raise exceptions,
//   but only sets the state of the flags.
//
// Return
//
//   The returned-value of the function is -1 if flagp is NULL,
//   else zero.
//

#define AV	__asm__ __volatile__

#define SET_EXCEPTS(FlgP, Xcpt)					\
    {								\
	fenv_t	FPU_Env;					\
	AV ("FSTENV %0" : "=m" (*&FPU_Env));			\
	FPU_Env.Status_Word &= ~FE_ALL_EXCEPT;			\
	FPU_Env.Status_Word |= FlgP & Xcpt & FE_ALL_EXCEPT;	\
	AV ("FLDENV %0" : : "m" (*&FPU_Env));			\
    }

#include <fenv.h>

int
fesetexceptflag (const fexcept_t *Flagp, int Excepts)
{
    int	    Retval;

    if (Flagp)
    {
	Retval = 0;
	SET_EXCEPTS(*Flagp, Excepts)
    }
    else
    {
	Retval = -1;
    }

  return Retval;
}
