// ------------------------------------------------------------------
// fminl.c - returns the minimum numeric value of a pair of arguments
// ------------------------------------------------------------------
//
//  Synopsis:
//
//	#include <math.h>
//
//	long double x, y, z, fminl()
//
//	z = fminl(x, y);
//
//  If either x or y is a NaN, return the numeric value
//  If both x and y are NaNs, return a NaN
//
//
#include <fdlibml.h>

long double	fminl(long double x, long double y)
{
    long double    Retval;

    if (isnanl(x) || isnanl(y))
    {
	Retval = isnanl(y) ? x : y;
    }
    else if (x == 0.0L && y == 0.0L)
    {
	int	Sign = signbitl(x);	// extract sign bit
					// return -0 if signs differ
	Retval = (Sign) ? x : y;
    }
    else
    {
	Retval = (x < y) ? x : y;
    }
    return Retval;
}
