// ------------------------------------------------------------------
// fmin.c - returns the minimum numeric value of a pair of arguments
// ------------------------------------------------------------------
//
//  Synopsis:
//
//	#include <math.h>
//
//	double x, y, z, fmin()
//
//	z = fmin(x, y);
//
//  If either x or y is a NaN, return the numeric value
//  If both x and y are NaNs, return a NaN
//
//
#include <fdlibml.h>

double	fmin(double x, double y)
{
    double    Retval;

    if (isnand(x) || isnand(y))
    {
	Retval = isnand(y) ? x : y;
    }
    else if (x == 0.0 && y == 0.0)
    {
	int	Sign = signbitd(x);	// extract sign bit
					// return -0 if signs differ
	Retval = (Sign) ? x : y;
    }
    else
    {
	Retval = (x < y) ? x : y;
    }
    return Retval;
}
