// ------------------------------------------------------------------
// fmaxf.c - returns the maximum numeric value of a pair of arguments
// ------------------------------------------------------------------
//
//  Synopsis:
//
//	#include <math.h>
//
//	float x, y, z, fmaxf()
//
//	z = fmaxf(x, y);
//
//  If just one argument is a NaN, return the other argument
//  If both arguments are NaNs, return a NaN
//
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, October 2003
//
//
#include <fdlibml.h>

float  fmaxf(float x, float y)
{
    float    Retval;

    if (isnanf(x) || isnanf(y))
    {
	Retval = isnanf(y) ? x : y;
    }
    else if (x == 0.0 && y == 0.0)
    {
	int	Sign = signbitf(x);	// extract sign bit
					// return +0 if signs differ
	Retval = (Sign) ? y : x;
    }
    else
    {
	Retval = (x > y) ? x : y;
    }
    return Retval;
}
